/*	
 *   xtel - Emulateur MINITEL sous X11
 *
 *   Copyright (C) 1991-1994  Lectra Systemes & Pierre Ficheux
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
static char rcsid[] = "$Id: procedure.c,v 1.1 1994/08/30 15:58:39 pierre Exp $";

/*
 * Fonction d'initialisation des procedures
 */

#include "xtel.h"
#include <string.h>
#include <stdlib.h>

/* 
 * Lecture du fichier des procedures, retourne le nb de procedures lues 
 */
init_procedures ()
{
    struct chat *p_chat, *p_chat_s;
    register int i, i_nom;
    FILE *fpproc;
    int nb_proc = 0;
    char *h, buf[256];

    /* Ouvre le fichier $HOME/.xtelproc */

    if ((h = getenv("HOME")) != NULL)
	strcat (strcpy (buf, h), "/.xtelproc");
    else
	strcpy (buf, ".xtelproc");

    if ((fpproc = fopen (buf, "r")) != NULL) {
	
	/* creation des entrees */
	nb_proc = 0;
	fgets (buf, 256, fpproc);
	
	for (;;) {

	    /*
	     * Si ce n'est pas une definition de procedure, c'est la fin 
	     * du fichier
	     */
	    if (buf[0] != 'P')
		break;

	    /* Sinon, traite la procedure */
	    buf[strlen(buf)-1] = 0;
	    procedures[nb_proc].nom = (char *) malloc(strlen(&buf[2])+1);

	    i_nom = 0;
	    i = 2;
	    
	    /*
	     * Lecture du nom en tenant compte des caracteres accentues (codes \xyz, 
	     * xyz = code octal du caractere)
	     */
	    
	    while (buf[i] != 0) {
		if (buf[i] == '\\') {
		    int x;

		    sscanf (&buf[i+1], "%o", &x);
		    procedures[nb_proc].nom[i_nom] = (char)x;
		    i += 4;
		}
		else
		    procedures[nb_proc].nom[i_nom] = buf[i++];

		i_nom++;
	    }

	    procedures[nb_proc].nom[i_nom] = 0;

	    /* Lecture du service (S numero_telephone_service) */

	    if (fgets (buf, 256, fpproc) == NULL || buf[0] != 'S' && nb_services != 0) {
		fprintf (stderr, "Erreur sur la procedure \"%s\": pas de definition de service !\n", procedures[nb_proc].nom);
		exit (0);
	    }
	    /*
	     * Lit le "chat-script" de la procedure
	     */
	    else {
		char trouve = 0;

		buf[strlen(buf)-1] = 0;

		/* Si l'utilisateur a droit a la composition directe, 
		   (ou bien qu'il utilise un M1) on ne teste pas l'autorisation */
		if (nb_services != 0 && strcmp (entree_compose[nb_services-1], "Direct") != 0) {
		    /* L'utilisateur est-il autorise a utiliser ce service ? */
		    for (i = 0 ; i != nb_services ; i++) {
			if (strcmp (definition_services[i].nom_uucp, &buf[2]) == 0) {
			    trouve = 1;
			    break;
			}
		    }
		}
		else
		    trouve = 1;

		if (!trouve) {
		    fprintf (stderr, "Erreur sur la procedure \"%s\": service %s interdit !\n", procedures[nb_proc].nom, &buf[2]);
		    exit (0);
		}

		/* Ok, alloue ce qu'il faut */
		procedures[nb_proc].service = (char *) malloc (strlen(buf)+1);
		strcpy (procedures[nb_proc].service, &buf[2]);
		procedures[nb_proc].chat = (struct chat *) malloc (sizeof(struct chat));
		p_chat = procedures[nb_proc].chat;
	    }
	    
	    /* Lecture des "chat-scripts" */
	    while (fgets (buf, 256, fpproc) != NULL && buf[0] != '\n' && buf[0] != 'P') {
		buf[strlen(buf)-1] = 0;

		if (buf[0] != 'A') {
		    fprintf (stderr, "Erreur sur la procedure \"%s\": %s, syntaxe incorrecte !\n", procedures[nb_proc].nom, buf);
		    exit (0);
		}

		/* chaine attendu */
		p_chat->attente = (char *) malloc (strlen(&buf[2])+1);
		strcpy (p_chat->attente, &buf[2]);

		/* chaine a emettre */
		fgets (buf, 256, fpproc);
		buf[strlen(buf)-1] = 0;

		if (buf[0] != 'E') {
		    fprintf (stderr, "Erreur sur la procedure \"%s\": %s, syntaxe incorrecte !\n", procedures[nb_proc].nom, buf);
		    exit (0);
		}

		p_chat->emission = (char *) malloc (strlen(&buf[2])+1);

		/* remplace '\' par 19 (pour les touches Minitel) */
		for (i = 2 ; buf[i] != 0 ; i++)
		    if (buf[i] == '\\')
			buf[i] = 19;

		strcpy (p_chat->emission, &buf[2]);

#ifdef DEBUG
		printf ("attendu %s, emise %s\n", p_chat->attente, p_chat->emission);
#endif

		/* Suivant */
		p_chat->suivant = (struct chat *) malloc (sizeof(struct chat));
		p_chat_s = p_chat;
		p_chat = p_chat->suivant;
	    }
	    p_chat_s->suivant = NULL;
	    
	    nb_proc++;
	}
	
	fclose (fpproc);
    }

    return (nb_proc);
}
