/*
   Time-stamp: <95/12/07 00:50:16 yusuf>
*/


#include "taper.h"
#include "restore.h"


PRIVATE FILE *fdfifo;				 /* for the FIFO */
PRIVATE char fifo_name[MAXNAMLEN];


PRIVATE _s32 find_min_vol()
{
/* Looks through the currently selected files and works out
 * which is the first volume it needs to read
*/
    _s32 vol;
    _s32 cur_pos=0;
    struct oa_file_entry *fe;
    
    fe=archive_files;
    vol=0;
    while (cur_pos++ <  no_in_archive) {
	if (fe->selected)			 /* only have to go through archive*/
	  if (S_ISREG(fe->i.mode) || (S_ISLNK(fe->i.mode))) /* to recreate reg files & */
	    vol = (vol==0) ? abs(fe->i.volume) : min(abs(vol), abs(fe->i.volume)); /* links */
	advance_ofe(&fe);			 /* we have information on everything else */
    }
    return vol;
}


PRIVATE _errstat setowners(char *s, _errstat ret, struct file_info *fi)
{
    char l[500];
    _s32  sz;
    struct utimbuf ut;

    if (!S_ISLNK(fi->mode)) {			 /* don't set anything for links */
	sprintf(l, "Setting permissions, modes & times for %s", s);
	if (log_level > 2) write_log(l);
	sz = 0;
	sz += chmod(s, fi->mode);		 /* directories/links */
	sz += chown(s, fi->uid, fi->gid);
	ut.actime = fi->atime;			 /* fix up times */
	ut.modtime = fi->mtime;
	sz += utime(s, &ut);
	if (sz)
	  write_error_log(l);
	if (ret == -4) return ret;
    }
    return (ret == -3) ? -2 : 1;		 /* we passed file */
}


PRIVATE _s32 rtotal_read;
PRIVATE _s32 rtotal_processed;
PRIVATE _s32 rtotal_files;
PRIVATE _errstat restore_action(struct file_info *fi, char *fn, struct oa_file_entry *fe, _s32 a_pos)
/* Acts on the restore loop finding filename fn
 * Action returns 1 if it advanced past file (ie. it read it in)
 * or 0 if it didn't read it in
 * 
 * Returns -1 if error
 * Returns -2 if no more files to be restored from this volume and did read this file
 * Returns -3 if no more files to be restored and didn't read this file
 * Returns -4 if no more files to be read in from archive
*/ 
{
    char      s[MAXNAMLEN], l[MAXNAMLEN*2], tmpf[MAXNAMLEN];
    _s32      c1, x, sz, tr;
    int       of;
    _errstat  ret;
    _s32      chk;
    
    a_pos--;
    rtotal_processed += strlen(s)+1+sizeof(struct file_info);
    if (S_ISREG(fi->mode))
      rtotal_processed += fi->act_size;
    if (!fe->selected) 				 /* not selected */
      return 0;					 /* tell loop that we didn't touch it */

    fe->selected = 0;				 /* mark as unselected now that it's read */
    ret = -1;					 /* work out return value */
    of = find_min_vol();
    if (of == 0) ret = -4;
    if (of == fe->i.volume) ret = 0;
    if (ret == -1) ret = -3;			 /* default */

    if (fi->checksum == -1) {
	sprintf(l, "There was a problem when backing up file %s, therefore file not restored", fn);
	write_warning_log(l);
	if (ret == -4) return ret;
	return (ret == -3) ? -2 : 1;		 /* we passed file */
    }
    if (fi->checksum == -2) {
	sprintf(l, "Backup was aborted before %s was backed up", fn);
	write_warning_log(l);
	if (ret == -4) return ret;
	return (ret == -3) ? -2 : 1;		 /* we passed file */
    }


    rtotal_files++;				 /* increment file count */
    strcpy(fn, stripped_cf);			 /* make filename as user */
    if (*stripped_cf)
      strcat(fn, "/");				 /* wants it */
    strcat(fn, name(fe));

    rtotal_read += strlen(fn)+1+sizeof(struct file_info)+strlen(cf);    
    if (*rel_path) {				 /* make pathname */
	strcpy(s, rel_path);			 /* taking into account */
	if (!((s[strlen(s)-1] == '/') ||	 /* the relative path supplied by */
	      (fn[0] == '/')))			 /* the user */
	  strcat(s, "/");
	    strcat(s, fn);
    }
    else 
      strcpy(s, fn);
    
    if (S_ISREG(fi->mode))
      rtotal_read += fi->size;
    else					 /* only create directories if not reg files */
      if (!make_dirs(s))			 /* make directories */
        return ret;				 /* failed in making directories */
    
    if (S_ISLNK(fi->mode)) {			 /* soft link */
	sprintf(l, "Reading in link info for %s", s);
	if (log_level > 2) write_log(l);
	if (tape_read(&x, sizeof(x)) != sizeof(x)) /* a link */
	  return -1;
	if (tape_read(tmpf, x) != x) 		 /* who do we point to */
	  return -1;
	sprintf(l, "Creating symbolic link file %s", s);
	if (log_level > 1) write_log(l);
	if (symlink(tmpf, s) == -1) 
	  write_error_log(l);
	return setowners(s, ret, fi);
    }

    if (S_ISDIR(fi->mode))  {			 /* directory */
	if (s[strlen(s)-1] == '/')
	  s[strlen(s)-1] = 0;
	sprintf(l, "Creating directory %s", s);
	if (log_level > 1) write_log(l);
	if (mkdir(s, 493) == -1)
	  if (errno != EEXIST)			 /* directory exists is not an error */
	    write_error_log(l); 
	return setowners(s, ret, fi);
    }

    if (!S_ISREG(fi->mode)) {			 /* device */
	sprintf(l, "Creating device %s", s);
	if (log_level > 1) write_log(l);
	if (mknod(s, fi->mode, fi->dev) == -1)
	  write_error_log(l);
	return setowners(s, ret, fi);
    }
    
/* OK - this is a regular file. Write the details to the FIFO
 * and write the file to a temporary file */

    fprintf(fdfifo, "%d\n", a_pos);		 /* position of file info */
    fprintf(fdfifo, "%s\n", s); 		 /* write filename */
    tmpnam(tmpf);				 /* make temporary name to store data in */
    if (log_level > 2) {
	sprintf(l, "Writing %s to %s to FIFO", s, tmpf);
	write_log(l);
    }
    of = creat(tmpf, S_IREAD|S_IWRITE);		 /* create a temporary file */
    if (of==-1) {				 /* to put data in */
	sprintf(l, "while creating temp file to receive data for %s", s);
	write_error_log(l);
	fprintf(fdfifo, "%s\n", FIFO_ERR);	 /* couldn't create temp file */
	fflush(fdfifo);
	return ret;
    }
    						 /* copy file to temporary file */
    sz = fi->act_size;				 /* from tape drive */
    sprintf(l, "Read in data for %s from tape to %s", s, tmpf);
    if (log_level > 2) write_log(l);
    chk=0;
    c1=0;
    while (1) {					 /* copy file accross */
	tr = min(sz, max_tr_size); 
	x = tape_read(tr_buffer, tr);		 /* from device file   */
	if (!x) break;
	if (x == -1) 
	  return -1;
	chk += mem_calc_checksum(tr_buffer, x);	 /* calculate checksum */
	sz -= x;
	if (c1 != -1) {				 /* if there have been no previous write errors */
	    c1 = write(of, tr_buffer, x);	 /* if there has been a prev write error */
	    if (c1 == -1)			 /* still continue reading to pass by file on device  */
	      write_error_log(l);
	}
	if (!sz) break;				 /* read all we need to */
    }
    if (labs(chk) != fi->checksum) {
	sprintf(l, "ERROR:  Checksum error for file %s", s);
	write_log(l);
	log_errors++;
    }
    else {
	sprintf(l, "Checksum OK for file %s", s);
	if (log_level > 1) write_log(l);
    }
    close(of);
    if (c1==-1)  {
	sprintf(l, "Error writing data to file %s", tmpf);
	write_log(l); log_errors++;
	fprintf(fdfifo, "%s\n", FIFO_ERR);	 /* couldn't create temp file */
	unlink(tmpf);
    }
    else					 /* file copied successfully -  */
      fprintf(fdfifo, "%s\n", tmpf);		 /* queue it for child to process */
    fflush(fdfifo);
    if (ret == -4) return ret;
    return (ret == -3) ? -2 : 1;		 /* we passed file */
}




PRIVATE void do_child_restore()
{
/* Goes through the FIFO and expects there to be paired
 * entries - the file_info & the raw data file - processes it */
    struct file_info fi;
    char   s[MAXNAMLEN], ff[MAXNAMLEN], fn[MAXNAMLEN];
    char   l[500];
    int    of, ifd;
    struct stat statbuf;
    UBYTE  *cmp_buf, *uncmp_buf;
    ULONG  xx, x;
    _s32   a_pos;

    if ((fdfifo = fopen(fifo_name, "r")) == NULL)/* open fifo */
      return;
    still_compressing = 1;
    while (1) {
	if (fgets(s, sizeof(s), fdfifo) == NULL) {
	    if (log_level > 3) write_log("Restore child unable to read from FIFO");
	    break;				 /* EOF == error */
	}
	a_pos = atol(s);
	if (fgets(s, sizeof(s), fdfifo) == NULL) /* name of file */
	  break;
	if (fgets(ff, sizeof(ff), fdfifo) == NULL)		 /* name of temporary file where file is */
	  break;
	if (!strcmp(ff, "END\n"))		 /* finished */
	  break;
	fi = find_entry(archive_files, a_pos)->i;   /* get file entry */
	if (ff[strlen(ff)-1] == '\n')
	  ff[strlen(ff)-1] = 0;
	if (s[strlen(s)-1] == '\n')
	  s[strlen(s)-1] = 0;
	sprintf(l, "FIFO info is %s --> %s", ff, s);
	if (log_level > 2) write_log(l);
	if (!strcmp(ff, FIFO_ERR)) 		 /* error writing out this entry */
	  continue;
	
	sprintf(l, "Getting file info for file %s", s);
	if (!make_dirs(s))			 /* make directories */
	  goto next_file;			 /* failed in making directories */
	if (log_level > 2) write_log(l);
	if ((of = lstat(s, &statbuf)) == -1)	 /* try and get info about file */
	  if (errno != ENOENT) {		 /* not an error is couldn't */
	    write_error_log(l);
	    goto next_file;
	  }
	switch (ovrwrite) {
	   case 0:				 /* no overwrite */
	      if (of != -1) {			 /* file existed */
		  sprintf(l, "File %s exists. Not overwriting", s);
		  write_warning_log(l);
		  goto next_file;
	      }
	      break;
	   case 1:				 /* only overwrite if backup file more recent */
	      if ((fi.ctime <= statbuf.st_ctime) && (of != -1)) {
		  sprintf(l, "File %s not overwritten because not as recent", s);
		  write_warning_log(l);
		  goto next_file;
	      }
	      break;
	}

	unlink(s);				 /* remove whatever file was there */
	if (fi.compressed == 0) {
	    if (log_level > 2) {
		sprintf(l, "Renaming %s to %s", ff, s);
		write_log(l);
	    }
	    my_rename(ff, s);			 /* rename this file  */
	    *ff = 0;				 /* the file doesn't exist anymore */
	}

	if (fi.compressed == 1) {		 /* must uncompress using gzip */
	    sprintf(fn, "%s %s > \"%s\"", DECOMPRESS_PROG, ff, s);
	    change_dollar(fn);			 /* fixes so that $ are changed to \$ */
	    sprintf(l, "Externally uncompressing file %s", s);
	    if (log_level > 2) write_log(l);
	    if (system(fn) != 0)			 /* do decompress */
	      write_error_log(l);
	}
	    
	if (fi.compressed==2) {			 /* internal compression */
	    cmp_buf = (UBYTE *) comp_buffer1;
	    uncmp_buf = (UBYTE *) comp_buffer2;
	    if ((fi.act_size > COMPRESS2_BUFFER_SIZE) || (comp_buffer1 == NULL))  {
		if (fi.act_size > COMPRESS2_BUFFER_SIZE) {
		    if (log_level > 2) write_log("Compressed file is bigger than buffer - allocating");
		}
		else {
		    if (log_level > 2) write_log("Couldn't create buffers earlier");
		}
		if (log_level > 2) write_log("Creating memory block to receive compressed file");
		cmp_buf=alloca(fi.act_size);
		if (cmp_buf==NULL) {
		    do_exit(ERROR_MEMORY);
		    goto next_file;
		}
		uncmp_buf=alloca(fi.size+COMPRESS_OVERRUN);
		if (uncmp_buf==NULL) {
		    do_exit(ERROR_MEMORY);
		    goto next_file;
		}
	    }
	    strcpy(l, "Reading in compressed file");
	    if (log_level > 2) write_log(l);
	    of=open(ff, O_RDONLY);		 /* read file into memory */
	    if (of==-1) {
		write_error_log(l);
		goto next_file;
	    }
	    read(of, cmp_buf, fi.act_size);	 /* read in all file */
	    close(of);
	    
	    compress(COMPRESS_ACTION_DECOMPRESS, cbuf,   /* decompress */
		     cmp_buf, fi.act_size, uncmp_buf, &xx);
	    strcpy(l, "Creating & writing out compressed file");
	    if (log_level > 2) write_log(l);
	    of=creat(s, O_WRONLY);		 /* write it out */
	    if (of==-1) {
		write_error_log(l);
		goto next_file;
	    }
	    x = write(of, uncmp_buf, fi.size);	 /* write uncompressed file */
	    close(of);
	}
	
	if (fi.compressed == 3) {
	    sprintf(l, "Internally unzipping file %s", s);
	    if (log_level > 2) write_log(l);
	    ifd=open(ff, O_RDONLY);
	    if (ifd==-1) {
		sprintf(l, "Opening %s", ff);
		write_error_log(l);
		goto next_file;
	    }
	    of=creat(s, O_WRONLY);		 /* write it out */
	    if (of==-1) {
		sprintf(l, "Opening %s", s);
		close(ifd);
		write_error_log(l);
		goto next_file;
	    }
	    if (unzip(ifd, of) != 0) {
		sprintf(l, "Error internally unzipping %s", s);
		write_warning_log(l);
	    }
	    close(ifd); close(of);
	}
	
	sprintf(l, "Read in %s successfully", s);
	if (log_level > 1) write_log(l);
	setowners(s, 0, &fi);
	next_file:
	  if (*ff) unlink(ff);			 /* remove temporary file */
    }						 /* continue loooping */
    fclose(fdfifo);
    unlink(fifo_name);
    still_compressing = 0;
}


void restore_print_status(WINDOW *mes_box, _s32 cur_in_vol,
				_s32 no_in_vol, _s32 vol,
				_s32 file_size, char *fn,
				_time_t t_start, _time_t t_current)
{
    char scr[MAXNAMLEN], num1[50], num2[50];
    _s32 x;
    
    sprintf(scr, "Passing %s", fn);
    status_box(mes_box, scr, 0, FALSE, 1);
    sprintf(scr, "Volume %d of %d. File %d of %d", vol, ifd.number_volumes,
	    cur_in_vol, no_in_vol);
    status_box(mes_box, scr, 2, FALSE, 1);
    sprintf(scr, "Read %s of %s", print_kb(num1, rtotal_read), 
	    print_kb(num2, total_selected));
    status_box(mes_box, scr, 3, FALSE, 1);
    sprintf(scr, "Passing %s of %s", print_kb(num1, rtotal_processed), 
	    print_kb(num2, total_compressed));
    status_box(mes_box, scr, 4, FALSE, 1);
    if (total_selected) 
      sprintf(scr, "%.0f%% done, time elapsed %s",  (float) rtotal_processed/(float) total_compressed*100,
	      convtime(num1, t_start, t_current));
    else				 /* if total bytes=0 then base on # files */
      sprintf(scr, "Time elapsed %s", convtime(num1, t_start, t_current));
    status_box(mes_box, scr, 6, FALSE, 1);
    x=t_current-t_start;
    if (x) {
	sprintf(scr, "Restore rate %s/min [%s/min]",
		print_mb(num1, rtotal_read/x*60),
		print_mb(num2, rtotal_processed/x*60));
	status_box(mes_box, scr, 7, FALSE, 1);
    }

}


PRIVATE _errstat restore_devs_dirs()
/* This routine restores anything other than regular files & links. It doesn't
   need to go through the archive for these - it has the information in the
   info file
*/
{
    _s32 c;
    struct oa_file_entry *fe;
    char fn[MAXNAMLEN];
    
    fe = archive_files;
    for (c=0; c<no_in_archive; c++) {
	if (fe->selected) 
	    if (!(S_ISREG(fe->i.mode) || S_ISLNK(fe->i.mode))) {
		strcpy(fn, cf);			 /* make the full pathname */
		strcat(fn, name(fe));
		if (restore_action(&fe->i, fn, fe, c+1) == -1) 
		  return -1;
	    }
	advance_ofe(&fe);
    }
    return 0;
}


PRIVATE _errstat check_files_to_restore()
{
/* Makes sure there are files to restore 
   Returns 1 if there are, 0 if there are not
*/
    _s32 c;
    struct oa_file_entry *fe;

    fe=archive_files;
    for (c=0; c<no_in_archive; c++)
      if (fe->selected)
	return 1;
      else
	advance_ofe(&fe);
    return 0;
}


PRIVATE void do_restore() {
    WINDOW *mes_box=NULL;
    _s32 v;
    char l[200];
    time_t t_start, t_current;
    struct volume_header vh;
    struct oa_file_entry *fe;
    _s32 c, dummy;
    _s32  old_pos, old_tape;
    char sa[6][150];
    char s2[30];
    
/* An error reading from the backup device is a fatal error */
    if (!no_sel)
      return;
    rtotal_read = 0;
    rtotal_processed = 0;
    rtotal_files = 0;
    mes_box = status_box(mes_box, "                                         ", 2, TRUE, 5);/* create window */
    nodelay(mes_box, TRUE);
    status_box(mes_box, "Restoring devices/directories", 2, FALSE, 1);
    if (restore_devs_dirs() == -1) return;
    if (!check_files_to_restore()) return;	 /* make sure there are files to restore */
    status_box(mes_box, "Identifying tape", 2, FALSE, 1);
    if (tape_rewind() == -1) return;		 /* rewind tape */
    if (tape_open(O_RDONLY) == -1)			 /* open rewinding */
	return;
    if (tape_readheader(&tdh, 0) == -1)
      return;					 /* read in tape header */
    if (tdh.magic != TAPER_MAGIC_NUMBER) {
	do_exit(ERROR_MAGIC);
	return;
    }
    tmpnam(fifo_name);				 /* set up FIFO */
    if ((mknod(fifo_name, S_IFIFO|S_IREAD|S_IWRITE, 0)) == -1)  {
	do_exit(ERROR_CREATING_FIFO);
	return;
    }
    if (restore_child) {				 /* a process still going on */
	kill(restore_child, SIGKILL);
	waitpid(restore_child, NULL, 0);
	restore_child = 0;
    }
    if (log_level > 3) write_log("About to fork off restore child");
    restore_child = fork();			 /* fork off a child to do restoration */
    if (restore_child == -1) {
	unlink(fifo_name);
	restore_child = 0;
	do_exit(ERROR_UNABLE_FORK);
	return;
    }
    if (restore_child == 0) {			 /* this is the child */
	signal(SIGTERM, child_term);
	if (log_level > 3) write_log("Restore child successfully forked off");
	close(dv);				 /* child doesn't need device open */
	detach_shared_buffers();		 /* doesn't need shared buffers */
	free_non_shared_buffers();
	malloc_comp_buffers();
	do_child_restore();			 /* do the business */
	free_comp_buffers();
	my_free_all();
	detach_shm();
	if (log_level > 3) write_log("Restore child about to finish");
	exit(0);
    }
    
    if ((fdfifo = fopen(fifo_name, "w")) == NULL) {/* open fifo */
	kill(restore_child, SIGTERM);
	waitpid(restore_child, NULL, 0);
	return;
    }

    t_start = time(NULL);
    old_pos = 1;
    while ((v=find_min_vol()) != 0) {
	rtotal_processed = 0;		 /* update processed bytes */
	fe = archive_files;
	for (c=0; c<no_in_archive; c++) {
	    if (fe->i.volume < v)
	      rtotal_processed += fe->i.act_size;
	    advance_ofe(&fe);
	}
	status_box(mes_box, "", 0, FALSE, 1);
	status_box(mes_box, "", 2, FALSE, 1);
	status_box(mes_box, "", 3, FALSE, 1);
	status_box(mes_box, "", 4, FALSE, 1);
	status_box(mes_box, "", 5, FALSE, 1);
	status_box(mes_box, "", 6, FALSE, 1);
	status_box(mes_box, "", 7, FALSE, 1);
	sprintf(l, "Advancing to volume %d", v);
	status_box(mes_box, l, 3, FALSE, 1);
	if (v != 1) {
	    if ((old_pos=goto_end_vol(mes_box, 3, v-1, old_pos, 0)) == -1)
	      goto fin;
	}
	else {
	    if (check_tape(mes_box, 3, 1) == -1)
	      goto fin;
	}
	old_tape = tdh.tape_number;
	if (read_volheader(&vh, 1, 0) == -1)	 /* read in volume header */
	  goto fin;
	
	vh = *get_vh(vol_headers, v);		 /* get volume header information */
						 /* from info file */
	if (traverse_volume(restore_action, vh.no_in_volume, t_start, mes_box, 
			    0, restore_print_status, &dummy, TRUE) < 0)
	  break;
	if (old_tape != tdh.tape_number)	 /* tape has changed */
	  old_pos = 1;
    }
    status_box(mes_box, "", 0, FALSE, 1);
    status_box(mes_box, "Closing & Rewinding tape", 3, FALSE, 1);
    status_box(mes_box, "", 2, FALSE, 1);
    status_box(mes_box, "", 4, FALSE, 1);
    status_box(mes_box, "", 5, FALSE, 1);
    status_box(mes_box, "", 6, FALSE, 1);
    status_box(mes_box, "", 7, FALSE, 1);

    fin:;
    if (fdfifo != NULL)	{			 /* tell FIFO we are finished */
	fprintf(fdfifo, "0\ndummy\nEND\n");
	fclose(fdfifo);
    }
    c = still_compressing;			 /* wait for child  */
    while (c) 					 /* to finish */
      c=still_compressing;
    waitpid(restore_child, NULL, 0);
    restore_child = 0;
    t_current = time(NULL);
    tape_close();
    touchwin(win_main); wrefresh(win_main);
    sprintf(sa[0], "Restore Finished");
    strcpy(sa[1], "");
    sprintf(sa[2], "Restored: %d files,  %s", rtotal_files,
	    print_kb(s2, rtotal_read));
    if (log_level > 1) write_log(sa[2]);
    sprintf(sa[3], "Time elapsed %s.", convtime(s2, t_start, t_current));
    if (log_level > 1) write_log(sa[3]);
    strcpy(sa[4], "");
    sprintf(sa[5], "%d warnings, %d errors", log_warnings, log_errors);
    if (log_level > 1) write_log(sa[5]);
    multi_message_box(sa, 6, MB_OK);
}


    
PUBLIC _errstat read_vol_dir(_u32 archive_id) 	 /* also in utils.c */
{
    if (do_read_vol_dir(archive_id, tape, O_RDONLY, TRUE, TRUE) ==  TAPE_EXIST)
      return 1;
    return -1;
}

PRIVATE _s32 sz;
PRIVATE void print_diff_line(char *fn, struct stat *b)
{
    char s[80], s1[50];

    if (S_ISDIR(b->st_mode)) return;
    strncpy(s, fn, sizeof(s)-2);
    s[79] = 0;
    printf("  %-62s %12s\n", s, convert(s1, b->st_size));
    sz+=b->st_size;
}


PRIVATE _errstat restore_dpd(char *full_path, struct stat *b)
{
    print_diff_line(full_path, b);
    return 0;
}


PRIVATE void print_diffs(char *sel)
{
    struct stat b;
    
    get_statinfo(sel, &b);
    if (S_ISDIR(b.st_mode)) {
	printf("\nSelection %s\n", sel);
	process_dir(NULL, 0, sel, 1, restore_dpd, FALSE);
    }
    else
      if (file_more_recent(sel, &b))
        print_diff_line(sel, &b);
}


PRIVATE void print_diff()
{
/* Prints the files that have changed since an archive was made */
    _s32 c, c1, c2, c3;
    char   *xx1, *xx;
    struct volume_header *vh, *vh1;
    char s1[20];
    
    sz=0;
    printf("\n\nArchive %d ", tdh.archive_id);
    if (*tdh.archive_title)
      printf("%s\n", tdh.archive_title);
    else
      printf("<no title>\n");
    printf("Differences between archive and file system\n");
    printf("\nName                                                                     Size");
    printf("\n-----------------------------------------------------------------------------");
    xx = vol_headers;
    for (c=0; c<ifd.number_volumes;c++) {	 /* loop through each volume */
	vh = (struct volume_header *) xx;
	xx += sizeof(struct volume_header);
	for (c1=0; c1<vh->no_sels; c1++) {
	    xx += sizeof(_s32);
	    for (c2=0; c2<c; c2++) {		 /* make sure haven't already printed this filespec */
		xx1 = (char *) vol_headers;
		vh1 = (struct volume_header *) xx1;
		xx1 += sizeof(struct volume_header);
		for (c3=0; c3<vh1->no_sels; c3++) {   
		    xx1 += sizeof(_s32);
		    if (!strcmp(xx1, xx))	 /* we've already printed this */
		      goto already_printed;
		    while (*xx1++); 
		    xx1 += sizeof(_s32); while (*xx1++);
		}
	    }
	    print_diffs(xx);
	    already_printed:
	      while (*xx++); xx+=sizeof(_s32); while (*xx++);
	}
    }
    printf("\n%-64s %12s\n", "TOTALS", convert(s1, sz));
}
    

PRIVATE void print_voldir() {
    _s32 c;
    struct oa_file_entry *fe;
    char   s[MAXNAMLEN], s1[20], s2[20], *xx;
    struct tm t;
    struct volume_header *vh;
    _s32   c_sz=0, u_sz=0;


    printf("Number volumes = %d\n", ifd.number_volumes);

    for (c=0; c<ifd.number_volumes;c++) {
	xx = (char *) get_vh(vol_headers, c+1);
	vh = (struct volume_header *) xx;
	if (*vh->volume_title)
	  printf("\nVolume %d %s\n", c+1, vh->volume_title);
	else
	  printf("\nVolume %d <no title>\n", c+1);
	printf("  Contains %d files\n", vh->no_in_volume);
	t = *localtime(&vh->backup_time);
	printf("  Backed up at %d/%d/%d %d:%d\n", t.tm_year, t.tm_mon+1, t.tm_mday,
		t.tm_hour, t.tm_min);
    }
    printf("\n\n%-25s %3s %5s %14s %12s %12s\n", "Pathname", "Vol", "Pos", "Backup", "File Size", "On tape");
    printf("----------------------------------------------------------------------------\n");
    fe = archive_files;
    for (c=0; c<ifd.no_in_archive; c++) {
	strcpy(s, name(fe)); s[22] = 0;
	t = *localtime(&fe->i.backup_time);
	printf("%-25s %3d %5d %2d/%2d/%2d %2d:%02d %12s %12s\n", s, abs(fe->i.volume), fe->i.pos_in_archive,t.tm_mday,
	       t.tm_mon+1, t.tm_year, t.tm_hour, t.tm_min, convert(s1, fe->i.size),
	       convert(s2, fe->i.act_size));
	c_sz += fe->i.act_size;
	u_sz += fe->i.size;
	advance_ofe(&fe);
    }
    printf("\n%-47s    %12s %12s\n", "TOTALS", convert(s1, u_sz), convert(s2, c_sz));
    return;
}

	
PRIVATE void restore_mfn(struct direntry *x, char *dir_name, char *prefix)
{
    char t[MAXNAMLEN], pth[MAXNAMLEN];
    int  fd;
    struct info_file_header ifd;
    
    strcpy(t, "ID ");
    strcat(t, &x->entry.d_name[strlen(prefix)]);
    strcpy(pth, dir_name);
    if (pth[strlen(pth)-1] != '/')
      strcat(pth, "/");
    strcat(pth, x->entry.d_name);
    fd = open(pth, O_RDONLY);
    if (fd != -1) {
	read(fd, &ifd, sizeof(ifd));
	strcat(t, " ");
	if (*ifd.archive_title)
	  strcat(t, ifd.archive_title);
	else
	  strcat(t, "<no title>");
	close(fd);
    }
    strcpy(x->entry.d_name, t);
}


PUBLIC _errstat select_archive(_u32 *archive_id) /* also used in utils.c */
{
    _errstat ret;
    struct tape_header th;
    WINDOW *mes=NULL;
    char   df[MAXNAMLEN];
    _s32    gdh;

    gdh = 0;
    if ((pr_dir == -1) || (diff_id == -1))	 /* work out if we need to */
      gdh = 1;					 /* read in tape header */
    if ((pr_dir == 0) && (diff_id == 0))
      gdh = 1;
    if (gdh) {
	if (!no_windows)
	  mes = status_box(mes, "Rewinding tape", 1, TRUE,  1); /* see what tape is */
	ret = get_tape_header(mes, 1, &th);	 /* in drive */
	tape_close();
	if (mes) close_statusbox(mes);
	if (ret == -1) return -1;			 /* error getting tape */
	if ((ret == TAPE_NOEXIST) && (!prompt_archive)) return do_exit(ERROR_OPENING_BACKUP);
	if (ret == BAD_MAGIC) {
	    message_box("This is not a taper archive", MB_OK);
	    return -1;
	}
    }
    else
      th.archive_id = (pr_dir == 0) ? diff_id : pr_dir;
    sprintf(df, "%s/taper_info.%d", taper_info_files, th.archive_id);
    ret = open(df, O_RDONLY);
    if (ret == -1) {
	if (!prompt_archive)
	  return do_exit(ERROR_NO_INFO);
	if (!message_box("Warning - Info file doesn't exist for current tape", MB_OKCANCEL))
	  return -1;
    }
    else
      close(ret);
    if (!prompt_archive) {			 /* no prompting */
	*archive_id = th.archive_id;		 /* go straight to archive  */
	return 0;
    }
    *df = 0;
    if (ret != -1)
      if (*th.archive_title)
	sprintf(df, "ID %d %s", th.archive_id, th.archive_title); /* set as default archive */
      else
	sprintf(df, "ID %d <no title>", th.archive_id); /* set as default archive */
    ret = select_file(taper_info_files, "taper_info.", df, restore_mfn, FALSE);
    if ((ret == 0) || (ret == -1))		 /* abort or error */
      return -1;
    *archive_id = atol(&df[3]);
    if (*archive_id == 0) {			 /* not valid info file */
	message_box("Not a valid info file", MB_OK);
	return -1;
    }
    return 0;
}


PUBLIC void taper_restore() {

    _s32  x;
    _u32 arch;

    backrest_do_mallocs();
    if (check_device_names() == -1) goto end;	 /* check devices & other parms */
    if (open_logfile("Restore") == -1)
      goto end;
    if (no_windows)
      prompt_archive = 0;
    if (select_archive(&arch) == -1)		 /* find out which archive user wants */
      goto end;
    if (!no_windows) {
	backrest_init_windows();
	backrest_clear_screen();
    }
    if (read_vol_dir(arch) == -1)
      goto end;					 /*  Read volume dir */
    if (pr_dir) {
	print_voldir();
	tape_close();
    }
    else
      if (diff_id) {
	  print_diff();
	  tape_close();
      }
    else {
	info = my_realloc(info, 1);		 /* free memory */
	print_title_line();
	if (ifd.no_in_archive) {
	    x = select_restore_files();
	    switch(x) {
	       case 0:				 /* user aborted */
		break;				 /* user aborted */
	       case -1:				 /* error occurred */
		x = 0;
		log_errors = 1;
		break;
	       default:				 /* must be OK */
		if (!no_sel) {
		    message_box("No files selected", MB_OK);
		    x = 0;
		}
		break;
	    }
	}
	else {
	    message_box("No files in archive", MB_OK);
	    x = 0;
	}
	backrest_kill_windows();
	print_my_name();
	chdir(original_cur_dir);		 /* change directory to ensure */
	if (x) 
	    do_restore();			 /* restore to proper place */
    }
    
    end:;
    backrest_free_memory();
    close_logfile("Restore");
    return;			                 /* succesful return */
}
    
