/*
 * dfile.c - AIX file processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dfile.c,v 1.14 96/03/08 14:02:19 abe Exp $";
#endif


#include "lsof.h"


/*
 * is_file_named() - is file named?
 */

int
is_file_named(p, ty, ch)
	char *p;			/* path name; NULL = search by device
					 * and inode (from *Lf) */
	enum vtype ty;			/* vnode type */
	chan_t ch;			/* gnode channel */
{
	int f;
	struct sfile *s;
/*
 * Search the file chain.
 */
	for (f = 0, s = Sfile; s; s = s->next) {

	/*
	 * Search by path name, as requested.
	 */
		if (p != NULL) {
			if (strcmp(p, s->aname) == 0
			||  strcmp(p, s->name)  == 0)
			{
				f = 2;
				break;
			}
			continue;
		}

	/*
	 * Check for a regular AIX multiplexed file.  Match the channel if
	 * it was supplied.
	 */
		if (ty == VMPC) {
			if (s->type && s->mode == S_IFCHR && Lf->dev == s->dev
			&&  (s->ch < 0 || ch == s->ch)) {
				f = 1;
				break;
			}
			continue;
		}
	/*
	 * Check for a regular file or directory -- the device and
	 * inode numbers must match.
	 */
		if (s->type) {
			if (Lf->dev == s->dev && (ino_t)Lf->inode == s->i) {
				f = 1;
				break;
			}
			continue;
		}
	/*
	 * Check for a file system match.
	 * Try to avoid matching character files to non-character devices.
	 */
		if (Lf->dev == s->dev) {
			if ( ! (ty == VCHR && s->mode != S_IFCHR)) {
				f = 1;
				break;
			}
		}
	}
/*
 * Convert the name if a match occurred.
 */
	if (f) {
		if (f == 2)
			(void) strcpy(Namech, p);
		else {
			(void) strcpy(Namech, s->name);
			if (ty == VMPC && s->ch < 0)
				(void) sprintf(endnm(), "/%d", ch);
			if (s->devnm)
				(void) sprintf(endnm(), " (%s)", s->devnm);
		}
		s->f = 1;
		return(1);
	}
	return(0);
}


/*
 * print_file() - print file
 */

void
print_file()
{
	char buf[16];
	int mjd, mnd;

	if (Hdr == 0) {
	    (void) printf("COMMAND     PID%s     USER   FD   TYPE     DEVICE ",
		Fpgrp ? "   PGRP" : "");
	    (void) printf("%10s", Foffset ? "OFFSET"
					  : Fsize ? "SIZE"
						  : "SIZE/OFF");
	    (void) puts("      INODE NAME");
	    Hdr++;
	}
	(void) printf("%-9.9s%6d", Lp->cmd, Lp->pid);
	if (Fpgrp)
	    printf(" %6d", Lp->pgrp);
	(void) printf(" %8.8s %4s%c%c %4.4s ",
			printuid((UID_ARG)Lp->uid, NULL),
			Lf->fd,
			Lf->access,
			Lf->lock,
			Lf->type
		);
	if (Lf->dev_def) {
		mjd = major(Lf->dev);
		mnd = minor(Lf->dev);

#if	_AIXV>=3200
		if (Lf->dev & SDEV_REMOTE)
		    (void) fputs("  NFS ", stdout);
		else
#endif	/* _AIXV>=3200 */
		{ 
		    if (mjd < 10000)
			(void) printf(" %4d,", mjd);
		    else
			(void) printf("*%3d,", mjd % 1000);
		}
		if (mnd < 10000)
		    (void) printf("%4d ", mnd);
		else
		    (void) printf("*%03d ", mnd % 1000);
	} else {
		if (Lf->dev_ch) {
			(void) fputs(Lf->dev_ch, stdout);
			putchar(' ');
		} else
			(void) fputs("           ", stdout);
	}
	if (Lf->sz_def)
		(void) printf("%10lu", Lf->sz);
	else if (Lf->off_def) {
		if (Lf->off < 100000000l) {
			(void) sprintf(buf, "0t%ld", Lf->off);
			(void) printf("%10.10s", buf);
		} else
			(void) printf("%#10x", (Lf->off & 0xffffffff));
	} else
		(void) fputs("          ", stdout);
	switch(Lf->inp_ty) {
	case 1:
		(void) printf(" %10lu ", Lf->inode);
		break;
	case 2:
		if (Lf->iproto[0] == '\0')
			(void) fputs("           ", stdout);
		else
			(void) printf(" %10.10s ", Lf->iproto);
		break;
	default:
		(void) fputs("            ", stdout);
	}
	printname(1);
}


/*
 * The ck_file_arg() function is obtained from ../common/ckfa.frag.
 * The process_file() function is obtained from ../common/prfp.frag.
 */

/* CKFA_EXPDEV is not defined. */
#define	CKFA_MPXCHAN	1
