/*
	coloranim.c - animate color

	Author:	Susumu Shiohara (shiohara@tpp.epson.co.jp)

			Copyright 1993-1997 by Susumu Shiohara

					All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

static int t[256];
static int mapsize;

static void SetAndStoreColors()
{
int i;

	for (i = 0; i < mapsize; i++) {
		fcolors[i].red   = xcolors[t[i]].red;
		fcolors[i].green = xcolors[t[i]].green;
		fcolors[i].blue  = xcolors[t[i]].blue;
		fcolors[i].flags = xcolors[i].flags;
		fcolors[i].pixel = xcolors[i].pixel;
	}
	StoreColors(fcolors,mapsize);
	myusleep(app_data.colorAnimTicks);
}

static void RandomizeIndex()
{
int i,j;

	for(i = 0; i < mapsize; i++)
		t[i] = -1;

	for(i = 0; i < mapsize; i++) {
		while(True){
			j = myrandom() % mapsize;
			if(t[j]== -1){
	 			t[j]=i;
				break;
			}
		}
	}
}

#if defined(__STDC__) || defined(__cplusplus)
static void QuickSortColors(int from,int to)
#else
static void QuickSortColors(from,to)
int from,to;
#endif
{
int i,j,mean,tmp;

	i = from;
	j = to;
	mean = (t[i]+t[j]) / 2;
	while(True){

		while(t[i] < mean)
			i++;

		while(t[j] > mean)
			j--;

		if(i <= j){
			tmp  = t[i];
			t[i] = t[j];
			t[j] = tmp;

			i++;
			j--;

			SetAndStoreColors();
			if(gotSomeAction == True)
				return;
		}
		else
			break;
	}

	if(from < j)
		QuickSortColors(from, j);

	if(i < to)
		QuickSortColors(i, to);
}

static void ShellSortColors()
{
int h,i,j,k,tmp;

	/* Shell Sort */
	for(h = mapsize >> 1; h > 0; h >>= 1) {
		for(i = mapsize-  h, k = 1; k <= i; k++) {
			for(j = k-1; (j >= 0) && (t[j] >t [j+1]); j -= h){
				tmp    = t[j];
				t[j]   = t[j+1];
				t[j+1] = tmp;

				SetAndStoreColors();
				if(gotSomeAction == True)
					return;
			}
		}
	}
}

static void BubbleSortColors()
{
int i,j,tmp;

	/* Bubble Sort */
	for(i = 0; i < mapsize - 1; i++) {
		for(j = 0; j < mapsize - 1; j++) {
			if(t[j] > t[j+1]){
				tmp    = t[j];
				t[j]   = t[j+1];
				t[j+1] = tmp;
				SetAndStoreColors();
				if(gotSomeAction == True)
					return;
			} 
		}
	}
}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xcoloranimateshow(char *fname)	/* color animate */
#else
ActionStatus xcoloranimateshow(fname)
char *fname;
#endif
{
	mapsize = gim.subImageList->mapsize;

	PreDisplay();
	PreFadeColors(mapsize);

	if(app_data.showFileName)
		createFileNameWindow(fname);

	ShowImage(
		(windowWidth-gim.subImageList->width)/2,
		(windowHeight-gim.subImageList->height)/2,
		gim.subImageList->width,gim.subImageList->height);

	RandomizeIndex();

	if(strcmp(app_data.colorAnimSort,"bubble")==0)
		BubbleSortColors();
	else if(strcmp(app_data.colorAnimSort,"shell")==0)
		ShellSortColors();
	else /* if(strcmp(app_data.colorAnimSort,"quick")==0) */
		QuickSortColors(0,mapsize-1);

	if(app_data.showFileName)
		raiseFileNameWindow();

	return(mywait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxcoloranimateshow(char *fname)	/* color animate */
#else
void postxcoloranimateshow(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();

	FadeColors(True, mapsize);
}

