/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifdef SPEAKER_AUDIO
#ifndef lint
static char speaker_c[] = "$Id: speaker.c,v 1.8 1999/04/06 15:55:50 erik Rel $";
#endif
#include <stdlib.h>
#include <assert.h>
#include "z80.h"
#include "debug.h"
#include "resource.h"
#include "io.h"
#include "machine.h"
#include "util.h"
#include "emul.h"
#include "audio.h"
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_AUDIO) { x } }
#else
#define DEB(x)
#endif
void (*SpeakerOutByte)(uns8);
static unsigned int lastPos, lastRem, accum;
static unsigned char lastVal = 0;
void
SpeakerInit(void)
{
lastPos = 0;
lastRem = 0;
accum = 0;
Audio.spBuf = Malloc((size_t)Audio.samplesPerFrame, "SpeakerInit");
}
void
SpeakerReInit(void)
{
assert(Audio.spBuf != NULL);
free(Audio.spBuf);
SpeakerInit();
}
void
SpeakerOut(uns8 newval)
{
unsigned int pos, rem;
unsigned char val = ((newval & (B_SPEAKER | B_MIC)) << 3) - 96;
if (val != lastVal)
{
pos = TSTATES / Audio.tstatesPerSample;
rem = TSTATES % Audio.tstatesPerSample;
if (pos > Audio.samplesPerFrame)
{
pos = Audio.samplesPerFrame;
}
assert(pos <= Audio.samplesPerFrame);
if (lastPos == pos)
{
accum += lastVal * (rem - lastRem);
}
else
{
Audio.spBuf[lastPos++] =
(accum + lastVal * (Audio.tstatesPerSample - lastRem)) /
Audio.tstatesPerSample;
for (; lastPos < pos; lastPos++)
{
Audio.spBuf[lastPos] = lastVal;
}
accum = lastVal * rem;
}
lastRem = rem;
lastVal = val;
}
}
void
SpeakerFillBuffer(void)
{
Audio.spBuf[lastPos++] =
(accum + lastVal * (Audio.tstatesPerSample - lastRem)) /
Audio.tstatesPerSample;
for (;lastPos < Audio.samplesPerFrame; lastPos++)
{
Audio.spBuf[lastPos] = lastVal;
}
lastPos = 0;
lastRem = 0;
accum = 0;
}
#endif
