.TH "dmt" 2 " June 6th 1997" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
dmt - Discrete Mellin transform of a vector
.sp
Author: Paulo Goncalves
.sp
Computes the Fast Mellin transform of a signal.
.sp
.sp
.SH Usage
\f(CR[\fPmellin,beta\f(CR]\fP = dmt(s,\f(CR[\fPfmin,fmax,N\f(CR]\fP) 
.SH Input parameters


.RS

.TP
o 
\fBs\fP : real vector \f(CR[\fP1,nt\f(CR]\fP or \f(CR[\fPnt,1\f(CR]\fP
Time samples of the signal to be transformed. 

.TP
o 
\fBfmin\fP : real scalar in \f(CR[\fP0,0.5\f(CR]\fP
Lower frequency bound of the signal

.TP
o 
\fBfmax\fP :  real scalar \f(CR[\fP0,0.5\f(CR]\fP and \fIfmax\fP \f(CR>\fP 
Upper frequency bound of the  signal

.TP
o 
\fBN\fP : positive integer. 
number of Mellin samples.
.RE

.SH Output parameters


.RS

.TP
o 
\fBmellin\fP : complex vector \f(CR[\fP1,N\f(CR]\fP
Mellin transform of \fIs\fP.

.TP
o 
\fBbeta\fP : real vector \f(CR[\fP1,N\f(CR]\fP
Variable of the Mellin transform \fImellin\fP.
.RE

.SH Description
.SH Parameters


.RS

.TP
o 
\fIs\fP : signal to be transformed. Real or complex vector. 

.TP
o 
\fIfmin\fP : lower frequency bound of the analysis. \fIfmin\fP is
real scalar comprised in  \f(CR[\fP0,0.5\f(CR]\fP

.TP
o 
\fIfmax\fP : upper frequency bound of the analysis. \fIfmax\fP is
a real scalar comprised in \f(CR[\fP0,0.5\f(CR]\fP and \fIfmax\fP \f(CR>\fP
\fIfmin\fP

.TP
o 
\fIN\fP : number of Mellin samples. This number must be greater
than some ammount determined by the spectral extent of the signal, to
avoid aliasing in the Mellin domain.
.RE

.SH Algorithm details
The fast Mellin transform can be simply interpreted as a FFT applied
to a geometrically sampled vector. 
.SH See also:
idmt, dilate
.SH Example:
\fI Signal synthesis \fP 
.sp
.ft CR
.nf
x = morlet(0.1,32) ;
plot(x)
.fi 
.ec
.ft P
.sp
\fI Computation of the Mellin transform\fP 
.sp
.ft CR
.nf
[mellin,beta] = dmt(x,0.01,0.5,128) ;
plot(beta,abs(mellin))
.fi 
.ec
.ft P
.sp
