.TH lqr 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
lqr - LQ compensator (full state)
.SH CALLING SEQUENCE
.nf
[K,X]=lqr(P12)
.fi
.SH PARAMETERS
.TP 10
P12
: \fVsyslin\fR list (state-space linear system)
.TP
K,X
: two real matrices
.SH DESCRIPTION
\fVlqr\fR  computes the linear optimal LQ full-state gain
for the plant \fVP12=[A,B2,C1,D12]\fR in continuous or
discrete time.
.LP
\fVP12\fR is a \fVsyslin\fR list (e.g. \fVP12=syslin('c',A,B2,C1,D12)\fR).
.LP
The cost function is l2-norm of \fVz'*z\fR with \fVz=C1 x + D12 u\fR
i.e. \fV[x,u]' * BigQ * [x;u]\fR where
.nf
      [C1' ]               [Q  S]
BigQ= [    ]  * [C1 D12] = [    ]
      [D12']               [S' R]
.fi
The gain \fVK\fR is such that \fVA + B2*K\fR is stable.
.LP
\fVX\fR is the stabilizing solution of the Riccati equation.
.LP

For a continuous plant:
.nf
(A-B2*inv(R)*S')'*X+X*(A-B2*inv(R)*S')-X*B2*inv(R)*B2'*X+Q-S*inv(R)*S'=0
.fi
.nf
K=-inv(R)*(B2'*X+S)
.fi
.LP
For a discrete plant:
.nf
X=A'*X*A-(A'*X*B2+C1'*D12)*pinv(B2'*X*B2+D12'*D12)*(B2'*X*A+D12'*C1)+C1'*C1;
.fi
.nf
K=-pinv(B2'*X*B2+D12'*D12)*(B2'*X*A+D12'*C1)
.fi
An equivalent form for \fVX\fR is
.nf
X=Abar'*inv(inv(X)+B2*inv(r)*B2')*Abar+Qbar
.fi
with \fVAbar=A-B2*inv(R)*S'\fR and \fVQbar=Q-S*inv(R)*S'\fR

.LP
The 3-blocks matrix pencils associated with these Riccati equations are:
.nf
               discrete                           continuous
   |I   0    0|   | A    0    B2|         |I   0   0|   | A    0    B2|
  z|0   A'   0| - |-Q    I    -S|        s|0   I   0| - |-Q   -A'   -S|
   |0   B2'  0|   | S'   0     R|         |0   0   0|   | S'  -B2'   R|
.fi
Caution: It is assumed that matrix R is non singular. In particular,
the plant must be tall (number of outputs >= number of inputs).
.SH EXAMPLE
.nf
A=rand(2,2);B=rand(2,1);   //two states, one input
Q=diag([2,5]);R=2;     //Usual notations x'Qx + u'Ru
Big=sysdiag(Q,R);    //Now we calculate C1 and D12
[w,wp]=fullrf(Big);C1=w(:,1:2);D12=w(:,3);   //[C1,D12]'*[C1,D12]=Big
P=syslin('c',A,B,C1,D12);    //The plant (continuous-time)
[K,X]=lqr(P)
spec(A+B*K)    //check stability
norm(A'*X+X*A-X*B*inv(R)*B'*X+Q,1)  //Riccati check
P=syslin('d',A,B,C1,D12);    // Discrete time plant
[K,X]=lqr(P)     
spec(A+B*K)   //check stability
norm(A'*X*A-(A'*X*B)*pinv(B'*X*B+R)*(B'*X*A)+Q-X,1) //Riccati check
.fi
.SH SEE ALSO
lqe, gcare, leqr
.SH AUTHOR
F.D.

