/*
 * Copyright(c) 1995-1998 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: font.c,v 1.4 1999/11/07 22:27:57 xfmail Exp $
 */

#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "configform.h"

#define MAX_ELEMENTS    64

extern cfgfile Config;

static FL_FORM *form;

static FL_OBJECT
* textobj, *styleobj, *sizeobj, *placeobj, *bg_obj, *fg_obj;

extern FL_OBJECT *b_folders, *b_messages, *msgpane;
static int ready = 0;
static int nfonts = 0;
static FD_config_intern *charset_obj;
static int cchanged = 0;

typedef struct _size_el {
    char el_name[16];
    char el_descr[32];
    FL_OBJECT **el_obj;
    u_int type;
#define NO_TYPE 0x00
#define BROWSER 0x01
#define MENU    0x02
#define FONT    0x03
#define XFDEF   0x04
#define XTEXT   0x05
#define NO_SIZE     0x10
#define NO_STYLE    0x20
#define NO_BGCOL    0x40
#define NO_FGCOL    0x80
#define N_RESTART   0x100
    u_int def_size, def_style, def_bg, def_fg;
}
size_el;

struct _size_el elements[MAX_ELEMENTS] = {

    {"Folders", "Folder browser", &b_folders, BROWSER, FL_NORMAL_SIZE,
        FL_FIXED_STYLE, FL_COL1, FL_YELLOW},
    {"Messages", "Message browser", &b_messages, BROWSER, FL_NORMAL_SIZE,
        FL_FIXED_STYLE, FL_COL1, FL_YELLOW},
    {"ChooseFolder", "Folder chooser", NULL, NO_TYPE, FL_NORMAL_SIZE,
        FL_FIXED_STYLE, FL_COL1, FL_YELLOW},
    {"AddrBook", "Address book", NULL, NO_TYPE, FL_NORMAL_SIZE,
        FL_FIXED_STYLE, FL_COL1, FL_YELLOW},
    {"Signature", "Signature editor", NULL, NO_TYPE, FL_NORMAL_SIZE,
        FL_FIXED_STYLE, FL_COL1, FL_BLACK},
    {"View", "Message viewer", &msgpane, XTEXT, FL_NORMAL_SIZE,
        FL_NORMAL_STYLE, FL_COL1, FL_BLACK},
    {"Edit", "Message editor", NULL, NO_TYPE, FL_NORMAL_SIZE,
        FL_NORMAL_STYLE, FL_COL1, FL_BLACK},
    {"InputFont", "Input box font size", NULL,
        XFDEF | NO_STYLE | NO_BGCOL | NO_FGCOL | N_RESTART, FL_DEFAULT_SIZE,
        FL_NORMAL_STYLE, FL_WHITE, FL_BLACK},
    {"LabelFont", "Label font size", NULL,
        XFDEF | NO_STYLE | NO_BGCOL | NO_FGCOL | N_RESTART, FL_DEFAULT_SIZE,
        FL_NORMAL_STYLE, FL_WHITE, FL_BLACK},
    {"ChoiceFont", "Choice font size", NULL,
        XFDEF | NO_STYLE | NO_BGCOL | NO_FGCOL | N_RESTART, FL_DEFAULT_SIZE,
        FL_NORMAL_STYLE, FL_WHITE, FL_BLACK},
    {"MenuFont", "Menu font size", NULL,
        XFDEF | NO_STYLE | NO_BGCOL | NO_FGCOL | N_RESTART, FL_DEFAULT_SIZE,
        FL_NORMAL_STYLE, FL_WHITE, FL_BLACK},
    {"BrowserFont", "Browser font size", NULL,
        XFDEF | NO_STYLE | NO_BGCOL | NO_FGCOL | N_RESTART, FL_DEFAULT_SIZE,
        FL_NORMAL_STYLE, FL_WHITE, FL_BLACK},
    {"ButtonFont", "Button font size", NULL,
        XFDEF | NO_STYLE | NO_BGCOL | NO_FGCOL | N_RESTART, FL_DEFAULT_SIZE,
        FL_NORMAL_STYLE, FL_WHITE, FL_BLACK},
    {"PopUpFont", "PopUp font size", NULL,
        XFDEF | NO_STYLE | NO_BGCOL | NO_FGCOL | N_RESTART, FL_DEFAULT_SIZE,
        FL_NORMAL_STYLE, FL_WHITE, FL_BLACK},
    {"SliderFont", "Slider font size", NULL,
        XFDEF | NO_STYLE | NO_BGCOL | NO_FGCOL | N_RESTART, FL_DEFAULT_SIZE,
        FL_NORMAL_STYLE, FL_WHITE, FL_BLACK},
    {"GoodiesFont", "Dialogs font size", NULL,
        NO_BGCOL | NO_FGCOL | N_RESTART, FL_DEFAULT_SIZE, FL_NORMAL_STYLE,
        FL_WHITE, FL_BLACK},
    {"_", "_", NULL, NO_TYPE, FL_NORMAL_SIZE, FL_FIXED_STYLE, FL_COL1,
        FL_YELLOW}
};

void display_styles();
void display_charsets();

void restore_fonts() {
    int i;
    char fname[16];

    for(i = 16; i < 32; i++) {
        snprintf(fname, sizeof(fname), "Font%d", i);
        if(Config.exist(fname)) {
            if(fl_set_font_name(i, Config.getString(conf_name, fname, ""))
               < 0) {
                display_msg(MSG_LOG, "font", "font %s can not be loaded",
                            Config.getString(conf_name, fname, ""));
                Config.delString(conf_name, fname);
            }
        }
    }

    return;
}

void restore_charsets() {
    int k = 0;
    char cname[MAX_CHARSET_NAME + 10], aname[MAX_CHARSET_NAME],
    adescr[MAX_CHARSET_NAME], *str;

    while(supp_charsets[k].charset_code != CHAR_UNKNOWN) {
        if(is_charset_alias(supp_charsets[k].charset_name)) {
            k++;
            continue;
        }

        snprintf(cname, sizeof(cname), "%sFStyle",
                 supp_charsets[k].charset_name);
        set_charset_style(supp_charsets[k].charset_name,
                          Config.getInt(conf_name, cname,
                                        supp_charsets[k].font_style));
        snprintf(cname, sizeof(cname), "%sFSize",
                 supp_charsets[k].charset_name);
        set_charset_size(supp_charsets[k].charset_name,
                         Config.getInt(conf_name, cname,
                                       supp_charsets[k].font_size));
        snprintf(cname, sizeof(cname), "%sAlias",
                 supp_charsets[k].charset_name);
        if(Config.exist(cname)) {
            str = Config.getString(conf_name, cname, "");
            while(1) {
                aname[0] = '\0';
                adescr[0] = '\0';
                if(sscanf(str, "%24s %24s", aname, adescr) != 2)
                    break;
                add_charset(aname, adescr, supp_charsets[k].charset_code);
                if((str = strchr(str, ' ')) == NULL)
                    break;
                while(*str == ' ')
                    str++;
                if((str = strchr(str, ' ')) == NULL)
                    break;
                while(*str == ' ')
                    str++;
                if(*str == '\0')
                    break;
            }
        }

        k++;
    }

    def_encoding = Config.getInt(conf_name, "encoding", DEFAULT_ENCODING);
    def_charset = Config.getInt(conf_name, "charset", DEFAULT_CHARSET);
    return;
}

void font_add(FL_OBJECT * obj, long arg) {
    char *p;
    int i;
    char *str, fname[16];

    if(nfonts >= 32) {
        display_msg(MSG_WARN, "FONTS",
                    "Can not use more then 32 different fonts");
        return;
    }

    str = (char *) fl_show_input("Enter X-Windows font name", "");

    if(!str || !*str)
        return;

    i = 0;
    p = str;
    while((p = strchr(p, '-')) != NULL) {
        p++;
        i++;
        if(i == 8) {
            if(*p == '*')
                *p = '?';

            break;
        }
    }

    /*if (i < 8)    {
        display_msg(MSG_WARN, "Invalid font", "%s", str);
        return; } */

    if(fl_set_font_name(nfonts, str) < 0) {
        display_msg(MSG_WARN, "Invalid font", "%s", str);
        return;
    }

    sprintf(fname, "Font%d", nfonts);
    Config.putString(conf_name, fname, str);
    display_styles();
    return;
}

void font_del(FL_OBJECT * obj, long arg) {
    char fname[32];
    int i;

    if(nfonts <= 16) {
        display_msg(MSG_WARN, "FONT", "Can not delete predefined font");
        return;
    }

    i = 0;
    while(strlen(elements[i].el_name) > 2) {
        snprintf(fname, sizeof(fname), "%sFStyle", elements[i].el_name);

        if(Config.getInt(conf_name, fname, elements[i].def_style) ==
           (nfonts - 1)) {
            display_msg(MSG_WARN, "FONT",
                        "The font is in use. Can not delete");
            return;
        }
        i++;
    }

    nfonts--;

    sprintf(fname, "Font%d", nfonts);
    Config.delString(conf_name, fname);
    fl_set_font_name(nfonts, "");
    display_styles();
    return;
}

void display_size(int el_num) {
    char buf[64];
    int size, style, bgcol, fgcol;
    int i, type, typef;

    type = elements[el_num].type;
    typef = type & 0xff0;
    type &= 0x0f;

    size = elements[el_num].def_size;
    style = elements[el_num].def_style;
    bgcol = elements[el_num].def_bg;
    fgcol = elements[el_num].def_fg;

    if(typef & NO_SIZE)
        fl_deactivate_object(sizeobj);
    else {
        fl_activate_object(sizeobj);
        snprintf(buf, sizeof(buf), "%sFSize", elements[el_num].el_name);
        size = Config.getInt(conf_name, buf, size);
        if(size == 0)
            size = FL_DEFAULT_SIZE;
    }

    if(typef & NO_STYLE)
        fl_deactivate_object(styleobj);
    else {
        fl_activate_object(styleobj);
        snprintf(buf, sizeof(buf), "%sFStyle", elements[el_num].el_name);
        style = Config.getInt(conf_name, buf, style);
    }

    if(typef & NO_BGCOL)
        fl_deactivate_object(bg_obj);
    else {
        if((type == BROWSER) && elements[el_num].el_obj
           && *elements[el_num].el_obj)
            bgcol = (*elements[el_num].el_obj)->col1;
        else
            if((type == XTEXT) && elements[el_num].el_obj
               && *elements[el_num].el_obj) bgcol =
            (*elements[el_num].el_obj)->col2;

        snprintf(buf, sizeof(buf), "%sBgCol", elements[el_num].el_name);
        bgcol = Config.getInt(conf_name, buf, bgcol);
        fl_activate_object(bg_obj);
    }

    if(typef & NO_FGCOL)
        fl_deactivate_object(fg_obj);
    else {
        if((type == BROWSER) && elements[el_num].el_obj
           && *elements[el_num].el_obj)
            fgcol = (*elements[el_num].el_obj)->col2;
        else
            if((type == XTEXT) && elements[el_num].el_obj
               && *elements[el_num].el_obj) fgcol =
            (*elements[el_num].el_obj)->col1;

        snprintf(buf, sizeof(buf), "%sFgCol", elements[el_num].el_name);
        fgcol = Config.getInt(conf_name, buf, fgcol);
        fl_activate_object(fg_obj);
    }

    if(type == FONT) {
        fgcol = Config.getInt(conf_name, "ViewFgCol", fgcol);
        bgcol = Config.getInt(conf_name, "ViewBgCol", bgcol);
    }

    fl_select_browser_line(styleobj, style + 1);

    switch(size) {
        case 8:
            i = 1;
            break;
        case 10:
            i = 2;
            break;
        case 11:
            i = 3;
            break;
        case 12:
            i = 4;
            break;
        case 13:
            i = 5;
            break;
        case 14:
            i = 6;
            break;
        case 18:
            i = 7;
            break;
        case 24:
            i = 8;
            break;
        case 30:
            i = 9;
            break;
        default:
            i = 1;
            break;
    }

    fl_select_browser_line(sizeobj, i);

    fl_set_object_lstyle(textobj, style);
    fl_set_object_lsize(textobj, size);
    fl_set_object_color(textobj, bgcol, textobj->col2);
    fl_set_object_lcol(textobj, fgcol);
    fl_redraw_object(textobj);

    return;
}

void color_cb(FL_OBJECT * obj, long arg) {
    char buf[64];
    FL_COLOR col = fl_show_colormap(arg ? textobj->col1 : textobj->lcol);
    int num = fl_get_browser(placeobj) - 1, type;

    type = elements[num].type & 0x0f;

    if(arg)
        fl_set_object_color(textobj, col, textobj->col2);
    else
        fl_set_object_lcol(textobj, col);

    if(type == FONT) {
        display_size(num);
        return;
    }

    snprintf(buf, sizeof(buf), "%sBgCol", elements[num].el_name);
    Config.putInt(conf_name, buf, textobj->col1);
    snprintf(buf, sizeof(buf), "%sFgCol", elements[num].el_name);
    Config.putInt(conf_name, buf, textobj->lcol);
    if((type == BROWSER) && elements[num].el_obj && *elements[num].el_obj) {
        fl_activate_object(*elements[num].el_obj);
        fl_set_object_color(*elements[num].el_obj, textobj->col1,
                            textobj->lcol);
        fl_redraw_object(*elements[num].el_obj);
    } else
        if((type == XTEXT) && elements[num].el_obj
           && *elements[num].el_obj) {
        fl_activate_object(*elements[num].el_obj);
        fl_set_textedit_color(*elements[num].el_obj, textobj->col1,
                              textobj->lcol, -1, 1);
    }

    display_size(num);

    return;
}

void place_cb(FL_OBJECT * obj, long arg) {
    display_size(fl_get_browser(placeobj) - 1);
}

void style_cb(FL_OBJECT * obj, long arg) {
    char buf[64];
    int num = fl_get_browser(placeobj) - 1;
    int style = fl_get_browser(obj) - 1, type;

    type = elements[num].type & 0x0f;
    snprintf(buf, sizeof(buf), "%sFStyle", elements[num].el_name);
    Config.putInt(conf_name, buf, style);
    if(elements[num].type & N_RESTART)
        fl_show_message("Warning!", "This change will take effect",
                        "after you restart XFMail");

    if(type == FONT)
        set_charset_style(elements[num].el_name, style);

    if((type == BROWSER) && elements[num].el_obj && *elements[num].el_obj) {
        fl_set_browser_fontstyle(*elements[num].el_obj, style);
        fl_set_object_lstyle(*elements[num].el_obj, style);
        fl_redraw_object(*elements[num].el_obj);
    } else
        if((type == XTEXT) && elements[num].el_obj
           && *elements[num].el_obj) {
        fl_set_textedit_fontstyle(*elements[num].el_obj, style);
        fl_set_object_lstyle(*elements[num].el_obj, style);
        fl_redraw_object(*elements[num].el_obj);
    }

    display_size(num);
}

void size_cb(FL_OBJECT * obj, long arg) {
    char buf[64];
    int num = fl_get_browser(placeobj) - 1;
    int size = FL_DEFAULT_SIZE, type;

    type = elements[num].type & 0x0f;
    switch(fl_get_browser(obj)) {
        case 1:
            size = 8;
            break;
        case 2:
            size = 10;
            break;
        case 3:
            size = 11;
            break;
        case 4:
            size = 12;
            break;
        case 5:
            size = 13;
            break;
        case 6:
            size = 14;
            break;
        case 7:
            size = 18;
            break;
        case 8:
            size = 24;
            break;
        case 9:
            size = 30;
            break;
    }

    if(type == FONT)
        set_charset_size(elements[num].el_name, size);

    snprintf(buf, sizeof(buf), "%sFSize", elements[num].el_name);
    Config.putInt(conf_name, buf, size);
    if(elements[num].type & N_RESTART)
        fl_show_message("Warning!", "This change will take effect",
                        "after you restart XFMail");

    display_size(num);

    if((type == BROWSER) && elements[num].el_obj && *elements[num].el_obj) {
        fl_set_browser_fontsize(*elements[num].el_obj, size);
        fl_set_object_lsize(*elements[num].el_obj, size);
        fl_redraw_object(*elements[num].el_obj);
    } else
        if((type == XTEXT) && elements[num].el_obj
           && *elements[num].el_obj) {
        fl_set_textedit_fontsize(*elements[num].el_obj, size);
        fl_set_object_lsize(*elements[num].el_obj, size);
        fl_redraw_object(*elements[num].el_obj);
    }

    return;
}

void create_form_form(void) {
    FL_OBJECT *obj;

    form = fl_bgn_form(FL_NO_BOX, 550, 300);
    fl_add_box(FL_FLAT_BOX, 0, 0, 550, 300, "");
    textobj = obj =
              fl_add_text(FL_NORMAL_TEXT, 10, 10, 530, 100,
                          "XFMail\nCopyright (c) 1995-1998 by\n Gennady B. Sorokopud\n\374\314\305\313\324\322\317\316\316\301\321 \320\317\336\324\301\n\351\360\345\370\350\367\354\340 \370\340\345\343");
    fl_set_object_boxtype(obj, FL_FRAME_BOX);
    fl_set_object_lalign(obj, FL_ALIGN_CENTER | FL_ALIGN_INSIDE);
    fl_set_object_color(obj, FL_INDIANRED, FL_YELLOW);
    fl_set_object_dblbuffer(obj, 1);
    styleobj = obj =
               fl_add_browser(FL_HOLD_BROWSER, 10, 120, 180, 130, "");
    fl_set_object_color(obj, FL_TOP_BCOL, FL_YELLOW);
    fl_set_object_callback(obj, style_cb, 0);
    sizeobj = obj =
              fl_add_browser(FL_HOLD_BROWSER, 200, 120, 170, 130, "");
    fl_set_object_color(obj, FL_TOP_BCOL, FL_YELLOW);
    fl_set_object_callback(obj, size_cb, 0);
    placeobj = obj =
               fl_add_browser(FL_HOLD_BROWSER, 380, 120, 160, 130, "");
    fl_set_object_color(obj, FL_TOP_BCOL, FL_YELLOW);
    fl_set_object_callback(obj, place_cb, 0);

    bg_obj = fl_add_button(FL_NORMAL_BUTTON, 330, 260, 70, 30, "Bg Col");
    fl_set_object_callback(bg_obj, color_cb, 1);

    fg_obj = fl_add_button(FL_NORMAL_BUTTON, 410, 260, 70, 30, "Fg Col");
    fl_set_object_callback(fg_obj, color_cb, 0);

    obj = fl_add_button(FL_RETURN_BUTTON, 10, 260, 70, 30, "Ok");

    obj = fl_add_button(FL_NORMAL_BUTTON, 90, 260, 70, 30, "Help");
    fl_set_button_shortcut(obj, "#H", 1);
    fl_set_object_callback(obj, cb_help_button, 15);

    obj = fl_add_button(FL_NORMAL_BUTTON, 170, 260, 70, 30, "Add");
    fl_set_object_callback(obj, font_add, 0);

    obj = fl_add_button(FL_NORMAL_BUTTON, 250, 260, 70, 30, "Delete");
    fl_set_object_callback(obj, font_del, 0);

    fl_end_form();
}

void create_the_forms(void) {
    create_form_form();
}

void addit(const char *str) {
    nfonts++;
    fl_add_browser_line(styleobj, str);
}

void display_styles() {
    int i = fl_get_browser(styleobj);

    if(i == 0)
        i = 1;

    fl_freeze_form(form);
    fl_clear_browser(styleobj);
    nfonts = 0;
    fl_enumerate_fonts(addit, 1);
    fl_select_browser_line(styleobj, i);
    fl_unfreeze_form(form);
}

void set_el_size() {
    FL_IOPT cntl;
    struct _size_el *sz = elements;
    char chdescr[32];
    int i = 0, k, xfdefs;
    int sep;

    if(ready)
        return;

    fl_get_defaults(&cntl);

    create_the_forms();
    ready = 1;
    xfdefs = -1;

    while(sz->el_name[0] != '_') {
        if((xfdefs == -1) && ((sz->type & 0x0f) == XFDEF))
            xfdefs = i;

        fl_add_browser_line(placeobj, sz->el_descr);
        i++;
        sz = &elements[i];
    }

    k = 0;
    sep = i;
    while(supp_charsets[k].charset_code != CHAR_UNKNOWN) {
        if(i >= MAX_ELEMENTS) {
            display_msg(MSG_WARN, "FONTS",
                        "Too many charsets, can't display");
            break;
        }

        if(is_charset_alias(supp_charsets[k].charset_name)) {
            k++;
            continue;
        }

        strcpy(elements[i].el_name, supp_charsets[k].charset_name);
        strcpy(elements[i].el_descr, supp_charsets[k].charset_descr);
        elements[i].el_obj = NULL;
        elements[i].type = FONT | NO_FGCOL | NO_BGCOL;
        elements[i].def_style = supp_charsets[k].font_style;
        elements[i].def_size = supp_charsets[k].font_size;
        elements[i].def_bg = FL_COL1;
        elements[i].def_fg = FL_BLACK;
        snprintf(chdescr, sizeof(chdescr), "%s (%s)", elements[i].el_name,
                 elements[i].el_descr);
        fl_add_browser_line(placeobj, chdescr);
        i++;
        k++;
    }

    if(xfdefs >= 0) {
        if(cntl.inputFontSize > 0)
            elements[xfdefs++].def_size = cntl.inputFontSize;
        if(cntl.labelFontSize > 0)
            elements[xfdefs++].def_size = cntl.labelFontSize;
        if(cntl.choiceFontSize > 0)
            elements[xfdefs++].def_size = cntl.choiceFontSize;
        if(cntl.menuFontSize > 0)
            elements[xfdefs++].def_size = cntl.menuFontSize;
        if(cntl.browserFontSize > 0)
            elements[xfdefs++].def_size = cntl.browserFontSize;
        if(cntl.buttonFontSize > 0)
            elements[xfdefs++].def_size = cntl.buttonFontSize;
        if(cntl.pupFontSize > 0)
            elements[xfdefs++].def_size = cntl.pupFontSize;
        if(cntl.sliderFontSize > 0)
            elements[xfdefs++].def_size = cntl.sliderFontSize;
    }

    display_styles();

    fl_addto_browser(sizeobj, "8 (small)");
    fl_addto_browser(sizeobj, "10(normal1)");
    fl_addto_browser(sizeobj, "11(scaled)");
    fl_addto_browser(sizeobj, "12(normal2)");
    fl_addto_browser(sizeobj, "13(scaled)");
    fl_addto_browser(sizeobj, "14(normal2)");
    fl_addto_browser(sizeobj, "18(large)");
    fl_addto_browser(sizeobj, "24(Huge)");
    fl_addto_browser(sizeobj, "30(scaled)");

    fl_select_browser_line(sizeobj, 2);
    fl_select_browser_line(placeobj, 1);
    fl_select_browser_line(styleobj, 1);
    display_size(0);

    fl_show_form(form, FL_PLACE_CENTER, FL_TRANSIENT, "Fonts & Colors");

    fl_do_only_forms();

    elements[sep].el_name[0] = '_';

    fl_hide_form(form);
    fl_free_form(form);
    ready = 0;
    return;

}

void CHSET_Select_Call(FL_OBJECT * obj, long param) {
}

void CHSET_AAlias_Call(FL_OBJECT * obj, long param) {
    char *p, aname[MAX_CHARSET_NAME + 1], adescr[MAX_CHARSET_NAME + 1],
    buf[127];
    int i = fl_get_browser(charset_obj->CHSET_Select);

    if(i < 1)
        return;
    i--;

    if(is_charset_alias(supp_charsets[i].charset_name)) {
        display_msg(MSG_WARN, "add charset alias",
                    "Can not make alias to alias");
        return;
    }

    snprintf(buf, sizeof(buf), "New alias name of charset %s:",
             supp_charsets[i].charset_name);
    p = (char *) fl_show_input(buf, "");
    if(!p || !*p)
        return;

    if(strlen(p) > MAX_CHARSET_NAME) {
        display_msg(MSG_WARN, "add charset alias",
                    "charset name can not be longer then %d characters",
                    MAX_CHARSET_NAME);
        return;
    }

    strncpy(aname, p, MAX_CHARSET_NAME);
    aname[MAX_CHARSET_NAME] = '\0';
    p = aname;
    while(*p != '\0') {
        if(!isgraph(*p)) {
            display_msg(MSG_WARN, "add charset alias",
                        "invalid character in charset name");
            return;
        }
        p++;
    }

    p = (char *) fl_show_input("Enter charset description:", "");
    if(!p || !*p)
        return;

    if(strlen(p) > MAX_CHARSET_NAME) {
        display_msg(MSG_WARN, "add charset alias",
                    "charset description can not be longer then %d characters",
                    MAX_CHARSET_NAME);
        return;
    }

    strncpy(adescr, p, MAX_CHARSET_NAME);
    adescr[MAX_CHARSET_NAME] = '\0';
    p = adescr;
    while(*p != '\0') {
        if(!isgraph(*p) || (*p == ' ')) {
            display_msg(MSG_WARN, "add charset alias",
                        "invalid character in charset description");
            return;
        }
        p++;
    }

    if(add_charset(aname, adescr, supp_charsets[i].charset_code) != 0)
        return;

    display_charsets();
    cchanged = 1;

    return;
}

void CHSET_DAlias_Call(FL_OBJECT * obj, long param) {
    int i = fl_get_browser(charset_obj->CHSET_Select);

    if(i < 1)
        return;
    i--;

    if(!is_charset_alias(supp_charsets[i].charset_name)) {
        display_msg(MSG_WARN, "delete charset alias",
                    "Only charset aliases can be deleted");
        return;
    }

    if(del_charset(supp_charsets[i].charset_name) != 0)
        return;

    display_charsets();
    cchanged = 1;

    return;
}

void display_charsets() {
    char buf[255];
    int i, k;

    i = 0;
    fl_freeze_form(charset_obj->config_intern);
    fl_clear_browser(charset_obj->CHSET_Select);
    while(supp_charsets[i].charset_code != CHAR_UNKNOWN) {
        k = is_charset_alias(supp_charsets[i].charset_name);
        snprintf(buf, sizeof(buf), "%-12.12s %-13.13s %-11.11s %-4d %-2d",
                 supp_charsets[i].charset_name,
                 supp_charsets[i].charset_descr ? supp_charsets[i].
                 charset_descr : "",
                 k > 0 ? supp_charsets[k - 1].charset_name : "",
                 supp_charsets[i].font_style, supp_charsets[i].font_size);
        fl_add_browser_line(charset_obj->CHSET_Select, buf);
        i++;
    }
    fl_select_browser_line(charset_obj->CHSET_Select, 1);
    fl_unfreeze_form(charset_obj->config_intern);

    return;
}

void charset_conf(int set_default, FD_config_intern * form) {
    cchanged = 0;
    charset_obj = form;
    fl_set_browser_fontstyle(charset_obj->CHSET_Select, FL_FIXED_STYLE);
    fl_set_browser_fontsize(charset_obj->CHSET_Select, FL_NORMAL_SIZE);
    display_charsets();
}

void handle_charsets_input(FD_config_intern * form) {
    char buf[255], aname[MAX_CHARSET_NAME + 10];
    int i, k;

    charset_obj = form;
    if(cchanged) {
        i = 0;
        while(supp_charsets[i].charset_code != CHAR_UNKNOWN) {
            if(is_charset_alias(supp_charsets[i].charset_name)) {
                i++;
                continue;
            }

            k = i + 1;
            buf[0] = '\0';
            while(supp_charsets[k].charset_code != CHAR_UNKNOWN) {
                if(supp_charsets[k].flags & CHARSET_FIXED) {
                    k++;
                    continue;
                }
                if(supp_charsets[k].charset_code ==
                   supp_charsets[i].charset_code) {
                    if(*buf)
                        strcat(buf, " ");
                    strcat(buf, supp_charsets[k].charset_name);
                    strcat(buf, " ");
                    strcat(buf, supp_charsets[k].charset_descr);
                }
                k++;
            }
            snprintf(aname, sizeof(aname), "%sAlias",
                     supp_charsets[i].charset_name);
            if(*buf)
                Config.putString(conf_name, aname, buf);
            else {
                if(Config.exist(aname))
                    Config.delString(conf_name, aname);
            }
            i++;
        }
    }
}
