/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  AFILE *AFsetNHread (FILE *fp, const char Fname[])

Purpose:
  Get file format information for a headerless audio file

Description:
  This routine gets file information for an audio file with a non-standard
  header or with no header.  File format information is passed to this routine
  by calling AFsetNHpar before calling this routine.  This information is used
  to set the file data format information in the audio file pointer structure.

Parameters:
  <-  AFILE *AFsetNHread
      Audio file pointer for the audio file
   -> FILE *fp
      File pointer for the file
   -> const char Fname[]
      File name

Author / revision:
  P. Kabal  Copyright (C) 1998
  $Revision: 1.52 $  $Date: 1998/06/26 21:12:44 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFsetNHread.c 1.52 1998/06/26 libtsp-v3r0 $";

#include <libtsp.h>
#include <libtsp/AFheader.h>
#include <libtsp/AFmsg.h>
#include <libtsp/AFpar.h>
#include <libtsp/sysOS.h>	/* #define unix */


AFILE *
AFsetNHread (fp, Fname)

     FILE *fp;
     const char Fname[];

{
  struct AF_NHpar *NHpar;
  AFILE *AFp;

/* Get the file data parameters */
  NHpar = &AFopt_NHpar;

/* Check the data format */
  if (NHpar->Format == FD_UNDEF) {
    UTwarn ("AFsetNHread - %s", AFM_NH_NoData);
    return NULL;
  }

/* Reopen the file as a text file if necessary */
/* For Unix text files and binary files are the same */
#ifndef unix
  if (NHpar->Format == FD_TEXT && fp != stdin) {
    fp = freopen (Fname, "r", fp);  /* Reopen as a text file */
    if (fp == NULL) {
      UTsysMsg ("AFsetNHread - %s", AFM_ReopenErr);
      return NULL;
    }
  }
#endif

/* Position at the start of data */
  if (RSKIP (fp, NHpar->Start) != NHpar->Start)
    return NULL;

  AFp = AFsetRead (fp, FT_NH, NHpar->Format, NHpar->Swapb, NHpar->Sfreq,
		   NHpar->ScaleF, NHpar->Nchan, AF_LDATA_UNDEF, AF_NSAMP_UNDEF,
		   NULL, AF_NOFIX);

  return AFp;
}
