/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  nucleus.h

Description:
  Function prototypes for the TSP library internal (nucleus) routines

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 2.52 $  $Date: 1997/10/16 22:17:22 $

----------------------------------------------------------------------*/

#ifndef nucleus_h_
#define nucleus_h_

#include <stdio.h>	/* typedef for FILE */
#include <time.h>	/* typedef for time_t */

#ifdef __STDC__
#  define p_(params)	params
#else
#  define const				/* Define const for K&R C */
#  define p_(params)	()
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ----- FI Prototypes ----- */
double
FIrCosF p_((double x, double alpha));
double
FIxKaiser p_((double x, double alpha));

/* ----- FL Prototypes ----- */
int
FLexist p_((const char Fname[]));
int
FLfReadTF p_((FILE *fp, int MaxNval, int cc, float x[]));
long int
FLfileSize p_((FILE *fp));
int
FLjoinNames p_((const char Dname[], const char Bname[], char Fname[]));
int
FLreadFile p_((FILE *fp, long int offs, void *ptr, int elem_size, int count));
int
FLseekable p_((FILE *fp));
int
FLterm p_((FILE *fp));
void
FLwriteFile p_((FILE *fp, long int offs, const void *ptr, int elem_size,
		int count));

/* ----- MA Prototypes ----- */
int
MAfChFactor p_((const float *A[], float *L[], int N));
void
MAfLTSolve p_((const float *L[], const float b[], float x[], int N));
void
MAfTTSolve p_((const float *L[], const float b[], float x[], int N));

/* ----- MS Prototypes ----- */
double *
MScoefMC p_((double x1, double x2, double y1, double y2,
	     double d1, double d2));
double
MSevalMC p_((double x, double x1, double x2, double y1, double y2,
	     double d1, double d2));
double
MSslEndMC p_((double Dxr, double Dxrr, double Dyr, double Dyrr));
double
MSslMidMC p_((double Dxl, double Dxr, double Dyl, double Dyr));
double
MSslopeMC p_((int k, const float x[], const float y[], int N));

/* ----- SP Prototypes ----- */
void
SPconvMSpoly p_((const float x[], double a, float z[], int N));
void
SPpprFFT p_((float x[], float y[], int N, int Ifn));
void
SPtrMat2 p_((float A[], int N, int Ifn));

/* ----- ST Prototypes ----- */
int
STdec1val p_((const char String[], int Type, void *Val));
int
STdecNval p_((const char String[], int Nmin, int Nmax, int Type, void *Val,
	      int *N));
int
STdecPair p_((const char String[], const char Delim[], int Type,
	      void *Val1, void *Val2));
char *
STstrDots p_((const char Si[], int Maxchar));
char *
STstrstrNM p_((const char Si[], const char Ti[], int N, int M));
char *
STtrimIws p_((const char Si[]));
int
STtrimNMax p_((const char Si[], char So[], int N, int Maxchar));

/* ----- UT Prototypes ----- */
int
UTbyteCode p_((int Dbo));
int
UTbyteOrder p_((void));
int
UTcheckIEEE p_((void));
char *
UTctime p_((time_t *timer, int format));
double
UTdIEEE80 p_((const unsigned char b[10]));
int
UTdecOption p_((const char String[], const char Option[],
		const char **Arg));
void
UTeIEEE80 p_((double V, unsigned char b[10]));
char *
UTgetHost p_((void));
int
UTswapCode p_((int Dbo));
char *
UTgetUser p_((void));

/* ----- VR Prototypes ----- */
void
VRswapBytes p_((const void *BuffI, void *BuffO, int Size, int Nelem));

#ifdef __cplusplus
}
#endif

#endif /* nucleus_h_ */
