/* file: "mem.h" */

/* Copyright (C) 1994-1998 by Marc Feeley, All Rights Reserved. */

#ifndef ___MEM_H
#define ___MEM_H

/*
 * Memory allocation parameters:
 *
 * ___MAX_NB_PARMS is the maximum number of formal parameters of procedures.
 *
 * ___MAX_NB_ARGS is the maximum number of arguments (actual parameters)
 * that are passed to procedures.  It must be >= ___MAX_NB_PARMS.
 *
 * ___MAX_NB_FRAME_SLOTS is the maximum number of slots in continuation
 * frames.  It must be >= ___MAX_NB_ARGS.
 *
 * ___DEFAULT_STACK_SIZE is the default size in words of the stack, not
 * counting the stack fudge area.  It must be >= ___MAX_NB_FRAME_SLOTS.
 *
 * ___STACK_FUDGE is the size in words of the stack fudge area which is a
 * special area at the end of the stack-cache.  Polling instructions in
 * the code generated by the compiler check every so often whether the frame
 * pointer points into the stack fudge area, which indicates a "stack-cache
 * overflow".  In this case the continuation frames in the stack-cache are
 * moved to the heap and the stack-cache is cleared, leaving room for
 * subsequent allocations on the stack.  There is at most one continuation
 * frame in the stack-cache.  Because of the way polling instructions are
 * added by the compiler and the way keyword parameters are handled,
 * ___STACK_FUDGE must be >= ___MAX_NB_ARGS+___MAX_NB_PARMS.
 *
 * ___MSECTION_SIZE is the size in words of sections that contain
 * movable objects (msections).
 *
 * ___MSECTION_FUDGE is the size in words of the fudge area in each
 * msection.  Instructions in the code generated by the compiler check
 * whether the heap allocation pointer points into the fudge area after
 * a bounded number of constant size allocations.  In this case the heap
 * allocation pointer is moved to a new msection, or a garbage collection
 * is triggered if there are no free msections available.  ___MSECTION_FUDGE
 * must be >= ___MAX_NB_ARGS*(___PAIR_SIZE+___OBJECT_OVERHEAD) and
 * <= ___MSECTION_SIZE/2.
 *
 * ___MSECTION_BIGGEST is the size in words of the biggest movable object.
 * It must be <= ___MSECTION_FUDGE.
 *
 * ___MIN_NB_MSECTIONS is the minimum number of msections contained
 * in the heap.
 *
 * ___PSECTION_SIZE is the size in words of sections that contain permanent
 * objects (psections).
 *
 * ___PSECTION_WASTE is the maximum number of words that are unused
 * in a psection due to fragmentation.  It must be <= ___PSECTION_SIZE.
 *
 * ___DEFAULT_LIVE_PERCENT is the default percentage of the heap that
 * is live after a GC.  At the end of a GC the heap is resized to reach
 * this percentage.
 */

#define ___MAX_NB_PARMS       1024
#define ___MAX_NB_ARGS        4096
#define ___MAX_NB_FRAME_SLOTS 4096
#define ___DEFAULT_STACK_SIZE 4096
#define ___STACK_FUDGE        (___MAX_NB_ARGS+___MAX_NB_PARMS)
#define ___MSECTION_SIZE      131072
#define ___MSECTION_FUDGE     ___MAX_NB_ARGS*(___PAIR_SIZE+___PAIR_OVERHEAD)
#define ___MSECTION_BIGGEST   255
#define ___MIN_NB_MSECTIONS   2
#define ___PSECTION_SIZE      4096
#define ___PSECTION_WASTE     32
#define ___DEFAULT_LIVE_PERCENT 50

extern void ___setup_mem ___P((___setup_params_struct *setup_params),());
extern void ___cleanup_mem ___PVOID;

extern int ___gc ___PVOID;
extern int ___heap_limit ___PVOID;

extern int get_live_percent ___PVOID;
extern void set_live_percent ___P((int percent),());

extern ___glo_struct *___alloc_global_var ___PVOID;

extern ___U64 ___bytes_allocated ___PVOID;

#endif
