package biss.awt;

import biss.ObserverSocket;
import biss.XorSet;
import biss.awt.BarMenu;
import biss.awt.Button;
import biss.awt.Checkbox;
import biss.awt.Choice;
import biss.awt.DecoGroup;
import biss.awt.EditList;
import biss.awt.Label;
import biss.awt.SpinButton;
import biss.awt.TextArea;
import biss.awt.TextField;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class ControlTest1
  extends TopWindow
  implements Observer
{
	SpinButton Sp = new SpinButton();
	TextField Ef = new TextField();
	Choice Cp = new Choice();
	Layouter Lo = new Layouter( this);
	DecoGroup Gr1 = new DecoGroup("Group 1");
	DecoGroup Gr2 = new DecoGroup("Group 2");
	TextArea Tp = new TextArea();
	EditList Eop = new EditList();
	BarMenu Bm = new BarMenu();
	Checkbox Cb = new Checkbox("A Checkbox");
	Button Pb = new Button("A ~Button");
	Label St = new Label("some static text");
	Checkbox Rb1 = new Checkbox("choice 1");
	Checkbox Rb2 = new Checkbox("choice 2");
	Image Img = Awt.DefToolkit.getImage( "duke_small.gif");
	Button Pb2 = new Button();

static {
	Button.setDefaultCarved( false);
}

public ControlTest1(){
	super( "ControlTest1");
	open();
}

Vector getChoiceData(){
	Vector v = new Vector();
	v.addElement( "A Choice");
	v.addElement( "with");
	v.addElement( "some");
	v.addElement( "more");
	v.addElement( "choicedata");
	return v;
}

Vector getEopData(){

	Vector v = new Vector();
	v.addElement( new DukeEntry( 1, "An EditList", Img));
	v.addElement( new DukeEntry( 2, "with", Img));
	v.addElement( new DukeEntry( 3, "some", Img));
	v.addElement( new DukeEntry( 4, "funny", Img));
	v.addElement( new DukeEntry( 5, "dukes", Img));
	v.addElement( new DukeEntry( 6, "and", Img));
	v.addElement( new DukeEntry( 7, "several", Img));
	v.addElement( new DukeEntry( 8, "fonts", Img));
	return v;
}

String[] getSpinArray(){
	String[] sa = {"A SpinButton","with","some","more","spindata"};
	return sa;
}

public void init () {
	Sp.setContents( getSpinArray() );
	Cp.setContents( getChoiceData() );
	Ef.setContents( "A TextField" );
	Tp.setContents( "A TextArea\nwith multiple\nlines" );
	Eop.setContents( getEopData() );

	//  Rb1.disable();
	XorSet cbs = new XorSet();
	Rb1.setExclusive( cbs);
	Rb2.setExclusive( cbs);

	Pb2.setImage( "duke_small.gif", "Hi d~uke");

	Eop.OsAdd.addObserver( this);
	Eop.OsModify.addObserver( this);
	Eop.OsEndEdit.addObserver( this);
	Eop.OsInsert.addObserver( this);

	Gr1.setCarved( true);
	Gr2.setCarved( true);
	setBarMenu();
}

public static void main ( String[] args) {
	new ControlTest1();
}

public void open() {
	Lo.add( Bm, 0, 0, 1000, 0, true, 0, 0, 0, 150, 0);
	Lo.add( Gr1, 0, 0, 1000, 0, true, 50, 200, -50, 1100, 0);
	Lo.add( Sp, 0, 0, 500, 0, true, 100, 300, 0, 500, 0);
	Lo.add( Cp, 0, 0, 500, 0, true, 100, 550, 0, 750, 0);
	Lo.add( Ef, 0, 0, 500, 0, true, 100, 800, 0, 1000, 0);
	Lo.add( Pb, 528, 0, 666, 0, true, 0, 300, 0, 490, 0);
	Lo.add( Cb, 528, 0, 732, 8, true, 0, 560, 0, 730, 0);
	Lo.add( St, 528, 0, 803, 0, true, 0, 800, 0, 990, 0);
	Lo.add( Rb1, 810, 0, 1000, 0, true, 90, 680, -150, 800, 0);
	Lo.add( Rb2, 810, 0, 1000, 0, true, 90, 840, -150, 960, 0);
	Lo.add( Gr2, 0, 0, 1000, 1000, true, 50, 1200, -50, -50, 0);
	Lo.add( Tp, 0, 0, 500, 1000, true, 100, 1300, 0, -100, 0);
	Lo.add( Eop, 510, 0, 1000, 1000, true, 0, 1300, -100, -100, 0);
	Lo.add( Pb2, 832, 0, 961, 0, true, 0, 280, 0, 630, 0);

	init();
	if ( Bounds != null)
		openIn( Bounds);
	else
		openIn( 32, 176, 600, 400);
}

void setBarMenu(){
	Bm.addItem( "File", new Menu( "~Open,~Close") );
	Bm.addItem( "~Do it" );
	Bm.addItem( "~Help" );
}

public void update (Observable obs, Object arg) {
	if ( obs == Eop.OsModify)
		Eop.modifyEntry( ((DukeEntry)arg).Text);
	else if ( obs == Eop.OsEndEdit){
		DukeEntry de = (DukeEntry)arg;
		String es = (String)(((ObserverSocket)obs).getExtraArg());
		de.Text = es;
	}
	else if ( obs == Eop.OsInsert)
		Eop.insertEntry( new DukeEntry( 0, "insert duke", Img));
	else if ( obs == Eop.OsAdd)
		Eop.addEntry( new DukeEntry( 0, "append duke", Img));
}
}

class DukeEntry
  implements SelfDrawingObject
{
	String Num;
	String Text;
	static Font FRegular = new Font( "Helvetica", Font.BOLD, 13);
	static Font FSmall = new Font( "Helvetica", Font.PLAIN, 12);
	Image Img;

DukeEntry (int num, String text, Image img) {
	Text = text;
	Num = Integer.toString( num);
	Img = img;
}

public int drawHeight () {
	return 30;
}

public void drawSelfIn ( Object o) {
	List op = (List) o;
	Rectangle r = op.DrawRect;
	Graphics  g = op.DrawGraphics;

	g.setFont( FRegular);
	g.drawString( Num, r.x + 5, r.y + r.height- 5);

	GraphicsLib.drawImageVCentered( g, Img, r.x + 20, r.y, r.height, op);

	g.setFont( FSmall);
	g.drawString( Text, r.x + 50, r.y + r.height- 5);
}

public String label () {
	return Text;
}

public int maxDrawWidth () {
	return Awt.ScreenWidth / 2;
}
}
