/* $Id:$
***************************************************************************

   X server for LibGGI - Graphics acceleration

   Copyright (C) 1997	   Michael Krause	[rawstyle@ms.demo.org]
   Copyright (C) 1998-1999 Marcus Sundberg	[marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

***************************************************************************
*/

#define PSZ 8
#include "mi.h"
#include "cfb.h"
#include "../../hw/xfree86/common/cfb16.h"
#include "../../hw/xfree86/common/cfb24.h"
#include "../../hw/xfree86/common/cfb32.h"

#include "scrnintstr.h"
#include "mibstore.h"
#include "gcstruct.h"

#include "xggi.h"


static unsigned long
mask2offset(unsigned long mask)
{
	int i;
	
	for (i = 0; (mask & 1) == 0; i++) {
		mask >>= 1;
	}
	
	return i;
}

/* dump_region, just here for debugging..
 */
#if 0
static void dump_region(RegionPtr p)
{
	BoxPtr box;
	int n;

	box = REGION_RECTS(p);
	n = REGION_NUM_RECTS(p);

	for (;n--;box++) {
		ErrorF("%d %d %d %d\n", box->x1, box->y1, box->x2, box->y2);
	}
}
#endif

/*
 * Ripped from hw/xfree86/accel/s3/s3blt.c
 */

static void
xggiFindOrdering(DrawablePtr pSrcDrawable, DrawablePtr pDstDrawable, GC *pGC,
		 int numRects, BoxPtr boxes, int srcx, int srcy,
		 int dstx, int dsty, unsigned int *ordering)
{
	int   i, j, y;
	int   xMax, yMin, yMax;

	/*
	 * If not the same drawable then order of move doesn't matter. Following
	 * assumes that boxes are sorted from top to bottom and left to right.
	 */
	if ((pSrcDrawable != pDstDrawable) &&
	    ((pGC->subWindowMode != IncludeInferiors) ||
	     (pSrcDrawable->type == DRAWABLE_PIXMAP) ||
	     (pDstDrawable->type == DRAWABLE_PIXMAP))) {
		for (i = 0; i < numRects; i++)
			ordering[i] = i;
	} else {	/* within same drawable, must sequence moves
			 * carefully! */
		if (dsty <= srcy) {	/* Scroll up or stationary vertical. Vertical
					 * order OK */
			if (dstx <= srcx) {	/* Scroll left or stationary horizontal.
						 * Horizontal order OK as well */
				for (i = 0; i < numRects; i++)
					ordering[i] = i;
			} else {	/* scroll right. must reverse horizontal
					 * banding of rects. */
				for (i = 0, j = 1, xMax = 0; i < numRects; j = i + 1, xMax = i) {
					/* find extent of current horizontal band */
					y = boxes[i].y1;	/* band has this y coordinate */
					while ((j < numRects) && (boxes[j].y1 == y))
						j++;
					/* reverse the horizontal band in the output ordering */
					for (j--; j >= xMax; j--, i++)
						ordering[i] = j;
				}
			}
		} else {			/* Scroll down. Must reverse vertical
						 * banding. */
			if (dstx < srcx) {	/* Scroll left. Horizontal order OK. */
				for (i = numRects - 1, j = i - 1, yMin = i,
					     yMax = 0; i >= 0;
				     j = i - 1, yMin = i) {
					/* find extent of current horizontal
					   band */
					/* band has this y coordinate */
					y = boxes[i].y1;
					while ((j >= 0) && (boxes[j].y1 == y))
						j--;
					/* reverse the horizontal band in the
					   output ordering */
					for (j++; j <= yMin; j++, i--, yMax++)
						ordering[yMax] = j;
				}
			} else {/* Scroll right or horizontal stationary.
				 * Reverse horizontal order as well (if
				 * stationary, horizontal order can be
				 * swapped without penalty and this is faster
				 * to compute). */
				for (i = 0, j = numRects - 1; i < numRects;
				     i++, j--) {
					ordering[i] = j;
				}
			}
		}
	}
}

/*
 * xggiCopyWindow - accelerated replacement for cfbCopyWindow
 *
 * pWin->drawable.x/y contains the destination position
 * ptOldOrg contains the old position
 * prgnSrc is a region describing the part of the source to be moved
 *  (this is padded by one pixel at all four edges of a window?!?!?)
 *
 * I don't really understand this, BTW ;)
 *
 */

static void
xggiCopyWindow(WindowPtr pWin, DDXPointRec ptOldOrg, RegionPtr prgnSrc)
{
	RegionRec rgnDst;
	BoxPtr pboxOrig, pbox;
	int dx, dy;
	int i, nbox;
	unsigned int *ordering;
	GC    dummyGC;
    
	dummyGC.subWindowMode = ~IncludeInferiors;
    
	REGION_INIT(pWin->drawable.pScreen, &rgnDst, NullBox, 0);
    
	dx = ptOldOrg.x - pWin->drawable.x;
	dy = ptOldOrg.y - pWin->drawable.y;
    
	REGION_TRANSLATE(pWin->drawable.pScreen, prgnSrc, -dx, -dy);
	REGION_INTERSECT(pWin->drawable.pScreen, &rgnDst,
			 &pWin->borderClip, prgnSrc);
    
	pboxOrig = REGION_RECTS(&rgnDst);
	nbox = REGION_NUM_RECTS(&rgnDst);
    
	ordering = (unsigned int *)ALLOCATE_LOCAL(nbox * sizeof(unsigned int));

	if (ordering) {
		int scr = xggiGetScreenIdx(pWin->drawable.pScreen);

		xggiFindOrdering((DrawablePtr)pWin, (DrawablePtr)pWin,
				 &dummyGC, nbox, pboxOrig,
				 ptOldOrg.x, ptOldOrg.y,
				 pWin->drawable.x, pWin->drawable.y, ordering);
		ggiResourceRelease(xggiScreens[scr].dbuf->resource);
		for (i = 0; i < nbox; i++) {
			pbox = &pboxOrig[ordering[i]];
			ggiCopyBox(xggiScreens[scr].vis,
				   pbox->x1 + dx, pbox->y1 + dy,
				   pbox->x2 - pbox->x1, pbox->y2 - pbox->y1,
				   pbox->x1, pbox->y1);
		}
		if (ggiResourceAcquire(xggiScreens[scr].dbuf->resource,
				       GGI_ACTYPE_WRITE | GGI_ACTYPE_READ)
		    != 0) {
			FatalError("Unable to re-acquire DirectBuffer\n");
		}
		DEALLOCATE_LOCAL(ordering);
	}
	
	REGION_UNINIT(pWin->drawable.pScreen, &rgnDst);
}


/*
 * xggiScreenInit
 *
 */
extern miBSFuncRec mfbBSFuncRec, cfbBSFuncRec, cfb16BSFuncRec;
extern miBSFuncRec cfb24BSFuncRec, cfb32BSFuncRec;

Bool
xggiScreenInit(ScreenPtr pScreen, pointer pbits,
	       int xsize, int ysize, int dpix, int dpiy, int width)
{
	VisualPtr visuals;
	DepthPtr depths;
	int nvisuals;
	int ndepths;
	int rootdepth = 0;
	VisualID defaultVisual;
	int bitsPerRGB;
	int	i;
	Bool Rstatus;
	VisualPtr visual;
	pointer oldDevPrivate = 0;
	int scr;
	miBSFuncPtr bsFuncs;

	scr = xggiGetScreenIdx(pScreen);

#ifdef XGGI_DEBUG
	ErrorF("scr: %d, depth: %d, bpp:%d\n", scr, xggiScreens[scr].depth,
	       xggiScreens[scr].bitsPerPixel);
#endif

	switch (xggiScreens[scr].depth) {
	case 8:
		bitsPerRGB = 8;
		break;
	case 15:
		bitsPerRGB = 5;
		break;
	case 16:
		bitsPerRGB = 6;
		break;
	default:
		bitsPerRGB = 8;
		break;
	}

	if (xggiScreens[scr].bitsPerPixel > 8) {
		if (!cfbSetVisualTypes(xggiScreens[scr].depth,
				       1 << TrueColor, bitsPerRGB)) {
			ErrorF("cfbSetVisualTypes failed\n");
			return FALSE;
		}
	}
	if (!cfbInitVisuals(&visuals, &depths, &nvisuals, 
			    &ndepths, &rootdepth, &defaultVisual,
			    1 << (xggiScreens[scr].bitsPerPixel - 1),
			    bitsPerRGB)) {
		ErrorF("cfbInitVisuals failed\n");
		return FALSE;
	}

#ifdef XGGI_DEBUG
	ErrorF("rootdepth: %d\n", rootdepth);
#endif

	if (rootdepth > 8) {
		for (i = 0, visual = visuals; i < nvisuals; i++, visual++) {
			if (visual->class == DirectColor
			    || visual->class == TrueColor) {
#define PIXFMT(scr)	((scr).dbuf->buffer.plb.pixelformat)
				visual->redMask
					= PIXFMT(xggiScreens[scr])->red_mask;
				visual->greenMask
					= PIXFMT(xggiScreens[scr])->green_mask;
				visual->blueMask
					= PIXFMT(xggiScreens[scr])->blue_mask;
#undef PIXFMT
				visual->offsetRed
					= mask2offset(visual->redMask);
				visual->offsetGreen
					= mask2offset(visual->greenMask);
				visual->offsetBlue
					= mask2offset(visual->blueMask);
			}
		}
	}

	if (scr == 0) {
		cfbWindowPrivateIndex = cfbGCPrivateIndex = -1;
	}
	pScreen->defColormap = FakeClientID(0);
	pScreen->whitePixel = (Pixel) 1;
	pScreen->blackPixel = (Pixel) 0;
	pScreen->QueryBestSize = mfbQueryBestSize;
	pScreen->RealizeFont = mfbRealizeFont;
	pScreen->UnrealizeFont = mfbUnrealizeFont;

	pScreen->CopyWindow = xggiCopyWindow;

	switch (rootdepth) {
	case 1:
		bsFuncs = &mfbBSFuncRec;
		pScreen->GetImage = mfbGetImage;
		pScreen->GetSpans = mfbGetSpans;
		pScreen->PaintWindowBackground = mfbPaintWindow;
		pScreen->PaintWindowBorder = mfbPaintWindow;
		pScreen->CreateGC = mfbCreateGC;
		if (!mfbAllocatePrivates(pScreen, NULL, NULL)) {
			ErrorF("mfbAllocatePrivates failed\n");
			return FALSE;
		}
		pScreen->CreateWindow = mfbCreateWindow;
		pScreen->DestroyWindow = mfbDestroyWindow;
		pScreen->PositionWindow = mfbPositionWindow;
		pScreen->ChangeWindowAttributes = mfbChangeWindowAttributes;
		pScreen->RealizeWindow = mfbMapWindow;
		pScreen->UnrealizeWindow = mfbUnmapWindow;
		pScreen->CreatePixmap = mfbCreatePixmap;
		pScreen->DestroyPixmap = mfbDestroyPixmap;
		mfbRegisterCopyPlaneProc(pScreen, mfbCopyPlane);
		break;
	case 8:
		bsFuncs = &cfbBSFuncRec;
		pScreen->GetImage = cfbGetImage;
		pScreen->GetSpans = cfbGetSpans;
		pScreen->PaintWindowBackground = cfbPaintWindow;
		pScreen->PaintWindowBorder = cfbPaintWindow;
		pScreen->CreateGC = cfbCreateGC;
		if (!cfbAllocatePrivates(pScreen, NULL, NULL)) {
			ErrorF("cfbAllocatePrivates failed\n");
			return FALSE;
		}
		pScreen->CreateWindow = cfbCreateWindow;
		pScreen->DestroyWindow = cfbDestroyWindow;
		pScreen->PositionWindow = cfbPositionWindow;
		pScreen->ChangeWindowAttributes = cfbChangeWindowAttributes;
		pScreen->RealizeWindow = cfbMapWindow;
		pScreen->UnrealizeWindow = cfbUnmapWindow;
		pScreen->CreatePixmap = cfbCreatePixmap;
		pScreen->DestroyPixmap = cfbDestroyPixmap;
		mfbRegisterCopyPlaneProc(pScreen, cfbCopyPlane);
		break;
	case 15:
	case 16:
		bsFuncs = &cfb16BSFuncRec;
		pScreen->GetImage = cfb16GetImage;
		pScreen->GetSpans = cfb16GetSpans;
		pScreen->PaintWindowBackground = cfb16PaintWindow;
		pScreen->PaintWindowBorder = cfb16PaintWindow;
		pScreen->CreateGC = cfb16CreateGC;
		if (!cfb16AllocatePrivates(pScreen, NULL, NULL)) {
			ErrorF("cfb16AllocatePrivates failed\n");
			return FALSE;
		}
		pScreen->CreateWindow = cfb16CreateWindow;
		pScreen->DestroyWindow = cfb16DestroyWindow;
		pScreen->PositionWindow = cfb16PositionWindow;
		pScreen->ChangeWindowAttributes = cfb16ChangeWindowAttributes;
		pScreen->RealizeWindow = cfb16MapWindow;
		pScreen->UnrealizeWindow = cfb16UnmapWindow;
		pScreen->CreatePixmap = cfb16CreatePixmap;
		pScreen->DestroyPixmap = cfb16DestroyPixmap;
		mfbRegisterCopyPlaneProc(pScreen, cfb16CopyPlane);
		break;
	case 24:
	case 32:
		if (xggiScreens[scr].bitsPerPixel == 24) {
			bsFuncs = &cfb24BSFuncRec;
			pScreen->GetImage = cfb24GetImage;
			pScreen->GetSpans = cfb24GetSpans;
			pScreen->PaintWindowBackground = cfb24PaintWindow;
			pScreen->PaintWindowBorder = cfb24PaintWindow;
			pScreen->CreateGC = cfb24CreateGC;
			if (!cfb24AllocatePrivates(pScreen, NULL, NULL)) {
				ErrorF("cfb24AllocatePrivates failed\n");
				return FALSE;
			}
			pScreen->CreateWindow = cfb24CreateWindow;
			pScreen->DestroyWindow = cfb24DestroyWindow;
			pScreen->PositionWindow = cfb24PositionWindow;
			pScreen->ChangeWindowAttributes
				= cfb24ChangeWindowAttributes;
			pScreen->RealizeWindow = cfb24MapWindow;
			pScreen->UnrealizeWindow = cfb24UnmapWindow;
			pScreen->CreatePixmap = cfb24CreatePixmap;
			pScreen->DestroyPixmap = cfb24DestroyPixmap;
			mfbRegisterCopyPlaneProc(pScreen, cfb24CopyPlane);
		} else {
			bsFuncs = &cfb32BSFuncRec;
			pScreen->GetImage = cfb32GetImage;
			pScreen->GetSpans = cfb32GetSpans;
			pScreen->PaintWindowBackground = cfb32PaintWindow;
			pScreen->PaintWindowBorder = cfb32PaintWindow;
			pScreen->CreateGC = cfb32CreateGC;
			if (!cfb32AllocatePrivates(pScreen, NULL, NULL)) {
				ErrorF("cfb32AllocatePrivates failed\n");
				return FALSE;
			}
			pScreen->CreateWindow = cfb32CreateWindow;
			pScreen->DestroyWindow = cfb32DestroyWindow;
			pScreen->PositionWindow = cfb32PositionWindow;
			pScreen->ChangeWindowAttributes
				= cfb32ChangeWindowAttributes;
			pScreen->RealizeWindow = cfb32MapWindow;
			pScreen->UnrealizeWindow = cfb32UnmapWindow;
			pScreen->CreatePixmap = cfb32CreatePixmap;
			pScreen->DestroyPixmap = cfb32DestroyPixmap;
			mfbRegisterCopyPlaneProc(pScreen, cfb32CopyPlane);
		}
		break;
	default:
		FatalError("root depth %d not supported\n", rootdepth);
	}

	pScreen->CreateColormap = cfbInitializeColormap;
	pScreen->DestroyColormap = (DestroyColormapProcPtr)NoopDDA;
	if (rootdepth == 1) {
		pScreen->ResolveColor = mfbResolveColor;
	} else {
		pScreen->ResolveColor = cfbResolveColor;
	}
	pScreen->BitmapToRegion = mfbPixmapToRegion;

	if (rootdepth != 8) {
		oldDevPrivate = pScreen->devPrivate;
	}

	Rstatus = miScreenInit(pScreen, pbits, xsize, ysize, dpix, dpiy, width,
			       rootdepth, ndepths, depths, defaultVisual,
			       nvisuals, visuals, bsFuncs);

	switch (rootdepth) {
	case 1:
		pScreen->CloseScreen = mfbCloseScreen;
		break;
	case 8:
		pScreen->CloseScreen = cfbCloseScreen;
		break;
	case 15:
	case 16:
		pScreen->CloseScreen = cfb16CloseScreen;
		pScreen->CreateScreenResources = cfb16CreateScreenResources;
		pScreen->devPrivates[cfb16ScreenPrivateIndex].ptr
			= pScreen->devPrivate;
		pScreen->devPrivate = oldDevPrivate;
		break;
	case 24:
	case 32:
		if (xggiScreens[scr].bitsPerPixel == 24) {
			pScreen->CloseScreen = cfb24CloseScreen;
			pScreen->CreateScreenResources
				= cfb24CreateScreenResources;
			pScreen->devPrivates[cfb24ScreenPrivateIndex].ptr
				= pScreen->devPrivate;
			pScreen->devPrivate = oldDevPrivate;
		} else {
			pScreen->CloseScreen = cfb32CloseScreen;
			pScreen->CreateScreenResources 
				= cfb32CreateScreenResources;
			pScreen->devPrivates[cfb32ScreenPrivateIndex].ptr
				= pScreen->devPrivate;
			pScreen->devPrivate = oldDevPrivate;
		}
		break;
	}
	
	return Rstatus;
}

