/* wmnetselect - Window Maker Netscape Selection dock app
   wmnetselect version 0.8    Last Modification:  22 Apr 1999
   
   Code canabalized from asclock/wmclock/wmmail.
   Thanks to respective authors of those apps, Beat Christen,
   Per Liden, Bryan Chan, and others I may have missed for
   making their code available.
   
   All errors herein are made by Patrick Hill (apathos@bham.net)
   This particular incarnation Copyright (c) 1999 Patrick Hill
   
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2, or (at your option)
 * 	any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program (see the file COPYING); if not, write to the
 * 	Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 *      Boston, MA  02111-1307, USA
 *
 *
 */

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>
#include <time.h>
#include <X11/Xatom.h>

#include <X11/Xproto.h>
#include <X11/Xmu/WinUtil.h>	/* for XmuClientWindow() */
#include <sys/types.h>
#include <unistd.h>

#define MOZILLA_VERSION_PROP	"_MOZILLA_VERSION"
#define MOZILLA_LOCK_PROP	"_MOZILLA_LOCK"
#define MOZILLA_COMMAND_PROP	"_MOZILLA_COMMAND"
#define MOZILLA_RESPONSE_PROP	"_MOZILLA_RESPONSE"
#define MOZILLA_URL_PROP	"_MOZILLA_URL"
#define DEFAULT_TIMEOUT 10000

static Window MozWin = None;

#include "netscape.xpm"
#include "negative.xpm"

#define VERSION 0.8
#define DEBUG 0

/* default executable is netscape, may be overridden by command line parameter */
#define EXECUTABLE "netscape"
#define LEFT_BUTTON          1         /* left mousebutton id */
#define MIDDLE_BUTTON        2         /* middle mousebutton id */
#define RIGHT_BUTTON         3         /* right mousebutton id */
#define DOUBLE_CLICK_TIME    250       /* double click latency (ms)  */
#define MW_EVENTS   (ExposureMask | ButtonPressMask | StructureNotifyMask)
#define FALSE 0

Display *dpy;
Window Root;
int screen;
int x_fd;
int d_depth;
XSizeHints mysizehints;
XWMHints mywmhints;
Pixel back_pix, fore_pix;
GC NormalGC;
Window iconwin, win;
char *ProgName;
char *Geometry;
char Execute[100];
char *ERR_colorcells = "not enough free color cells\n";
long Length = (65536 / sizeof(long));

typedef struct _XpmIcon {
    Pixmap pixmap;
    Pixmap mask;
    XpmAttributes attributes;
}        XpmIcon;

XpmIcon nets, negt;
XpmIcon visible;

/* prototypes */

void GetXPM(void);
static void CreatePixmap(Display *dpy, Window Root, char **data, XpmIcon* icon);
Pixel GetColor(char *name);
void RedrawWindow( XpmIcon *v);
void InsertTime();
int ProcessSelection (char *selection, Display *dpy, int NewWin, int dontask,
    int noproto, int quiet, int button);
int Selection2Bookmark (char *prefix, char *select, Window win);
int URLSelection (char *prefix, char *select, Window win, int NewWin);
int Search4Selection (char *select, Window win, int NewWin);
void strim(char * str);
void transform(char * str);
char *encode (char *url, int button);
char *protocol (char *select, int noproto);
static void InitAtoms (Display *dpy);
static Window FindMozWin(Display *dpy);
static int SendCommand (Display *dpy, Window win, const char *command);

/*****************************************************************************/

static char *help_message[] = {
    "where options include:",
    " -dontask                Don't prompt for URL if there is no X selection.",
    " -exe <program>          program to start on double-click, defaults to netscape.",
    " -onstartup              start netscape when wmnetselect is started.",
    " -noprotocol             Don't add http or ftp or mailto to URL.",
    " -position [+|-]x[+|-]y  position of wmnetselect.",
    " -quiet                  disable audible error indication.",
    NULL
};

void usage() {
    char **cpp;

    fprintf(stderr,"\n%s version %4.2f\n\n",
            ProgName, VERSION);
    fprintf(stderr,"usage:  %s [-options ...] \n", ProgName);
    for (cpp = help_message; *cpp; cpp++) {
        fprintf(stderr, "%s\n", *cpp);
    }
    fprintf(stderr,"\n");
    exit(1);
}


int main(int argc,char *argv[]) {
    static Time last_left_mouse_click   = -1;
    int i;
    unsigned int borderwidth ;
    char *display_name = NULL;
    char *wname = "wmnetselect";
    XGCValues gcv;
    unsigned long gcm;
    XEvent event;
    XTextProperty name;
    XClassHint classHint;
    Pixmap pixmask;

    unsigned long nitems, bytes_after;
    Atom type, property, target;
    int format;
    unsigned char *selection;
    Bool exists;

    int NewWin, cnt, delay, dontask, onstart, noproto, quiet;
    int ret = 25;
    
    cnt = dontask = onstart = noproto = quiet = 0;

    ProgName = argv[0];
    Geometry = "";

    /* Default program to execute is #define EXECUTABLE  */
    strcpy (Execute, EXECUTABLE);

    /* Parse command line options */
    for(i=1;i<argc;i++) {
        char *arg= argv[i];

        if (arg[0] == '-') {
            switch(arg[1]) {
            case 'd':
                dontask=1;	/* if no selection, ask */
                continue;
            case 'e':
                if(++i >=argc) usage();
                strcpy(&Execute[0], argv[i]);
                continue;
            case 'o':
                onstart=1;	/* start it at startup */
                continue;
            case 'n':
                noproto=1;	/* don't infer protocol */
                continue;
            case 'p':
                if(++i >=argc) usage();
                Geometry = argv[i];
                continue;
            case 's':
            case 'q':
                quiet=1;	/* no XBells */
                continue;
            default:
                usage();
            }
        }
    }

    /* Open the display */
    if (!(dpy = XOpenDisplay(display_name))) {
        fprintf(stderr,"%s: can't open display %s\n",
                ProgName, XDisplayName(display_name));
        exit (1);
    }
    screen = DefaultScreen(dpy);
    Root = RootWindow(dpy, screen);
    d_depth = DefaultDepth(dpy, screen);
    x_fd = XConnectionNumber(dpy);

    GetXPM();

    /* Create a window to hold the banner */
    mysizehints.flags= USSize|USPosition;
    mysizehints.x = 0;
    mysizehints.y = 0;

    back_pix = GetColor("white");
    fore_pix = GetColor("black");

    XWMGeometry(dpy, screen, Geometry, NULL, (borderwidth =1), &mysizehints,
                &mysizehints.x,&mysizehints.y,&mysizehints.width,&mysizehints.height, &i);

    mysizehints.width = nets.attributes.width;
    mysizehints.height= nets.attributes.height;

    win = XCreateSimpleWindow(dpy,Root,mysizehints.x,mysizehints.y,
                              mysizehints.width,mysizehints.height,
                              borderwidth,fore_pix,back_pix);

    iconwin = XCreateSimpleWindow(dpy,win,mysizehints.x,mysizehints.y,
                                  mysizehints.width,mysizehints.height,
                                  borderwidth,fore_pix,back_pix);

    XSetWMNormalHints(dpy, win, &mysizehints);
    classHint.res_name =  "wmnetselect";
    classHint.res_class = "WMNetselect";
    XSetClassHint(dpy, win, &classHint);

    XSelectInput(dpy,win,MW_EVENTS);
    XSelectInput(dpy,iconwin,MW_EVENTS);

    if (XStringListToTextProperty(&wname, 1, &name) == 0) {
        fprintf(stderr, "%s: can't allocate window name\n", ProgName);
        exit(-1);
    }
    XSetWMName(dpy, win, &name);

    /* Create a GC for drawing */
    gcm = GCForeground|GCBackground|GCGraphicsExposures;
    gcv.foreground = fore_pix;
    gcv.background = back_pix;
    gcv.graphics_exposures = FALSE;
    NormalGC = XCreateGC(dpy, Root, gcm, &gcv);

    mywmhints.initial_state = WithdrawnState;
    mywmhints.icon_window = iconwin;
    mywmhints.icon_x = mysizehints.x;
    mywmhints.icon_y = mysizehints.y;
    mywmhints.window_group = win;
    mywmhints.flags = StateHint | IconWindowHint | IconPositionHint
                      | WindowGroupHint;
    XSetWMHints(dpy, win, &mywmhints);

    XSetCommand(dpy, win, argv, argc);
    XMapWindow(dpy,win);

    if (onstart) {
        strcat(&Execute[0], "&");
        system(Execute);
        /* take the ampersand back out */
        Execute[strlen(Execute)-1]='\0';
    }

    InitAtoms (dpy);

    RedrawWindow(&visible);
    while(1) {
        /* read a packet */
        while (XPending(dpy)) {
            XNextEvent(dpy,&event);
            switch(event.type) {
            case Expose:
                if(event.xexpose.count == 0 )
                    RedrawWindow(&visible);
                break;
            case ButtonPress:
                if (event.xbutton.button == LEFT_BUTTON) {
                    if (last_left_mouse_click > 0 && (event.xbutton.time
		            - last_left_mouse_click) <= DOUBLE_CLICK_TIME) {
                        last_left_mouse_click = -1;
                        XCopyArea(dpy, negt.pixmap, visible.pixmap,NormalGC,
                                  0,0,mysizehints.width,mysizehints.height,0,0);

                        delay=1;
                        RedrawWindow(&visible);

                        strcat(&Execute[0], "&");
                        system(Execute);

                        /* take the ampersand back out */
                        Execute[strlen(Execute)-1]='\0';
                   }
                    last_left_mouse_click = event.xbutton.time;
                    if ((event.xbutton.state & ControlMask) != 0 ) {
                        NewWin = 0;
		        property = XInternAtom(dpy, "TEXT_STRING", exists = False);
                        target = XInternAtom(dpy, "STRING", exists = True);
                        XConvertSelection(dpy, XA_PRIMARY, target, property, win, CurrentTime);
 		    }
                }

                if (event.xbutton.button == MIDDLE_BUTTON ||
			event.xbutton.button == RIGHT_BUTTON) {

                    /* Open a new window when ctrl-[Middle|Right]Button pressed */
                    if ((event.xbutton.state & ControlMask) != 0 )
                        NewWin = 1;
                    else
                        NewWin = 0;

                    /* create an atom for data property to be put into */
                    property = XInternAtom(dpy, "TEXT_STRING", exists = False);

                    /* target type atom must have been created by owner */
                    target = XInternAtom(dpy, "STRING", exists = True);

                    /* now send out a request for the data */
                    XConvertSelection(dpy, XA_PRIMARY, target, property, win, CurrentTime);
                }
                break;
            case SelectionNotify:
                if (event.xselection.property == property) {
                    ret = XGetWindowProperty(dpy, win, property, 0L, Length,
                                             True, target, &type, &format,
                                             &nitems, &bytes_after, &selection);

                    if (NULL != selection) {
                        XCopyArea(dpy, negt.pixmap, visible.pixmap,NormalGC,
                                  0,0,mysizehints.width,mysizehints.height,0,0);
                        delay = 1;
                        RedrawWindow(&visible);
                        ProcessSelection (selection, dpy, NewWin, dontask,
			    noproto, quiet, event.xbutton.button);
                    }

                } else {
                    if (event.xselection.property == None) {
                        /* printf ("Nothing higlighted.\n");  */
                        ProcessSelection (NULL, dpy, 0, dontask, 0, quiet, event.xbutton.button);
                    }
                }
                break;
            case DestroyNotify:
                XCloseDisplay(dpy);
                exit(0);
            default:
                break;
            }
        }
        XFlush(dpy);
#ifdef SYSV
        poll((struct poll *) 0, (size_t) 0, 50);
#else
        usleep(50000L);			/* 5/100 sec */
#endif
        /* Delay ~2 seconds before redrawing default pixmap  */
        if (delay) cnt++;
        if (cnt > 40) {
            cnt = 0;
            delay=0;
            XCopyArea(dpy, nets.pixmap, visible.pixmap,NormalGC,
                      0,0,mysizehints.width,mysizehints.height,0,0);
            RedrawWindow(&visible);
        }
    }
    return 0;
}

/****************************************************************************/

void nocolor(char *a, char *b) {
    fprintf(stderr,"%s: can't %s %s\n", ProgName, a,b);
}

/****************************************************************************/

void GetXPM(void) {
    XWindowAttributes attributes;

    /* for the colormap */
    XGetWindowAttributes(dpy,Root,&attributes);

    CreatePixmap(dpy, Root, netscape, &nets);
    CreatePixmap(dpy, Root, negative, &negt);
    CreatePixmap(dpy, Root, netscape, &visible);
}

/****************************************************************************/

static void CreatePixmap(Display *dpy, Window Root, char **data, XpmIcon* icon) {
    int ret;

    icon->attributes.valuemask |= (XpmReturnPixels | XpmReturnExtensions
                                   | XpmExactColors | XpmCloseness);
    icon->attributes.exactColors=False;
    icon->attributes.closeness=40000;
    ret = XpmCreatePixmapFromData(dpy, Root, data, &(icon->pixmap),
                                  &(icon->mask), &(icon->attributes));
    if(ret != XpmSuccess) {
        fprintf(stderr, ERR_colorcells);
        exit(1);
    }
}

/****************************************************************************/
/* Removes expose events for a specific window from the queue */

int flush_expose(Window win) {
    XEvent dummy;
    int i=0;

    while (XCheckTypedWindowEvent (dpy, win, Expose, &dummy))i++;
    return i;
}

/****************************************************************************/
/* Draws the icon window */

void RedrawWindow(XpmIcon *v) {
    flush_expose (iconwin);
    XCopyArea(dpy,v->pixmap,iconwin,NormalGC,
              0,0,v->attributes.width, v->attributes.height,0,0);
    flush_expose (win);
    XCopyArea(dpy,v->pixmap,win,NormalGC,
              0,0,v->attributes.width, v->attributes.height,0,0);

}

/****************************************************************************/

Pixel GetColor(char *name) {
    XColor color;
    XWindowAttributes attributes;

    XGetWindowAttributes(dpy,Root,&attributes);
    color.pixel = 0;
    if (!XParseColor (dpy, attributes.colormap, name, &color)) {
        nocolor("parse",name);
    } else if(!XAllocColor (dpy, attributes.colormap, &color)) {
        nocolor("alloc",name);
    }
    return color.pixel;
}

/****************************************************************************/

/*
 * Process the X selection:
 *   trim whitespace
 *   encode URL per RFC1738
 *   transform Slashdot, etc.
 *   Add protocol, if there is none
 *   Get existing Netscape window id, 
 *     or start Netscape if there isn't one.
 *   Send "processed" selection to Netscape via SendCommand().
 */
 
int ProcessSelection (char *selection, Display *dpy, int NewWin, int dontask,
        int noproto, int quiet, int button) {
    char *prefix, *select;
    int err;
    Window win;

    strim (selection);
    select = encode (selection, button);
    if (select == NULL) {
        fprintf (stderr, "Could not allocate memory\n");
        return -1;
    }

    /* transform keywords like slashdot, windowmaker, etc. */
    transform (select);
    
    /* This block determines how to handle Null selections.  */
    if (strlen (select) == 0) {
        if (dontask) {
            if (!quiet) XBell(dpy, 10);
            if (select) free (select);
            return 0;
        } else {
	    NewWin = 0;
	    noproto = 1;
 	}
    }
    prefix = protocol (select, noproto);
    
    switch (button) {
    case LEFT_BUTTON:
        err = Selection2Bookmark (prefix, select, FindMozWin(dpy));
        break;
    case MIDDLE_BUTTON:
        err = URLSelection (prefix, select, FindMozWin(dpy), NewWin);
        break;
    case RIGHT_BUTTON:
        err = Search4Selection (select, FindMozWin(dpy), NewWin);
        break;
    }
    if (select) free (select);
    return err;
}

/*
 * Create Bookmark using selection.  If Netscape is not started,
 * start it, then create bookmark.
 */
 
int Selection2Bookmark (char *prefix, char *select, Window win) {
    char *netcommand;
    int error;

    if (win == None) {
        /* No netscape window, start one.  */
	/* prefix + & + "" + spaces + 2>/dev/null = 24 */
        netcommand = (char *)malloc(sizeof(char) * (strlen(Execute)
	    + strlen(select) + 25));
        if (netcommand == NULL) {
             fprintf (stderr, "Could not allocate memory\n");
            return -1;
        }
        sprintf (netcommand, "%s \"%s%s\" 2>/dev/null &", Execute,
                 prefix, select);
        error = system (netcommand);
    } else {
    
	netcommand = (char *) malloc(sizeof(char) * (strlen(select) + 30));
	if (netcommand == NULL) {
            fprintf (stderr, "Could not allocate memory\n");
            return -1;
	}
	sprintf (netcommand, "AddBookmark(%s%s,noraise)", prefix, select);

	error = SendCommand(dpy, win, netcommand);
    }
    if (netcommand) free (netcommand);
    return error;
}

int URLSelection (char *prefix, char *select, Window win, int NewWin) {
    char *netcommand = NULL;
    int error;
    
    if (win == None) {
        /* No netscape window: start one.  */
	/* prefix + & + "" + spaces + 2>/dev/null = 24 */
        netcommand = (char *)malloc(sizeof(char) * (strlen(Execute)
	    + strlen(select) + 25));
        if (netcommand == NULL) {
            fprintf (stderr, "Could not allocate memory\n");
            return -1;
        }
        sprintf (netcommand, "%s \"%s%s\" 2>/dev/null &", Execute,
                 prefix, select);
        error = system (netcommand);
    } else /* win != None */ {
        netcommand = (char *) malloc(sizeof(char) * (strlen(select) + 27));
        if (netcommand == NULL) {
            fprintf (stderr, "Could not allocate memory\n");
            return -1;
        }
        sprintf (netcommand, "openURL(%s%s%s)",
                 prefix, select, NewWin ? ",newwindow" : "");

        error = SendCommand(dpy, win, netcommand);
    }
    /* printf ("\nerr = <%d>, netcommand=<%s> ",error, netcommand);  */
    if (netcommand) free (netcommand);
    return error;
}

/*
 * Send selection to the search engine as a query.
 */
 
int Search4Selection (char *select, Window win, int NewWin) {
    static char *google = "http://www.google.com/search?q=";
    static char *numhits = "&num=30";
    char *netcommand = NULL;
    int error;
    
    if (win == None) {
        /* No netscape window, start one.  */
        /* 2>/dev/null + spaces + & + "" + google + numhits = 55 */
        netcommand = (char *)malloc (sizeof(char) * (strlen(Execute)
	    + strlen(select) + 56));
        if (netcommand == NULL) {
            fprintf (stderr, "Could not allocate memory\n");
            return -1;
        }
        sprintf (netcommand, "%s \"%s%s%s\" 2>/dev/null &", Execute,
                 google, select, numhits);
        error = system (netcommand);
    } else /* win != None */ {
        /* strlen ("openURL(,newwindow)") + google + numhits = 57 */
        netcommand = (char *) malloc(sizeof(char) * (strlen(select) + 58));
        if (netcommand == NULL) {
            fprintf (stderr, "Could not allocate memory\n");
            return -1;
        }
        sprintf (netcommand, "openURL(%s%s%s%s)",
                 google, select, numhits, NewWin ? ",newwindow" : "");

        error = SendCommand(dpy, win, netcommand);
    }
    if (netcommand) free (netcommand);
    return error;
}

/* Trim whitespace from both ends of str */

void strim(char *str) {
    int beg, end;

    if (str != NULL && *str != '\0') {
        end = strlen(str);
        for (; end > 0 && isspace(str[end-1]); end--);

        str[end] = '\0';
        for (beg = 0; beg < end && isspace(str[beg]); beg++);

        if (beg > 0)
            memmove(str, &str[beg], end-beg+1);
    }
}

/* Transform windowmaker to windowmaker.org, etc.  */
/* encode() malloc'ed extra memory for select to add ".org" or ".net"  */

void transform (char *str) {
    if (strcasecmp (str, "windowmaker") == 0)
        strcat (str, ".org");
    else if (strcasecmp (str, "slashdot") == 0)
        strcat (str, ".org");
    else if (strcasecmp (str, "freshmeat") == 0)
        strcat (str, ".net");
}

/*
 * Validating URLs:  If the selection is to be interpreted as a URL,
 * then, encode extra chars with "%HH", where H is a Hex digit and
 * extra chars are "!", "*", "'", "(", ")", ","
 *
 *     encode chars per RFC1738
 */

char *encode (char *url, int button) {
    char *ncoded, esc[3], *uns;
    int i, j, len;
    static char *unsafe = "!*'(),{};|\\^~[]`";
    static char *punctuation = "#?&+$%\":<>/.=!*'(),{};|\\^~[]`";
    
    if (NULL == url || (len = strlen(url)) == 0) {
        ncoded = (char *) malloc(sizeof(char) * 2);
	*ncoded = '\0';
	return (ncoded);
    }
    if (button == RIGHT_BUTTON)
    	uns = punctuation;
    else
        uns = unsafe;
    i=j=0;

    /* allocate extra chars for ".org" or ".net"   */
    ncoded = (char *) malloc(sizeof(char) * (len + 5));
    if (ncoded == NULL) {
        fprintf (stderr, "Could not allocate memory\n");
        return NULL;
    }

    while (1) {
	if (strchr (uns, url[j])) {
	           sprintf (esc, "%2x", url[j]);
            if ((ncoded = (char *) realloc(ncoded, sizeof(char) * (len + 4)))
                        == NULL)
                return NULL;
            ncoded[i++]='%';
            ncoded[i++]=esc[0];
            ncoded[i++]=toupper(esc[1]);
	}
	 else if (isspace (url[j]))
	     ncoded[i++] = '+';
	 else
	     ncoded[i++] = url[j];

        if (url[++j] == '\0')
            break;
    }
    ncoded[i] = '\0';
    return (ncoded);
}

/*
 * Heuristic to supply the URL protocol: mailto, ftp;//, or http://
 */

char *protocol (char *url, int noproto) {
     static char ptcol[8];
     char *ptr;
    
    if (noproto || strstr(url, ":/"))
    	return (strcpy(ptcol,""));

    /* Are the first 4 chars "ftp." ?  */
    ptr = url;
    if (strstr(url, "ftp.") == ptr)
         return (strcpy (ptcol,"ftp://"));

    /* contains a '@' but no '/'  */
    if (!strchr(url, '/') && strchr(url, '@'))
         return (strcpy (ptcol, "mailto:"));
    return (strcpy (ptcol, "http://"));
}

/********************* nsremote **********************************
  
  Netscape remote control mechanism:
  See the reference implementation of the Netscape remote control
  protocol (written by ex-Mozillan Jamie Zawinski jwz@jwz.org) at:
     http://home.netscape.com/newsref/std/remote.c
 
********************** nsremote **********************************/

static Atom XA_MOZILLA_VERSION  = 0;
static Atom XA_MOZILLA_LOCK     = 0;
static Atom XA_MOZILLA_COMMAND  = 0;
static Atom XA_MOZILLA_RESPONSE = 0;

static void InitAtoms (Display *dpy) {
    if (!XA_MOZILLA_VERSION)
        XA_MOZILLA_VERSION = XInternAtom (dpy, MOZILLA_VERSION_PROP, False);
    if (!XA_MOZILLA_LOCK)
        XA_MOZILLA_LOCK = XInternAtom (dpy, MOZILLA_LOCK_PROP, False);
    if (!XA_MOZILLA_COMMAND)
        XA_MOZILLA_COMMAND = XInternAtom (dpy, MOZILLA_COMMAND_PROP, False);
    if (!XA_MOZILLA_RESPONSE)
        XA_MOZILLA_RESPONSE = XInternAtom (dpy, MOZILLA_RESPONSE_PROP, False);
}

/*
 * See if the given window is a Netscape window by looking for the
 * XA_MOZILLA_VERSION property
 */

static int
Check4Moz(Display *dpy, Window win) {
    Atom type;
    int format;
    unsigned long nitems, bytes_after;
    unsigned char *version = NULL;
    int status = XGetWindowProperty(dpy, win, XA_MOZILLA_VERSION, 0,
                                    Length, False, XA_STRING, &type,
                                    &format, &nitems, &bytes_after, &version);

    if (status != Success || !version) {
        if (version)
            XFree(version);
        return 0;
    }
    XFree(version);
    return 1;
}

/*
 * Find a netscape window.  If none available, return None.
 */

static Window
GetWindow(Display *dpy) {
    int i;
    Window root = RootWindowOfScreen (DefaultScreenOfDisplay (dpy));
    Window root2, parent, *kids;
    unsigned int nkids;
    Window result = None;

    if (! XQueryTree(dpy, root, &root2, &parent, &kids, &nkids)) {
        return None;
    }
    if (root != root2) {
        return None;
    }
    if (parent != None) {
        return None;
    }
    if (! (kids && nkids)) {
        return None;
    }

    for (i = 0; i < nkids; i++) {
        Window w = XmuClientWindow(dpy, kids[i]);
        if (Check4Moz(dpy, w)) {
            result = w;
            break;
        }
    }
    return result;
}

/* 
 * Trap error, but ignore it.
 */

int ErrorHandler (Display *dpy, XErrorEvent *event) {
    return 0;
}

/* 
 * Returns the saved window id Netscape.  If no window id set,
 *  call GetWindow to attempt to find one.
 */

static Window
FindMozWin(Display *dpy) {
    Window win = None;

    XSetErrorHandler (ErrorHandler);
    if (win != None) {
        if (! Check4Moz(dpy, win)) {
            return None;
        }
    }
    if (MozWin != None && win == None) {
        if (Check4Moz(dpy, MozWin)) {
            win = MozWin;
        } else {
            MozWin = None;
        }
    }
    if (win == None) {
        if ((win = GetWindow(dpy)) == None) {
            return None;
        }
        MozWin = win;
    }
    return win;
}

/*
 * Participate in the Netscape locking protocol so commands don't collide
 */

static int
GetLock(Display *dpy, Window win) {
    char lock_data[255];
    Bool locked = False;

    sprintf(lock_data, "pid%d@", getpid());
    if (gethostname(lock_data + strlen(lock_data), 100) == -1) {
        fprintf (stderr, "gethostname() error\n");
        return 0;
    }

    do {
        int result;
        Atom type;
        int format;
        unsigned long nitems, bytes_after;
        unsigned char *data = NULL;

        /*
         * Grab the server so nobody else can do anything
         */

        XGrabServer(dpy);

        /*
         * Check for Mozilla Lock
         */
        result = XGetWindowProperty(dpy, win, XA_MOZILLA_LOCK, 0,
                                    Length, False, XA_STRING, &type,
                                    &format, &nitems, &bytes_after, &data);

        if (result != Success || type == None) {
            /*
             * It's not locked now, lock it
             */
            XChangeProperty(dpy, win, XA_MOZILLA_LOCK, XA_STRING,
                            8, PropModeReplace,
                            (unsigned char *) lock_data,
                            strlen(lock_data));
            locked = True;
        }
        /*
         * Release the server grab
         */

        XUngrabServer(dpy);
        XSync(dpy, False);

        if (!locked) {
           /*
            * There was already a lock in place.  Wait for
            * a PropertyDelete event.
            */

            while (1) {
                XEvent event;
                XNextEvent (dpy, &event);
                if (event.xany.type == DestroyNotify
			&& event.xdestroywindow.window == win) {
                    /* 
		     * fprintf (stderr, "window 0x%x unexpectedly
                     * destroyed.\n", win);
		     */
                    return -1;
                } else if (event.xany.type == PropertyNotify
			&& event.xproperty.state == PropertyDelete
			&& event.xproperty.window == win
			&& event.xproperty.atom == XA_MOZILLA_LOCK) {
                    break;
                }
            }
        }
        if (data)
            XFree(data);
    } while (! locked);

    return locked == True ? 1 : 0;
}

static void
ReleaseLock(Display *dpy, Window win) {
    Atom type;
    int format;
    unsigned long nitems, bytes_after;
    unsigned char *data;

    XGetWindowProperty(dpy, win, XA_MOZILLA_LOCK, 0,
                       Length, True /* delete */,
                       XA_STRING, &type, &format,
                       &nitems, &bytes_after, &data);
    if (data)
        XFree(data);
}

/*
 * Send a command to the Netscape window we found previously
 */

static int SendCommand (Display *dpy, Window win, const char *command) {
    int result, counter = 0;
    Bool done = False;
    Atom type;
    int format;
    unsigned long nitems, bytes_after;
    unsigned char *data = 0;

    /*
    * Select for PropertyChange events on the Netscape window
    */

    XSelectInput(dpy, win, (PropertyChangeMask | StructureNotifyMask));

    if (GetLock(dpy, win) == 0) {
        XSelectInput(dpy, win, 0);
        return 1;
    }

    /*
     * We've got a successful lock, so send the command to Netscape
     */

    /*  
     * fprintf (stderr, "(writing " MOZILLA_COMMAND_PROP " \"%s\" to 0x%x)\n",
     *  command, (unsigned int) win);
     */

    XChangeProperty(dpy, win, XA_MOZILLA_COMMAND,
                    XA_STRING, 8, PropModeReplace,
                    (unsigned char *) command, strlen(command));

    while (!done) {
        XEvent event;
        XNextEvent (dpy, &event);
        if (event.xany.type == DestroyNotify &&
                    event.xdestroywindow.window == win) {
            /*
	     * fprintf (stderr, "window 0x%x was destroyed.\n",
             * (unsigned int) win);
	     */
            return -1;
        } else if (event.xany.type == PropertyNotify &&
                    event.xproperty.state == PropertyNewValue &&
                    event.xproperty.window == win &&
                    event.xproperty.atom == XA_MOZILLA_RESPONSE) {

            result = XGetWindowProperty(dpy, win,
                                        XA_MOZILLA_RESPONSE, 0,
                                        Length, True /* delete */,
                                        XA_STRING, &type, &format,
                                        &nitems, &bytes_after, &data);

            if (result != Success) {
                /* 
		 * fprintf (stderr, "Failed to read response from Netscape\n");
		 */
                ReleaseLock(dpy, win);
                XSelectInput(dpy, win, 0);
                return 1;
            }
            if (DEBUG && result == Success && data && *data) {
                fprintf (stderr, "(server sent " MOZILLA_RESPONSE_PROP
                         " \"%s\" to 0x%x.)\n", data, (unsigned int) win);
            }
	    
	    /* 
	     * counter gets us out if we are stuck waiting for a lock.
	     */
            if (!data || (++counter > 9)) {
                /* 
		 * printf ("No data returned from Netscape\n");
		 */
                ReleaseLock(dpy, win);
                XSelectInput(dpy, win, 0);
                return 1;
            }
            if (data) {
                XFree (data);
                done=True;
            }
            ReleaseLock(dpy, win);
            XSelectInput(dpy, win, 0);
        }
    }
    return 0;
}

