#include <math.h>
#include "zmath.h"


/* ******* Gestion des matrices 4x4 ****** */

void IdM4(M4 *a)
{
  int i,j;

  for (i=0;i<4;i++)
    for (j=0;j<4;j++)
      a->m[i][j] = (i==j) ? 1.0 : 0.0;
}

M4 MulM4(M4 a, M4 b)
{
  int i,j,k;
  float s;
  M4 c;

  for (i=0;i<4;i++)
    for (j=0;j<4;j++) {
      for (s = 0.0, k=0;k<4;k++)
        s += a.m[i][k] * b.m[k][j];
      c.m[i][j] = s;
    }
   return c;
}

M4 ScaleM4(float sx, float sy, float sz)
{
  M4 a;

  IdM4(&a);
  a.m[0][0]=sx;
  a.m[1][1]=sy;
  a.m[2][2]=sz;
  return a;
}

M4 RotateM4(float t, int u)
{
  float s,c;
  int v,w;
  M4 a;

  if ((v=u+1)>2) v=0;
  if ((w=v+1)>2) w=0;
  s=sin(t);
  c=cos(t);
  IdM4(&a);
  a.m[v][v]=c;  a.m[v][w]=-s;
  a.m[w][v]=s;  a.m[w][w]=c;
  return a;
}

M4 TranslateM4(float x, float y, float z)
{
  M4 a;

  IdM4(&a);
  a.m[0][3]=x;
  a.m[1][3]=y;
  a.m[2][3]=z;
  return a;
}

void MoveM4(M4 *a, M4 *b)
{
  memcpy(a,b,sizeof(M4));
}

void MoveV3(V3 *a, V3 *b)
{
  memcpy(a,b,sizeof(V3));
}

void MulM4V3(V3 *a, M4 *b, V3 *c)
{
  a->X=b->m[0][0]*c->X+b->m[0][1]*c->Y+b->m[0][2]*c->Z+b->m[0][3];
  a->Y=b->m[1][0]*c->X+b->m[1][1]*c->Y+b->m[1][2]*c->Z+b->m[1][3];
  a->Z=b->m[2][0]*c->X+b->m[2][1]*c->Y+b->m[2][2]*c->Z+b->m[2][3];
}

void MulM3V3(V3 *a, M4 *b, V3 *c)
{
  a->X=b->m[0][0]*c->X+b->m[0][1]*c->Y+b->m[0][2]*c->Z;
  a->Y=b->m[1][0]*c->X+b->m[1][1]*c->Y+b->m[1][2]*c->Z;
  a->Z=b->m[2][0]*c->X+b->m[2][1]*c->Y+b->m[2][2]*c->Z;
}

void MulM4V4(V4 *a, M4 *b, V4 *c)
{
  a->X=b->m[0][0]*c->X+b->m[0][1]*c->Y+b->m[0][2]*c->Z+b->m[0][3]*c->W;
  a->Y=b->m[1][0]*c->X+b->m[1][1]*c->Y+b->m[1][2]*c->Z+b->m[1][3]*c->W;
  a->Z=b->m[2][0]*c->X+b->m[2][1]*c->Y+b->m[2][2]*c->Z+b->m[2][3]*c->W;
  a->W=b->m[3][0]*c->X+b->m[3][1]*c->Y+b->m[3][2]*c->Z+b->m[3][3]*c->W;
}

/* inverse of a 3x3 matrix */
M3 M3_Inv(M3 m)
{
  float det;
  M3 a;

  det = m.m[0][0]*m.m[1][1]*m.m[2][2]-m.m[0][0]*m.m[1][2]*m.m[2][1]-
        m.m[1][0]*m.m[0][1]*m.m[2][2]+m.m[1][0]*m.m[0][2]*m.m[2][1]+
        m.m[2][0]*m.m[0][1]*m.m[1][2]-m.m[2][0]*m.m[0][2]*m.m[1][1];

  a.m[0][0] = (m.m[1][1]*m.m[2][2]-m.m[1][2]*m.m[2][1])/det;
  a.m[0][1] = -(m.m[0][1]*m.m[2][2]-m.m[0][2]*m.m[2][1])/det;
  a.m[0][2] = -(-m.m[0][1]*m.m[1][2]+m.m[0][2]*m.m[1][1])/det;

  a.m[1][0] = -(m.m[1][0]*m.m[2][2]-m.m[1][2]*m.m[2][0])/det;
  a.m[1][1] = (m.m[0][0]*m.m[2][2]-m.m[0][2]*m.m[2][0])/det;
  a.m[1][2] = -(m.m[0][0]*m.m[1][2]-m.m[0][2]*m.m[1][0])/det;

  a.m[2][0] = (m.m[1][0]*m.m[2][1]-m.m[1][1]*m.m[2][0])/det;
  a.m[2][1] = -(m.m[0][0]*m.m[2][1]-m.m[0][1]*m.m[2][0])/det;
  a.m[2][2] = (m.m[0][0]*m.m[1][1]-m.m[0][1]*m.m[1][0])/det;
  return a;
}

/* normalisation d'un vecteur */
int V3_Norm(V3 *a)
{
  float n;

  n=sqrt(a->X*a->X+a->Y*a->Y+a->Z*a->Z);
  if (n==0) return 1;
  a->X/=n;
  a->Y/=n;
  a->Z/=n;
  return 0;
}

/* evaluate NPC matrix */
M4 EvalVMM4(float umin, float umax, float vmin, float vmax,
            V3 *PRP, float F, float B, float *zmin)
{
  M4 t,sh,s,vm;
  V3 DOP;
  float vz,fz;

/* T(-PRP) */
  t=TranslateM4(-PRP->X,-PRP->Y,-PRP->Z);

/* SHpar */
  DOP.X=(umax+umin)/2-PRP->X;
  DOP.Y=(vmax+vmin)/2-PRP->Y;
  DOP.Z=-PRP->Z;
  IdM4(&sh);
  sh.m[0][2]=- DOP.X / DOP.Z;
  sh.m[1][2]=- DOP.Y / DOP.Z;

/* Scale Sper */
  vz=-PRP->Z;
  fz=-1/(vz+B);
  s=ScaleM4(-2*vz/(umax-umin)*fz,-2*vz/(vmax-vmin)*fz,fz);
  *zmin=(vz+F)*fz;
/* vm=Sper*SHpar*T(-PRP) */
   vm=MulM4(s,MulM4(sh,t));
   return vm;
}

V3 V3_New(float x, float y, float z)
{
  V3 a;

  a.X=x;
  a.Y=y;
  a.Z=z;
  return a;
}

V4 V4_New(float x, float y, float z, float w)
{
  V4 a;

  a.X=x;
  a.Y=y;
  a.Z=z;
  a.W=w;
  return a;
}

