#include "global.h"
#include "move.h"
#include "col.h"


/* Signale au module Gestion du Monde qu'une touche a change d'etat
 * key_id = 0..MAXKEYS-1
 * key_state = 0..1
 */
Public
void changeKey(int k_id, int k_state, long sec, long usec)
{
  WObject *puser = plocaluser;  /* possibilite d'agir sur un autre user */
  
  if ((k_id >= MAXKEYS) || (k_id < 0) || (k_state < 0) || (k_state > 1)) {
    warning("Wmgt changeKey err: k_id = %d, k_state = %d", k_id, k_state);
    return;
  }
  if (puser->ext.user.k_status[k_id] != k_state) {
    puser->ext.user.k_status[k_id] = k_state;
    if (k_state == KEY_DOWN) {
      puser->ext.user.kb_s[k_id] = sec;
      puser->ext.user.kb_u[k_id] = usec;
    }
    else {
      puser->ext.user.kd_s[k_id] = sec - puser->ext.user.kb_s[k_id];
      puser->ext.user.kd_u[k_id] = usec - puser->ext.user.kb_u[k_id];
    }
  }
  else
    notice("Key '%x' already at '%x'", k_id, k_state);
}

/* clear keys times array */
Public
void clearKeyTab(WObject *puser)
{
  int i;

  for (i = 0; i < MAXKEYS; i++) {
    puser->ext.user.k_status[i] = KEY_UP;
    puser->ext.user.kb_s[i] = puser->ext.user.kb_u[i] = 0;
    puser->ext.user.kd_s[i] = puser->ext.user.kd_u[i] = 0;
 }
}

/* update the keydifftime arrays */
Private
void updateKeysTimes(WObject *puser, long sec, long usec)
{
  int i;

  for (i = 0; i < MAXKEYS; i++)
    if (puser->ext.user.k_status[i] == KEY_DOWN) {
      puser->ext.user.kd_s[i] = sec - puser->ext.user.kb_s[i];
      puser->ext.user.kd_u[i] = usec - puser->ext.user.kb_u[i];
      puser->ext.user.kb_s[i] = sec;
      puser->ext.user.kb_u[i] = usec;
    }
}

/* modify user position in a direction */
Private
void userChangePositionOneType(int move_type, float last, WObject *puser)
{
  switch (move_type) {
  case KEY_AV: /* move forward left */
    puser->x += last * puser->ext.user.lspeed * (float)cos((double)puser->a1);
    puser->y += last * puser->ext.user.lspeed * (float)sin((double)puser->a1);
    break;
  case KEY_AR: /* move backward right */
    puser->x -= last * puser->ext.user.lspeed * (float)cos((double)puser->a1);
    puser->y -= last * puser->ext.user.lspeed * (float)sin((double)puser->a1);
    break;
  case KEY_SD: /* move forward right */
    puser->x += last * puser->ext.user.lspeed * (float)sin((double)puser->a1);
    puser->y -= last * puser->ext.user.lspeed * (float)cos((double)puser->a1);
    break;
  case KEY_SG: /* move backward left */
    puser->x -= last * puser->ext.user.lspeed * (float)sin((double)puser->a1);
    puser->y += last * puser->ext.user.lspeed * (float)cos((double)puser->a1);
    break;
  case KEY_DR: /* turn right */
    puser->a1 -= last * puser->ext.user.aspeed;
    puser->a1 -= M_2PI * (float)floor((double)(puser->a1 / M_2PI));
    break;
  case KEY_GA: /* turn left */
    puser->a1 += last * puser->ext.user.aspeed;
    puser->a1 -= M_2PI * (float)floor((double)(puser->a1 / M_2PI));
    break;
  case KEY_MT: /* down backward */
    puser->a2 = MINI(puser->a2 + last * puser->ext.user.aspeed, M_2PI_5);
    break;
  case KEY_DE: /* down forward */
    puser->a2 = MAXI(puser->a2 - last * puser->ext.user.aspeed, -M_2PI_5);
    break;
  case KEY_HZ: /* stand up */
    puser->a2 = puser->a3 = 0.0;
    break;
  case KEY_JU: /* move up */
    puser->z += last * puser->ext.user.lspeed;
    break;
  case KEY_JD: /* move down */
    puser->z -= last * puser->ext.user.lspeed;
    break;
  case KEY_TL: /* tilt left */
    puser->a3 = MINI(puser->a3 + last * puser->ext.user.aspeed, M_2PI_5);
    break;
  case KEY_TR: /* tilt right */
    puser->a3 = MAXI(puser->a3 - last * puser->ext.user.aspeed, -M_2PI_5);
    break;
  }
}

/* fill delays's array for each user motion direction */
Private
void userUpdateTime(float lasting[], WObject *puser)
{
  int i;
  
  for (i = 0; i < MAXKEYS; i++) {
    lasting[i] = (float) puser->ext.user.kd_s[i] +
                 (float) puser->ext.user.kd_u[i] / MILLION;
    puser->ext.user.kd_s[i] = puser->ext.user.kd_u[i] = 0;
  }
}

/* do the motion in each direction */
Private
void userChangePosition(float lasting[], WObject *pu)
{
  int i;
  
  for (i = 0; i < MAXKEYS; i++) {
    if (lasting[i] > KEYLASTING) {
      userChangePositionOneType(i,
                                lasting[i] * (pu->ext.user.k_status[KEY_VI]+1),
                                pu);
    }
  }
}

/* update an object Bounding Box */
Public
void updateBB(WObject *pwoh)
{
  SolidGetBB(pwoh->soh, &(pwoh->bb_center), &(pwoh->bb_size));
}

/* save current position and Bounding Box of an object */
Public
void copyPositionAndBB(WObject *psrc, WObject *pdest)
{
  /* Why not do: *pdest = *pscr ? */
#ifdef OLD_COPYBB
  int i;

  for (i = 0; i < 3; i++) {
    pdest->bb_center.v[i] = psrc->bb_center.v[i];
    pdest->bb_size.v[i] = psrc->bb_size.v[i];
  }
  pdest->noh.type = psrc->noh.type;
  pdest->x = psrc->x;
  pdest->y = psrc->y;
  pdest->z = psrc->z;
  pdest->a1 = psrc->a1;
  pdest->a2 = psrc->a2;
  pdest->a3 = psrc->a3;
#else
  *pdest = *psrc;
#endif
}

/* user motion limited by the defmaxlast */
Private
void userElementaryMovement(float lasting[], WObject *puser)
{
  WObject userold, *puserold = &userold;
  ObjectList vicinitylist = NULL;

  memset(puserold, 0, sizeof(WObject));
  copyPositionAndBB(puser, puserold);     /* copy oldpos, oldangle */
  userChangePosition(lasting, puser);
  updateObjectIn3D(puser);
  updateBB(puser);
  
  vicinitylist = vicinityObject(puser, puserold);
  generalIntersect(puser, puserold, vicinitylist);
  freeObjectList(vicinitylist);
}

/* object motion limited by the defmaxlast */
Private
void objectElementaryMovement(float lasting, WObject *pwoh)
{
  WObject wohold, *pwohold = &wohold;
  ObjectList vicinitylist = NULL;

  memset(pwohold, 0, sizeof(WObject));
  copyPositionAndBB(pwoh, pwohold);     /* copy oldpos, oldangle */
  if (generalFuncList[pwoh->noh.type].changePosition == NULL) {
    warning("Wmgt: Bad type in changePosition");
    return;
  }
  generalFuncList[pwoh->noh.type].changePosition(lasting, pwoh);
  updateObjectIn3D(pwoh);
  updateBB(pwoh);

  vicinitylist = vicinityObject(pwoh, pwohold);
  generalIntersect(pwoh, pwohold, vicinitylist);
  freeObjectList(vicinitylist);
}

/* object permanent motion limited by the defmaxlast */
Private
void objectElementaryPermanentMovement(float lasting, WObject *pwoh)
{
  WObject wohold, *pwohold = &wohold;
  ObjectList vicinitylist = NULL;

  memset(pwohold, 0, sizeof(WObject));
  copyPositionAndBB(pwoh, pwohold);     /* copy oldpos, oldangle */
  generalFuncList[pwoh->noh.type].changePermanent(lasting, pwoh);
  updateObjectIn3D(pwoh);
  updateBB(pwoh);

  vicinitylist = vicinityObject(pwoh, pwohold);
  generalIntersect(pwoh, pwohold, vicinitylist);
  freeObjectList(vicinitylist);
}

/* user general motion */
void userMovement(long sec, long usec, WObject *puser)
{
  int i, j, n;
  WObject userold;
  float lasting[MAXKEYS], delta[MAXKEYS], maxlasting = -1.0;
  float defmaxlast = defmaxlasting[puser->noh.type];

  /* userold.noh.type = 0; */
  copyPositionAndBB(puser, &userold);     /* copy oldpos, oldangle */
  updateKeysTimes(puser, sec, usec);
  userUpdateTime(lasting, puser);
  for (i = 0; i < MAXKEYS; i++) {
    if (lasting[i] > maxlasting) {
      maxlasting = lasting[i];
    }
  }
  if (maxlasting > LASTING) {                /* change */
    n = (int)(maxlasting / defmaxlast);
    for (i = 0; i <= n; i++) {
      for (j = 0; j < MAXKEYS; j++) {
	if (lasting[j] > defmaxlast) {
	  delta[j] = defmaxlast;
	  lasting[j] -= defmaxlast;
	}
	else {
	  delta[j] = lasting[j];	/* last movement */
	  lasting[j] = 0.0;
	}
      }
      userElementaryMovement(delta, puser);
    }
    if (updateObjectToNetwork(puser, &userold)) {
      updateObjectIntoGrid(puser, &userold);
      updateObjectIn3D(puser);
      updateCameraFromObject(puser);
    }
  }
}

/* object general motion, eg. door, animator, rocket, lift */
Public
void objectMovement(long sec, long usec, WObject *pwoh)
{
  int i, n;
  WObject wohold;
  float lasting, delta = 0.0;
  float defmaxlast = defmaxlasting[pwoh->noh.type];

  wohold.noh.type = 0;
  if (generalFuncList[pwoh->noh.type].change == NULL) {
    warning("Wmgt: bad type in change");
    return;
  }
  if (generalFuncList[pwoh->noh.type].change(pwoh)) {
    /* Correction: the animator object needs the whole definition,
       not just the position and BB */
    wohold = *pwoh;
    
    if (generalFuncList[pwoh->noh.type].updateTime == NULL) {
      warning("Wmgt: bad type in updateTime");
      return;
    }
    generalFuncList[pwoh->noh.type].updateTime(sec, usec, &lasting, pwoh);
    if (lasting > LASTING) {
      n = (int) (lasting / defmaxlast);
      for (i = 0; i <= n; i++) {
	if (lasting > defmaxlast) {
	  delta = defmaxlast;
	  lasting -= defmaxlast;
	}
	else {
	  delta = lasting;
	  lasting = 0.0;
	}
	objectElementaryMovement(delta, pwoh);
      }
    }
    if (updateObjectToNetwork(pwoh, &wohold)) {
      updateObjectIntoGrid(pwoh, &wohold);
      updateObjectIn3D(pwoh);
      if (pwoh == plocaluser) {
        trace(DBG_FORCE, "objectMotion: user");
	updateCameraFromObject(pwoh);
      }
    }
  }
}

/* object general permanent motion, eg. earth */
Public
void objectPermanentMovement(long sec, long usec, WObject *pwoh)
{
  int i, n;
  WObject wohold;
  float lasting, delta = 0.0;
  float defmaxlast = defmaxlasting[pwoh->noh.type];

  if ((generalFuncList[pwoh->noh.type].changePermanent!= NULL)  &&
      (pwoh->secs > 0)) {
    /* wohold.noh.type = 0; */
    copyPositionAndBB(pwoh, &wohold);

    lasting = (float) (sec - pwoh->secs) +
              (float) (usec - pwoh->usecs) / MILLION;
    pwoh->secs = sec;
    pwoh->usecs = usec;
    
    if (lasting > LASTING) {
      n = (int) (lasting / defmaxlast);
      for (i = 0; i <= n; i++) {
	if (lasting > defmaxlast) {
	  delta = defmaxlast;
	  lasting -= defmaxlast;
	}
	else {
	  delta = lasting;
	  lasting = 0.0;
	}
	objectElementaryPermanentMovement(delta, pwoh);
      }
    }
    if (updateObjectToNetwork(pwoh, &wohold)) {
      updateObjectIntoGrid(pwoh, &wohold);
      updateObjectIn3D(pwoh);
      if (pwoh == plocaluser) {
	updateCameraFromObject(pwoh);
      }
    }
  }
}
