#include "global.h"


/* ajout d'un pointeur vers un objet dans une liste */
Public
ObjectList addObjectToList(WObject *object, ObjectList list)
{
  ObjectList tmp_list;
  
  tmp_list = (ObjectList)malloc(sizeof(struct _ObjectList));
  tmp_list->next = list;
  tmp_list->pobject = object;
  return tmp_list;
}

/* suppression d'un pointeur vers un objet dans une liste */
Public
ObjectList deleteObjectFromList(WObject *pobject, ObjectList list)
{
  ObjectList first, nm1, tmplist = list;

  if (list == NULL) {
    warning("W_mgt: I can't delete a mobile object from a NULL list!");
    return ((ObjectList) NULL);
  }
  first = list;
  nm1 = list;
  if (list->pobject == pobject) {
    first = list->next;
    free (list);
    return first;
  }
  while (tmplist != NULL && tmplist->pobject != pobject) {
    nm1 = tmplist;
    tmplist = tmplist->next;
  }
  if (tmplist == NULL)  return first;
  nm1->next = tmplist->next;
  free(tmplist);
  return first;
}
     
/* desalloue une liste d'objet */
Public
void freeObjectList(ObjectList list)
{
  if (list != NULL) {
    freeObjectList(list->next);
    free(list);
  }
}
     
/* concatenation de liste de pointeurs sur objet */
Public
ObjectList
addObjectList(ObjectList l1, ObjectList l2)
{
  if (l1 == NULL)
    return l2;
  return addObjectList(l1->next, addObjectToList(l1->pobject, l2));
}

/* concatenation (avec test de "ispointed" et objet) de liste
 * de pointeurs sur objet
 */
Public
ObjectList
addObjectListToList(ObjectList l1, WObject *pwob, ObjectList l2)
{
  if (l1 == NULL) {
    if (l2 != NULL) {
      if (l2->pobject != pwob)
	return l2;
      else
	return NULL;
    }
    else
      return NULL;
  }
  else {
    if ((!(l1->pobject->ispointed) && (l1->pobject != pwob))) {
      l1->pobject->ispointed = TRUE;
      return addObjectListToList(l1->next,
                                              pwob,
					      addObjectToList(l1->pobject,
                                              l2));
    }
    else
      return addObjectListToList(l1->next, pwob, l2);
  }
}

/* clear flags "ispointed" of all objects */
Public
void clearIspointedFlag(ObjectList list)
{
  if (list !=NULL) {
    list->pobject->ispointed = FALSE;
    clearIspointedFlag(list->next);
  }
}
