#include "global.h"
#include "parse.h"
#include "xterm.h"
#include "audio.h"


/* host parser */
Private
void hostParser(char *l, WObject *phost)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, phost);
  strcpy(phost->ext.host.url, w); w = strtok(NULL, SEP);
  phost->soh = SolidParser(w);
}

/* create an host from a fileline */
Private
void createHostFromFile(Fileline l)
{
  WObject *phost;

  phost = (WObject*) malloc(sizeof(WObject));
  memset(phost, 0, sizeof(WObject));    
  phost->noh.type = HOSTTYPE;
  hostParser(l, phost);
  strcpy(phost->h_name, HOSTNAME);
  updateObjectIn3D(phost);
  setOptionalBuffer(phost);
  updateBB(phost);
  stilllist = addObjectToList(phost, stilllist);
  insertObjectIntoGrid(phost);
} 

/* object intersects: stop */
Private
void hostIntersect(WObject *pwoh, WObject *pwohold, WObject *phost)
{
  copyPositionAndBB(pwohold, pwoh);
}

/* xterm */
Private
void hostMethode0(WObject *phost, long sec, long usec)
{
#ifdef WITHXTERM
  char *host;

  host = strrchr(phost->ext.host.url, '/');
  host++;
  trace(DBG_TOOL, "Wmgt: connect to %s", host);
  quitxterm();
  startxterm(host);
#endif
}

/* functions initialization */
Public
void initHostFuncList(void)
{
  generalFuncList[HOSTTYPE].createFromFileline = createHostFromFile;
  generalFuncList[HOSTTYPE].whenIntersect = hostIntersect;
  
  propertiesnumber[HOSTTYPE] = 0;

  strcpy(generalMethodList[0][HOSTTYPE].name, "Connect");
  generalMethodList[0][HOSTTYPE].method = hostMethode0;
}
