#include "global.h"
#include "grid.h"


/* clear all pointers in the grid */
Public
void clearGrid()
{
  int x, y, z;

  for (x = 0; x < GRIDL; x++)
    for (y = 0; y < GRIDW; y++)
      for (z = 0; z < GRIDH; z++)
	grid[x][y][z] = NULL;
}

/* free all the grid */
Public
void freeGrid()
{
  int x, y, z;

  for (x = 0; x < GRIDL; x++)
    for (y = 0; y < GRIDW; y++)
      for (z = 0; z < GRIDH; z++)
	freeObjectList(grid[x][y][z]);
}

/* evalue et remplit le tableau igrid, tableaux d'indices de la position
 * de pos dans la grille
 */
void calculateCoordinatesIntoGrid(float pos[3], int igrid[3])
{
  igrid[0] = (pos[0] + (float)GRIDdX * (GRIDL/2)) / GRIDdX;
  igrid[1] = (pos[1] + (float)GRIDdY * (GRIDW/2)) / GRIDdY;
  igrid[2] = (pos[2] + (float)GRIDdZ * (GRIDH/2)) / GRIDdZ;

  igrid[0] = MAXI(0, igrid[0]);
  igrid[0] = MINI(GRIDL-1, igrid[0]);
  igrid[1] = MAXI(0, igrid[1]);
  igrid[1] = MINI(GRIDW-1, igrid[1]);
  igrid[2] = MAXI(0, igrid[2]);
  igrid[2] = MINI(GRIDH-1, igrid[2]);
}

/* add an object in the grid */
Public
void insertObjectIntoGrid(WObject *pobject)
{
  int i, x, y, z;
  float pmin[3], pmax[3];
  int imin[3], imax[3];

  for (i = 0; i < 3; i++) {
    pmin[i] = pobject->bb_center.v[i] - pobject->bb_size.v[i]; /* coord. min */
    pmax[i] = pobject->bb_center.v[i] + pobject->bb_size.v[i]; /* coord. max */
  }

  calculateCoordinatesIntoGrid(pmin, imin);
  calculateCoordinatesIntoGrid(pmax, imax);

  for(x = imin[0]; x <= imax[0]; x++)
    for(y = imin[1]; y <= imax[1]; y++)
      for(z = imin[2]; z <= imax[2]; z++)
	grid[x][y][z] = addObjectToList(pobject, grid[x][y][z]);
}

/* delete an object in the grid */
Public
void deleteObjectFromGrid(WObject *pobject)
{
  int i, x, y, z;
  float pmin[3], pmax[3];
  int imin[3], imax[3];

  for (i = 0; i < 3; i++) {
    pmin[i] = pobject->bb_center.v[i] - pobject->bb_size.v[i];
    pmax[i] = pobject->bb_center.v[i] + pobject->bb_size.v[i];
  }
  calculateCoordinatesIntoGrid(pmin, imin);
  calculateCoordinatesIntoGrid(pmax, imax);

  for(x = imin[0]; x <= imax[0]; x++)
    for(y = imin[1]; y <= imax[1]; y++)
      for(z = imin[2]; z <= imax[2]; z++)
	grid[x][y][z] = deleteObjectFromList(pobject, grid[x][y][z]);    
}

/* update an object in the grid */
Public
void updateObjectIntoGrid(WObject *pobject, WObject *poldobject)
{
  int i, x, y, z;
  int  change = FALSE;
  float pmin1[3], pmax1[3], pmin2[3], pmax2[3];
  int imin1[3], imax1[3], imin2[3], imax2[3];

  for (i = 0; i < 3; i++) {
    pmin1[i] = pobject->bb_center.v[i] - pobject->bb_size.v[i];
    pmax1[i] = pobject->bb_center.v[i] + pobject->bb_size.v[i];
    pmin2[i] = poldobject->bb_center.v[i] - poldobject->bb_size.v[i];
    pmax2[i] = poldobject->bb_center.v[i] + poldobject->bb_size.v[i];
  }

  calculateCoordinatesIntoGrid(pmin1, imin1);
  calculateCoordinatesIntoGrid(pmax1, imax1);
  calculateCoordinatesIntoGrid(pmin2, imin2);
  calculateCoordinatesIntoGrid(pmax2, imax2);

  for (i = 0; i < 3; i++)
    if ((imin1[i] != imin2[i]) || (imax1[i] != imax2[i]))
      change = TRUE;

  if (change == TRUE) {
    for (x = imin2[0]; x <= imax2[0]; x++)
      for (y = imin2[1]; y <= imax2[1]; y++)
	for (z = imin2[2]; z <= imax2[2]; z++)
	  grid[x][y][z] = deleteObjectFromList(pobject, grid[x][y][z]);    
    for (x = imin1[0]; x <= imax1[0]; x++)
      for (y = imin1[1]; y <= imax1[1]; y++)
	for (z = imin1[2]; z <= imax1[2]; z++)
	  grid[x][y][z] = addObjectToList(pobject, grid[x][y][z]);
  }
}

/* place an object in the grid */
Public
void placeObjectInGrid(WObject *pwoh)
{
  pwoh->bb_center.v[0] = GRIDdX/2;
  pwoh->bb_center.v[1] = GRIDdY/2;
  pwoh->bb_center.v[2] = GRIDdZ/2;
  pwoh->bb_size.v[0] = GRIDdX/10;
  pwoh->bb_size.v[1] = GRIDdY/10;
  pwoh->bb_size.v[2] = GRIDdZ/10;
}
