#include "global.h"
#include "net_shm.h"
#include "stat.h"


static float kbps_sent = 0.0;
static float kbps_recvd = 0.0;
static FILE *flog;


/* compute kbps_sent & co */
Public
void statAdjust()
{
  static struct timeval then;
  struct timeval now;
  float d;

  gettimeofday(&now, NULL);
  d = diffDates(then, now);
  if (fabs(d) > 0.1) {
    kbps_sent = bytes_sent/d/1000*8;
    kbps_recvd = bytes_recvd/d/1000*8;
    trace(DBG_NET, "kbps sent: %5.2f recvd: %5.2f\n",
	   bytes_sent/d/1000*8, bytes_recvd/d/1000*8);
    then = now;
    bytes_sent = bytes_recvd = 0;  
  }
}

Public
void statRTP(Session *pse)
{
  if ((flog = writelog("---------- RTP stats ---------")) == NULL)
    return;
  writelog("worldname       : %s", worldname);
  writelog("channel         : %s", curr_chan);
/***
  writelog("ssrc            : %x", my_ssrcid);
***/
  writelog("sources ssrc    : %x", pse->sess_sinfo->ssrc);
  writelog("sources number  : %d", pse->sess_nbsources);
/***
  writelog("sdes item number: %d", pse->sess_nbsdes);
  writelog("source max_seq  : %x", pse->sess_sinfo->s.max_seq);
  writelog("source cycles   : %d", pse->sess_sinfo->s.cycles);
  writelog("source bad_seq  : %x", pse->sess_sinfo->s.bad_seq);
  writelog("source probation: %d", pse->sess_sinfo->s.probation);
***/
  writelog("source received : %d", pse->sess_sinfo->s.received);
/***
  writelog("source sr ssrc  : %x", pse->sess_sr.ssrc);
  writelog("source sr ts    : %x", pse->sess_sr.rtp_ts);
***/
  writelog("source sr psent : %d", pse->sess_sr.psent);
  writelog("source sr osent : %d", pse->sess_sr.osent);
  writelog("source lost     : %d", pse->sess_sinfo->lost);
/***
  writelog("source rr lost  : %d", pse->sess_sinfo->rr.lost);
  writelog("source rr ssrc  : %x", pse->sess_sinfo->rr.ssrc);
  writelog("source rr last  : %x", pse->sess_sinfo->rr.last_seq);
  writelog("source rr frac  : %d", pse->sess_sinfo->rr.fraction);
  writelog("source rr lsr   : %x", pse->sess_sinfo->rr.lsr);
  writelog("source rr dlsr  : %x", pse->sess_sinfo->rr.dlsr);
***/
}

Public
void statNetwork()
{
  struct timeval stop_time;
  float d;

  if (flog != (FILE *) NULL) {
    closelog(flog);
    printlog();
  }

  fprintf(stderr, "-------------------- NET stats -------------------\n");
  gettimeofday(&stop_time, NULL);
  d = diffDates(start_time, stop_time);

  fprintf(stderr, "session time    : %5.2f s\n", d);
  fprintf(stderr, "pkts sent       : %d\n", sum_pkts_sent);
  fprintf(stderr, "pkts sent/s     : %.0f/s\n", sum_pkts_sent/d);
  fprintf(stderr, "pkts received   : %d\n", sum_pkts_recvd);
  fprintf(stderr, "pkts received/s : %.0f/s\n", sum_pkts_recvd/d);
  fprintf(stderr, "pkts lost       : %d\n", sum_pkts_lost);
  if (sum_pkts_recvd)
    fprintf(stderr, "%% pkts lost     : %2.2f%%\n", ((double) 100*sum_pkts_lost)/(double) sum_pkts_recvd);
  fprintf(stderr, "bytes sent      : %d\n", sum_bytes_sent);
  fprintf(stderr, "bytes sent/s    : %.0f/s\n", sum_bytes_sent/d);
  fprintf(stderr, "bytes received  : %d\n", sum_bytes_recvd);
  fprintf(stderr, "bytes received/s: %.0f/s\n", sum_bytes_recvd/d);
  if (sum_pkts_sent)
    fprintf(stderr, "bytes/pkt sent  : %d\n", sum_bytes_sent / sum_pkts_sent);
  if (sum_pkts_recvd)
    fprintf(stderr, "bytes/pkt recvd : %d\n", sum_bytes_recvd / sum_pkts_recvd);
}
