#ifndef HTTP_H
#define HTTP_H

#include <X11/Intrinsic.h>
#include "global.h"


#define URLBAD  0
#define URLHTTP 1
#define URLFTP  2
#define URLFILE 3

#define WAITING 0
#define FIRST   1
#define HEADER  2
#define TRANSF  3

#define HTABLE    41
#define MAXNCBUF 512
#define MAXBUF  256
#define MAXREAD 4096

#define HTTPPORT	80
#define NETEOF      0
#define NETSERV    -1
#define NETERROR   -2
#define NETBADURL  -3
#define NETSOCKET  -4
#define NETCONNECT -5
#define NETBADNAME -6
#define NETBADSERV -7

#define NO_BLOCK    1
#define NO_NONBLOCK 0


#ifdef WITHTHREAD
/* File d'attente si on dpasse le nombre maximal de connections */
typedef struct waitfifo {
  pthread_cond_t cond;
  struct waitfifo *next;
} WaitFIFO;
#endif

/* Structure pour le lancement du thread */
typedef struct threadlaunch {
  void *handle;
  char url[URL_LEN];
  int (*callback)(void *,void *);
#ifdef WITHTHREAD
  WaitFIFO *wait;
#endif
  int block;
} ThreadLaunch;

typedef struct netcon {
  int fd;
  int bptr;
  int bl;
  char buf[MAXNCBUF];
} NetCon;

/* Element de la table de hashage pour le cache */
typedef struct rescache {
  char name[URL_LEN];
  struct sockaddr_in addr;
  struct rescache *next;
} ResCache;


/*
 * functions
 */
int httpOpen(char *, int (*)(void *, void *), void *, int);
void httpClose(void *);
int httpRead(void *, char *, int);
int httpSend(int, char *, int);
int httpRecv(int, char *, int);
int httpConnect(struct sockaddr_in *);
int resolve(char *, char *, struct sockaddr_in *);
int parseURL(char *, char *, char *, char *);
void initThreads(void);
void initsysinfo(void);

#endif  /* HTTP_H */
