/*
   File     : keys.c
   Author   : Lionel ULMER
   Creation : 04/12/96
*/

#undef WANT_TCL

#include "global.h"

#ifdef WANT_TCL
/* Include TCL/Tk header files */
#include <tcl.h>
#include <tk.h>

#include "tcl_def.h"
#include "gui.h"
#else
/* Includes needed by Xt */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#endif
/* Includes needed by X */
#include <X11/keysym.h>

#include "initui.h"
#include "initfuncs.h"
#include "user.h"
#include "keys.h"

int keystatus;		/* key status up or down */

/* called when releasing or strike a key into the 3D area */
Public
void key3D(Widget w, XEvent *ev, String *s, Cardinal *c)
{
  int key_up;
  struct timeval t;
  KeySym keysym;

  /* get the date  */
  gettimeofday(&t, NULL);
  
  /* get the Keycode */
  keysym = XKeycodeToKeysym(display, ev->xkey.keycode, 0);
  
  /* Up ou Down ? */
  key_up = (*s[0] == 'u') ? 1 : 0;
  
  /* On gre la crise ;) */

  switch (keysym) {

  case XK_Up:		/* move forward */
    DOKEY(K_UP, KEY_AV, K_DO, KEY_AR);
    break;
  case XK_Down:		/* move backward */
    DOKEY(K_DO, KEY_AR, K_UP, KEY_AV);
    break;
  case XK_Left:		/* turn left */
    DOKEY(K_LE, (keystatus & K_AL ? KEY_SG : KEY_GA),
	  K_RI, (keystatus & K_AL ? KEY_SD : KEY_DR));
    break;
  case XK_Right:	/* turn right */
    DOKEY(K_RI, (keystatus & K_AL ? KEY_SD : KEY_DR),
	  K_LE, (keystatus & K_AL ? KEY_SG : KEY_GA));
    notice(" key '%04X' status=%x", (unsigned int) keysym, keystatus);
    break;
  case XK_Alt_L:
  case XK_Alt_R:
  case XK_Mode_switch: /* key AltGr on French keyboards */
    if (key_up) {
      keystatus &= ~K_AL;
      if ((keystatus & K_LE) && !(keystatus & K_RI)) {
	changeKey(KEY_SG, KEY_UP, t.tv_sec, t.tv_usec);
	changeKey(KEY_GA, KEY_DOWN, t.tv_sec, t.tv_usec);
      }
      else if (!(keystatus & K_LE) && (keystatus & K_RI)) {
	changeKey(KEY_SD, KEY_UP, t.tv_sec, t.tv_usec);
	changeKey(KEY_DR, KEY_DOWN, t.tv_sec, t.tv_usec);
      }
    }
    else {
      keystatus |= K_AL;
      if ((keystatus & K_LE) && !(keystatus & K_RI)) {
	changeKey(KEY_GA, KEY_UP, t.tv_sec, t.tv_usec);
	changeKey(KEY_SG, KEY_DOWN, t.tv_sec, t.tv_usec);
      }
      else if (!(keystatus & K_LE) && (keystatus & K_RI)) {
	changeKey(KEY_DR, KEY_UP, t.tv_sec, t.tv_usec);
	changeKey(KEY_SD, KEY_DOWN, t.tv_sec, t.tv_usec);
      }
    }
    break;
  case XK_Prior:	/* down backward */
    DOKEY(K_PU, KEY_MT, K_PD, KEY_DE);
    break;
  case XK_Next:		/* down forward */
    DOKEY(K_PD, KEY_DE, K_PU, KEY_MT);
    break;
  case XK_Home:
    if (key_up) {
      keystatus &= ~K_HO;
      changeKey(KEY_HZ, KEY_UP, t.tv_sec, t.tv_usec);
    }
    else {
      keystatus |= K_HO;
      changeKey(KEY_HZ, KEY_DOWN, t.tv_sec, t.tv_usec);
    }
    break;
  case XK_KP_Left:	/* down left */
    DOKEY(K_KL, KEY_TL, K_KR, KEY_TR);
    break;
  case XK_KP_Right:	/* down right */
    DOKEY(K_KR, KEY_TR, K_KL, KEY_TL);
    break;
  case XK_Insert:
    DOKEY(K_IN, KEY_JU, K_DE, KEY_JD);
    break;
  case XK_Delete:
    DOKEY(K_DE, KEY_JD, K_IN, KEY_JU);
    break;
  case XK_End:
    if (key_up) {
      keystatus &= ~K_EN;
      changeKey(KEY_VI, KEY_UP, t.tv_sec, t.tv_usec);
    }
    else {
      keystatus |= K_EN;
      changeKey(KEY_VI, KEY_DOWN, t.tv_sec, t.tv_usec);
    }
    break;

  case XK_Control_L:
  case XK_Control_R:
    if (!key_up)	/* NULL = user, 0 = shoot bullet */
      specialAction(NULL, BULLETCREAT, t.tv_sec, t.tv_usec);
    break;
  case XK_Meta_L:
  case XK_Meta_R:
    if (!key_up)	/* NULL = user, 0 = shoot dart */
      specialAction(NULL, DARTCREAT, t.tv_sec, t.tv_usec);
    break;
  case XK_KP_Home:
    if (!key_up)	/* NULL = user, 0 = original fovy */
      specialAction(NULL, FOVYORIGINAL, t.tv_sec, t.tv_usec);
    break;
  case XK_KP_Down:
    if (!key_up)	/* NULL = user, 0 = decrease fovy */
      specialAction(NULL, FOVYLESS, t.tv_sec, t.tv_usec);
    break;
  case XK_KP_Up:
    if (!key_up)	/* NULL = user, 0 = increase fovy */
      specialAction(NULL, FOVYGREATER, t.tv_sec, t.tv_usec);
    break;
    
  default:
#ifndef WANT_TCL
    notice("invalid key '%04X'", (unsigned int) keysym);
    /* Modify the event */
    ev->xkey.window = XtWindow(enterText);
    /* resent it */
    XtDispatchEvent(ev);
    trace(DBG_WIN, "Event resent");
#endif
    break;
  }
  
#ifndef WANT_TCL
  if ((keystatus == 0) && (grabactive)) {
    XAutoRepeatOn(display);
    XUngrabKeyboard(display, CurrentTime);
  }
#endif
}

