/*
   File     : chat.c
   Author   : Lionel ULMER
   Creation : 07/12/96

   Fichier contenant les fonctions de gestion des texts
*/

/* Fichiers ncessaire  Xt */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
/* Fichiers d'include public des widgets utiliss */
#ifndef WANT_TCL
#include "TextField.h"
#endif


/* Fichier des variables globales du module Interface */
#include "global.h"
#include "initui.h"
#include "initfuncs.h"
#include "supportfuncs.h"


int history;		/* Le nombre de lignes "souvenues" */
int histpos;		/* La position de l'insertion d'une nelle ligne */
char **histtab;		/* Le tableau o l'on stocke ces lignes */

/* Variables globales du fichier */
static int histcur = 0;
static int fdown = 1;


/* newTextMessage: reoit le message mess du joueur player */
Public
void newTextMessage(char *player, char *mess)
{
  int l1, l2, c;
  char buf[MESS_LEN+10+NICK_LEN];
  
  sprintf(buf, "<%s> %s\n", player, mess);
  l1 = strlen(buf);
  l2 = strlen(displaystring);
  c = 0;
  
  /* Si a dpasse la taille alloue */
  if (l1+l2+1 > DISPLAYTEXTSIZE) {
    /* On coupe des phrases tant qu'on ne peut pas caser la dernire */
    while (l1+l2+1-c > DISPLAYTEXTSIZE) {
      while (displaystring[c] != '\n')
	c++;
      c++;
    }
    memmove(displaystring, displaystring+c,l2+1-c);
  }
  strcat(displaystring, buf);
#ifndef WANT_TCL
  XtVaSetValues(displayText, XtNstring, displaystring, NULL);
  XtVaSetValues(displayText, XtNinsertPosition,l1+l2-c-1, NULL);
#endif
}

/* newPlayerText (callback de la widget enterText):
   se dbrouille avec le nouveau texte tap par l'utilisateur */
void newPlayerText(Widget w, XtPointer cad, XtPointer cld)
{
  TextFieldReturnStruct *ret;

  ret = (TextFieldReturnStruct *) cld;

  /* Affiche le message */
  if (strlen(ret->string) > 0) {    
    newTextMessage(resources.nick, ret->string);
    /* Mets le message dans l'history */
    if (histtab[histpos] != NULL)
      free(histtab[histpos]);
    histtab[histpos] = strdup(ret->string);
    histpos = (histpos+1) % history;
    histcur = histpos;
    fdown = 1;
  }
  /* send to World Management */
  userWriting(ret->string);
  
  /* clear input zone */
#ifndef WANT_TCL
  XtVaSetValues(w, XtNstring, "", NULL);
#endif
}

/* upHistory: gestion de l'history pour le TextField */
void upHistory(Widget w, XEvent *ev, String *s, Cardinal *c)
{
  histcur = (histcur-1) % history;
  if (histcur < 0)
    histcur += history;
  if (histtab[histcur] == NULL || (histcur == histpos)) {
    histcur = (histcur+1) % history;
    XBell(display, 100);
  }
  else {    
#ifndef WANT_TCL
    XtVaSetValues(w, XtNstring, histtab[histcur], NULL);
#endif
    fdown = 0;
  }
}

/* downHistory: gestion de l'history pour le TextField */
void downHistory(Widget w, XEvent *ev, String *s, Cardinal *c)
{
  histcur = (histcur+1) % history;
  if (histtab[histcur] == NULL || (histcur == histpos)) {
#ifndef WANT_TCL
    if (fdown)
      XBell(display, 100);
    XtVaSetValues(w, XtNstring, "", NULL);
#endif
    histcur = histpos;
    fdown = 1;
  }
#ifndef WANT_TCL
  else
    XtVaSetValues(w, XtNstring, histtab[histcur], NULL);
#endif
}
