/*  Sclient
 *  Copyright (C) 1999 Heathen (the.heathen@swipnet.se)
 *                1999 Drizzt  (doc.day@swipnet.se)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Most of the functions in this file is almost identical to the
 * functions in wizard.c and alias.c as they all use the CList
 * widgets.
 */

#include "triggers.h"

/* free up the memory */
void free_trigger_data ( TRIGGER_DATA *w )
{
#ifdef DEBUG_TRIGGERS
    g_print ("DEBUG Function: free_trigger_data START\n");
#endif

    g_free (w->trigger);
    g_free (w->send1);
    g_free (w->send2);
    g_free (w->send3);
    g_free (w->send4);
    g_free (w->send5);
    g_free (w);

#ifdef DEBUG_TRIGGERS
    g_print ("DEBUG Function: free_trigger_data END\n");
#endif
}

TRIGGER_DATA *trigger_get_trigger_data ( gchar *text )
{
    GList       *tmp;
    TRIGGER_DATA *w;

    for (tmp = g_list_first (trigger_list); tmp != NULL; tmp = tmp->next)
    {
        if ( tmp->data != NULL)
        {
            w = (TRIGGER_DATA *) tmp->data;

            if ( !strcmp (w->trigger, text) )
                 return w;
        }
    }

    return NULL;
}

/*
 * Search the incomming text for matching strings!
 */
void search_triggers (gchar *incomming)
{
    GList *tmp;
    TRIGGER_DATA *trigger;
    gchar *in_text, *iptr;
    int size, n = 0;

#ifdef DEBUG_TRIGGERS
    g_print ("DEBUG Function: search_triggers START\n");
#endif

    /* There are no triggers in list so don't bother to look */
    if (trigger_list == NULL) {
#ifdef DEBUG_TRIGGERS
    g_print ("DEBUG Function: search_triggers (no triggers) END\n");
#endif
        return;
    }

    iptr = g_malloc0 (sizeof(char)+strlen(incomming)+2);

    /* First we need to strip away ANSI COLOR and some
     * other strange characters.  This is equal to what we do
     * in ANSI.C in function disp_ansi (...)
     */
/* OLD... new one from diff recived in email below */
//    while (*incomming) {
//        /* Stripp out goofy signs like linefeeds.... */
//        if (*incomming == '\x0d') {
//            incomming++;
//            continue;
//        }
//        /* Color and special signs -> stripp it! */
//        if (*incomming == 27) {
//            while (*incomming != 'm')
//                incomming++;
//            incomming++;
//            continue;
//        }
//        /* And here we are with usable characters. */
//        iptr[n] = *incomming;
//        n++;
//        iptr[n] = '\0';
//        incomming++;
//    }
    while (*incomming) {
        /* Stripp out goofy signs like linefeeds.... */
        if (*incomming == '\x0d')
            incomming++;
        /* Color and special signs -> stripp it! */
        else if (*incomming == 27) {
             /* We want to skip ANSI, but not overrun buffer. */ 
              while (*incomming != 'm' && *incomming != '\0')
                  incomming++; 
              /* If on last character of ANSI code, skip past it. */ 
              if (*incomming == 'm')
                  incomming++; 
          } 
          else {
               /* And here we are with usable characters. */
               iptr[n++] = *incomming++;
               iptr[n] = '\0'; 
          }
     }

    /* Now can we check for triggers =)
     */
    while (*iptr) {
        /* Cycle thruh the trigger list */
        for (tmp = trigger_list; tmp != NULL; tmp = tmp->next) {
            if (tmp->data) {
                trigger = (TRIGGER_DATA *)tmp->data;
                if (!trigger->trigger || !*trigger->trigger)
                    continue;
                size = strlen(trigger->trigger);
                if (!strncmp(trigger->trigger,  iptr, size)) {
                    alt_send_to_connection (trigger->send1);
                    alt_send_to_connection (trigger->send2);
                    alt_send_to_connection (trigger->send3);
                    alt_send_to_connection (trigger->send4);
                    alt_send_to_connection (trigger->send5);
                }
            }
        }
        iptr++;
    }
#ifdef DEBUG_TRIGGERS
    g_print ("DEBUG Function: search_triggers END\n");
#endif
}

/*
 * Save triggers to file
 */
void save_triggers ()
{
    GList       *tmp;
    TRIGGER_DATA *w;
    FILE *fp;
    gchar *home, filename[255] = "";
    gchar buf[250];

    home = getenv ("HOME");

    g_snprintf (filename, 255, "%s%s", home, "/.sclient");
    if (check_sclient_dir (filename) != 0)
        return;

    g_snprintf (filename, 255, "%s%s", home, "/.sclient/triggers");

    if ( ( fp = fopen (filename, "w") ) == NULL )
    {
        g_snprintf (buf, 250, "You must create the directory %s/.sclient before you save.",
                    home);
        popup_window (buf);
        return;
    }

    for ( tmp = trigger_list; tmp != NULL; tmp = tmp->next )
    {
        if ( tmp->data )
        {
            w = (TRIGGER_DATA *) tmp->data;

            fprintf (fp, "Trigger %s\n", w->trigger);

            if ( strlen (w->send1) )
                fprintf (fp, "1: %s\n", w->send1);
            if ( strlen (w->send2) )
                fprintf (fp, "2: %s\n", w->send2);
            if ( strlen (w->send3) )
                fprintf (fp, "3: %s\n", w->send3);
            if ( strlen (w->send4) )
                fprintf (fp, "4: %s\n", w->send4);
            if ( strlen (w->send5) )
                fprintf (fp, "5: %s\n", w->send5);
            fprintf (fp, "\n");
        }
        w = NULL;
    }

    fclose (fp);
}

/*
 * Load triggers from file at startup
 */
void load_triggers ()
{
    TRIGGER_DATA *w = NULL;
    FILE *fp;
    gchar *home, filename[255] = "";
    gchar line[1024];

    home = getenv ("HOME");

    g_snprintf (filename, 255, "%s%s", home, "/.sclient");
    if (check_sclient_dir (filename) != 0)
        return;

    g_snprintf (filename, 255, "%s%s", home, "/.sclient/triggers");

    if ((fp = fopen (filename, "r"))); 
       
    if ( fp == NULL )
        return; 

    while ( fgets (line, 1024, fp) != NULL )
    {
        gchar *name;
        gchar value[1004] = "";

        name = (gchar *) g_malloc0 ( 20 * sizeof (gchar));

        sscanf (line, "%s %[^\n]", name, value);

        if ( !strcmp (name, "Trigger") )
        {
            if ( w != NULL )
            {
                if ( trigger_list == NULL)
                {
                    trigger_list = g_list_alloc ();
                }
                trigger_list = g_list_append (trigger_list, w);
            }
            w = (TRIGGER_DATA *) g_malloc0 ( sizeof (TRIGGER_DATA) );
            w->trigger = g_strdup (value);
            w->send1 = g_strdup ("");
            w->send2 = g_strdup ("");
            w->send3 = g_strdup ("");
            w->send4 = g_strdup ("");
            w->send5 = g_strdup ("");
        }

        if ( !strcmp (name, "1:") )
            w->send1 = g_strdup (value);

        if ( !strcmp (name, "2:") )
            w->send2 = g_strdup (value);

        if ( !strcmp (name, "3:") )
            w->send3 = g_strdup (value);

        if ( !strcmp (name, "4:") )
            w->send4 = g_strdup (value);

        if ( !strcmp (name, "5:") )
            w->send5 = g_strdup (value);

        g_free (name);
    }

    if (w)
    {
      if ( w->trigger )
      {
	  if ( trigger_list == NULL )
            trigger_list = g_list_alloc ();
	  trigger_list = g_list_append (trigger_list, w);
      }
      else if ( w != NULL )
        free_trigger_data (w);

      trigger_list = trigger_list->next;
      trigger_list->prev = NULL;
    }
    fclose (fp);
}


void trigger_selection_made (GtkWidget *clist, gint row, gint column, GdkEventButton *event, gpointer data)
{
    TRIGGER_DATA *w;
    
    gchar *text;

    trigger_selected_row = row;

    gtk_clist_get_text (GTK_CLIST(clist), row, 0, &text);

    w = trigger_get_trigger_data ( text );

    if ( w != NULL)
    {
        if ( w->trigger)
            gtk_entry_set_text (GTK_ENTRY (entry_trigger), w->trigger);
        if ( w->send1)
            gtk_entry_set_text (GTK_ENTRY (entry_send1), w->send1);
        if ( w->send2)
            gtk_entry_set_text (GTK_ENTRY (entry_send2), w->send2);
        if ( w->send3 )
            gtk_entry_set_text (GTK_ENTRY (entry_send3), w->send3);
        if ( w->send4 )
            gtk_entry_set_text (GTK_ENTRY (entry_send4), w->send4);
        if ( w->send5 )
            gtk_entry_set_text (GTK_ENTRY (entry_send5), w->send5);
    }

    gtk_widget_set_sensitive (button_apply, TRUE);
    gtk_widget_set_sensitive (button_delete, TRUE);
}

void trigger_unselection_made (GtkWidget *clist, gint row, gint column, GdkEventButton *event, gpointer data)
{
    trigger_selected_row = -1;

    gtk_widget_set_sensitive (button_apply, FALSE);
    gtk_widget_set_sensitive (button_delete, FALSE);
}

void trigger_button_add (GtkWidget *button, gpointer data)
{
    TRIGGER_DATA *w;
    gchar *texta[1];

    texta[0] = gtk_entry_get_text (GTK_ENTRY (entry_trigger));

    if ( texta[0] == NULL || texta[0][0] == '\0' )
    {
        popup_window ( "You haven't set an Trigger." );
        return;
    }

    if ( trigger_get_trigger_data (texta[0]) )
    {
        popup_window ("Can't add an existing trigger.");
        return;
    }

    gtk_clist_append ((GtkCList *) data, texta);

    if ( !trigger_list || !trigger_list->data )
        gtk_clist_select_row ((GtkCList *) data, 0, 0);

    w = (TRIGGER_DATA *) g_malloc0 ( sizeof (TRIGGER_DATA) );

    w->trigger    = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_trigger)));
    w->send1      = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_send1)));
    w->send2      = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_send2)));
    w->send3      = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_send3)));
    w->send4      = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_send4)));
    w->send5      = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_send5)));

    trigger_list = g_list_append (trigger_list, w);

    gtk_widget_set_sensitive (button_apply, TRUE);
    gtk_widget_set_sensitive (button_delete, TRUE);
}

void trigger_button_delete (GtkWidget *button, gpointer data)
{
    TRIGGER_DATA *w;
    gchar *word;
    
    if ( trigger_selected_row < 0 )
    {
        popup_window ("No selection made");
        return;
    }
    
    gtk_clist_get_text ((GtkCList *) data, trigger_selected_row, 0, &word);

    w = trigger_get_trigger_data (word);
    
    trigger_list = g_list_remove (trigger_list, w);
    
    gtk_clist_remove ((GtkCList *) data, trigger_selected_row);
    trigger_selected_row = -1;

    /* Clear out the entry boxes */
    gtk_entry_set_text (GTK_ENTRY (entry_trigger), "");
    gtk_entry_set_text (GTK_ENTRY (entry_send1), "");
    gtk_entry_set_text (GTK_ENTRY (entry_send2), "");
    gtk_entry_set_text (GTK_ENTRY (entry_send3), "");
    gtk_entry_set_text (GTK_ENTRY (entry_send4), "");
    gtk_entry_set_text (GTK_ENTRY (entry_send5), "");


    if ( trigger_list == NULL )
    {
        gtk_widget_set_sensitive (button_apply, FALSE);
        gtk_widget_set_sensitive (button_delete, FALSE);
    }
}

void trigger_button_modify (GtkWidget *button, gpointer data)
{
    TRIGGER_DATA *w;
    gchar *texta[1];

    texta[0] = gtk_entry_get_text (GTK_ENTRY (entry_trigger));

    if ( texta[0] == NULL || texta[0][0] == '\0' )
    {
        popup_window ( "You haven't set an Trigger." );
        return;
    }

    if ( (  w = trigger_get_trigger_data (texta[0]) ) == NULL )
    {
        popup_window ( "As for the moment, everything but the trigger can be "
                       "changed.\n\nIf you need to change the trigger, you "
		       "have to use delete.");
        return;
    }

    g_free (w->send1);   w->send1   = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_send1)));
    g_free (w->send2);   w->send2   = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_send2)));
    g_free (w->send3);   w->send3   = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_send3)));
    g_free (w->send4);   w->send4   = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_send4)));
    g_free (w->send5);   w->send5   = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry_send5)));
}

void trigger_clist_append (TRIGGER_DATA *w, GtkCList *clist)
{

    if ( w )
    {
        gchar *text[1];

        text[0] = w->trigger;

        gtk_clist_append (GTK_CLIST (clist), text);
    }

}

void triggers_window ()
{
  GtkWidget *vbox1;
  GtkWidget *hbox1;
  GtkWidget *scrolledwindow_triggerlist;
  GtkWidget *clist;
  GtkWidget *label_clist_trigger;
  GtkWidget *vbox2;
  GtkWidget *label_trigger;
  GtkWidget *hseparator1;
  GtkWidget *label_send1;
  GtkWidget *label_send2;
  GtkWidget *label_send3;
  GtkWidget *label_send4;
  GtkWidget *label_send5;
  GtkWidget *hbuttonbox1;
  GtkWidget *button_add;
  GtkWidget *button_done;
  GtkWidget *button_cancel;
  GtkTooltips *tooltip;

  tooltip = gtk_tooltips_new ();
  gtk_tooltips_set_colors (tooltip, &color_lightyellow, &color_black);


  window_triggers = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (window_triggers), "window_triggers", window_triggers);
  gtk_widget_set_usize (window_triggers, 500, 350);
  gtk_container_border_width (GTK_CONTAINER (window_triggers), 3);
  gtk_window_set_title (GTK_WINDOW (window_triggers), "Triggers");
  gtk_window_set_policy (GTK_WINDOW (window_triggers), FALSE, FALSE, FALSE);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window_triggers), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (window_triggers), vbox1);
  gtk_container_border_width (GTK_CONTAINER (vbox1), 3);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window_triggers), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, TRUE, 0);

  scrolledwindow_triggerlist = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (window_triggers), "scrolledwindow_triggerlist", scrolledwindow_triggerlist);
  gtk_widget_show (scrolledwindow_triggerlist);
  gtk_box_pack_start (GTK_BOX (hbox1), scrolledwindow_triggerlist, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow_triggerlist), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  clist = gtk_clist_new (1);
  gtk_object_set_data (GTK_OBJECT (window_triggers), "clist", clist);
  gtk_signal_connect_object (GTK_OBJECT (clist), "select_row",
                             GTK_SIGNAL_FUNC (trigger_selection_made),
                             (gpointer) clist);
  gtk_signal_connect_object (GTK_OBJECT (clist), "unselect_row",
                             GTK_SIGNAL_FUNC (trigger_unselection_made),
                             NULL);
  gtk_widget_show (clist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow_triggerlist), clist);
  gtk_clist_set_column_width (GTK_CLIST (clist), 0, 80);
  gtk_clist_column_titles_show (GTK_CLIST (clist));

  label_clist_trigger = gtk_label_new ("Trigger");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "label_clist_trigger", label_clist_trigger);
  gtk_widget_show (label_clist_trigger);
  gtk_clist_set_column_widget (GTK_CLIST (clist), 0, label_clist_trigger);
  gtk_label_set_justify (GTK_LABEL (label_clist_trigger), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label_clist_trigger), 0.0500002, 0.5);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (window_triggers), "vbox2", vbox2);
  gtk_widget_show (vbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox2, TRUE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (vbox2), 9);

  label_trigger = gtk_label_new ("The Trigger");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "label_trigger", label_trigger);
  gtk_widget_show (label_trigger);
  gtk_box_pack_start (GTK_BOX (vbox2), label_trigger, TRUE, TRUE, 0);

  entry_trigger = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window_triggers), "entry_trigger", entry_trigger);
  gtk_widget_show (entry_trigger);
  gtk_box_pack_start (GTK_BOX (vbox2), entry_trigger, TRUE, TRUE, 3);
  gtk_tooltips_set_tip (tooltip, entry_trigger,
			"This is the text that will couse the trigger to be activated.\n "
			"NOTE, the trigger string is cAsE sEnSiTiVe! ",
                        NULL);

  hseparator1 = gtk_hseparator_new ();
  gtk_object_set_data (GTK_OBJECT (window_triggers), "hseparator1", hseparator1);
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator1, TRUE, TRUE, 5);

  label_send1 = gtk_label_new ("1:st line to send:");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "label_send1", label_send1);
  gtk_widget_show (label_send1);
  gtk_box_pack_start (GTK_BOX (vbox2), label_send1, TRUE, TRUE, 3);

  entry_send1 = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window_triggers), "entry_send1", entry_send1);
  gtk_widget_show (entry_send1);
  gtk_box_pack_start (GTK_BOX (vbox2), entry_send1, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltip, entry_send1,
			"This is the first string of text that will be sent to the mud, "
			"when the trigger is activated. ",
                        NULL);

  label_send2 = gtk_label_new ("2:nd line to send:");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "label_send2", label_send2);
  gtk_widget_show (label_send2);
  gtk_box_pack_start (GTK_BOX (vbox2), label_send2, TRUE, TRUE, 3);

  entry_send2 = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window_triggers), "entry_send2", entry_send2);
  gtk_widget_show (entry_send2);
  gtk_box_pack_start (GTK_BOX (vbox2), entry_send2, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltip, entry_send2,
			"This is the second string of text that will be sent to the mud, "
			"when the trigger is activated. ",
                        NULL);

  label_send3 = gtk_label_new ("3:rd line to send:");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "label_send3", label_send3);
  gtk_widget_show (label_send3);
  gtk_box_pack_start (GTK_BOX (vbox2), label_send3, TRUE, TRUE, 3);

  entry_send3 = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window_triggers), "entry_send3", entry_send3);
  gtk_widget_show (entry_send3);
  gtk_box_pack_start (GTK_BOX (vbox2), entry_send3, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltip, entry_send3,
			"This is the third string of text that will be sent to the mud, "
			"when the trigger is activated. ",
                        NULL);

  label_send4 = gtk_label_new ("4:th line to send:");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "label_send4", label_send4);
  gtk_widget_show (label_send4);
  gtk_box_pack_start (GTK_BOX (vbox2), label_send4, TRUE, TRUE, 5);

  entry_send4 = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window_triggers), "entry_send4", entry_send4);
  gtk_widget_show (entry_send4);
  gtk_box_pack_start (GTK_BOX (vbox2), entry_send4, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltip, entry_send4,
			"This is the fourth string of text that will be sent to the mud, "
			"when the trigger is activated. ",
                        NULL);

  label_send5 = gtk_label_new ("5:th line to send:");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "label_send5", label_send5);
  gtk_widget_show (label_send5);
  gtk_box_pack_start (GTK_BOX (vbox2), label_send5, TRUE, TRUE, 0);

  entry_send5 = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (window_triggers), "entry_send5", entry_send5);
  gtk_widget_show (entry_send5);
  gtk_box_pack_start (GTK_BOX (vbox2), entry_send5, TRUE, TRUE, 0);
  gtk_tooltips_set_tip (tooltip, entry_send5,
			"This is the fifth string of text that will be sent to the mud, "
			"when the trigger is activated. ",
                        NULL);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (window_triggers), "hbuttonbox1", hbuttonbox1);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox1, FALSE, TRUE, 15);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_SPREAD);

  button_add = gtk_button_new_with_label ("Add");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "button_add", button_add);
  gtk_signal_connect (GTK_OBJECT (button_add), "clicked",
                             GTK_SIGNAL_FUNC (trigger_button_add),
                             (gpointer) clist);
  gtk_widget_show (button_add);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button_add);
  gtk_container_border_width (GTK_CONTAINER (button_add), 3);

  button_delete = gtk_button_new_with_label ("Delete");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "button_delete", button_delete);
  gtk_signal_connect (GTK_OBJECT (button_delete), "clicked",
                             GTK_SIGNAL_FUNC (trigger_button_delete),
                             (gpointer) clist);
  gtk_widget_show (button_delete);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button_delete);
  gtk_container_border_width (GTK_CONTAINER (button_delete), 3);

  button_apply = gtk_button_new_with_label ("Apply");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "button_apply", button_apply);
  gtk_signal_connect (GTK_OBJECT (button_apply), "clicked",
                             GTK_SIGNAL_FUNC (trigger_button_modify),
                             (gpointer) clist);
  gtk_widget_show (button_apply);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button_apply);
  gtk_container_border_width (GTK_CONTAINER (button_apply), 3);

  button_done = gtk_button_new_with_label ("Done");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "button_done", button_done);
  gtk_signal_connect (GTK_OBJECT (button_done), "clicked",
                             GTK_SIGNAL_FUNC (save_triggers), NULL);
  gtk_signal_connect (GTK_OBJECT (button_done), "clicked",
                             GTK_SIGNAL_FUNC (close_window), window_triggers);
  gtk_widget_show (button_done);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button_done);
  gtk_container_border_width (GTK_CONTAINER (button_done), 3);

  button_cancel = gtk_button_new_with_label ("Cancel");
  gtk_object_set_data (GTK_OBJECT (window_triggers), "button_cancel", button_cancel);
  gtk_signal_connect (GTK_OBJECT (button_cancel), "clicked",
                             GTK_SIGNAL_FUNC (close_window), window_triggers);
  gtk_widget_show (button_cancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button_cancel);
  gtk_container_border_width (GTK_CONTAINER (button_cancel), 3);

  gtk_widget_set_sensitive (button_apply, FALSE);
  gtk_widget_set_sensitive (button_delete, FALSE);

  g_list_foreach (trigger_list, (GFunc) trigger_clist_append, clist);
  gtk_clist_select_row (GTK_CLIST (clist), 0, 0);

  gtk_widget_show (window_triggers);
}
