/***************************************************************************
                          setupdialog.h  -  setup dialog
                             -------------------
    begin                : September 22nd 1999
    copyright            : (C) 1999 by David Johnson
    email                : arandir@meer.net

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef SetupDialog_included
#define SetupDialog_included

#include <qpushbutton.h>
#include <qdialog.h>
#include <qcombobox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>

#include "fixedspinbox.h"

class SetupDialog : public QDialog
{
	Q_OBJECT

public:
	/** constructor */
	SetupDialog(QWidget* parent = NULL, const char* name = NULL);
	/** destructor */
	virtual ~SetupDialog();

	/** set the qbrew directory edit box */
	void setQBrewDir(const QString &qdir);
	/** return the qbrew directory edit text */
	const QString qbrewDir();
	/** set the style combo box */
	void setStyle(const QString &sstyle);
	/** return the style combo box text */
	const QString style();
	/** set the batch spin box */
	void setBatch(const QString &qbatch);
	/** return the batch spin box text */
	const QString batch();
	/** set the efficiency spin box */
	void setEfficiency(const QString &qeff);
	/** return the efficiency spin box text */
	const QString efficiency();

protected:
	QGridLayout *layout;
	
	QLabel *qbrewLabel;
	QLabel *styleLabel;
	QLabel *batchLabel;
	QLabel *efficiencyLabel;
	QFrame *sepOne;
	QFrame *sepTwo;
    QLineEdit *qbrewEdit;
    QComboBox *styleBox;
    QSpinBox *batchSpin;
    QSpinBox *efficiencySpin;
    QPushButton *cancelButton;
    QPushButton *okButton;
};

#endif // SetupDialog_included





