/***************************************************************************
                          resource.h  -  global resources for QBrew
                             -------------------
    begin                : September 20th, 1999
    copyright            : (C) 1999 by David Johnson
    email                : arandir@meer.net

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef RESOURCE_H
#define RESOURCE_H

#include <qobject.h>
#include <qstring.h>
#include <qmap.h>

// get the define for VERSION
#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#define VERSION "0.0.0"
#endif


///////////////////////////////////////////////////////////////////
// COMMAND VALUES FOR MENUBAR AND TOOLBAR ENTRIES

///////////////////////////////////////////////////////////////////
// File-menu entries
const unsigned ID_FILE_NEW					= 10020;
const unsigned ID_FILE_OPEN					= 10030;
const unsigned ID_FILE_SAVE					= 10050;
const unsigned ID_FILE_SAVE_AS				= 10060;
const unsigned ID_FILE_PRINT				= 10080;
const unsigned ID_FILE_QUIT					= 10100;

///////////////////////////////////////////////////////////////////
// Edit-menu entries
//const unsigned ID_EDIT_UNDO					= 11010;
//const unsigned ID_EDIT_REDO					= 11020;
const unsigned ID_EDIT_COPY					= 11030;
const unsigned ID_EDIT_CUT					= 11040;
const unsigned ID_EDIT_PASTE				= 11050;

///////////////////////////////////////////////////////////////////
// View-menu entries
const unsigned ID_OPTIONS_TOOLBAR			= 12010;
const unsigned ID_OPTIONS_STATUSBAR			= 12020;
const unsigned ID_OPTIONS_SETUP				= 12030;
const unsigned ID_OPTIONS_SAVESETTINGS		= 12040;

///////////////////////////////////////////////////////////////////
// Help-menu entries
const unsigned ID_HELP_CONTENTS				= 1001;
const unsigned ID_HELP_ABOUT_QT				= 1002;
const unsigned ID_HELP_ABOUT				= 1003;

///////////////////////////////////////////////////////////////////
// General application values
const QString IDS_TITLE						= "QBrew";
const QString IDS_DEFAULT_MESSAGE			= QObject::tr("Ready.");
const QString IDS_APP_ABOUT					= "<b><big>" + IDS_TITLE + " Version " + VERSION + "</big></b>"
											+ QObject::tr("<br/><hr/><p><b>A Brewing Recipe Calculator</b>")
											+ QObject::tr("<p>Copyright 1999 by David Johnson (arandir@meer.net)")
											+ QObject::tr("<br/>Special thanks to ") + "Stephen Lowrie";
const QChar CHAR_LATIN_DEGREE				= QChar(0xB0);
const QChar CHAR_NBSP						= QChar(0xA0);

///////////////////////////////////////////////////////////////////
// file locations and stuff
const QString IDS_FILE_FILTER				= "*.qbrew";
const QString IDS_SETTINGS_FILE				= ".qbrewrc";
const QString IDS_HELP_FILE					= QObject::tr("doc/en/index.html"); // the english version
const QString IDS_CALC_FILE					= "calcdb";
// name of default recipe file
const QString IDS_DEFAULT_FILE				= QObject::tr("untitled");

///////////////////////////////////////////////////////////////////
// Settings values
const QString IDS_NULL						= "NULL";
const QString IDS_SETTINGS_STATUSBAR		= "STATUSBAR";
const QString IDS_SETTINGS_STATUSBAR_DEFAULT	= "TRUE";
const QString IDS_SETTINGS_TOOLBAR			= "TOOLBAR";
const QString IDS_SETTINGS_TOOLBAR_DEFAULT	= "TRUE";
const QString IDS_SETTINGS_QBREWDIR			= "DOCDIR";
const QString IDS_SETTINGS_QBREWDIR_DEFAULT	= "/usr/local/share/qbrew/";
const QString IDS_SETTINGS_STYLE			= "STYLE";
const QString IDS_SETTINGS_STYLE_DEFAULT	= "Default";
const QString IDS_SETTINGS_BATCH			= "BATCH";
const QString IDS_SETTINGS_BATCH_DEFAULT	= "500";
const QString IDS_SETTINGS_EFFICIENCY		= "EFFICIENCY";
const QString IDS_SETTINGS_EFFICIENCY_DEFAULT	= "75";

///////////////////////////////////////////////////////////////////
// Qt Themable Style "Map"
enum { STYLE_MOTIF, STYLE_PLATINUM, STYLE_WINDOWS, STYLE_CDE, STYLE_DEFAULT };
const QString STYLES[] = { "Motif", "Platinum", "Windows", "CDE", "Default" };
extern QMap<QString, int> styleMap;

#endif // RESOURCE_H
















