.\" Copyright (C) 1997 and 1998 WIDE Project.  All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. Neither the name of the project nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\" 
.\" THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\"	$Id: mgp.man,v 1.56 1999/08/27 18:48:34 itojun Exp $
.\"
.Dd November 1997
.Dt MGP 1
.Os
.\"
.Sh NAME
.Nm mgp
.Nd MagicPoint -- an X11 based presentation tool
.\"
.Sh SYNOPSIS
.Nm mgp
.Op Fl dhlnoqvBCGORSV
.Op Fl b Ar bgcolor
.Op Fl c Ar vfcap
.Op Fl f Ar vfont
.Op Fl g Ar geometry
.Op Fl p Ar page
.Op Fl t Ar timeslot
.Op Fl w Ar wdir
.Op Fl x Ar engine
.Op Fl D Ar htmldir
.Op Fl F Ar mode,effect,value
.Op Fl Q Ar quality
.Op Fl T Ar timestampfile
.Op Fl X Ar gsdevice
.Ar file
.\"
.Sh DESCRIPTION
.Nm
is an X11 based presentation tool.
It is designed to make
simple presentations easy while to make complicated presentations
possible.
Its presentation file
.Pq whose suffix is typically Li .mgp
is
just text so that you can create presentation files quickly with your
favorite editor (such as Emacs).
.Pp
The 
.Li .mgp
file consists of text and
control commands (such as pagebreak, centering, and/or inline image).
Control commands are specified on the beginning of lines started with
one
.Li %
sign.
You can include numerous kinds of image format files
onto the presentation file.
.Pp
.Nm
uses Japanese/English fonts in various sizes.
.Nm
uses X11 scalable fonts provided by X11 servers.
.Nm
can also utilize the Japanese outline font library, "VFlib",
if configured to do so at compilation time.
.Pp
The following options are available:
.Bl -tag -width indent
.It Fl b Ar bgcolor
Set background color to
.Ar bgcolor .
(The default value is black)
.It Fl c Ar vfcap
Specify a VFlib configuration file.
.It Fl d
Demonstration mode.
Browse all page quickly and terminate.
.It Fl f Ar vfont
Specify the font name to be used by VFlib.
(The default value is minsl)
.It Fl g Ar geometry
Set the size and location of the window.
Please note that
.Fl g
implies
.Fl o.
.Nm
will not override the window manager if you specify the geometry.
.It Fl h
Display the usage and exit without performing a presentation.
.It Fl l
There are two kind of fonts available by VFlib;
They are outline font and bitmap font.
By specifying
.Fl l ,
you can disable the use of outline fonts.
.It Fl n
.Nm
accepts any key inputs from invoked terminal as
KEY OPERATION described below.
.Fl n
disables this feature.
(This option may be removed in the future release)
.It Fl o
Do not override window manager.
(By default, 
.Nm
overrides window manager and occupies the whole display)
.It Fl p Ar page
Start presentation from
.Ar page ,
rather than the first page.
.It Fl q
Do not beep on errors.
.It Fl t Ar timeslot
Specify the timeslot assigned to the presentation in minute.
The timer is invoked when the second page is displayed and the remaining
presentation time is indicated by the length of bar shown at the bottom of
the display.
The timebar is updated when some X11 event is raised,
for instance some keypress.
Timebar will be green if you have more than 50% of the timeslot,
yellow while you have more than 30% of the timeslot,
and red for the other cases.
When the assigned timeslot is expired, exceeding time is also shown as 
a timebar growing from left to right.
Current page is indicated by the position of a small vertical bar; the vertical
bar is drawn at the leftend when the first page is displayed while the
bar is drawn at the rightend when the last page is displayed.
.It Fl v
Display the MagicPoint version and exit without performing a presentation.
.It Fl w Ar wdir
specifies the working directory used for store embedded images if any.
To generate an embedded MGP file, use 
.Xr mgpembed 1 .
.It Fl x Ar engine
Do not use rendering engine, specified by
.Ar engine .
.Ar engine
can be
.Li VFlib
or
.Li FreeType .
.It Fl B
Omit background image.
.It Fl C
Use private colormap.
.It Fl D Ar htmldir
Generate html pages of the presentation into
.Ar htmldir .
You will need
.Xr xwintoppm 1
(included in mgp kit),
and
.Xr pnmscale 1 ,
.Xr cjpeg 1 ,
and
.Xr djpeg 1
.Po
included in
.Li netpbm
and
Independent Jpeg Group
.Li jpeg
package
.Pc .
.It Fl F Ar mode,effect,value
specifies forward page cache options.
.Ar Mode ,
.Ar effect
and
.Ar value
are numbers. 
.Ar Mode
specifies caching mode. 
.Ar Mode
0 means caching is executed after 2 seconds idle.
.Ar Mode
1 means caching is executed immediately.
.Ar Effect 
specifies 'special effect' for the forward page cache. Currently, 
two special effects are supported.
.Ar Effect 
1 means that the next page will come in from the left side.
.Ar Effect 
2 means that the current page will go out to the left side.
.Ar Effect 
0 means no special effect.
.Ar Value
specifies speed of special effect. 
.Ar Value
1 means the highest speed. A higher value for 
.Ar value
decreases effect speed.
.It Fl G
Specifies to turn on page guide function.
At the bottom of the screen, the titles of next page and previous page are
displayed to assist the presentation.
Page guide can be turned on and off by keyboard too.
.It Fl O
Obey to the window manager, but with less decoration around the window.
The behavior of this option is affected by how the window manager
is implemented; this option may have no effect on some of the window managers.
.It Fl Q Ar quality
Set background image quality(0-100).
.It Fl R
.Nm
will usually reload the presentation file if it gets updated,
based on the file modification time taken by 
.Xr stat 2 .
.Fl R
disables this auto-reloading feature.
.It Fl S
Be secure.
Skip directives that fork/exec the child process.
It is suggested to use this option if you got some presentation file
from others.
.It Fl T Ar timestampfile
If the option is specified,
.Nm
will modify the content of
.Ar timestampfile
every time it updates the presentation window.
This option is useful for external process to understand when
.Nm
modifies the window.
.It Fl V
Be verbose.
Generate debugging output to standard output.
.It Fl X Ar gsdevice
.Nm
sometimes invokes
.Xr ghostscript 1
to render postscript image.
.Fl X
enables you to specify the device to be used by
.Xr ghostscript 1 .
.\"If your
.\".Xr ghostscript 1
.\"is capable of using
.\".Li x11alpha
.\"device, you should try using that.
If you specify
.Ar gsdevice
with a trailing '+',
.Xr pnmscale 1
and
.Xr pnmdepth 1
will be invoked for anti-aliasing.
The default
.Ar gsdevice
is "pnmraw+".

.El
.\"
.Sh KEY OPERATION
The keyboard/mouse commands are:
.Bl -tag -width -diag indent
.It mouse button 1 (leftmost button)
Go forward a page.
Space key, downward cursor key, scroll down key, "f" key, "j" key,
and "n" key have the same effect.
If <number> is specified, go forward <number> pages.
.It mouse button 3 (rightmost button)
Go to the previous page.
"b" key, "k" key, "p" key, backspace key, scroll up key and upward cursor
key have the same effect.
If <number> is specified, go back <number> pages.
.It 0 - 9 (number buttons)
Set prefix number in decimal.
i.e. <number> = <number> * 10 + <keyN> - <key0>.
For example, by typing in "10g" you can jump to page 10.
.It g
Go to the <number> page.
If number of 0 is specified, go to the last page.
.It control key
Display the page listing menu.
See below for details.
.It G
Enable/disable page guide.
See description for option
.Fl G
for details.
.It x
Enable/disable rakugaki (jotting) mode.
You can make an annotation (by mouse) on the presentation.
Mouse button 2 (middle) has the same effect.
.It X
Change the pen color for rakugaki (jotting) mode.
.It t
Enable/disable the timebar if -t timeslot option is specified.
.It c
Enable/disable forward page cache.
.It control-L
Repaint the current page.
Use this if you messed up the page by jotting too much.
.It control-R
Reload the current presentation file.
If the current page becomes unavailable, page pointer will be moved back to 1.
.It escape key
Quit the currently running
.Nm mgp .
"q" key also has the same effect.
.El
.Pp
During the presentation, you can see the page list at the bottom of the
window when you press a Control Key.
Choosing a page with the mouse and clicking it with the leftmost mouse button,
you can go to corresponding page directly.
Releasing the Control Key, the page list disappears and you can continue
with the current page.
This function is useful during the Q-and-A period after your presentation
completes.
.\"
.Sh CONFIGURATION FILES
.Nm
will look at a file named
.Pa ~/.mgprc
in your home directory.
The content of the file must be a limited set of magicpoint directives,
one directive per line, without 
.Li %
sign.
Lines start with
.Li # ,
or empty lines, will be silently ignored.
See
.Pa SYNTAX
for eligible directives.
.Pp
.Nm
imports various image draw functions from
.Xr xloadimage 1 .
This means that the location of image files can be specified
by
.Pa ~/.xloadimagerc
file.
If you specify the presentation file with its directory, that directory
is searched first and then the path specified in the
.Pa ~/.xloadimagerc
is searched.
.\"
.Sh SECURITY ISSUES
The presentation file can include directives to call the external process,
just like shell process.
Therefore, the presentation file should be treated just like shell script
or perl script.
This is STRONGLY recommended to review the content
of the presentation file before invoking
.Nm mgp ,
if you got the file from others.
By adding the
.Fl S
option to the command line argument, directives that call external processes
will be skipped.
.\"
.Sh SEE ALSO
.Xr mgp2ps 1 ,
.Xr xloadimage 1 ,
.Xr mgpembed 1
.\"
.Sh AUTHOR CONTACT
Yoshifumi Nishida <nishida@sfc.wide.ad.jp>
.\"
.Sh CONTRIBUTION
Jun-ichiro Hagino <itojun@itojun.org>, Akira Kato <kato@wide.ad.jp>,
Atsushi Onoe <onoe@sm.sony.co.jp>, Kazu Yamamoto <Kazu@Mew.org>,
Youjiro Uo <yuo@nui.org>, and Masaki Minami <Masaki@Minami.org> 
extensively contributed improvements, bug fixes, and documents.
Special thanks to Chaki Kusakari <chaki@sfc.wide.ad.jp>.
.\"
.Sh HISTORY
.Nm
was created shortly after the autumn camp of WIDE Project in 1997,
which was originally called
.Nm tp
.Pq TinyPoint .
