#include <stdio.h>

#include <gnome.h>

#include "callbacks.h"

#define MY_STOCK(label, callback, stock_id, key) \
{ GNOME_APP_UI_ITEM, label, NULL, (gpointer)callback, NULL, NULL, \
  GNOME_APP_PIXMAP_STOCK, stock_id, key, GDK_CONTROL_MASK, NULL }

static GnomeUIInfo search_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Download"), NULL, download_cb,
			  GNOME_STOCK_MENU_NEW),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Browse user's mp3s"), NULL, browse_user_menu_cb1,
			  GNOME_STOCK_MENU_OPEN),
   GNOMEUIINFO_END,
};

static GnomeUIInfo download_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Browse user's mp3s"), NULL, browse_user_menu_cb2,
			  GNOME_STOCK_MENU_OPEN),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Cancel Download"), NULL, cancel_download_cb,
			  GNOME_STOCK_MENU_TRASH),
   GNOMEUIINFO_ITEM_STOCK(N_("Cancel and Remove file"), NULL, cancel_remove_cb,
			  GNOME_STOCK_MENU_TRASH),
   GNOMEUIINFO_END,
};

/*static GnomeUIInfo gnapster_toolbar[] = {
   GNOMEUIINFO_END,
};*/

static GnomeUIInfo gnapster_file_menu[] = {
   MY_STOCK("_Connect", connect_cb, GNOME_STOCK_MENU_EXEC, 'C'),
   MY_STOCK("_Disconnect", disconnect_cb, GNOME_STOCK_MENU_TRASH, 'D'),
/*   GNOMEUIINFO_ITEM_STOCK(N_("_Connect"), NULL, connect_cb,
			  GNOME_STOCK_MENU_EXEC),*/
/*   GNOMEUIINFO_ITEM_STOCK(N_("_Disconnect"), NULL, disconnect_cb,
			  GNOME_STOCK_MENU_TRASH),*/
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_MENU_EXIT_ITEM(gnapster_exit_cb, NULL),
   GNOMEUIINFO_END,
};

static GnomeUIInfo gnapster_settings_menu[] = {
   GNOMEUIINFO_MENU_PREFERENCES_ITEM(preferences_cb, NULL),
   GNOMEUIINFO_END,
};

static GnomeUIInfo gnapster_help_menu[] = {
   GNOMEUIINFO_MENU_ABOUT_ITEM(about_cb, NULL),
   GNOMEUIINFO_END,
};

static GnomeUIInfo gnapster_menu[] = {
   GNOMEUIINFO_MENU_FILE_TREE(gnapster_file_menu),
   GNOMEUIINFO_MENU_SETTINGS_TREE(gnapster_settings_menu),
   GNOMEUIINFO_MENU_HELP_TREE(gnapster_help_menu),
   GNOMEUIINFO_END,
};
