package MState;
require Tk;
require Tk::Button;

@ISA = qw( Tk::Button  Tk::Frame);

Construct Tk::Widget 'MState';

sub new {
    my $class = shift;
    my $w = shift;
    my $self = $w->Button();
    bless $self,$class;
    $self->init();
    $self->configure(@_);
    return $self;
}


sub init {
    my($w) = @_;
    $w->bind('<Button-1>' => 'rotate');
}


#########################
# config methods

sub configure {
    my($objref, @hook_list) = @_;

    if(@hook_list == 1) {
	return $objref->Tk::Button::configure($hook_list[0]);
    }

    my($option, $value);
    while (($option, $value) = splice(@hook_list, 0, 2)) {
#	print "'$option':'$value'\n";
	if ($option eq '-states') {
	    $objref->states($value);
	}
	elsif ($option eq '-value') {
	    $objref->value($value);
	}
	else {
	     $objref->Tk::Button::configure($option => $value);
	} 
    } # whilend all options/values          
    
} # end configure


sub states {
    my ($self,$states) = @_;
    $self->{States} = [@$states];
    $self->{Value} = $states->[0] unless exists $self{Value};
    $self->value($self->{Value});
}    

# sets value;
sub value {
    my $self = shift;
    my $val = shift;
    my $i = $self->find_value($val);
    if($i<0) {
	$self->{Value} = $val;
	return;
    }
    $self->{Value} = $self->{States}->[$i];
    $self->configure(-text=> $self->{States}->[$i]);
}


##############################
sub find_value {
    my $self = shift;
    my $val = shift;
    my $i=0;
    my ($one,$two);
    $val =~ s/^\s+|\s+$//g;
    foreach $one (@{$self->{States}}) {
	$two = $one;
	$two =~ s/^\s+|\s+$//g;
	return $i if $two eq $val;
	$i++;
    }
    return -1;
}

sub get {
    my $self = shift;
    return $self->get_value();
}

sub get_value {
    my $self = shift;
    my $back = $self->{Value};
    $back =~ s/^\s+|\s+$//g;
    return $back;
}


sub set_value_num {
    my $self = shift;
    my $i= shift;
    return if $i <0 or $i >= @{$self->{States}};
#    print "$i\n";
    $self->{Value} = $self->{States}->[$i];
#    print "settting to $self->{Value}\n";
    $self->configure(-text=>$self->{States}->[$i]);    
}

sub pad {
    my  $self = shift;
    my $size = shift;
    $size = $self->max_size unless defined $size;
    foreach (@{$self->{States}}) {
	$_ .= ' ' x ($size-length($_)) if $size-length($_) > 0;
    }

}

sub max_size {
    my $self=shift;
    my $max = 0;
    foreach (@{$self->{States}}) {
	$max = length($_) if length($_) > $max;
    }
    return $max;
}

sub rotate {
    my $self = shift;
    my $i = $self->find_value($self->get_value());
#    print "old val $i\n";
    $i++;
    $i=0 if $i== @{$self->{States}};
    $self->set_value_num($i);
}

1;
