/* redir.c - Implement redirection */

#ifndef lint
char RCS_redir_c[] =
"$Id: redir.c,v 2.9 1999/01/19 12:26:51 caleishm Exp caleishm $  Produced by Chris Leishman & Trevor Cohn.  Ormond College student IT department, 1998.$\n";
#endif /* not lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "main.h"
#include "redir.h"
#include "buildconf.h"
#include "utils.h"
#ifndef NOUSE_REGEX
#include <regex.h>
#endif

#define HOST_BEGIN   "://"
#define HOST_LENGTH  3
#define PATH_BEGIN   "/"
#define MAX_PERC     100

#define BROWSER_REDIR "301:"

enum { FOUND_MATCH, NOT_FOUND };

int  parse_tree(item *, char *, char *, char *, char *, char *);
int  check(char *, char *, char *, char *, item *);
void print_redir(redir_list *, int);


/* Controlling function.  Breaks url into host and path, then searches 
   for matches */


void redirect(item *data, char *url, char *sourceAddr)
{
#ifdef NOUSE_REGEX
	int  i, j;
#endif
	int M = strlen(url);
	char *host, *path, *str;

#if !defined NOSAVESKIP && defined NOUSE_REGEX
	static int *hb_skip = NULL;
	static int *pb_skip = NULL;

	/* Build skip table for host and path start defines, 
           but only on initialisation */

	if (hb_skip == NULL || pb_skip == NULL)
	{
		hb_skip = buildskip(HOST_BEGIN);
		pb_skip = buildskip(PATH_BEGIN);
	}
#endif


	/* Chop newline */

	if (url[M - 1] == EOLN) {
		url[M - 1] = EOS;
		M--;
	}

	str = strdup(url);

	/* Allows invalid url to be parsed */

#ifndef NOUSE_REGEX
	if ((host = strstr(str, HOST_BEGIN)) == NULL)
		host = str;
	else
		host += HOST_LENGTH;

	if ((path = strstr(host, PATH_BEGIN)) == NULL)
		path = str + M;
	else
		*(path++) = EOS;

#else

#ifdef NOSAVESKIP
	if ((i = search(HOST_BEGIN, url)) == -1)
#else
	if ((i = search(HOST_BEGIN, url, hb_skip)) == -1)
#endif
		i = 0;
	else
		i += HOST_LENGTH;

#ifdef NOSAVESKIP
	if ((j = search(PATH_BEGIN, url + i)) == -1)
#else
	if ((j = search(PATH_BEGIN, url + i, pb_skip)) == -1)
#endif
		j = M - 1 - i;
	else
		str[i + j] = EOS;

	host = str + i;
	path = str + i + j + 1;

#endif


#ifdef DEBUG
	printf("--Url:  %s, Host: %s, Path: %s\n", url, host, path);
#ifdef NOUSE_REGEX
	printf("--Indices: i %d, j %d M %d\n", i, j, M);
#endif
#endif

	
	/* Search for match.  If none, then output original url. */

	if (parse_tree(data, host, path, url, sourceAddr, NULL) == NOT_FOUND)
	{
#ifdef DEBUG
		printf("--Not found... allowing\n");
#endif
		putchar('\n');
	}


	/* Free temp string */

	free(str);
}


/* This function recurses through the data tree, searching for matches.
   If a match is found the appropriate url is output, otherwise NOT_FOUND
   is returned. */

int parse_tree(item *node, char *host, char *path, 
		         char *url, char *sourceAddr, char *lfile)
{
	while (node != NULL)
	{
#ifdef DEBUG
		printf("--Checking, type %d, key %s\n", node->type,
		        (node->keys == NULL)?"null":node->keys->data);
#endif


		/* Check the keys in this node to see if this node applies. */
	
		if (check(url, host, path, sourceAddr, node))
		{
			char *oldlog = lfile;

			/* Got a new log file? */

			if (node->logfile != NULL) {
				if (*(node->logfile) != EOS)
				{
					lfile = node->logfile;
#ifdef DEBUG
					printf("Now logging to %s.\n", lfile);
#endif
				}
				else
				{
					lfile = NULL;
#ifdef DEBUG
					printf("Logfile set to none.\n");
#endif
				}
			}

			/* an exempt? */
			if (node->type >= EXEMPT)
			{
#ifdef DEBUG
				printf("--Found exempt... returning\n");
#endif
				putchar('\n');
				return FOUND_MATCH;
			}
			else if (node->subs != NULL)
			{
				int i;
	
#ifdef DEBUG
				printf("--Recursing...\n");
#endif

				/* recurse subtree.. */
				i = parse_tree(node->subs, host, path, url, sourceAddr, lfile);

				if (i == FOUND_MATCH)
					return i;

				/* ignore it */
			}

			if (node->redirect != NULL)
			{
#ifdef DEBUG
				printf("--Applying redirects... returning\n");
#endif
				print_redir(node->redirect, node->numredir);
				addlog(lfile, 2, sourceAddr, url);
				return FOUND_MATCH;
			}

			lfile = oldlog;
		}
		node = node->next;
#ifdef DEBUG
		printf("--Next one...\n");
#endif
	}

	return NOT_FOUND;
}


/* Check the keys in the node to see if it applies to the current url. */

int check(char *url, char *host, char *path, char *sourceAddr, item *node)
{		
#ifdef NOUSE_REGEX
	int i;
#endif
	str_list *l = node->keys;

	/* If randomness is not 100%, decide whether to check this rule. */
	if ((node->random < MAX_PERC) && (rand() % 100 > node->random)) {
#ifdef DEBUG
		printf("Randomly ignoring this rule.\n");
#endif
		return FALSE;
	}

	if (l == NULL)
		return TRUE;

	while (l != NULL)
	{
#ifdef DEBUG
		printf("--Searching...%s\n", l->data);
#endif
		switch (node->type)
		{
			case CONTAINS:
			case EXEMPT:
#ifndef NOUSE_REGEX
				if (regexec(l->regc, url, 0, NULL, 0) == 0)
					return TRUE;
#else
#ifdef NOSAVESKIP
				i = search(l->data, url);
#else
				i = search(l->data, url, l->skip);
#endif
#endif
				break;
			case HOSTCONTAINS:
			case HOSTEXEMPT:
				if (*host != EOS)
#ifndef NOUSE_REGEX
					if (regexec(l->regc, host, 0, NULL, 0) == 0)
						return TRUE;
#else
#ifdef NOSAVESKIP
					i = search(l->data, host);
#else
					i = search(l->data, host, l->skip);
#endif
				else 
					i = -1;
#endif
				break;
			case PATHCONTAINS: 
			case PATHEXEMPT:
				if (*path != EOS)
#ifndef NOUSE_REGEX
					if (regexec(l->regc, path, 0, NULL, 0) == 0)
						return TRUE;
#else
#ifdef NOSAVESKIP
					i = search(l->data, path);
#else
					i = search(l->data, path, l->skip);
#endif
				else 
					i = -1;
#endif
				break;
			case SOURCECONTAINS:
			case SOURCEEXEMPT:
				if (*sourceAddr != EOS)
#ifndef NOUSE_REGEX
					if (regexec(l->regc, sourceAddr, 0, NULL, 0) == 0)
						return TRUE;
#else
#ifdef NOSAVESKIP
					i = search(l->data, sourceAddr);
#else
					i = search(l->data, sourceAddr, l->skip);
#endif
				else
					i = -1;
#endif
				break;
			default:
				fprintf(stderr, "Invalid 'type' in config.\n");
				exit(EXIT_FAILURE);
				break;
		}
#ifdef DEBUG
		printf("--Completed...\n");
#endif

#ifdef NOUSE_REGEX
		if (i != -1)
			return TRUE;
#endif

		l = l->next;
	}

	return FALSE;
}


/* This function outputs one of the redirection strings, randomly choosing 
   between them.  It also uses the random integer to determine whether to
   output the original url */

void print_redir(redir_list *redir, int numredirs)
{
	int i, j;
	redir_list *curr;

	if (redir == NULL)
		return;

	/* Randomly choose a redirect */

	j = rand() % numredirs;

#ifdef DEBUG
	printf("Total redirects = %d, choosing %d.\n", numredirs, j+1);
#endif

	curr = redir;
	for(i=0; i<j; i++) {
		curr = curr->next;
	}
#ifdef DEBUG
	printf("Redir type: %d.\n", curr->type);
#endif

	if (curr->type == 1)
	{
		fputs(BROWSER_REDIR, stdout);
	}
	puts(curr->data);
}
