#ifndef SCREEM_PREFERENCES_H
#define SCREEM_PREFERENCES_H

#include <glib.h>
#include <gnome-xml/debugXML.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

typedef struct _Hi_colours {
        gboolean useFore;     /* if we should highlight using fore colour */
        gboolean useBack;     /* if we should highlight using back colour */
        guint16 fore[ 4 ];    /* the fore colour rgba */
        guint16 back[ 4 ];    /* the back colour rgba */
} Hi_colours;

typedef struct _Preferences {
	GtkWidget *box;        /* the prefs dialog */
        gint    tag_width;     /* width of the html tag tree */
	gint    tag_height;    /* height of html tag tree */
        gint    file_width;    /* width of the file tree */
	gint    file_height;   /* the height of the file tree */
	gint    editor_width;
	gint    editor_height;
	gint    preview_width;
	gint    preview_height;
     	gint    tag_highlighting;
	gint    inline_tagging;
	gint    undo_levels;
	GdkFont *font;
	gchar   *font_name;
	guint16 back[ 3 ];
	guint16 fore[ 3 ];
	GList   *colours;
	GList   *coloursBak;
	Hi_colours *current;
	gchar   *default_filename;
	xmlDocPtr tag_tree;

	GList *helpers;
	GList *recent_sites;
	GList *recent_pages;

	gchar *java_compiler;

	GList *perl_colours;
	GList *java_colours;

} Preferences;

void load_preferences( void );
void save_preferences( void );
void edit_preferences( void );
Hi_colours* tag_colour( gchar *name );

#endif
