#!/usr/bin/perl
##
## Copyright (c) 1999 Internet Images Srl
##                    Massimiliano Masserelli
##
## $Id: gencat.pl,v 1.1 1999/11/02 11:11:16 negro Exp $
##

$source_catalog = shift || die("Specificare il nome del catalogo sorgente.");
$target_catalog = shift || die("Specificare il nome del DBM destinazione.");

use GDBM_File;

unlink($target_catalog);
tie(%MSGID, 'GDBM_File', $target_catalog, &GDBM_WRCREAT, 0644) || die("cannot tie to $target_catalog");
           
open(SOURCE, $source_catalog);

$idfound = 0;
$strfound = 1;
while (<SOURCE>) {
#  print $_;
  $ln++;
  chomp;
  next if (/^#/ || /^$/); # Skip comments and white lines
  if ($idfound) {
    if (/^msgstr +"(.*)"$/) {
      $msgstr = $1;
      $idfound = 0;
      $strfound = 1;
    } elsif (/^[^"]*"(.*)"[^"]*$/) {
      $msgid .= $1;
    } else {
      print $source_catalog . ":" . $ln . "\n";
      die("Syntax error in $_");
    }
  } elsif ($strfound) {
    if (/^msgid +"(.*)"$/) {
      if ($msgstr && $msgid) {
        $MSGID{stripquotes($msgid)} = stripquotes($msgstr);
      }
      $msgid = $1;
      $idfound = 1;
      $strfound = 0;
    } elsif (/^[^"]*"(.*)"[^"]*$/) {
      $msgstr .= $1;
    } else {
      print $source_catalog . ":" . $ln . "\n";
      die("Syntax error in $_");
    }
  } else {
    die ("Parse error in $source_catalog. $target_catalog corrupted.");
  }
}
if ($strfound) {
  if ($msgstr && $msgid) {
    $MSGID{stripquotes($msgid)} = stripquotes($msgstr);
  }
} else {
  die ("Parse error in $source_catalog. $target_catalog corrupted.");
}

close(SOURCE);
untie(%MSGID);

exit;

sub stripquotes($) {
 $string = shift;
 $string =~ s/\\n/\n/g;
 $string =~ s/\\"/"/g;
 return $string;
}
