# $Id: UserVar.pm,v 1.4 1999/05/23 04:00:07 kenji Exp $
package HNS::Hnf::UserVar;
################################################################
use strict;
use ObjectTemplate;
use vars qw(@ISA %Templates);

@ISA = qw(ObjectTemplate);
attributes qw(content);

%Templates = (TENKI=>"[%value]",
	      BASHO=>"(%value) ",
	      TAION=>"Temperature:%value ",
	      TAIJU=>"Weight:%value" . "Kg ",
	      SUIMIN=>"Hours of Sleep:%value hour ",
	      BGM=>"BGM:%value ");

################################################################	
sub initialize($)
{
    my $self = shift;
    $self->content({});
}
sub Account($$$)
{
    my ($self, $name, $value) = @_;

    $self->content->{$name} = $value;
    return exists $Templates{$name};
}
sub Eval($$)
{
    my ($self, $name) = @_;

    my $template = $Templates{$name};

    if (! $template){                        # template is not set
	return $self->content->{$name};
    } else {
	if ($self->content->{$name}){
	    $template =~ s/%value/$self->content->{$name}/ge;
	    $template =~ s/%user{([A-Z]+)}/($1 eq $name) ? "'$name' FORMAT ERROR: self-reference" : $self->Eval($1)/ge; #call recursible
	    return $template;
	} else {
	    return undef;
	}
    }
}
1;
