################################################################
# $Id: CategoryList.pm,v 1.6 1999/05/30 06:55:44 kenji Exp $

package HNS::CategoryList;

use strict;
use HNS::DateSelect;
@HNS::CategoryList::ISA = qw(HNS::DateSelect);

use Image::Size;
use HNS::System;
use HNS::Template;

attributes qw(year month day);

use vars qw(%DB $CatDir $TitleLabel $SubmitLabel $Template $Categorize);

$CatDir = "cat";
$TitleLabel = "Title List";
$SubmitLabel = "Show!";
$Template = qq(<img src="%src" width="%width" height="%height" alt="">%value<br>\n);
$Categorize = "Categorize";

################################################################
sub initialize($)
{
    my $self = shift;
    $self->SUPER::initialize;
    $self->month_all(1);
    tie %DB, 'SimpleDB::Hash', "$CatDir/cat.txt";
#    print $DB{anime};
}
sub AsHTML($)
{
    my $self = shift;

    my $html = "$TitleLabel<br>\n" .
	qq(<form action="title_wrapper.cgi" method="get">\n);
    $html .= qq(<input name="CAT" type="checkbox" value="ALL">$Categorize<br>\n);

    my $templ = new HNS::Template;
    for my $cat (sort keys %DB){
	next unless $cat;
	my $img = "$CatDir/$DB{$cat}";
	my ($w, $h) = imgsize($img);
	
	$html .= qq(<input name="CAT" type="checkbox" value="$cat">\n);
#	$html .= qq(<img src="$CatDir/$img">$cat<br>);
	$html .= $templ->Expand($Template,
				{src=>$img,
				 width=>$w, height=>$h,
				 value=>$cat});
				 
    }
    $html .= $self->SUPER::AsHTML($self->year, $self->month, $self->day, $SubmitLabel);
    $html .= "</form>\n";
    return $html;
}


1;
