################################################################
# english theme
# $Id: theme.ph,v 1.8.2.3 1999/07/30 08:54:04 kenji Exp $

################################################################
# User variable
#  parameter %value is expanded to value of the user variable.
#  you can use other value of user variable by noting as "%user{BASHO}".
package HNS::Hnf::UserVar;
$Templates{'TENKI'} = "[%value]";
$Templates{'BASHO'} = "(%value)";
$Templates{'TAION'} = " Temperature:%value";
$Templates{'TAIJU'} = " Weight:%value" . "Kg";
$Templates{'SUIMIN'} = " Hours Sleep:%value";
$Templates{'BGM'} = " BGM:%value";

################################################################
# Mark
package HNS::Hnf::Command::MARK;
# image size is automatically set
$List{"(^^)"} =  "icons/nomal_13.gif";
$List{"(^^;"} = "icons/ase_13.gif";
$List{"(;_;)"} = "icons/naku_13.gif";
$List{"v(^^)"} = "icons/v_13.gif";
$List{"!!"} = "icons/neko_13.gif";
$List{"??"} = "icons/hatena_13.gif";

################################################################
# CategoryList
package HNS::CategoryList;
$CatDir = "cat";

$TitleLabel = "Title List";
$SubmitLabel = "Show!";
$Template = qq(<img src="%src" width="%width" height="%height" alt="">%value<br>\n);
$Categorize = "Categorize";

################################################################
# Extend HTML
package HNS::ExtHTML;
$DOCTYPE = qq(<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"
	"http://www.w3.org/TR/REC-html40/loose.dtd">\n);
#$Head = undef;
$Head = qq(<meta http-equiv="Content-Style-Type" content="text/css">
<style type="text/css"><!--
 h3.new { margin-left: 1em }
 div.section { margin-left: 2em; margin-top: 0 }
 div.sub { margin-left: 1em; margin-top: 0 }
 div.list { margin-left: 1em }
 div.fn { margin-left: 1em; margin-top: 0 }
 div.url { margin-bottom: 0 }
 pre { 
  white-space:  pre;
  padding:      0.5em;
  border-color: #ffeeb0;
  border-style: outset;
  border-width: 4px
 }
--></style>
);

#$BodyVal = undef;
##$BodyVal = "bgcolor=#ffffcc";
#$DynamicPrintFunc = undef;
##$DynamicPrintFunc = \&PrintTime;
##sub PrintTime
##{
##    print qq(<div align="center">time is);
##    print join(':', reverse ((localtime)[0..2]));
##    print qq(</div>);
##}
################################################################
package HNS::Collection;
# %num : number of showing diarys
$FootMessages{'HasContent'} = "Diary for %num day(s).\n";
$FootMessages{'NoContent'} = "No match.\n";


################################################################
# PIM
# Schedule
package HNS::PIM::Schedule;
@WeekString = ('<font color="red">Sun</font>', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', '<font color="blue">Sat</font>');
$ContentTemplate = qq(<li><strong>%month/%day(%week)</strong> %content</li>\n);
$BeginTemplate = "<ul>";
$EndTemplate = "</ul>";

# TODO
package HNS::PIM::Todo;
$ContentTemplate = "<li><strong>%priority</strong> %content</li>\n";
$BeginTemplate = "<ul>";
$EndTemplate = "</ul>";

################################################################
# Calendar
package HNS::Calendar::Table;
@WeekString = ('<font color="red">Sun</font>', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', '<font color="blue">Sat</font>');
$TableBorder = 0;
$NextTemplate = qq(<a href="./?%year%month">Next</a>);
$PrevTemplate = qq(<a href="./?%year%month">Prev</a>);
$ThisTemplate = qq(<a href="./?%year%month">%year/%month</a>);
$DayCurrentTemplate = qq(<a href="%ruri#%{ymd}0">%day</a>);
$DayNonCurrentTemplate = qq(<a href="./?%year%month%high#%{ymd}0">%day</a>);

package HNS::Calendar::NoTable;
$NextTemplate = qq(<a href="./?%year%month">&gt;&gt;</a>);
$PrevTemplate = qq(<a href="./?%year%month">&lt;&lt;</a>);
$ThisTemplate = qq(<a href="./?%year%month">%year/%month</a>);
$DayCurrentTemplate = qq(<a href="%ruri#%{ymd}0">%day</a>);
$DayNonCurrentTemplate = qq(<a href="./?%year%month%high#%{ymd}0">%day</a>);

################################################################
# DateSelect
package HNS::DateSelect;
$YearTemplate = "%year/";
$MonthTemplate = "%month/";
$DayTemplate = "%start_day - %end_day";
$AllLabel = "All";

################################################################
# Direct Ctalendar
package HNS::Calendar::Direct;
$SubmitLabel = "Go!";

################################################################
# Style
package HNS::Style;
$Templates{Table}->{pim} = qq(
<hr>
<table summary="pim" width="100%">
<tr><th align="left">Schedule</th><th align="left">TODO</th></tr>
<tr><td valign="top">
%schedule
</td>
<td valign="top">
%todo
</td></tr>
</table>
);

$Templates{Table}->{head_style} = qq( 
%pim
<hr>
<table summary="calendar">
<tr>
<td rowspan="2" valign="top">
%calendar
</td>
<td valign="top">
%unagi
</td>
</tr>
<tr>
<td valign="bottom">
%direct_calendar
</td>
</tr>
</table>
<hr>
);

$Templates{Table}->{foot_style} = "\n<hr>\n%category_list";

# template for no table browser
$Templates{NoTable} = {
    pim => qq(<hr>\n%schedule %todo),
    head_style => qq(%pim\n<hr>\n%unagi\n<hr>\n%calendar
		      %direct_calendar\n<hr>\n),
    foot_style=> "<hr>\n%category_list"
    };

# unagi template
$UnagiTemplate = qq( 
<a href="%namazu_url">Namazu</a> for hns, Search Engine<br>
for detail see <a href="%unagi_url">help</a>
<form method="GET" action="%unagi_url">
<strong>keyword:</strong>
<input type="TEXT" name="key" size="30" value="">
<input type="SUBMIT" name="submit" value="Search!">
<input type="HIDDEN" name="whence" value="0">
</form>
);

$NoUnagiTemplate = qq(
<a href="http://www.h14m.org/"><img src="./icons/hns-logo.gif" width="200" height="40" align="right" alt="HNS logo"></a>
);



################################################################
# Warning
package HNS::Hnf::Warning;
$Head = "<br><font color=\"red\">\[- Warning:";
$Foot = "-\]</font><br>\n";

# parameters:
#  %c : the command name
#  %p : command name of inserted position
#
$Messages{'IllegalHeader'} = "illegal header.";
$Messages{'UndefinedUserVar'} = "undefined user var %c";
$Messages{'Reserved'} = "command '%c' is reserved. ";
$Messages{'NotDefined'} = "term '%t' is not defined in %c definition file.";
$Messages{'NoMatch'} = "command '%c' is not allowed in command '%p'. command '%c' is missing ?";

################################################################
# Version Message
# paramter:
#  %homepage
#  %public_version
#  %current_version

package HNS;
$VersionMessages{'Public'} = q(<hr>
<div>hns - Hyper NIKKI System - Version %public</div>);

$VersionMessages{'NonPublic'} = qq(<hr>
<div>
<font color="red">Caution: </font> 
current version is %current, 
public released version is %public.
</div>
);

################################################################
# Template
# usable parameter (%[A-Za-z0-9_]) is:
#  date:
#   %year, %month, %day : year, month, day
#   %high               : int(day/10)
#   
#  counter:
#   %new, %sub, %fn     : counter of NEW, SUB, FN

package HNS::Diary;
################
# diary limited parameter:
#   %week               : week string
#
#  user-variable
#   %user{VARNAME}      : string as which user-var-format is expanded using
#                         value of user-variable VARNAME.
@WeekString = ('<font color="red">Sun</font>', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', '<font color="blue">Sat</font>');

$Head = qq(
<h2><a href="./?%year%month%high&amp;to=%year%month%{day}0#%year%month%{day}0"
name="%year%month%{day}0">%year/%month/%day(%week)</a>
 %user{TENKI}%user{BASHO}%user{TAIJU}%user{TAION}%user{SUIMIN}%user{BGM}</h2>);

$Foot = qq(<hr>\n);

package HNS::Hnf::Command::NEW;
$Template = q(
<h3 class="new"><a name="%year%month%day%new" 
href="./?%year%month%high&amp;to=%year%month%day%new#%year%month%day%new">#%new</a>
%cat %content</h3>
<div class="section">);
$EndTemplate = "</div><!-- end of NEW -->\n";

package HNS::Hnf::Command::LNEW;
$Template = q(
<h3 class="new"><a name="%year%month%day%new" 
href="./?%year%month%high&amp;to=%year%month%day%new#%year%month%day%new">#%new</a>
%cat <a href="%1">%content</a></h3>
<div class="section">);
$EndTemplate = "</div><!-- end of LNEW -->\n";

package HNS::Hnf::Command::SUB;
$Template = q(
<h4><a name="%year%month%day%{new}S%sub"
href="./?%year%month%high&amp;to=%year%month%day%{new}S%sub#%year%month%day%{new}S%sub">@</a>
%content:</h4> 
<div class="sub">
);
$EndTemplate = "</div><!-- end of SUB -->\n";

package HNS::Hnf::Command::LSUB;
$Template = q(
<h4><a name="%year%month%day%{new}S%sub"
href="./?%year%month%high&amp;to=%year%month%day%{new}S%sub#%year%month%day%{new}S%sub">@</a>
<a href="%1">%content</a>:</h4> 
<div class="sub">
);
$EndTemplate = "</div><!-- end of LSUB -->\n";
$NumAttr = 1;

################################################################
# Inline Elements
# these element has no content commands,
# so $EndTemplate, $AllowCommands has no means.

package HNS::Hnf::Command::LINK;
$Template = qq(<a href="%1">%content</a> );
$NumAttr = 1;

package HNS::Hnf::Command::RLINK;
$Template = qq(<a href="%url%2">%content</a> );
$NumAttr = 2;
# overriden AsHTML

package HNS::Hnf::Command::URL;
$Template = qq(<div class="url">
<img alt="*" src="./icons/mark01.gif" width="16" height="16"><a href="%1">%content (%1)</a>
</div>);
$NumAttr = 1;

package HNS::Hnf::Command::STRIKE;
#$Template = q(<strike>%content</strike>);

package HNS::Hnf::Command::LSTRIKE;
$Template = q(<strike><a href="%1">%content</a></strike>);
$NumAttr = 1;

package HNS::Hnf::Command::STRONG;
$Template = q(<strong>%content</strong>);

package HNS::Hnf::Command::FONT;
$Template = q(<font %1="%2">%content</font>);
$NumAttr = 2;

package HNS::Hnf::Command::IMG;
$Template = q(<img %align src="%2" alt="%content" width="%width" height="%height">);
$NumAttr = 2;
# overriden AsHTML

package HNS::Hnf::Command::MARK;
$Template = qq(<img src="%src" alt="%1" width="%width" height="%height">\n);
$NumAttr = 1;
# overriden AsHTML

package HNS::Hnf::Command::ALIAS;
$Template = "%term";
# overriden AsHTML

################################################################
# Block Commands
package HNS::Hnf::Command::PRE;
$Template = "<pre>\n";
$EndTemplate = "</pre>\n";

package HNS::Hnf::Command::CITE;
$Template = "<blockquote>\n";
$EndTemplate = "</blockquote>\n";

package HNS::Hnf::Command::UL;
$Template = "<ul>\n";
$EndTemplate = qq(</ul>\n);

package HNS::Hnf::Command::OL;
$Template = "<ol>\n";
$EndTemplate = qq(</ol>\n);

package HNS::Hnf::Command::LI;
$Template = q(<li>%content);
$EndTemplate = "</li>\n";

package HNS::Hnf::Command::HR;
$Template = q(<hr>\n);

package HNS::Hnf::Command::FN;
$Template = qq(
<a href="$ENV{'REQUEST_URI'}#%year%month%day%{new}F%fn"><small>*%fn</small></a>
);

$HeaderTemplate = qq(<hr class="section" width="40%" align="left">
<div class="fn">);
$FooterTemplate = qq(</div>);

$ContentTemplate = qq(
<a name="%year%month%day%{new}F%fn"
href="./?%year%month%high&amp;to=%year%month%day%{new}F%fn#%year%month%day%{new}F%fn"><small>*%fn</small></a>: %content<br>
);
################################################################
1;
