#ifndef __HISTORY_H__
#define __HISTORY_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define URL_SIZE 1024

typedef struct _HistoryNode   HistoryNode;
typedef struct _HistoryTree   HistoryTree;

struct _HistoryNode
{
  HistoryNode *parent;
  HistoryNode *sibling;
  HistoryNode *descendent;

  /* data */
  char url[URL_SIZE];
};

HistoryNode *historynode_new(char *url);
HistoryNode *historynode_add_descendent(HistoryNode *node, char *url);
/*HistoryNode *historynode_add_sibling(HistoryNode *node, char *url);*/
void historynode_remove_node(HistoryNode *node); 

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __HISTORY_H__ */
