#include "config.h"
#include <signal.h>
#include <stdio.h>

/* ****************************************************************** */
RETSIGTYPE alarm_handler(int sig) {
  fprintf(stderr, "Timer has expired.  Giving up.\n");
  exit(-1);
}
/* ****************************************************************** */


/* ****************************************************************** 
   This function was pretty much lifted from Qmail code.  Thanks to
   Professor Bernstein. 
   ****************************************************************** */
void set_handler(int sig, RETSIGTYPE (*h)()) {
#ifdef HAVE_SIGACTION
  struct sigaction sa;
  sa.sa_handler = h;
  sa.sa_flags = 0;
  sigemptyset(&sa.sa_mask);
  sigaction(sig,&sa,(struct sigaction *) 0);
#else
  signal(sig,h);
#endif
}
/* ****************************************************************** */
