/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 * Can be freely distributed and used under the terms of the GNU GPL.
 * 
 * Routines to convert config file tags into pokes.
 */

typedef struct Tweaks_s {
	const char *tagname;
	const int poke_reg;
	const int poke_mask;
	const int poke_value;
	const char *poke_name;
} Tweaks_t;


int tune_device(Tweaks_t *Tweaks, struct pci_dev *current_dev)
{
	int actual_poke_value;
	int tweaksmade=0;
	unsigned char current_value, option;
	unsigned long hardware_ID;

	hardware_ID = (current_dev->vendor_id<<16)|current_dev->device_id;

	while (Tweaks->tagname) {

		switch (find_PCI_tag(hardware_ID, Tweaks->tagname, &option)) {

			/* Tag found, but with no parameter. */
			case OPTION_UNSET:
				printf ("Powertweak hasn't been configured properly\n");
				return(1);

			/* Tag not found, or is commented out: Ignore silently. */
			case FALSE:
				return(1);

			/* Tag found. */
			case TRUE:
				if (option==OPTION_ON) {
					current_value = pci_read_byte (current_dev, Tweaks->poke_reg);
					actual_poke_value = (current_value | Tweaks->poke_value);

					if (current_value != actual_poke_value) {
						if (open_log_file(&logfile)==TRUE) {
							fprintf(logfile, "\tPOKE:%s enabled.\n", Tweaks->poke_name);
							fprintf(logfile, "Register: 0x%x\tBefore: 0x%x\tAfter: 0x%x\n",
								Tweaks->poke_reg, current_value, actual_poke_value);
							close_log_file(&logfile);
						}
						pci_write_byte (current_dev, Tweaks->poke_reg, actual_poke_value);
						tweaksmade++;
					}
				}
				break;
		} // Switch.
		Tweaks++;
	}

	if (tweaksmade==0) {
		if (open_log_file(&logfile)==TRUE) {
			fprintf(logfile, "\t-> Device is already tuned.\n");
			close_log_file(&logfile);
		}
	}
	return(0);
}
