/*
 * Hardware tuning for the Intel 82437VX bridge
 */

#define PCI_DEVICE_ID_Intel_82437VX 0x7030

// Note, The tweaks commented out are done so until they have
// been double checked - DJ.
static Tweaks_t Intel_82437VX_Tweaks[] = {
	/* Tagname					Reg		Mask	Bit		Description	*/
	{ "CPU_PRIORITY",			0x4f,	1<<3,	0<<3,	"CPU gets priority after 2 PCI slots" },
	{ "PCI_CONCURRENCY",		0x50,	1<<3,	1<<3,	"PCI concurrency" },
	{ "LEVEL_ONE_CACHE",		0x52,	1<<0,	1<<0,	"Level 1 cache" },
	{ "REFRESH_RAS_ASSERTION",	0x56,	1<<6,	0<<6,	"4 clock refresh RAS assertion" },
	{ "FAST_MA_TO_RAS_DELAY",	0x58,	1<<7,	1<<7,	"Fast MA to RAS delay" },
	{ "FAST_RAS_TO_CAS_DELAY",	0x58,	1<<2,	1<<2,	"2 clock RAS to CAS delay" },
	{ 0, 0, 0, 0, 0 }
};

