#!/bin/sh
# This is the INSTALL script for the apcupsd package for libc5 and libc6...

case "$2" in
	remove)	echo "You are removing apcupsd from your system."
		;;
	libc5)	echo "You are installing apcupsd for libc5."
		;;
	libc6)	echo "You are installing apcupsd for libc6 or glibc2."
		;;
	*)	echo "You forgot to tell me what libc you are using."
		echo -n "Usage:   ${0##*/} [ remove | slackware | redhat | suse | unifix | debian | unknown ]"
		echo " [ remove | libc5 | libc6 ]"
		exit 1
		;;
esac

case "$1" in
	remove)	echo "Sorry to see you go........"

		if [ `ps x | gawk '{ if (($5 == "/sbin/apcupsd") || \
			($5 == "/usr/sbin/apcupsd") || \
			($5 == "apcupsd")) print $1 }'` ]; then
			printf "Stopping a running version of "\"apcupsd\"".\n"
			kill `ps x | gawk '{ if (($5 == "/sbin/apcupsd") || \
				($5 == "/usr/sbin/apcupsd") || \
				($5 == "apcupsd")) print $1 }'`
			if [ -f /var/run/apcupsd.pid ]; then
				rm -f /var/run/apcupsd.pid
			fi
		fi

		if [ -d /etc/rc.d/init.d ]; then
			echo "removing: redhat installation"
			echo "removing: /etc/rc.d/init.d/apcups"
			rm -f /etc/rc.d/init.d/apcups
			echo "removing: /etc/rc.d/rc[1235].d/S20apcups"
			rm -f /etc/rc.d/rc1.d/S20apcups
			rm -f /etc/rc.d/rc2.d/S20apcups
			rm -f /etc/rc.d/rc3.d/S20apcups
			rm -f /etc/rc.d/rc5.d/S20apcups
			echo "removing: /etc/rc.d/rc[016].d/K20apcups"
			rm -f /etc/rc.d/rc0.d/K20apcups
			rm -f /etc/rc.d/rc1.d/K20apcups
			rm -f /etc/rc.d/rc6.d/K20apcups
		fi

		if [ -d /sbin/init.d ]; then
			echo "removing: suse installation"
			echo "System configurations files for apcupsd need to be updated."
			if [ "`grep -i "START_APCUPSD" /etc/rc.config`" = "START_APCUPSD=yes" ]; then
				echo "Have been here before, change START_APCUPSD=yes"
				echo "to START_APCUPSD=no or delete lines"
			fi
			echo "removing: /sbin/init.d/apcups"
			rm -f /sbin/init.d/apcups
			echo "removing: /sbin/init.d/rc[12].d/S20apcups"
			rm -f /sbin/init.d/rc1.d/S20apcups
			rm -f /sbin/init.d/rc2.d/S20apcups
			echo "removing: /sbin/init.d/rc[12].d/K20apcups"
			rm -f /sbin/init.d/rc1.d/K20apcups
			rm -f /sbin/init.d/rc2.d/K20apcups
		fi

		if [ -d /etc/init.d ]; then
			if [ -f /etc/init.d/shutdown ]; then
				echo "removing: unifix installation"
				echo "/etc/SERVICES needs adjustment"
			else
				echo "removing: debian installation"
				echo "removing: /etc/init.d/apcups"
				rm -f /etc/init.d/apcups
				echo "removing: /etc/rc[12345].d/S20apcups"
				rm -f /etc/rc1.d/S20apcups
				rm -f /etc/rc2.d/S20apcups
				rm -f /etc/rc3.d/S20apcups
				rm -f /etc/rc4.d/S20apcups
				rm -f /etc/rc5.d/S20apcups
				echo "removing: /etc/rc[016].d/K20apcups"
				rm -f /etc/rc0.d/K20apcups
				rm -f /etc/rc1.d/K20apcups
				rm -f /etc/rc6.d/K20apcups
			fi
		fi

		echo "removing: /etc/apcupsd.conf"
		rm -f /etc/apcupsd.conf
		echo "removing: /etc/apcupsd.status"
		rm -f /etc/apcupsd.status
		echo "removing: /var/log/apcupsd.log"
		rm -f /var/log/apcupsd.log
		echo "removing: /sbin/apcupsd"
		rm -f /sbin/apcupsd
		echo "removing: /sbin/powersc"
		rm -f /sbin/powersc
		echo "removing: /usr/man/man8/apcupsd.8.gz"
		rm -f /usr/man/man8/apcupsd.8.gz
		exit 0
		;;
	slackware)
		if [ ! "`grep -i "/sbin/powersc" /etc/rc.d/rc.6`" = \
				"    /sbin/powersc KILL" ]; then
			cp /etc/rc.d/rc.6 /etc/rc.d/rc.6.old
			rm -f /etc/rc.d/rc.6
			install installs/halt.slackware /etc/rc.d/rc.6
		fi
		if [ ! "`grep -i "/sbin/powersc ]; then" /etc/rc.d/rc.local`" = \
				"if [ -x /sbin/powersc ]; then" ]; then
			cp /etc/rc.d/rc.local /etc/rc.d/rc.local.old
			echo "#" >> /etc/rc.d/rc.local
			echo "#" >> /etc/rc.d/grepped.rc.files
			echo "if [ -x /sbin/powersc ]; then" >> /etc/rc.d/rc.local
			echo "if [ -x /sbin/powersc ]; then" >> /etc/rc.d/grepped.rc.files
			echo "  /sbin/powersc INIT" >> /etc/rc.d/rc.local
			echo "  /sbin/powersc INIT" >> /etc/rc.d/grepped.rc.files
			echo "fi" >> /etc/rc.d/rc.local
			echo "fi" >> /etc/rc.d/grepped.rc.files
		fi
		if [ "`grep -i "apcupsd" /etc/rc.d/rc.inet2`" = \
				"if [ -f /usr/sbin/apcupsd ]; then" ]; then
			echo "Delete the following lines from /etc/rc.d/rc.6"
			echo "if [ -f /usr/sbin/apcupsd ]; then"
			echo "  echo -n "\" apcupsd\"""
			echo "  /usr/sbin/apcupsd /dev/apcups"
			echo "  if [ -f /etc/powerfail ]; then"
			echo "    rm -f /etc/powerfail"
			echo "  fi"
			echo "  if [ -f /etc/nologin ]; then"
			echo "    rm -f /etc/nologin"
			echo "  fi"
			echo "fi"
		fi
		if [ -f /etc/rc.d/grepped.rc.files ]; then
			cat /etc/rc.d/grepped.rc.files
			echo "System configurations files for apcupsd (updated)."
			echo "/etc/rc.d/rc.6 and-or /etc/rc.d/rc.local"
			echo "have been changed and originals changed to"
			echo "/etc/rc.d/rc.6.old and-or /etc/rc.d/rc.local.old"
			echo "Make need changes to the new files with respect"
			echo "to your original files before you reboot your system."
			echo "DO THIS NOW, AND DON'T HASSLE ME IF YOU DON'T"
			echo
		fi
		;;
	redhat)
		rm -f /etc/rc.d/init.d/apcups
		install installs/apcups.rhs /etc/rc.d/init.d/apcups
		chmod +x /etc/rc.d/init.d/apcups
		if [ -f /etc/rc.d/init.d/apc.halt ]; then
			rm -f /etc/rc.d/init.d/halt
			cp /etc/rc.d/init.d/apc.halt /etc/rc.d/init.d/halt
			rm -f /etc/rc.d/init.d/apc.halt
		fi
		cp /etc/rc.d/init.d/halt /etc/rc.d/init.d/halt.old
		rm -f /etc/rc.d/init.d/halt
		install installs/halt.rhs /etc/rc.d/init.d/halt
		chmod +x /etc/rc.d/init.d/halt
		echo "System configurations files for apcupsd (updated)."
		echo "/etc/rc.d/init.d/halt have been changed"
		echo "and saved as /etc/rc.d/init.d/halt.old"
		echo "Make need changes to the new files with respect"
		echo "to your original files before you reboot your system."
		echo "DO THIS NOW, AND DON'T HASSLE ME IF YOU DON'T"
		echo
		rm -f /etc/rc.d/rc0.d/K20apcups
		rm -f /etc/rc.d/rc1.d/S20apcups
		rm -f /etc/rc.d/rc1.d/K20apcups
		rm -f /etc/rc.d/rc2.d/S20apcups
		rm -f /etc/rc.d/rc3.d/S20apcups
		rm -f /etc/rc.d/rc5.d/S20apcups
		rm -f /etc/rc.d/rc6.d/K20apcups
		ln -sf /etc/rc.d/init.d/apcups /etc/rc.d/rc0.d/K20apcups
		ln -sf /etc/rc.d/init.d/apcups /etc/rc.d/rc1.d/S20apcups
		ln -sf /etc/rc.d/init.d/apcups /etc/rc.d/rc1.d/K20apcups
		ln -sf /etc/rc.d/init.d/apcups /etc/rc.d/rc2.d/S20apcups
		ln -sf /etc/rc.d/init.d/apcups /etc/rc.d/rc3.d/S20apcups
		ln -sf /etc/rc.d/init.d/apcups /etc/rc.d/rc5.d/S20apcups
		ln -sf /etc/rc.d/init.d/apcups /etc/rc.d/rc6.d/K20apcups
		;;
	suse)
		rm -f /sbin/init.d/apcups
		install installs/apcups.suse /sbin/init.d/apcups
		chmod +x /sbin/init.d/apcups
		if [ -f /sbin/init.d/apc.halt ]; then
			rm -f /sbin/init.d/halt
			cp /sbin/init.d/apc.halt /sbin/init.d/halt
			rm -f /sbin/init.d/apc.halt
		fi
		cp /sbin/init.d/halt /sbin/init.d/halt.old
		rm -f /sbin/init.d/halt
		install installs/halt.suse /sbin/init.d/halt
		chmod +x /sbin/init.d/halt
		echo "System configurations files for apcupsd (updated)."
		if [ "`grep -i "START_APCUPSD" /etc/rc.config`" = "START_APCUPSD=no" ]; then
			echo "Have been here before, change START_APCUPSD=no"
			echo "to START_APCUPSD=yes"
		elif [ "`grep -i "START_APCUPSD" /etc/rc.config`" = "START_APCUPSD=yes" ]; then
			echo "Have been here before, no changes to /etc/rc.config";\
		elif [ ! "`grep "START_APCUPSD=yes" /etc/rc.config`" = "START_APCUPSD=yes" ]; then
			cp /etc/rc.config /etc/rc.config.old
			echo "#" >> /etc/rc.config
			echo "# Should the apcupsd daemon be started at bootup? (yes/no)" >> /etc/rc.config
			echo "#" >> /etc/rc.config
			echo "START_APCUPSD=yes" >> /etc/rc.config
			echo "#" >> /etc/rc.config
			/sbin/SuSEconfig 1> /dev/null 2> /dev/null
			echo "/etc/rc.config has been changed and saved as /etc/rc.config.old"
		fi
		echo "/sbin/init.d/halt has been changed and saved as /sbin/init.d/halt.old"
		echo "Make need changes to the new files with respect"
		echo "to your original files before you reboot your system."
		echo "DO THIS NOW, AND DON'T HASSLE ME IF YOU DON'T"
		echo
		rm -f /sbin/init.d/rc1.d/S20apcups /sbin/init.d/rc1.d/K20apcups
		rm -f /sbin/init.d/rc2.d/S20apcups /sbin/init.d/rc2.d/K20apcups
		ln -sf /sbin/init.d/apcups /sbin/init.d/rc1.d/S20apcups
		ln -sf /sbin/init.d/apcups /sbin/init.d/rc1.d/K20apcups
		ln -sf /sbin/init.d/apcups /sbin/init.d/rc2.d/K20apcups
		ln -sf /sbin/init.d/apcups /sbin/init.d/rc2.d/S20apcups
		;;
	unifix)
		echo "Adjusting /etc/SERVICES"
		mv /etc/SERVICES /etc/SERVICES.old
		grep -iv "/etc/init.d/powersc INIT" /etc/SERVICES.old | grep -iv "/sbin/powersc INIT" > /etc/SERVICES
		echo "\"/sbin/powersc INIT\"" >> /etc/SERVICES
		if [ -f /etc/init.d/apcups.shutdown ]; then
			rm -f /etc/init.d/shutdown
			rm -f /etc/init.d/apcups.shutdown
			install installs/halt.unifix /etc/init.d/apcups.shutdown
			chmod +x /etc/init.d/apcups.shutdown
			ln -s /etc/init.d/apcups.shutdown /etc/init.d/shutdown
		else
			mv /etc/init.d/shutdown /etc/init.d/shutdown.old >/dev/null 2>&1
			rm -f /etc/init.d/apcups.shutdown
			install installs/halt.unifix /etc/init.d/apcups.shutdown
			chmod +x /etc/init.d/apcups.shutdown
			ln -s /etc/init.d/apcups.shutdown /etc/init.d/shutdown
		fi
		echo "System configurations files for apcupsd (updated)."
		echo "/sbin/powersc and /etc/init.d/shutdown"
		echo "have been changed and originals changed to"
		echo "/sbin/powersc.old and /etc/init.d/shutdown.old"
		echo "Make need changes to the new files with respect"
		echo "to your original files before you reboot your system."
		echo "DO THIS NOW, AND DON'T HASSLE ME IF YOU DON'T"
		echo
		;;
	debian)
		rm -f /etc/init.d/apcups
		install installs/apcups.deb /etc/init.d/apcups
		chmod +x /etc/init.d/apcups
		cp /etc/init.d/halt /etc/init.d/halt.old
		rm -f /etc/init.d/halt
		install installs/halt.deb /etc/init.d/halt
		chmod +x /etc/init.d/halt
		echo "System configurations files for apcupsd (updated)."
		echo "/etc/init.d/halt have been changed"
		echo "and saved as /etc/init.d/halt.old"
		echo "Make need changes to the new files with respect"
		echo "to your original files before you reboot your system."
		echo "DO THIS NOW, AND DON'T HASSLE ME IF YOU DON'T"
		echo
		rm -f /etc/rc0.d/K20apcups
		rm -f /etc/rc1.d/S20apcups
		rm -f /etc/rc1.d/K20apcups
		rm -f /etc/rc2.d/S20apcups
		rm -f /etc/rc3.d/S20apcups
		rm -f /etc/rc4.d/S20apcups
		rm -f /etc/rc5.d/S20apcups
		rm -f /etc/rc6.d/K20apcups
		ln -sf /etc/init.d/apcups /etc/rc0.d/K20apcups
		ln -sf /etc/init.d/apcups /etc/rc1.d/S20apcups
		ln -sf /etc/init.d/apcups /etc/rc1.d/K20apcups
		ln -sf /etc/init.d/apcups /etc/rc2.d/S20apcups
		ln -sf /etc/init.d/apcups /etc/rc3.d/S20apcups
		ln -sf /etc/init.d/apcups /etc/rc4.d/S20apcups
		ln -sf /etc/init.d/apcups /etc/rc5.d/S20apcups
		ln -sf /etc/init.d/apcups /etc/rc6.d/K20apcups
		;;
	unknown)
		echo "YOU ARE ON YOUR OWN WITH THE REST OF THE SETUP"
		;;
	*)	echo -n "Usage:   ${0##*/} [ remove | slackware | redhat | suse | unifix | debian | unknown ]"
		echo " [ remove | libc5 | libc6 ]"
		exit 1
		;;
esac

if [ `ps x | gawk '{ if (($5 == "/sbin/apcupsd") || \
	($5 == "/usr/sbin/apcupsd") || \
	($5 == "apcupsd")) print $1 }'` ]; then
	printf "Stopping a running version of "\"apcupsd\"".\n"
	kill `ps x | gawk '{ if (($5 == "/sbin/apcupsd") || \
		($5 == "/usr/sbin/apcupsd") || \
		($5 == "apcupsd")) print $1 }'`
	if [ -f /var/run/apcupsd.pid ]; then
		rm -f /var/run/apcupsd.pid
	fi
fi

rm -f /sbin/backupsd /usr/sbin/backupsd /usr/local/sbin/backupsd
rm -f /sbin/apc_upsd /usr/sbin/apc_upsd /usr/local/sbin/apc_upsd
rm -f /usr/sbin/apcupsd /sbin/apcupsd /usr/local/sbin/apcupsd
rm -f /dev/apc_ups /dev/backups /dev/apc_upsd /dev/backupsd
rm -f /dev/apcups /dev/apcupsd
rm -f /etc/apcupsd.status /var/log/apcupsd.log
rm -f /etc/apcupsd /etc/apcflute /etc/rc.d/rc.power

case "$2" in
	libc5)
		printf "Installing "\"apcupsd-libc5\"" in "\"/sbin/apcupsd\""\n"
		install apcupsd-libc5 /sbin/apcupsd
		;;
	libc6)
		printf "Installing "\"apcupsd-libc6\"" in "\"/sbin/apcupsd\""\n"
		install apcupsd-libc6 /sbin/apcupsd
		;;
	*)
		echo "library case error ${2}"
		printf "Installing both versions OPPS there was an ERROR.\n"
		printf "Installing "\"apcupsd-libc5\"" in "\"/sbin/apcupsd-libc5\""\n"
		printf "Installing "\"apcupsd-libc6\"" in "\"/sbin/apcupsd-libc6\""\n"
		install apcupsd-libc5 /sbin/apcupsd-libc5
		install apcupsd-libc6 /sbin/apcupsd-libc6
		printf "You need to do some fixes or something, continuing.\n"
		sleep 5
		;;
esac

printf "Installing Manual "\"apcupsd.8\"" in "\"/usr/man/man8/apcupsd.8\""\n"
rm -f /usr/man/man8/apcupsd.8 /usr/man/man8/apcupsd.8.gz
cp docs/apcupsd.man8 docs/apcupsd.8
gzip -9 docs/apcupsd.8
mv docs/apcupsd.8.gz /usr/man/man8/apcupsd.8.gz

if [ ! -f /etc/apcupsd.conf ]; then
	printf "Installing "\"apcupsd.conf\"" in "\"/etc/apcupsd.conf\""\n"
	cp installs/apcupsd.conf /etc/apcupsd.conf
elif [ ! "`grep -i "#           backupspro | smartvsups | newbackupspro |" \
		/etc/apcupsd.conf`" = "#           backupspro | smartvsups | newbackupspro |" ]; then
	printf "Force UPDATE "\"apcupsd.conf\"" in "\"/etc/apcupsd.conf\""\n"
	cp /etc/apcupsd.conf /etc/apcupsd.conf.old
	rm -f /etc/apcupsd.conf
	cp installs/apcupsd.conf /etc/apcupsd.conf
	printf "Edit your new "\"/etc/apcupsd.conf\"" file for changes.""\n"
elif [ ! "`grep -i "#FLUTE" /etc/apcupsd.conf`" = \
		"#FLUTE <string> [ true | false ]" ]; then
	printf "Force UPDATE "\"apcupsd.conf\"" in "\"/etc/apcupsd.conf\""\n"
	cp /etc/apcupsd.conf /etc/apcupsd.conf.old
	rm -f /etc/apcupsd.conf
	cp installs/apcupsd.conf /etc/apcupsd.conf
	printf "Edit your new "\"/etc/apcupsd.conf\"" file for changes.""\n"
fi

if [ ! -f /sbin/powersc ]; then
	printf "Installing "\"powersc\"" in "\"/sbin/powersc\""\n"
	install installs/powersc /sbin/powersc
elif [ ! "`grep -i "ONBATTERY)" /sbin/powersc`" = "	ONBATTERY)" ]; then
	printf "Forced update of "\"powersc\"" in "\"/sbin/powersc\""\n"
	install installs/powersc /sbin/powersc
elif [ ! "`grep -i "REMOTE)" /sbin/powersc`" = "	REMOTE)" ]; then
	printf "Forced update of "\"powersc\"" in "\"/sbin/powersc\""\n"
	install installs/powersc /sbin/powersc
fi

chown root.root /etc/apcupsd.conf
chmod 640 /etc/apcupsd.conf
chown root.bin /sbin/apcupsd
chmod 110 /sbin/apcupsd
chown root.bin /sbin/powersc
chmod 550 /sbin/powersc
chown man.man /usr/man/man8/apcupsd.8.gz

printf "Done... I hope there were no problems...\n"
exit 0
