/*
 * Copyright (c) 1997, 1998  Motoyuki Kasahara
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef PERMISSION_H
#define PERMISSION_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


/*
 * Access permission list.
 */
typedef struct permission {
    int not;			/* inverse permission */
    char *hostname;		/* hostname pattern */
    int address;		/* address */
    int netmask;		/* netmask */
    struct permission *next;	/* pointer to next node */
} Permission;



/*
 * Function declarations.
 */
#ifdef __STDC__
void initialize_permission(Permission *);
void clear_permission(Permission *);
int add_permission(Permission *, const char *);
int test_permission(const Permission *, const char *, const char *,
    int (*func)(const char *, const char *));
int count_permission(const Permission *);

#else /* not __STDC__ */
void initialize_permission();
void clear_permission();
int add_permission();
int test_permission();
int count_permission();
#endif /* not __STDC__ */

#endif /* not PERMISSION_H */
