//
// STIL - Common defines
//

#ifndef _STILDEFS_H
#define _STILDEFS_H

// Define what slash is in pathname.
// Define whether to match dirnames/entries case insensitevely or not
// (Even LFNs in Win are case-insensitive!)
#define SLASH '/'
#define MYSTRCMP strcmp
#define MYSTRNCMP strncmp

// Common definition for boolean
// NOTE: Comment these out if 'bool' is a recognized type on your compiler!
// typedef int bool;
// #define false 0
// #define true 1

// These are the hardcoded STIL/BUG field names.
const char   _TITLE_STR[]="  TITLE: ";
const char  _ARTIST_STR[]=" ARTIST: ";
const char _COMMENT_STR[]="COMMENT: ";
const char     _BUG_STR[]="BUG: ";

// Maximum size of a single line in STIL - also accounts for some extra
// padding, just in case.
#define STIL_MAX_LINE_SIZE 91

// Maximum size of a single STIL entry (in bytes).
#define STIL_MAX_ENTRY_SIZE STIL_MAX_LINE_SIZE*50

// Maximum size of the full path to a SID.
#define STIL_MAX_PATH_SIZE 256

// Maximum number of STIL directories.
#define STIL_MAX_DIRS 300

// HVSC path to STIL.
const char PATH_TO_STIL[]="/DOCUMENTS/STIL.txt";

// HVSC path to BUGlist.
const char PATH_TO_BUGLIST[]="/DOCUMENTS/BUGlist.txt";

#endif // _STILDEFS_H
