#ifndef EmuDialog_h
#define EmuDialog_h

#include <sidplay/emucfg.h>

#include "EmuDialogData.h"
#include "GlobalIcon.h"

class EmuDialog : public EmuDialogData
{
    Q_OBJECT

public:

    EmuDialog(QWidget* parent = NULL, const char* name = NULL);
    
    void setConfig(const emuConfig&);
    const emuConfig& getConfig() const;

 public slots:

    void receiveConfig(const emuConfig&);

 protected:

    emuConfig config;
    
 protected slots:

    void newCLKsetting(int);
    void newMPUsetting(int);
    void newEMUsetting(int);

 signals:

    void changed(const emuConfig&);

 private:
    
    void setButtons();
    
    bool changedSignalEnabled;
    void enableChangedSignal(bool);
    void emitChangedIfEnabled();

};

#endif  // EmuDialog_h
