%define	name	xmms
%define	version	1.0.1
%define	release	1
%define	serial	1
%define	prefix	/usr

Summary:	XMMS - Multimedia player for the X Window System.
Name:		%{name}
Version:	%{version}
Release:	%{release}
Serial:		%{serial}
Copyright:	GPL
Group:		Applications/Multimedia
Vendor:		XMMS Development Team <bugs@xmms.org>
Url:		http://www.xmms.org/
Source:		%{name}-%{version}.tar.gz
BuildRoot:	/var/tmp/%{name}-%{version}-root
Obsoletes:	x11amp, x11amp0.7-1-1
Requires:	gtk+ >= 1.2.2

%description
X MultiMedia System is a sound player written from scratch. Since it 
uses the WinAmp GUI, it can use WinAmp skins. It can play mp3s, mods, s3ms,
and other formats. It now has support for input, output, general, and
visualization plugins.

%package	devel
Summary:	XMMS - Static libraries and header files.
Group:		Applications/Multimedia
Obsoletes:	x11amp-devel
Requires:	%{name} = %{version}

%description	devel
Static libraries and header files required for compiling xmms plugins.

%package	esd
Summary:	XMMS - Output plugin for use with the esound package.
Group:		Applications/Multimedia
Requires:	%{name} = %{version}
Obsoletes:	x11amp-esd
Requires:	esound >= 0.2.8

%description	esd
Output plugin for xmms for use with the esound package

%package	gnome
Summary:	XMMS - applet for controlling xmms from the GNOME panel.
Group:		Applications/Multimedia
Requires:	%{name} = %{version}
Obsoletes:	x11amp-gnome
Requires:	gnome-libs >= 1.0.0

%description	gnome
GNOME applet for controlling xmms from the GNOME panel

%package	mikmod
Summary:	XMMS - Input plugin to play MODs.
Group:		Applications/Multimedia
Obsoletes:	x11amp-mikmod
Requires:	%{name} = %{version}
Requires:	%(rpm -qf --qf '%{NAME}' /usr/lib/libmikmod.so.2) >= 3.1.6

%description	mikmod
Input plugin for XMMS to play MODs (.MOD,.XM,.S3M, etc)

%package 	mesa
Summary:	XMMS - Visualization plugins that use the Mesa3d library.
Group:		Applications/Multimedia
Requires:	%{name} = %{version}

%description	mesa
Visualization plugins that use the Mesa3d library.

%prep
%setup -q -n %{name}-%{version}

%build
CFLAGS="$RPM_OPT_FLAGS"; CPPFLAGS="$RPM_OPT_FLAGS"; CXXFLAGS="$RPM_OPT_FLAGS";
export CFLAGS CPPFLAGS CXXFLAGS;

if [ -f configure ]; then
	./configure --prefix=%{prefix};
else
	./autogen.sh --prefix=%{prefix};
fi

make

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -rf $RPM_BUILD_ROOT; fi
mkdir $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

# Strip binaries. But, not plugins.
strip --strip-unneeded $RPM_BUILD_ROOT%{prefix}/bin/*xmms;

# Install logo.
mkdir -p $RPM_BUILD_ROOT/usr/share/pixmaps
install -m 644 xmms/xmms_logo.xpm $RPM_BUILD_ROOT/usr/share/pixmaps/xmms_logo.xpm

# Install wmconfig file
mkdir -p $RPM_BUILD_ROOT/etc/X11/wmconfig
install -m 644 xmms/xmms.wmconfig $RPM_BUILD_ROOT/etc/X11/wmconfig/xmms

# Install applnk file
mkdir -p $RPM_BUILD_ROOT/etc/X11/applnk/Multimedia/                             
install -m 644 xmms/xmms.desktop  $RPM_BUILD_ROOT/etc/X11/applnk/Multimedia/ 

%post	-p /sbin/ldconfig
%postun -p /sbin/ldconfig

%clean
if [ -d $RPM_BUILD_ROOT ]; then rm -rf $RPM_BUILD_ROOT; fi

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README
/etc/X11/wmconfig/xmms
/etc/X11/applnk/Multimedia/xmms.desktop
%{prefix}/bin/xmms
%{prefix}/bin/wmxmms
%{prefix}/lib/libxmms.so.*
%{prefix}/lib/xmms/Input/libcdaudio*
%{prefix}/lib/xmms/Input/libmpg123*
%{prefix}/lib/xmms/Input/libwav*
%{prefix}/lib/xmms/Input/libidcin*
%{prefix}/lib/xmms/Output/libOSS*
%{prefix}/lib/xmms/Output/libdisk_writer*
%{prefix}/lib/xmms/General/*
%{prefix}/lib/xmms/Effect/*
%{prefix}/lib/xmms/Visualization/libbscope*
%{prefix}/lib/xmms/Visualization/libsanalyzer*
%{prefix}/share/xmms/*
/usr/share/pixmaps/xmms_logo.xpm

%files devel
%defattr(-, root, root)
%{prefix}/bin/xmms-config
%{prefix}/lib/lib*.so
%{prefix}/lib/lib*.a
%{prefix}/include/*
%{prefix}/share/aclocal/xmms.m4

%files esd
%defattr(-, root, root)
%{prefix}/lib/xmms/Output/libesdout*

%files gnome
%defattr(-, root, root)
%{prefix}/bin/gnomexmms
/etc/CORBA/servers/gnomexmms.gnorba
/usr/share/applets/Multimedia/gnomexmms.desktop

%files mikmod
%defattr(-, root, root)
%{prefix}/lib/xmms/Input/libmikmod*

%files mesa
%defattr(-, root, root)
%{prefix}/lib/xmms/Visualization/libogl_spectrum*

%changelog

