#include "snd.h"

enum {W_snd_pane,
      W_snd_name_form,W_snd_amp_form,
      W_snd_amp,W_snd_amp_label,W_snd_amp_number,W_snd_amp_separator,
      W_snd_srate,W_snd_srate_label,W_snd_srate_number,W_snd_srate_arrow,
      W_snd_expand,W_snd_expand_label,W_snd_expand_number,W_snd_expand_button,
      W_snd_contrast,W_snd_contrast_label,W_snd_contrast_number,W_snd_contrast_button,
      W_snd_revscl,W_snd_revscl_label,W_snd_revscl_number,
      W_snd_revlen,W_snd_revlen_label,W_snd_revlen_number,W_snd_reverb_button,
      W_snd_record,W_snd_replay,W_snd_apply,W_snd_set,W_snd_reset,
      W_snd_record_sep,
      W_snd_filter_label,W_snd_filter_order,W_snd_filter_env,W_snd_filter,W_snd_filter_button,W_snd_filter_dB,W_snd_filter_frame,
      W_snd_filter_order_down,W_snd_filter_order_up,
      W_snd_name,W_snd_name_icon,W_snd_info_label,W_snd_info,
      W_snd_info_sep,
      W_snd_play,W_snd_sync,W_snd_combine,
      W_snd_ctrls
};
/* order matters here -- W_snd_ctrls should be last */

#define NUM_SND_WIDGETS 50

Widget w_snd_ctrls(snd_info *sp) {if ((sp) && (sp->sgx)) return(((snd_context *)(sp->sgx))->snd_widgets[W_snd_ctrls]); else return(NULL);}
Widget w_snd_pane(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_pane]); else return(NULL);}
Widget w_snd_amp(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_amp]); else return(NULL);}
Widget w_snd_srate(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_srate]); else return(NULL);}
Widget w_snd_expand(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_expand]); else return(NULL);}
Widget w_snd_contrast(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_contrast]); else return(NULL);}
Widget w_snd_revscl(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_revscl]); else return(NULL);}
Widget w_snd_revlen(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_revlen]); else return(NULL);}
Widget w_snd_name(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_name]); else return(NULL);}
Widget w_snd_info_label(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_info_label]); else return(NULL);}
Widget w_snd_info(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_info]); else return(NULL);}
Widget w_snd_srate_arrow(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_srate_arrow]); else return(NULL);}
Widget w_snd_combine(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_combine]); else return(NULL);}
Widget w_snd_play(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_play]); else return(NULL);}

static Widget w_snd_record(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_record]); else return(NULL);}
static Widget w_snd_replay(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_replay]); else return(NULL);}
static Widget w_snd_amp_number(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_amp_number]); else return(NULL);}
static Widget w_snd_srate_number(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_srate_number]); else return(NULL);}
static Widget w_snd_expand_number(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_expand_number]); else return(NULL);}
static Widget w_snd_expand_button(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_expand_button]); else return(NULL);}
static Widget w_snd_contrast_number(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_contrast_number]); else return(NULL);}
static Widget w_snd_contrast_button(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_contrast_button]); else return(NULL);}
static Widget w_snd_revscl_number(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_revscl_number]); else return(NULL);}
static Widget w_snd_revlen_number(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_revlen_number]); else return(NULL);}
static Widget w_snd_reverb_button(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_reverb_button]); else return(NULL);}
static Widget w_snd_apply(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_apply]); else return(NULL);}
static Widget w_snd_filter_order(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_filter_order]); else return(NULL);}
static Widget w_snd_filter(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_filter]); else return(NULL);}
static Widget w_snd_filter_button(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_filter_button]); else return(NULL);}
static Widget w_snd_filter_dB(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_filter_dB]); else return(NULL);}
static Widget w_snd_name_icon(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_name_icon]); else return(NULL);}
static Widget w_snd_info_sep(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_info_sep]); else return(NULL);}
static Widget w_snd_sync(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_sync]); else return(NULL);}

#if 0
static Widget w_snd_name_form(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_name_form]); else return(NULL);}
static Widget w_snd_amp_form(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_amp_form]); else return(NULL);}
static Widget w_snd_amp_label(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_amp_label]); else return(NULL);}
static Widget w_snd_amp_separator(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_amp_separator]); else return(NULL);}
static Widget w_snd_srate_label(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_srate_label]); else return(NULL);}
static Widget w_snd_expand_label(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_expand_label]); else return(NULL);}
static Widget w_snd_contrast_label(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_contrast_label]); else return(NULL);}
static Widget w_snd_revscl_label(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_revscl_label]); else return(NULL);}
static Widget w_snd_revlen_label(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_revlen_label]); else return(NULL);}
static Widget w_snd_set(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_set]); else return(NULL);}
static Widget w_snd_reset(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_reset]); else return(NULL);}
static Widget w_snd_record_sep(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_record_sep]); else return(NULL);}
static Widget w_snd_filter_label(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_filter_label]); else return(NULL);}
static Widget w_snd_filter_env(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_filter_env]); else return(NULL);}
static Widget w_snd_filter_frame(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_filter_frame]); else return(NULL);}
static Widget w_snd_filter_order_down(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_filter_order_down]); else return(NULL);}
static Widget w_snd_filter_order_up(snd_info *sp) {if ((sp) && (sp->sgx)) return((sp->sgx)->snd_widgets[W_snd_filter_order_up]); else return(NULL);}
#endif

#define MAX_NOTEBOOK_TAB_LENGTH 5

#ifndef LESSTIF_VERSION
  #define No_Pixmap XmUNSPECIFIED_PIXMAP
#else
  #define No_Pixmap None
  /* in Lesstif, setting the label pixmap to XmUNSPECIFIED_PIXMAP changes the goddamn label type!  (Label.c line 849) */
#endif 

static void W_info_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
#if HAVE_XmHTML
  snd_help((snd_state *)clientData,"Minibuffer","#panelayout");
#else
  snd_help((snd_state *)clientData,"Minibuffer",get_info_help());
#endif
}

static void W_play_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
#if HAVE_XmHTML
  snd_help((snd_state *)clientData,"Play","#play");
#else
  snd_help((snd_state *)clientData,"Play",get_play_help());
#endif
}

static char info_sep_help[] =
"When reading a very large file, Snd tries to\n\
keep an overview at hand of the channels so\n\
that you can move around quickly in very large\n\
data sets; when first read in, these overviews\n\
are set underway, and when they are finally\n\
ready for use, the line after the file name\n\
appears.  If you try to zoom out to a large\n\
view before the separator line appears, the\n\
graphics update process may be slow.\n\
";

static void W_info_sep_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_help((snd_state *)clientData,"Name Separator",info_sep_help);
}

static char amp_help[] = 
"This scrollbar controls the amplitude\n\
at which the sound is played.  Click the\n\
amp label to return to 1.0. Control-Click\n\
returns to the previous value.\n\
";

static void W_amp_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_help((snd_state *)clientData,"Amp",amp_help);
}

static char srate_help[] =
"This scrollbar controls the sampling rate\n\
at which the sound is played.  The arrow\n\
controls the direction (forwards or backwards)\n\
of playback.  Label clicks behave as with amp.\n\
";

static void W_srate_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
#if HAVE_XmHTML
  snd_help((snd_state *)clientData,"Srate","#speed");
#else
  ssnd_help((snd_state *)clientData,"Srate",srate_help,"\n",get_speed_menu_help(),NULL);
#endif
}

static char srate_arrow_help[] = 
"This button determines which direction\n\
the sound file is played.  When pointing\n\
to the right, the sound is played forwards;\n\
to the left, backwards.\n\
";

static void W_srate_arrow_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_help((snd_state *)clientData,"Srate Arrow",srate_arrow_help);
}

static char expand_help[] =
"This scrollbar controls the tempo at which\n\
the sound is played back, using granular\n\
synthesis. The expand button must be down\n\
to get any expansion. Label clicks as in amp.\n\
";

static void W_expand_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
#if HAVE_XmHTML
  snd_help((snd_state *)clientData,STR_Expand,"#expand");
#else
  ssnd_help((snd_state *)clientData,STR_Expand,expand_help,"\n",get_expand_menu_help(),NULL);
#endif
}

static void W_expand_button_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_help((snd_state *)clientData,"Expand Button","This button turns on expansion\n");
}

static char contrast_help[] =
"This scrollbar controls the amount of\n\
'contrast enhancement' applied during\n\
playback.  The contrast button must be\n\
down to get any effect.  Label clicks as in amp.\n\
";

static void W_contrast_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
#if HAVE_XmHTML
  snd_help((snd_state *)clientData,STR_Contrast,"#contrast");
#else
  ssnd_help((snd_state *)clientData,STR_Contrast,contrast_help,"\n",get_contrast_menu_help(),NULL);
#endif
}

static void W_contrast_button_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_help((snd_state *)clientData,"Contrast Button","This button turns on contrast enhancement\n");
}

static char revscl_help[] =
"This scrollbar controls the amount of the\n\
sound that is fed into the reverberator.\n\
The reverb button must be down to get any\n\
reverb during playback.  Label clicks as in amp.\n\
";

static void W_revscl_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
#if HAVE_XmHTML
  snd_help((snd_state *)clientData,"Reverb amount","#reverb");
#else
  ssnd_help((snd_state *)clientData,"Reverb amount",revscl_help,"\n",get_reverb_menu_help(),NULL);
#endif
}

static char revlen_help[] =
"This scrollbar controls the lengths of\n\
the various delay lines in the reverb.\n\
It only takes effect when the reverb is\n\
created, that is, only when the play\n\
operation starts from silence.  Label clicks\n\
as in amp.\n\
";

static void W_revlen_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
#if HAVE_XmHTML
  snd_help((snd_state *)clientData,"Reverb length","#reverb");
#else
  ssnd_help((snd_state *)clientData,"Reverb length",revlen_help,"\n",get_reverb_menu_help(),NULL);
#endif
}

static void W_reverb_button_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,"Reverb Button","This button turns on reverberation\n");
}

static char filter_help[] =
"The Snd filter is an FIR filter of arbitrary\n\
order.  You specify the filter you want by\n\
defining the frequency response as an envelope\n\
in the 'env' window; set the desired order in\n\
the 'order' window; then turn it on by pushing\n\
the filter button at the right.  The filter\n\
design algorithm uses frequency sampling.\n\
The higher the order, the closer the filter\n\
can approximate the envelope you draw.\n\
You can also specify the filter coefficients\n\
in a file of floats, then load them into the\n\
Snd filter by typing the file name in the\n\
filter envelope text window.\n\
";

static void W_filter_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,"Filter",filter_help);
} 

static char filter_order_help[] =
"The filter order determines how closely\n\
the filter approximates the frequency response\n\
curve you drew in the 'env' window.\n\
";

static void W_filter_order_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,"Filter Order",filter_order_help);
}

static char filter_envelope_help[] =
"The filter envelope is a line-segment\n\
description of the frequency response\n\
you want.  It consists of a sequence of\n\
x,y pairs; normally the x axis goes\n\
from 0 to .5 or 0 to 1.0.  For example,\n\
a low-pass filter envelope could be:\n\
0.0 1.0 .25 1.0 .5 0.0 1.0 0.0\n\
";

static void W_filter_envelope_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,"Filter Envelope",filter_envelope_help);
}

static void W_filter_button_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,"Filter Button","This button turns on the filter\n");
}

static void W_filter_dB_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,"Filter dB",
"This button chooses between dB and linear y axis\n\
in the frequency response graph\n");
}

static void W_sync_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_help((snd_state *)clientData,
	   "Sync Button",
"This button causes edit operations on one\n\
channel to be applied to all channels at the\n\
same time.\n\
");
}

static void W_combine_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_help((snd_state *)clientData,
	   "Combine Button",
"This button causes all channels to be\n\
displayed in one window, sharing the various\n\
channel controls.  Two extra scrollbars on\n\
the right provide scroll and zoom for the\n\
overall set of channel graphs. The default\n\
multichannel display style can be set in\n\
the Snd initialization file by setting\n\
the variable combine-channels.\n\
");
}

static void W_record_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,
	   STR_Record,
"The Record button causes Snd to rememeber\n\
any settings or changes to the settings within\n\
the control panel while the sound is playing.\n\
You can subsequently replay that 'take' by pressing\n\
the Replay button, and save it as an edit to\n\
the file with the Apply button.\n\
");
}

static void W_replay_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,
	   STR_Replay,
"The Replay button replays the last\n\
recorded run (see Record) of the current\n\
sound.\n\
");
}

static void W_apply_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,
	   STR_Apply,
"The Apply button saves the last recorded\n\
run over the current file (see Record) as\n\
an edit of the current file.\n\
");
}

static void W_set_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_help((snd_state *)clientData,
	   STR_Save,
"The 'Save' button saves the current control\n\
panel state for a subsequent 'Restore'.\n\
");
}

static void W_reset_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,
	   "Restore",
"The 'Restore' button returns the control\n\
panel to the state at the time of the\n\
last 'Save', or the initial state if there\n\
has been no 'Save'.\n\
");
}

static void W_name_Help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  ssnd_help((snd_state *)clientData,
	   "Minibuffer",
"This portion of the snd display has several\n\
parts: the sound file name, with an asterisk if\n\
the file has unsaved edits; a minibuffer for\n\
various expression evaluations; a sync button\n\
that causes operations on one channel to be\n\
applied to all channels; and a play button\n\
that causes the sound to be played.  The\n\
lower portion of the pane, normally hidden,\n\
contains a variety of sound manipulation\n\
controls that can be applied while it is\n\
playing:\n\
\n\
    file name, followed by a separator\n\
\n",
info_sep_help,
"\n\n\
    minibuffer, sync, and play buttons\n\
    amplitude scrollbar\n\
\n",
amp_help,
"\n\n\
    srate scrollbar\n\
\n",
srate_help,
"\n\
    srate arrow button\n\
\n",
srate_arrow_help,
"\n\n\
    expand scrollbar and button\n\
\n",
expand_help,
"\n\n\
    contrast scrollbar and button\n\
\n",
contrast_help,
"\n\n\
    reverb amount scrollbar\n\
\n",
revscl_help,
"\n\
    reverb length scrollbar\n\
\n",
revlen_help,
"\n\n\
    filter section\n\
\n",
filter_help,
"\n\
    filter order text window\n\
\n",
filter_order_help,
"\n\
    filter envelope window\n\
\n",
filter_envelope_help,
NULL);
}

#define SND_TXT_BUF_SIZE 256
static char snd_txt_buf[SND_TXT_BUF_SIZE];

int sound_unlock_ctrls(snd_info *sp, void *ptr)
{
  XtManageChild(w_snd_ctrls(sp));
  XtVaSetValues(w_snd_ctrls(sp),XmNpaneMinimum,1,NULL);
  return(0);
}

int sound_lock_ctrls(snd_info *sp, void *ptr)
{
  snd_state *ss;
  ss = (snd_state *)(sp->state);
  XtUnmanageChild(w_snd_ctrls(sp));
  XtVaSetValues(w_snd_ctrls(sp),XmNpaneMinimum,ss->ctrls_height,NULL);
  return(0);
}

static char *link_file = NULL;
static char *linked_file(char *link_name)
{
  int bytes;
#ifndef _MSC_VER
  if (link_file == NULL) link_file = (char *)CALLOC(128,sizeof(char));
  bytes = readlink(link_name,link_file,128);
  if (bytes > 0)
    {
      link_file[bytes] = 0;
      return(link_file);
    }
  else 
#endif
    return("?");
}

static char *short_sound_format (int format, int type)
{
  switch (format)
    {
    case SNDLIB_16_LINEAR: if (type == RIFF_sound_file) return("short swapped"); else return("short"); break;
    case SNDLIB_16_LINEAR_LITTLE_ENDIAN: if (type == AIFF_sound_file) return("short swapped"); else return("short"); break;
    case SNDLIB_16_UNSIGNED: case SNDLIB_16_UNSIGNED_LITTLE_ENDIAN: return("unsigned short"); break;
    case SNDLIB_8_MULAW: return("mulaw"); break;
    case SNDLIB_8_LINEAR: return("byte"); break;
    case SNDLIB_8_ALAW: return("alaw"); break;
    case SNDLIB_32_FLOAT: if (type == RIFF_sound_file) return("float swapped"); else return("float"); break;
    case SNDLIB_32_FLOAT_LITTLE_ENDIAN: if (type == AIFF_sound_file) return("float swapped"); else return("float"); break;
    case SNDLIB_32_VAX_FLOAT: return("vax float"); break;
    case SNDLIB_32_LINEAR: if (type == RIFF_sound_file) return("int swapped"); else return("int"); break;
    case SNDLIB_32_LINEAR_LITTLE_ENDIAN: if (type == AIFF_sound_file) return("int swapped"); else return("int"); break;
    case SNDLIB_8_UNSIGNED: return("unsigned byte"); break;
    case SNDLIB_24_LINEAR: if (type == RIFF_sound_file) return("24-bit swapped"); else return("24-bit"); break;
    case SNDLIB_24_LINEAR_LITTLE_ENDIAN: if (type == AIFF_sound_file) return("24-bit swapped"); else return("24-bit"); break;
    case SNDLIB_64_DOUBLE: case SNDLIB_64_DOUBLE_LITTLE_ENDIAN: return("double"); break;
    case SNDLIB_12_LINEAR: case SNDLIB_12_LINEAR_LITTLE_ENDIAN: case SNDLIB_12_UNSIGNED: case SNDLIB_12_UNSIGNED_LITTLE_ENDIAN: return("12-bit"); break;
    default: return(STR_unknown); break;
    }
}

static char timebuf[64];

static void W_name_Click_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  char *str;
  file_info *hdr;
  float dur;
  int linked = 0;
  snd_info *sp = (snd_info *)clientData;
  if (sp)
    {
      hdr = sp->hdr;
      if (hdr)
	{
	  linked = is_link(sp->fullname);
	  dur = (float)(hdr->samples)/(float)(hdr->chans * hdr->srate);
	  str = (char *)CALLOC(256,sizeof(char));
#if (!defined(HAVE_CONFIG_H)) || defined(HAVE_STRFTIME)
	  strftime(timebuf,64,STRFTIME_FORMAT,localtime(&(sp->write_date)));
#else
	  sprintf(timebuf,"");
#endif
	  sprintf(str,"%d, %d chan%s, %.3f sec%s, %s:%s, %s%s%s%s",
		  hdr->srate,
		  hdr->chans,
		  ((hdr->chans > 1) ? "s" : ""),
		  dur,
		  ((dur == 1.0) ? "" : "s"),
		  sound_type_name(hdr->type),
		  short_sound_format(hdr->format,hdr->type),
		  timebuf,
		  (linked) ? ", (link to " : "",
		  (linked) ? linked_file(sp->fullname) : "",
		  (linked) ? ")" : "");
	  report_in_minibuffer(sp,str);
	  FREE(str);
	}
    }
}

static char number_one[5]={'1',STR_decimal,'0','0','\0'};
static char number_zero[5]={'0',STR_decimal,'0','0','\0'};
static char semitone_one[5]={' ',' ',' ','0','\0'};
static char ratio_one[5]={' ','1','/','1','\0'};

static char amp_number_buffer[5]={'1',STR_decimal,'0','0','\0'};

int snd_amp_to_int(float amp)
{
  int val;
  if (amp <= 0.0)
    val = 0;
  else
    {
      val = round(amp / (float)(SCROLLBAR_LINEAR_MULT));
      if (val > SCROLLBAR_LINEAR_MAX)
	{
	  val = round((log(amp)*((float)SCROLLBAR_MAX*.2)) + SCROLLBAR_MID);
	}
    }
  return(val);
}

void snd_amp_changed(snd_info *sp, int val)
{
  char *sfs;
  if (val == 0) 
    sp->amp = 0.0;
  else 
    {
      if (val < SCROLLBAR_LINEAR_MAX)
	sp->amp = (float)val * SCROLLBAR_LINEAR_MULT;
      else sp->amp = exp((float)(val-SCROLLBAR_MID)/((float)SCROLLBAR_MAX*.2));
    }
  sfs=prettyf(sp->amp,2);
  fill_number(sfs,amp_number_buffer);
  make_name_label(w_snd_amp_number(sp),amp_number_buffer);
  if (sp->recording) record_amp_change(sp,val,sp->amp);
  FREE(sfs);
}

static void W_amp_Click_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmPushButtonCallbackStruct *cb = (XmPushButtonCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  XButtonEvent *ev;
  int val;
  snd_context *sx;
  sx = sp->sgx;
  ev = (XButtonEvent *)(cb->event);
  if (ev->state & (snd_ControlMask | snd_MetaMask)) val = sp->last_amp; else val = 50;
  snd_amp_changed(sp,val);
  XtVaSetValues(sx->snd_widgets[W_snd_amp],XmNvalue,val,NULL);
}

static void W_amp_Drag_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_amp_changed((snd_info *)clientData,((XmScrollBarCallbackStruct *)callData)->value);
}

static void W_amp_ValueChanged_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmScrollBarCallbackStruct *cb = (XmScrollBarCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  sp->last_amp = cb->value;
  snd_amp_changed(sp,cb->value);
}



static char srate_number_buffer[5]={'1',STR_decimal,'0','0','\0'};

int snd_srate_to_int(float val)
{
  if (val > 0.0)
    return(round(450.0 + 150.0 * log(val)));
  else return(0);
}

void snd_srate_changed(snd_info *sp, int ival)
{
  snd_state *ss;
  ss = sp->state;
  sp->srate = srate_changed(ival,srate_number_buffer,speed_style(ss),speed_tones(ss));
  make_name_label(w_snd_srate_number(sp),srate_number_buffer);
  if (sp->recording) record_speed_change(sp,ival,sp->srate);
}

static void W_srate_Click_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmPushButtonCallbackStruct *cb = (XmPushButtonCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  XButtonEvent *ev;
  int val;
  snd_context *sx;
  sx = sp->sgx;
  ev = (XButtonEvent *)(cb->event);
  if (ev->state & (snd_ControlMask | snd_MetaMask)) val = sp->last_srate; else val = 450;
  snd_srate_changed(sp,val);
  XtVaSetValues(sx->snd_widgets[W_snd_srate],XmNvalue,val,NULL);
}

static void W_srate_Drag_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_srate_changed((snd_info *)clientData,((XmScrollBarCallbackStruct *)callData)->value);
}

static void W_srate_ValueChanged_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmScrollBarCallbackStruct *cb = (XmScrollBarCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  sp->last_srate = cb->value;
  snd_srate_changed(sp,cb->value);
}

void toggle_direction_arrow(snd_info *sp, int state)
{
  XmToggleButtonSetState(w_snd_srate_arrow(sp),state,TRUE);
}



static char expand_number_buffer[5]={'1',STR_decimal,'0','0','\0'};

int snd_expand_to_int(float ep)
{
  int val;
  val = (int)(ep/.0009697);
  if (val>100) val = (int)(round(450+150*log(ep)));
  return(val);
}

void snd_expand_changed(snd_info *sp, int val)
{
  char *sfs;
  if (val < 100)
    sp->expand = (float)val * .0009697;
  else sp->expand = exp((float)(val-450)/150.0);
  sfs=prettyf(sp->expand,2);
  fill_number(sfs,expand_number_buffer);
  make_name_label(w_snd_expand_number(sp),expand_number_buffer);
  if ((sp->recording) && (sp->expanding)) record_expand_change(sp,val,sp->expand);
  FREE(sfs);
}

static void W_expand_Click_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmPushButtonCallbackStruct *cb = (XmPushButtonCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  XButtonEvent *ev;
  int val;
  snd_context *sx;
  sx = sp->sgx;
  ev = (XButtonEvent *)(cb->event);
  if (ev->state & (snd_ControlMask | snd_MetaMask)) val = sp->last_expand; else val = 450;
  snd_expand_changed(sp,val);
  XtVaSetValues(sx->snd_widgets[W_snd_expand],XmNvalue,val,NULL);
}

static void W_expand_Drag_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_expand_changed((snd_info *)clientData,((XmScrollBarCallbackStruct *)callData)->value);
}

static void W_expand_ValueChanged_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmScrollBarCallbackStruct *cb = (XmScrollBarCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  sp->last_expand = cb->value;
  snd_expand_changed(sp,cb->value);
}

static void Expand_button_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_state *ss;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData; 
  snd_info *sp = (snd_info *)clientData;
  ss = sp->state;
  sp->expanding = cb->set;
  if (!(ss->using_schemes)) 
    XmChangeColor(w_snd_expand(sp),(Pixel)((sp->expanding) ? ((ss->sgx)->position_color) : ((ss->sgx)->basic_color)));
}

void toggle_expand_button(snd_info *sp, int state)
{
  XmToggleButtonSetState(w_snd_expand_button(sp),state,TRUE);
}



static char contrast_number_buffer[5]={'0',STR_decimal,'0','0','\0'};

int snd_contrast_to_int(float val)
{
  return(round(val*10));
}

void snd_contrast_changed(snd_info *sp, int val)
{
  char *sfs;
  sp->contrast = (float)val/10.0;
  sfs=prettyf(sp->contrast,2);
  fill_number(sfs,contrast_number_buffer);
  make_name_label(w_snd_contrast_number(sp),contrast_number_buffer);
  if ((sp->recording) && (sp->contrasting)) record_contrast_change(sp,val,sp->contrast);
  FREE(sfs);
}

static void W_contrast_Click_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmPushButtonCallbackStruct *cb = (XmPushButtonCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  XButtonEvent *ev;
  int val;
  snd_context *sx;
  sx = sp->sgx;
  ev = (XButtonEvent *)(cb->event);
  if (ev->state & (snd_ControlMask | snd_MetaMask)) val = sp->last_contrast; else val = 0;
  snd_contrast_changed(sp,val);
  XtVaSetValues(sx->snd_widgets[W_snd_contrast],XmNvalue,val,NULL);
}

static void W_contrast_Drag_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_contrast_changed((snd_info *)clientData,((XmScrollBarCallbackStruct *)callData)->value);
}

static void W_contrast_ValueChanged_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmScrollBarCallbackStruct *cb = (XmScrollBarCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  sp->last_contrast = cb->value;
  snd_contrast_changed(sp,cb->value);
}

static void Contrast_button_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_state *ss;
  snd_info *sp = (snd_info *)clientData;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData;
  ss = sp->state;
  sp->contrasting = cb->set;
  if (!(ss->using_schemes)) 
    XmChangeColor(w_snd_contrast(sp),(Pixel)((sp->contrasting) ? ((ss->sgx)->position_color) : ((ss->sgx)->basic_color)));
}

void toggle_contrast_button(snd_info *sp, int state)
{
  XmToggleButtonSetState(w_snd_contrast_button(sp),state,TRUE);
}



static char revscl_number_buffer[7]={'0',STR_decimal,'0','0','0','0','\0'};
static char number_long_zero[7]={'0',STR_decimal,'0','0','0','0','\0'};

int snd_revscl_to_int(float val)
{
  return(round(pow(val,0.333)*60.0));
}

void snd_revscl_changed(snd_info *sp, int val)
{
  char *fs,*ps,*sfs;
  int i,j;
  sp->revscl = cube((float)val/60.0);
  sfs=prettyf(sp->revscl,3);
  fs=sfs;
  ps=(char *)(revscl_number_buffer);
  j=strlen(fs);
  if (j>6) j=6;
  if (j<6) 
    {
      revscl_number_buffer[5]='0';
      revscl_number_buffer[4]='0'; 
      revscl_number_buffer[3]='0';
      revscl_number_buffer[2]='0'; 
      revscl_number_buffer[1]=STR_decimal;
    }
  for (i=0;i<j;i++) (*ps++) = (*fs++);
  make_name_label(w_snd_revscl_number(sp),revscl_number_buffer);
  if ((sp->recording) && (sp->reverbing)) record_reverb_change(sp,val,sp->revscl);
  FREE(sfs);
}

static void W_revscl_Click_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmPushButtonCallbackStruct *cb = (XmPushButtonCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  XButtonEvent *ev;
  int val;
  snd_context *sx;
  sx = sp->sgx;
  ev = (XButtonEvent *)(cb->event);
  if (ev->state & (snd_ControlMask | snd_MetaMask)) val = sp->last_revscl; else val = 0;
  snd_revscl_changed(sp,val);
  XtVaSetValues(sx->snd_widgets[W_snd_revscl],XmNvalue,val,NULL);
}


static void W_revscl_Drag_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_revscl_changed((snd_info *)clientData,((XmScrollBarCallbackStruct *)callData)->value);
}

static void W_revscl_ValueChanged_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmScrollBarCallbackStruct *cb = (XmScrollBarCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  sp->last_revscl = cb->value;
  snd_revscl_changed(sp,cb->value);
}



static char revlen_number_buffer[5]={'1',STR_decimal,'0','0','\0'};

int snd_revlen_to_int(float val)
{
  return(round(val*20.0));
}

void snd_revlen_changed(snd_info *sp, int val)
{
  char *sfs;
  sp->revlen = (float)val/20.0;
  sfs=prettyf(sp->revlen,2);
  fill_number(sfs,revlen_number_buffer);
  make_name_label(w_snd_revlen_number(sp),revlen_number_buffer);
  FREE(sfs);
}

static void W_revlen_Click_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmPushButtonCallbackStruct *cb = (XmPushButtonCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  XButtonEvent *ev;
  int val;
  snd_context *sx;
  sx = sp->sgx;
  ev = (XButtonEvent *)(cb->event);
  if (ev->state & (snd_ControlMask | snd_MetaMask)) val = sp->last_revlen; else val = 20;
  snd_revlen_changed(sp,val);
  XtVaSetValues(sx->snd_widgets[W_snd_revlen],XmNvalue,val,NULL);
}

static void W_revlen_Drag_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_revlen_changed((snd_info *)clientData,((XmScrollBarCallbackStruct *)callData)->value);
}

static void W_revlen_ValueChanged_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  XmScrollBarCallbackStruct *cb = (XmScrollBarCallbackStruct *)callData;
  snd_info *sp = (snd_info *)clientData;
  sp->last_revlen = cb->value;
  snd_revlen_changed(sp,cb->value);
}



static void Reverb_button_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_state *ss;
  snd_info *sp = (snd_info *)clientData;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData;
  ss = sp->state;
  sp->reverbing = cb->set;
  if (!(ss->using_schemes))
    {
      XmChangeColor(w_snd_revlen(sp),(Pixel)((sp->reverbing) ? ((ss->sgx)->position_color) : ((ss->sgx)->basic_color)));
      XmChangeColor(w_snd_revscl(sp),(Pixel)((sp->reverbing) ? ((ss->sgx)->position_color) : ((ss->sgx)->basic_color)));
    }
}

void toggle_reverb_button(snd_info *sp, int state)
{
  XmToggleButtonSetState(w_snd_reverb_button(sp),state,TRUE);
}

static void Filter_button_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_info *sp = (snd_info *)clientData;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData;
  sp->filtering = cb->set;
}

void toggle_filter_button(snd_info *sp, int state)
{
  XmToggleButtonSetState(w_snd_filter_button(sp),state,TRUE);
}

static void filter_textfield_deactivate(snd_info *sp)
{
  chan_info *active_chan;
  Widget graph;
  active_chan = current_channel(sp);
  if (active_chan)
    {
      graph = channel_graph(active_chan);
      if ((XmIsTraversable(graph)) && (XmGetVisibility(graph) != XmVISIBILITY_FULLY_OBSCURED))
	XmProcessTraversal(graph,XmTRAVERSE_CURRENT);
    }
}


/* -------------------------------- FILTER GRAPH -------------------------------- */

typedef struct {
  int *current_xs;
  int *current_ys;
  int current_size;
  chan_info *axis_cp;
  axis_info *gray_ap;
  Time down_time;
  int env_dragged;
  int env_pos;
  int click_to_delete;
  Widget drawer;
  int edited;
} spflt;

static spflt *new_flt(Widget drawer)
{
  spflt *spf;
  spf = (spflt *)CALLOC(1,sizeof(spflt));
  spf->current_xs = (int *)CALLOC(8,sizeof(int));
  spf->current_ys = (int *)CALLOC(8,sizeof(int));
  spf->current_size = 8;
  spf->env_dragged = 0;
  spf->env_pos = 0;
  spf->click_to_delete = 0;
  spf->drawer = drawer;
  spf->edited = 0;
  return(spf);
}

void snd_filter_cleanup(snd_info *sp)
{
  spflt *spf;
  if (sp)
    {
      if (sp->sgx)
	{
	  spf = (spflt *)((sp->sgx)->flt);
	  if (spf)
	    {
	      spf->edited = 0;
	      spf->env_dragged = 0;
	      spf->env_pos = 0;
	      spf->click_to_delete = 0;
	    }
	  XmTextSetString(w_snd_filter(sp),"");
	}
    }
}

static void sp_set_current_point(spflt *spf, int pos, int x, int y)
{
  if (pos == spf->current_size)
    {
      spf->current_size += 8;
      spf->current_xs = (int *)REALLOC(spf->current_xs,spf->current_size * sizeof(int));
      spf->current_ys = (int *)REALLOC(spf->current_ys,spf->current_size * sizeof(int));
    }
  spf->current_xs[pos] = x;
  spf->current_ys[pos] = y;
}

static void sp_make_axis_cp(snd_info *sp, char *name, GC cur_gc, int ex0, int ey0, int width, int height, float xmin, float xmax, float ymin, float ymax)
{
  /* conjure up minimal context for axis drawer in snd-axis.c */
  spflt *spf;
  snd_state *ss;
  ss = sp->state;
  spf = (spflt *)((sp->sgx)->flt);
  if (!(spf->axis_cp)) spf->axis_cp = new_env_axis(ss,spf->drawer);
  if (!(spf->gray_ap)) spf->gray_ap = new_wave_axis(ss,spf->drawer,(spf->axis_cp)->axis,(ss->sgx)->fltenv_data_gc);
  init_env_axes(spf->axis_cp,name,cur_gc,ex0,ey0,width,height,xmin,xmax,ymin,ymax);
}

#define EXP_SEGLEN 4

static short sp_grf_y_dB(snd_info *sp, float val, axis_info *ap)
{
  if (sp->filter_dBing)
    return(grf_y(dB(sp->state,val),ap));
  else return(grf_y(val,ap));
}

static double sp_ungrf_y_dB(snd_info *sp, axis_info *ap, int y)
{
  if (sp->filter_dBing)
    return(un_dB(sp->state,ungrf_y(ap,y)));
  else return(ungrf_y(ap,y));
}

#define MIN_FILTER_GRAPH_HEIGHT 20

static void sp_display_env(snd_info *sp, spflt *spf)
{
  snd_state *ss;
  int i,j,k;
  float ex0,ey0,ex1,ey1,val;
  int ix0,ix1,iy0,iy1,size,half,lx0,lx1,ly0,ly1;
  Display *dp;
  Drawable wn;
  float curx,xincr;
  int dur;
  int height,width;
  axis_info *ap;
  env *e;
  GC cur_gc;
  Widget drawer;
  ss = sp->state;
  drawer = spf->drawer;
  height = get_window_height(drawer);
  if (height < MIN_FILTER_GRAPH_HEIGHT) return;
  width = get_window_width(drawer);
  e = sp->filter_env;
  cur_gc = (ss->sgx)->fltenv_basic_gc;
  dp = XtDisplay(drawer);
  wn = XtWindow(drawer);
  XClearWindow(dp,wn);
  ex0 = e->data[0];
  ey0 = e->data[1];
  ex1 = e->data[(e->pts*2) - 2];
  ey1 = ey0;
  for (i=3;i<e->pts*2;i+=2)
    {
      val = e->data[i];
      if (ey0 > val) ey0 = val;
      if (ey1 < val) ey1 = val;
    }
  if (ey0 > 0.0) ey0 = 0.0;
  if ((ey0 == ey1) && (ey1 == 0.0)) ey1 = 1.0; /* fixup degenerate case */
  if (ey1 < 1.0) ey1 = 1.0;
  if (sp->filter_dBing) {ey0 = ss->min_dB; ey1 = 0.0;}
  sp_make_axis_cp(sp, "frequency response", cur_gc, 0,0, width, height, ex0, ex1, ey0, ey1); 
  ap = (spf->axis_cp)->axis;
  ix1 = grf_x(e->data[0],ap);
  iy1 = sp_grf_y_dB(sp,e->data[1],ap);
  if (e->pts < 100)
    size = ss->enved_point_size;
  else size = (int)(ss->enved_point_size * 0.4);
  half = (int)(size * 0.5);
  sp_set_current_point(spf,0,ix1,iy1);
  XFillArc(dp,wn,cur_gc,ix1-half,iy1-half,size,size,0,360*64);
  if (sp->filter_dBing)
    {
      for (j=1,i=2;i<e->pts*2;i+=2,j++)
	{
	  ix0 = ix1;
	  iy0 = iy1;
	  ix1 = grf_x(e->data[i],ap);
	  iy1 = sp_grf_y_dB(sp,e->data[i+1],ap);
	  sp_set_current_point(spf,j,ix1,iy1);
	  XFillArc(dp,wn,cur_gc,ix1-half,iy1-half,size,size,0,360*64);
	  /* now try to fill in from the last point to this one */
	  if ((ix1-ix0) < (2*EXP_SEGLEN))
	    {
	      /* points are too close to be worth interpolating */
	      XDrawLine(dp,wn,cur_gc,ix0,iy0,ix1,iy1);
	    }
	  else
	    {
	      /* interpolate so the display looks closer to dB (we should use the env base...) */
	      dur = (ix1-ix0) / EXP_SEGLEN;
	      xincr = (e->data[i] - e->data[i-2]) / (float)dur;
	      curx = e->data[i-2] + xincr;
	      lx1 = ix0;
	      ly1 = iy0;
	      for (k=1;k<dur;k++,curx+=xincr)
		{
		  lx0 = lx1;
		  ly0 = ly1;
		  lx1 = grf_x(curx,ap);
		  val = list_interp(curx,e->data,e->pts);
		  ly1 = grf_y(dB(ss,val),ap);
		  XDrawLine(dp,wn,cur_gc,lx0,ly0,lx1,ly1);
		}
	      XDrawLine(dp,wn,cur_gc,lx1,ly1,ix1,iy1);
	    }
	}
    }
  else
    {
      for (j=1,i=2;i<e->pts*2;i+=2,j++)
	{
	  ix0 = ix1;
	  iy0 = iy1;
	  ix1 = grf_x(e->data[i],ap);
	  iy1 = grf_y(e->data[i+1],ap);
	  sp_set_current_point(spf,j,ix1,iy1);
	  XFillArc(dp,wn,cur_gc,ix1-half,iy1-half,size,size,0,360*64);
	  XDrawLine(dp,wn,cur_gc,ix0,iy0,ix1,iy1);
	}
    }
  if (spf->edited)
    {
      display_frequency_response(ss,e,ap,(spf->gray_ap)->ax,sp->filter_order,sp->filter_dBing);
    }
}

static void filter_drawer_help_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_help((snd_state *)clientData,"Filter Frequency Response",
"This graph shows the current filter frequency response envelope,\n\
and the actual response (dependent on the filter order).\n\
See the envelope editor documentation for editing directions.\n");
}

static void filter_drawer_button_motion(Widget w,XtPointer clientData,XEvent *event,Boolean *cont) 
{
  snd_info *sp = (snd_info *)clientData;
  spflt *spf;
  XMotionEvent *ev = (XMotionEvent *)event;
  Time motion_time;
  axis_info *ap;
  float x0,x1,x,y;
  snd_state *ss;
  env *e;
  ss = sp->state;
  spf = (spflt *)((sp->sgx)->flt);
  e = sp->filter_env;
  motion_time = ev->time;
  if ((motion_time - spf->down_time) < (0.5 * XtGetMultiClickTime(XtDisplay(w)))) return;
  spf->env_dragged = 1;
  spf->click_to_delete = 0;
  ap = (spf->axis_cp)->axis;
  x = ungrf_x(ap,ev->x);
  if (spf->env_pos > 0) x0 = e->data[spf->env_pos*2-2]; else x0 = 0.0;
  if (spf->env_pos < e->pts) x1 = e->data[spf->env_pos*2+2]; else x1 = 1.0;
  if (x<x0) x=x0;
  if (x>x1) x=x1;
  if (spf->env_pos == 0) x = e->data[0];
  if (spf->env_pos == (e->pts-1)) x = e->data[(e->pts-1)*2];
  y = ungrf_y(ap,ev->y);
  if (y<ap->y0) y=ap->y0;
  if (y>ap->y1) y=ap->y1;
  if (sp->filter_dBing) y=un_dB(ss,y);
  move_point(e,spf->env_pos,x,y);
  spf->edited = 1;
  sp_display_env(sp,spf);
  sp->filter_changed = 1;
}

static void filter_drawer_button_press(Widget w,XtPointer clientData,XEvent *event,Boolean *cont) 
{
  snd_info *sp = (snd_info *)clientData;
  XButtonEvent *ev = (XButtonEvent *)event;
  int pos;
  float x,y;
  spflt *spf;
  axis_info *ap;
  env *e;
  spf = (spflt *)((sp->sgx)->flt);
  e = sp->filter_env;
  ap = (spf->axis_cp)->axis;
  spf->down_time = ev->time;
  spf->env_dragged = 0;
  pos = hit_point(sp->state,spf->current_xs,spf->current_ys,e->pts,ev->x,ev->y);
  x = ungrf_x(ap,ev->x);
  y = sp_ungrf_y_dB(sp,ap,ev->y);
  if (pos == -1)
    {
      if (x < 0.0)
	{
	  pos = 0;
	  x = 0.0;
	}
      else 
	if (x > 1.0) 
	  {
	    pos = e->pts-1;
	    x = 1.0;
	  }
    }
  spf->env_pos = pos;
  /* if not -1, then user clicked existing point -- wait for drag/release to decide what to do */
  if (pos == -1) 
    {
      pos = place_point(spf->current_xs,e->pts,ev->x);
      add_point(e,pos+1,x,y);
      spf->env_pos = pos+1;
      spf->click_to_delete = 0;
      sp_display_env(sp,spf);
    }
  else spf->click_to_delete = 1;
  spf->edited = 1;
}

static void filter_drawer_button_release(Widget w,XtPointer clientData,XEvent *event,Boolean *cont) 
{
  snd_info *sp = (snd_info *)clientData;
  env *e;
  char *tmpstr=NULL;
  spflt *spf;
  spf = (spflt *)((sp->sgx)->flt);
  e = sp->filter_env;
  if ((spf->click_to_delete) && (!(spf->env_dragged)) && 
      ((spf->env_pos > 0) && (spf->env_pos < ((sp->filter_env)->pts - 1))))
    delete_point(e,spf->env_pos);
  spf->env_pos = 0;
  spf->env_dragged = 0;
  spf->click_to_delete = 0;
  sp_display_env(sp,spf);
  XmTextSetString(w_snd_filter(sp),tmpstr=env_to_string(e));
  if (tmpstr) FREE(tmpstr);
  sp->filter_changed = 1;
}

static void filter_drawer_resize(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_info *sp = (snd_info *)clientData;
  sp_display_env(sp,(spflt *)((sp->sgx)->flt));
}

static void filter_dB_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_info *sp = (snd_info *)clientData;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData;
  sp->filter_dBing = (cb->set);
  sp_display_env(sp,(spflt *)((sp->sgx)->flt));
}

void set_filter_dBing(snd_info *sp, int val)
{
  sp->filter_dBing = val;
  XmToggleButtonSetState(w_snd_filter_dB(sp),val,FALSE);
  sp_display_env(sp,(spflt *)((sp->sgx)->flt));
}

void filter_order_changed(snd_info *sp, int order)
{
  char *fltorder;
  if (order&1) order++;
  fltorder = (char *)CALLOC(4,sizeof(char));
  sprintf(fltorder,"%d",order);
  XmTextSetString(w_snd_filter_order(sp),fltorder);
  sp->filter_order = order;
  FREE(fltorder);
  sp_display_env(sp,(spflt *)((sp->sgx)->flt));
  sp->filter_changed = 1;
}

static void filter_order_up_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_info *sp = (snd_info *)clientData;
  filter_order_changed(sp,sp->filter_order + 2);
}

static void filter_order_down_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_info *sp = (snd_info *)clientData;
  if (sp->filter_order > 2)
    filter_order_changed(sp,sp->filter_order - 2);
}

static void W_filter_order_up_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,
	   "Filter Order Increment Button",
"This button causes the filter order to be incremented\n\
in case your keyboard is not working, or arabic numbers\n\
present an insuperable challenge.\n\
");
}

static void W_filter_order_down_Help_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_help((snd_state *)clientData,
	   "Filter Order Decrement Button",
"This button causes the filter order to be decremented\n\
in case your keyboard is not working, or arabic numbers\n\
present an insuperable challenge.\n\
");
}

static void Filter_activate_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  /* make an envelope out of the data */
  snd_info *sp = (snd_info *)clientData;
  char *str=NULL;
  spflt *spf;
  int err,order;
  str = XmTextGetString(w);
  if (sp->filter_env) free_env(sp->filter_env);
  sp->filter_env = scan_envelope_and_report_error(sp,str,&err);
  if (str) FREE(str);
  if (!(sp->filter_env)) /* maybe user cleared text field? */
    sp->filter_env = default_env(1.0);
  str = XmTextGetString(w_snd_filter_order(sp));
  if ((str) && (*str))
    {
      sscanf(str,"%d",&order);
      if (order&1) order++;
      sp->filter_order = order;
      FREE(str);
    }
  spf = (spflt *)((sp->sgx)->flt);
  spf->edited = 1;
  sp_display_env(sp,spf);
  filter_textfield_deactivate(sp);
  sp->filter_changed = 1;
}

static void Filter_Order_activate_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  char *str;
  int order;
  snd_info *sp = (snd_info *)clientData;
  str = XmTextGetString(w);
  if ((str) && (*str))
    {
      sscanf(str,"%d",&order);
      if (order&1) order++;
      sp->filter_order = order;
      sp->filter_changed = 1;
      sp_display_env(sp,(spflt *)((sp->sgx)->flt));
      FREE(str);
    }
  filter_textfield_deactivate(sp);
}

void filter_env_changed(snd_info *sp, env *e)
{
  /* turn e back into a string for textfield widget */
  char *tmpstr=NULL;
  XmTextSetString(w_snd_filter(sp),tmpstr=env_to_string(e));
  if (tmpstr) FREE(tmpstr);
  sp_display_env(sp,(spflt *)((sp->sgx)->flt));
  /* this is called also from snd-gh */
  sp->filter_changed = 1;
}



/* ---------------- reflect control panel slider/button defaults ---------------- */

static void reflect_control_panel_defaults(snd_state *ss, snd_info *sp)
{
  float spdf;
  int val;
  toggle_expand_button(sp,default_expanding(ss));
  toggle_reverb_button(sp,default_reverbing(ss));
  toggle_contrast_button(sp,default_contrasting(ss));
  toggle_filter_button(sp,default_filtering(ss));
  snd_revlen_changed(sp,snd_revlen_to_int(default_reverb_length(ss)));
  snd_revscl_changed(sp,snd_revscl_to_int(default_reverb_scale(ss)));
  snd_expand_changed(sp,snd_expand_to_int(default_expand(ss)));
  snd_amp_changed(sp,snd_amp_to_int(default_amp(ss)));
  if (default_speed(ss) < 0.0)
    {
      spdf = -(default_speed(ss));
      sp->play_direction = -1;
    }
  else
    {
      spdf = (default_speed(ss));
      sp->play_direction = 1;
    }
  val = snd_srate_to_int(spdf);
  snd_srate_changed(sp,val);
  XtVaSetValues(w_snd_srate(sp),XmNvalue,val,NULL);
  toggle_direction_arrow(sp,(sp->play_direction == -1)); /* true here means reversed playback */
  snd_contrast_changed(sp,snd_contrast_to_int(default_contrast(ss)));
  XtVaSetValues(w_snd_amp(sp),XmNvalue,snd_amp_to_int(default_amp(ss)),NULL);
  XtVaSetValues(w_snd_expand(sp),XmNvalue,snd_expand_to_int(default_expand(ss)),NULL);
  XtVaSetValues(w_snd_contrast(sp),XmNvalue,snd_contrast_to_int(default_contrast(ss)),NULL);
  XtVaSetValues(w_snd_revlen(sp),XmNvalue,snd_revlen_to_int(default_reverb_length(ss)),NULL);
  XtVaSetValues(w_snd_revscl(sp),XmNvalue,snd_revscl_to_int(default_reverb_scale(ss)),NULL);
  filter_order_changed(sp,default_filter_order(ss));
  set_filter_dBing(sp,default_filter_dBing(ss));
}

void set_play_button(snd_info *sp, int val)
{
  XmToggleButtonSetState(w_snd_play(sp),val,FALSE);
  set_file_browser_play_button(sp->shortname,val);
}

static void Play_button_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_info *sp = (snd_info *)clientData;
  chan_info *cp;
  snd_state *ss;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData;
  int i;
  XButtonEvent *ev;
  ev = (XButtonEvent *)(cb->event);
  if (sp->playing) 
    {
      if (sp->cursor_follows_play != DONT_FOLLOW)
	{
	  for (i=0;i<sp->nchans;i++)
	    {
	      cp = sp->chans[i];
	      cp->original_cursor = cp->cursor;
	    }
	}
      stop_playing_sound(sp);
    }
  if (sp->cursor_follows_play != FOLLOW_ALWAYS)         /* can be set in init file */
    {
      if ((cb->set) && (ev->state & (snd_ControlMask | snd_MetaMask)))
	sp->cursor_follows_play = FOLLOW_ONCE;
      else sp->cursor_follows_play = DONT_FOLLOW;
    }
  set_file_browser_play_button(sp->shortname,cb->set);
  cp = any_selected_channel(sp);
  goto_graph(cp);
  if ((!(cp->cursor_on)) && (sp->cursor_follows_play != DONT_FOLLOW))
    for (i=0;i<sp->nchans;i++)
      {
	cp = sp->chans[i];
	cp->cursor_on = 1;
      }
  if (cb->set) 
    {
      ss = sp->state;
      XtVaSetValues(w,XmNselectColor,((sp->cursor_follows_play != DONT_FOLLOW) ? ((ss->sgx)->green) : ((ss->sgx)->pushed_button_color)),NULL);
      start_playing(sp,0);
    }
}

typedef struct {int pausing; snd_state *ss;} pause_data;

static int set_play_button_pause(snd_info *sp, void *ptr)
{
  pause_data *pd = (pause_data *)ptr;
  snd_state *ss;
  Widget w;
  if (sp->playing)
    {
      ss = pd->ss;
      w = w_snd_play(sp);
      if (pd->pausing)
	XtVaSetValues(w,XmNselectColor,(ss->sgx)->red,NULL);
      else XtVaSetValues(w,XmNselectColor,((sp->cursor_follows_play != DONT_FOLLOW) ? ((ss->sgx)->green) : ((ss->sgx)->pushed_button_color)),NULL);
    }
  return(0);
}

void play_button_pause(snd_state *ss, int pausing)
{
  pause_data *pd;
  pd = (pause_data *)CALLOC(1,sizeof(pause_data));
  pd->pausing = pausing;
  pd->ss = ss;
  map_over_sounds(ss,set_play_button_pause,(void *)pd);
  FREE(pd);
}


static void Play_arrow_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_info *sp = (snd_info *)clientData;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData;
  int dir;
  dir = cb->set;
  if (dir) sp->play_direction = -1; else sp->play_direction = 1;
  if (sp->recording) record_direction_change(sp,dir,sp->play_direction);
}

static void set_sync_color(snd_info *sp)
{
  snd_state *ss;
  Widget syb;
  syb = w_snd_sync(sp);
  ss = sp->state;
  switch (sp->syncing)
    {
    case 1: case 0: XtVaSetValues(syb,XmNselectColor,(ss->sgx)->pushed_button_color,NULL); break;
    case 2: XtVaSetValues(syb,XmNselectColor,(ss->sgx)->green,NULL); break;
    case 3: XtVaSetValues(syb,XmNselectColor,(ss->sgx)->yellow,NULL); break;
    case 4: XtVaSetValues(syb,XmNselectColor,(ss->sgx)->red,NULL); break;
    default: XtVaSetValues(syb,XmNselectColor,(ss->sgx)->black,NULL); break;
    }
}

void syncb(snd_info *sp, int on)
{
  sp->syncing = on;
  set_sync_color(sp);
  XmToggleButtonSetState(w_snd_sync(sp),(on == 0) ? FALSE : TRUE,FALSE);
}

static void Sync_button_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  snd_info *sp = (snd_info *)clientData;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData;
  chan_info *cp;
  XButtonEvent *ev;
  ev = (XButtonEvent *)(cb->event);
  if (cb->set)
    if (ev->state & snd_ControlMask) 
      if (ev->state & snd_MetaMask)
	if (ev->state & snd_ShiftMask)
	  sp->syncing = 4;
	else sp->syncing = 3;
      else sp->syncing = 2;
    else sp->syncing = 1;
  else sp->syncing = 0;
  if (sp->syncing != 0) 
    {
      set_sync_color(sp);
      cp = sp->lacp;
      if (cp == NULL) cp = any_selected_channel(sp);
      goto_graph(cp);
      if (cp->cursor_on) cursor_moveto(cp,cp->cursor);
      apply_x_axis_change(cp->axis,cp,sp);
    }
}

void combineb(snd_info *sp, int val)
{
  switch (val)
    {
    case CHANNELS_SEPARATE: separate_sound(sp); break; /* snd-xchn.c -> change_channel_style */
    case CHANNELS_COMBINED: combine_sound(sp); break;
    case CHANNELS_SUPERIMPOSED: superimpose_sound(sp); break;
    }
}

static void Combine_button_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  /* click if set unsets, click if unset->combine, ctrl-click->superimpose */
  snd_info *sp = (snd_info *)clientData;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData;
  XButtonEvent *ev;
  int val;
  ev = (XButtonEvent *)(cb->event);
  if (cb->set)
    {
      if (ev->state & (snd_ControlMask | snd_MetaMask)) 
	val = CHANNELS_SUPERIMPOSED;
      else val = CHANNELS_COMBINED;
    }
  else val = CHANNELS_SEPARATE;
  combineb(sp,val);
}


static Boolean xrun_amp_env (XtPointer sp)
{
  /* this extra step is needed to get around various X-isms */
  return(run_amp_env((snd_info *)sp));
}

void start_amp_env(snd_info *sp, int anew)
{
  /* fire up work proc for amp env */
  Widget info_sep;
  snd_state *ss;
  snd_context *sgx;
  ss = sp->state;
  sgx = sp->sgx;
  if (!(sgx->env_in_progress))
    {
      info_sep = w_snd_info_sep(sp);
      if (info_sep) XtVaSetValues(info_sep,XmNseparatorType,XmNO_LINE,NULL);
      sp->env_anew = anew;
      sgx->env_in_progress = XtAppAddWorkProc((ss->sgx)->mainapp,xrun_amp_env,(XtPointer)sp);
    }
}

void signal_amp_env_done(snd_info *sp)
{
  Widget info_sep;
  info_sep = w_snd_info_sep(sp);
  if (info_sep) XtVaSetValues(info_sep,XmNseparatorType,XmSHADOW_ETCHED_IN,NULL);
  alert_enved_amp_env(sp);
}

void remove_amp_env(snd_info *sp)
{
  /* assume someone else is dealing with the arrays */
  snd_context *sgx;
  sgx = sp->sgx;
  if (sgx->env_in_progress)
    {
      signal_amp_env_done(sp);
      XtRemoveWorkProc(sgx->env_in_progress);
      sgx->env_in_progress = 0;
    }
  free_sound_env(sp,1); /* ?? */
}

void remove_apply(snd_info *sp)
{
  snd_context *sgx;
  if ((sp) && (sgx = sp->sgx) && (sgx->apply_in_progress))
    {
      XtRemoveWorkProc(sgx->apply_in_progress);
      sgx->apply_in_progress = 0;
    }
}

static void Info_activate_Callback(Widget w,XtPointer clientData,XtPointer callData)
{
  /* can be response to various things */
  snd_info *sp = (snd_info *)clientData;
  snd_state *ss;
  XmAnyCallbackStruct *cb = (XmAnyCallbackStruct *)callData;
  XKeyEvent *ev;
  KeySym keysym;
  ev = (XKeyEvent *)(cb->event);
  keysym = XKeycodeToKeysym(XtDisplay(w),(int)(ev->keycode),(ev->state & ShiftMask) ? 1 : 0);
  ss = sp->state;
  ss->mx_sp = sp; 
  snd_info_activate(sp,keysym);
}

static void Record_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  /* merge (record) changes in ctrl state into current state */
  snd_info *sp = (snd_info *)clientData;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData;
  sp->recording = cb->set;
  if (sp->recording) 
    {
      initialize_record(sp);
      XmToggleButtonSetState(w_snd_apply(sp),FALSE,TRUE);
    }
}

static void Replay_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  /* run dac using current ctrls state (and envs, if any)
   * if any changes made (and record on), merge them into current state 
   */
  snd_info *sp = (snd_info *)clientData;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData;
  sp->replaying = cb->set;
  if (sp->replaying) 
    {
      initialize_replay(sp);
      XmToggleButtonSetState(w_snd_apply(sp),FALSE,TRUE);
    }
  /* assume play explicit (may want to set several of these before starting) */
}

static Boolean xrun_apply(XtPointer sp)
{
  return(apply_controls((void *)sp));
}

static void Apply_Callback(Widget w,XtPointer clientData,XtPointer callData) 
{
  /* create temp file of run over current file using the current (saved) ctrls state */
  snd_info *sp = (snd_info *)clientData;
  snd_state *ss;
  XmToggleButtonCallbackStruct *cb = (XmToggleButtonCallbackStruct *)callData;
  snd_context *sgx;
  sgx = sp->sgx;
  sp->applying = cb->set;
  if (sp->applying) 
    {
      ss = sp->state;
      XmToggleButtonSetState(w_snd_replay(sp),FALSE,TRUE);
      XmToggleButtonSetState(w_snd_record(sp),FALSE,TRUE);
      sgx->apply_in_progress = XtAppAddWorkProc((ss->sgx)->mainapp,xrun_apply,(XtPointer)make_apply_state(sp));
    }
  else 
    {
      stop_applying(sp);
    }
}

void call_apply(snd_info *sp)
{
  XmToggleButtonSetState(w_snd_replay(sp),FALSE,TRUE);
  XmToggleButtonSetState(w_snd_record(sp),FALSE,TRUE);
  run_apply_to_completion(sp);
}

void reflect_replay_stop(snd_info *sp)
{
  if (sp->replaying)
    XmToggleButtonSetState(w_snd_replay(sp),FALSE,FALSE);
  if (sp->recording)
    XmToggleButtonSetState(w_snd_record(sp),FALSE,FALSE);
  sp->replaying = 0;
  sp->recording = 0;
}

/* apply is only safe if the DAC is currently inactive and remains safe only
 * if all other apply buttons are locked out (and play).
 */

static int lockapply(snd_info *sp, void *up) 
{
  if (sp != up) XtSetSensitive(w_snd_apply(sp),FALSE);
  return(0);
}

void lock_apply(snd_state *ss, snd_info *sp)
{
  /* if playing or applying, set other applys to insensitive */
  map_over_sounds(ss,lockapply,(void *)sp);
}

static int lockplay(snd_info *sp, void *up) 
{
  XtSetSensitive(w_snd_replay(sp),FALSE);
  XtSetSensitive(w_snd_record(sp),FALSE);
  XtSetSensitive(w_snd_play(sp),FALSE);
  return(0);
}

void lock_play_and_record(snd_state *ss, snd_info *sp)
{
  /* if applying, set plays, records, and replays to insensitive */
  map_over_sounds(ss,lockplay,(void *)sp);
}

static int unlockapply(snd_info *sp, void *up) 
{
  if (sp != up) XtSetSensitive(w_snd_apply(sp),TRUE);
  return(0);
}

void unlock_apply(snd_state *ss,snd_info *sp)
{
  map_over_sounds(ss,unlockapply,(void *)sp);
}

static int unlockplay(snd_info *sp, void *up) 
{
  XtSetSensitive(w_snd_replay(sp),TRUE);
  XtSetSensitive(w_snd_record(sp),TRUE);
  XtSetSensitive(w_snd_play(sp),TRUE);
  return(0);
}

void unlock_play_and_record(snd_state *ss,snd_info *sp)
{
  map_over_sounds(ss,unlockplay,(void *)sp);
}

static int cant_write(char *name)
{
#ifndef _MSC_VER
  return((access(name,W_OK)) != 0);
#else
  return(0);
#endif
}

static void Set_Callback(Widget w,XtPointer clientData,XtPointer callData) {save_control_state((snd_info *)clientData);}
static void Reset_Callback(Widget w,XtPointer clientData,XtPointer callData) {restore_control_state((snd_info *)clientData);}

static void add_sound_callbacks(Widget *sw, XtPointer sps)
{
  int i;
  snd_info *sp;
  chan_info *cp;
  sp=(snd_info *)sps;
  XtAddCallback(sw[W_snd_play],XmNvalueChangedCallback,Play_button_Callback,sps);
  XtAddCallback(sw[W_snd_name],XmNactivateCallback,W_name_Click_Callback,sps);
  XtAddCallback(sw[W_snd_amp_label],XmNactivateCallback,W_amp_Click_Callback,sps);
  XtAddCallback(sw[W_snd_srate_label],XmNactivateCallback,W_srate_Click_Callback,sps);
  XtAddCallback(sw[W_snd_contrast_label],XmNactivateCallback,W_contrast_Click_Callback,sps);
  XtAddCallback(sw[W_snd_expand_label],XmNactivateCallback,W_expand_Click_Callback,sps);
  XtAddCallback(sw[W_snd_revscl_label],XmNactivateCallback,W_revscl_Click_Callback,sps);
  XtAddCallback(sw[W_snd_revlen_label],XmNactivateCallback,W_revlen_Click_Callback,sps);
  XtAddCallback(sw[W_snd_srate_arrow],XmNvalueChangedCallback,Play_arrow_Callback,sps);
  XtAddCallback(sw[W_snd_expand_button],XmNvalueChangedCallback,Expand_button_Callback,sps);
  XtAddCallback(sw[W_snd_contrast_button],XmNvalueChangedCallback,Contrast_button_Callback,sps);
  XtAddCallback(sw[W_snd_reverb_button],XmNvalueChangedCallback,Reverb_button_Callback,sps);
  XtAddCallback(sw[W_snd_filter_button],XmNvalueChangedCallback,Filter_button_Callback,sps);
  XtAddCallback(sw[W_snd_info],XmNactivateCallback,Info_activate_Callback,sps);
  XtAddCallback(sw[W_snd_filter_order],XmNactivateCallback,Filter_Order_activate_Callback,sps);
  XtAddCallback(sw[W_snd_filter],XmNactivateCallback,Filter_activate_Callback,sps);
  XtAddCallback(sw[W_snd_sync],XmNvalueChangedCallback,Sync_button_Callback,sps);
  if (sp->nchans > 1) XtAddCallback(sw[W_snd_combine],XmNvalueChangedCallback,Combine_button_Callback,sps);
  XtAddCallback(sw[W_snd_record],XmNvalueChangedCallback,Record_Callback,sps);
  XtAddCallback(sw[W_snd_replay],XmNvalueChangedCallback,Replay_Callback,sps);
  XtAddCallback(sw[W_snd_apply],XmNvalueChangedCallback,Apply_Callback,sps);
  XtAddCallback(sw[W_snd_set],XmNactivateCallback,Set_Callback,sps);
  XtAddCallback(sw[W_snd_reset],XmNactivateCallback,Reset_Callback,sps);
  XtAddCallback(sw[W_snd_filter_env],XmNresizeCallback,filter_drawer_resize,sps);
  XtAddCallback(sw[W_snd_filter_env],XmNexposeCallback,filter_drawer_resize,sps);
  XtAddCallback(sw[W_snd_filter_dB],XmNvalueChangedCallback,filter_dB_Callback,sps);
  XtAddCallback(sw[W_snd_filter_order_up],XmNactivateCallback,filter_order_up_Callback,sps);
  XtAddCallback(sw[W_snd_filter_order_down],XmNactivateCallback,filter_order_down_Callback,sps);
  for (i=0;i<sp->nchans;i++)
    {
      cp=sp->chans[i];
      add_chan_callbacks(cp);
    }
}

static void remove_sound_callbacks(snd_info *sp)
{
  snd_context *sx;
  Widget *sw;
  sx = sp->sgx;
  sw = sx->snd_widgets;
  XtRemoveCallback(sw[W_snd_play],XmNvalueChangedCallback,Play_button_Callback,sp);
  XtRemoveCallback(sw[W_snd_amp_label],XmNactivateCallback,W_amp_Click_Callback,sp);
  XtRemoveCallback(sw[W_snd_srate_label],XmNactivateCallback,W_srate_Click_Callback,sp);
  XtRemoveCallback(sw[W_snd_contrast_label],XmNactivateCallback,W_contrast_Click_Callback,sp);
  XtRemoveCallback(sw[W_snd_expand_label],XmNactivateCallback,W_expand_Click_Callback,sp);
  XtRemoveCallback(sw[W_snd_revscl_label],XmNactivateCallback,W_revscl_Click_Callback,sp);
  XtRemoveCallback(sw[W_snd_revlen_label],XmNactivateCallback,W_revlen_Click_Callback,sp);
  XtRemoveCallback(sw[W_snd_srate_arrow],XmNvalueChangedCallback,Play_arrow_Callback,sp);
  XtRemoveCallback(sw[W_snd_expand_button],XmNvalueChangedCallback,Expand_button_Callback,sp);
  XtRemoveCallback(sw[W_snd_contrast_button],XmNvalueChangedCallback,Contrast_button_Callback,sp);
  XtRemoveCallback(sw[W_snd_reverb_button],XmNvalueChangedCallback,Reverb_button_Callback,sp);
  XtRemoveCallback(sw[W_snd_filter_button],XmNvalueChangedCallback,Filter_button_Callback,sp);
  XtRemoveCallback(sw[W_snd_info],XmNactivateCallback,Info_activate_Callback,sp);
  XtRemoveCallback(sw[W_snd_filter_order],XmNactivateCallback,Filter_Order_activate_Callback,sp);
  XtRemoveCallback(sw[W_snd_filter],XmNactivateCallback,Filter_activate_Callback,sp);
  XtRemoveCallback(sw[W_snd_sync],XmNvalueChangedCallback,Sync_button_Callback,sp);
  if (sp->nchans > 1) XtRemoveCallback(sw[W_snd_combine],XmNvalueChangedCallback,Combine_button_Callback,sp);
  XtRemoveCallback(sw[W_snd_record],XmNvalueChangedCallback,Record_Callback,sp);
  XtRemoveCallback(sw[W_snd_replay],XmNvalueChangedCallback,Replay_Callback,sp);
  XtRemoveCallback(sw[W_snd_apply],XmNvalueChangedCallback,Apply_Callback,sp);
  XtRemoveCallback(sw[W_snd_set],XmNactivateCallback,Set_Callback,sp);
  XtRemoveCallback(sw[W_snd_reset],XmNactivateCallback,Reset_Callback,sp);
  XtRemoveCallback(sw[W_snd_filter_env],XmNresizeCallback,filter_drawer_resize,sp);
  XtRemoveCallback(sw[W_snd_filter_env],XmNexposeCallback,filter_drawer_resize,sp);
  XtRemoveCallback(sw[W_snd_filter_dB],XmNvalueChangedCallback,filter_dB_Callback,sp);
  XtRemoveCallback(sw[W_snd_filter_order_up],XmNactivateCallback,filter_order_up_Callback,sp);
  XtRemoveCallback(sw[W_snd_filter_order_down],XmNactivateCallback,filter_order_down_Callback,sp);
}

/* bitmaps for the playback direction arrow */
static unsigned char speed_r_bits[] = {
   0x00, 0x04, 0x10, 0x08, 0x00, 0x10, 0x04, 0x20, 0x00, 0x40, 0xa5, 0xbf,
   0x00, 0x40, 0x04, 0x20, 0x00, 0x10, 0x10, 0x08, 0x00, 0x04, 0x00, 0x00};
static unsigned char speed_l_bits[] = {
   0x20, 0x00, 0x10, 0x08, 0x08, 0x00, 0x04, 0x20, 0x02, 0x00, 0xfd, 0xa5,
   0x02, 0x00, 0x04, 0x20, 0x08, 0x00, 0x10, 0x08, 0x20, 0x00, 0x00, 0x00};

#if HAVE_XPM
#include <X11/xpm.h>
/* XPM icon for lock (read-only file) */

static char * mini_lock_xpm[] = {
"16 14 6 1",
" 	c None s None",
".	c gray50",
"X	c black",
"o	c white",
"O	c yellow",
"-      c ivory2 s basiccolor",
"------.XXX.-----",
"-----X.ooo.X----",
"----..oXXXo..---",
"----XoX...XoX---",
"----XoX.--XoX.--",
"----XoX.--XoX.--",
"---XXXXXXXXXXX--",
"---XOOOOOOOOOX.-",
"---XO.......OX.-",
"---XOOOOOOOOOX.-",
"---XO.......OX.-",
"---XOOOOOOOOOX.-",
"---XXXXXXXXXXX.-",
"----...........-"};

static Pixmap mini_lock = 0;
static int mini_lock_allocated = 0;

/* bomb for out-of-date in-core data fuse shortens with sparks flying off; */

static char * mini_bomb0_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----.--","-X.#X....X---.--",
"-..oX.....---O-O","-.......O.-O-OO-","-......Xo.--OOO-","-X.....X.X--O---","--.......-------","---X...X--------","----------------"};

static char * mini_bomb1_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----.--","-X.#X....X---Y--",
"-..oX.....---YYY","-.......O.-YYOOY","-......Xo.--OOY-","-X.....X.X--Y---","--.......-------","---X...X--------","----------------"};

static char * mini_bomb2_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----Y--","-X.#X....X---YY-",
"-..oX.....---OYO","-.......O.--O-OO","-......Xo.--Y-Y-","-X.....X.X------","--.......----Y--","---X...X--------","----------------"};

static char * mini_bomb3_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----.---","---.....----.---","--.X#o...----Y--","-X.#X....X---OO-",
"-..oX.....-YYYYO","-.......O.----O-","-......Xo.----O-","-X.....X.X----Y-","--.......-------","---X...X--------","------------YY--"};

static char * mini_bomb4_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-------...------","------.---.-----","-----.-----.--Y-","----...-----.---","---.....----O---","--.X#o...---OO--","-X.#X....X-YOYO-",
"-..oX.....--OYY-","-.......O.------","-......Xo.-Y----","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static char * mini_bomb5_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-------...------","------.---.-----","-----.-----.----","----...-----Y---","---.....----OO--","--.X#o...--OOO--","-X.#X....X---YO-",
"-..oX.....---YY-","-.......O.-----Y","-......Xo.-----O","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static char * mini_bomb6_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-------...------","------.---.-----","-----.-----OO-O-","----...-----YO--","---.....----O---","--.X#o...-YY-OO-","-X.#X....X--Y---",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-----OO","---X...X------Y-","----------------"};

static char * mini_bomb7_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-------...----OO","------.---O-----","-----.-----OOYY-","----...-----YOO-","---.....-YY-O---","--.X#o...-------","-X.#X....X--YO--",
"-..oX.....---Y--","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","--------------YY"};

static char * mini_bomb8_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-------..Y------","------.--OO-----","-----.----OOO-Y-","----...---OO--O-","---.....-YY----O","--.X#o...-------","-X.#X....X------",
"-..oX.....--YO--","-.......O.---O--","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static char * mini_bomb9_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-------YOY--O---","------.---YO----","-----.----OYY---","----...---------","---.....----YY--","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.--YO--","-......Xo.---Y--","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static char * mini_bomb10_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-----OYYOYOO----","-----YOO--YO----","-----.-----YY---","----...---------","---.....--------","--.X#o...----OO-","-X.#X....X---Y--",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static char * mini_bomb11_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-----OOYOO--O---","----OOY----O----","---OOOO---------","----...---------","---.....--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......---OO--","---X...X--------","----------------"};

static char * mini_bomb12_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"-----OO---------","--YYOOYYY-------","YYOOOOYYYY------","--OOOOO---------","---.....--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","------------YY--"};

static char * mini_bomb13_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"----------------","----OOY---------","--YYYYY-Y-------","--Y-OOO---------","---.YOY.--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

static char * mini_bomb14_xpm[] = {
"16 14 8 1"," 	c None s None",".	c black","X	c gray50","o	c gray85","O	c red","#	c white","-      c ivory2 s basiccolor","Y      c yellow",
"----------------","----------------","----------------","----------------","---.....--------","--.X#o...-------","-X.#X....X------",
"-..oX.....------","-.......O.------","-......Xo.------","-X.....X.X------","--.......-------","---X...X--------","----------------"};

#define NUM_BOMBS 15
static Pixmap mini_bombs[NUM_BOMBS];

static char * mini_glass0_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.OOOOOOOOOO.c-","-.cOOOOOOOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.cooooooooooc.-","-cooooooooooooc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass1_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.OOOOoOOOOO.c-","-.cOOOOOOOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.coOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---coooOooooc---","--cooooooooooc--","-.cooooooooooc.-","-coooooOooooooc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass2_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.OOOOoooOOO.c-","-.cOOOOOOOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.cOoc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.cooooOoooooc.-","-cooooOOOoooooc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass3_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.OOOoooOOOO.c-","-.cOOOOooOOOOc.-","--cOOOOOOOOOOc--","----cOOOOOOc----","-----.coOc.-----","-------cc-------",
"-----.cOoc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.coooOooooooc.-","-coooOOOOoooooc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass4_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.OOOooooOOO.c-","-.cOOOOoooOOOc.-","--cOOOOOoOOOOc--","----cOOoOOOc----","-----.cOOc.-----","-------cc-------",
"-----.coOc.-----","----cooooooc----","---cooooooooc---","--cooooooooooc--","-.coooOOOooooc.-","-coooOOOOoooooc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass5_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.OOOoooooOO.c-","-.cOOOOooooOOc.-","--cOOOOOoOOOOc--","----cOOOOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--coooOooooooc--","-.coooOOOOoooc.-","-coooOOOOOooooc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass6_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.OOOoooooOO.c-","-.cOOOOooooOOc.-","--cOOOOoooOOOc--","----cOOOOoOc----","-----.cOOc.-----","-------cc-------",
"-----.cOoc.-----","----coooOooc----","---cooooooooc---","--cooooooooooc--","-.coooOOOOoooc.-","-coooOOOOOOoooc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass7_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.OOooooooOO.c-","-.cOOOoooooOOc.-","--cOOOOoOoOOOc--","----cOOoOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooOoooc---","--coooOOoooooc--","-.cooOOOOOoooc.-","-cooOOOOOOOoooc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass8_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.OoooooooOO.c-","-.cOOooooooOOc.-","--cOOOooooOOOc--","----cOOOOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooooooooc---","--coooOOOooooc--","-.cooOOOOOoooc.-","-cooOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass9_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.ooooooooOO.c-","-.cOoooooooOOc.-","--cOOoooooOOOc--","----cOOoOOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooOoooc----","---cooooooooc---","--cooOOOOOOOoc--","-.coOOOOOOOOooc.-","-coOOOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass10_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cOoooooooooc.-","--cOOooooooOOc--","----cOOooOOc----","-----.coOc.-----","-------cc-------",
"-----.cooc.-----","----cooooooc----","---cooOOOOooc---","--cooOOOOOOooc--","-.coOOOOOOOOoc.-","-cOOOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass11_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cOOooooooooc--","----cOOooOOc----","-----.coOc.-----","-------cc-------",
"-----.cooc.-----","----cooOoooc----","---cooOOOOooc---","--coOOOOOOOooc--","-.cOOOOOOOOOoc.-","-cOOOOOOOOOOOoc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass12_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cooooooooooc--","----cOoooOOc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooOOooc----","---coOOOOOooc---","--cOOOOOOOOOoc--","-.cOOOOOOOOOOc.-","-cOOOOOOOOOOOOc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass13_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cooooooooooc--","----cooooooc----","-----.cOOc.-----","-------cc-------",
"-----.cooc.-----","----cooOOooc----","---cOOOOOOOOc---","--cOOOOOOOOOOc--","-.cOOOOOOOOOOc.-","-cOOOOOOOOOOOOc-","-XXXXXXXXXXXXXX-"};

static char * mini_glass14_xpm[] = {"16 14 6 1",". 	c ivory4","c	c gray50","X	c black","o	c white","O	c tan","-      c ivory2 s basiccolor",
"-XXXXXXXXXXXXXX-","-c.oooooooooo.c-","-.cooooooooooc.-","--cooooooooooc--","----cooooooc----","-----.cooc.-----","-------cc-------",
"-----.cOOc.-----","----cOOOOOOc----","---cOOOOOOOOc---","--cOOOOOOOOOOc--","-.cOOOOOOOOOOc.-","-cOOOOOOOOOOOOc-","-XXXXXXXXXXXXXX-"};

#define NUM_GLASSES 15
static Pixmap mini_glasses[NUM_GLASSES];


void snd_file_lock_icon(snd_info *sp, int on)
{
  snd_context *sx;
  if (mini_lock) 
    {
      sx = sp->sgx;
      if (on)
	sx->file_pix = mini_lock;
      else sx->file_pix = No_Pixmap;
      XtVaSetValues(w_snd_name_icon(sp),XmNlabelPixmap,sx->file_pix,NULL);
    }
  /* these Pixmaps can be null if the colormap is screwed up */
}

#define BOMB_TIME 200

static void show_bomb_icon(snd_info *sp, int on)
{
  snd_context *sx;
  if (sp->bomb_ctr >= NUM_BOMBS) sp->bomb_ctr = 0;
  if (mini_bombs[sp->bomb_ctr]) 
    {
      sx = sp->sgx;
      if (on)
	sx->file_pix = mini_bombs[sp->bomb_ctr];
      else sx->file_pix = No_Pixmap;
      XtVaSetValues(w_snd_name_icon(sp),XmNlabelPixmap,sx->file_pix,NULL);
    }
}

void x_bomb(snd_info *sp, int on)
{
  show_bomb_icon(sp,on);
  if (on) sp->bomb_ctr++; else sp->bomb_ctr = 0;
}

static int inc_bomb(snd_info *sp, void *ptr)
{
  int *buf;
  if (sp)
    {
      if (sp->need_update)
	{
	  buf = (int *)ptr;
	  buf[0]++;
	  show_bomb_icon(sp,sp->bomb_ctr);
	  sp->bomb_ctr++;
	}
    }
  return(0);
}

static int bomb_in_progress = 0;

static void bomb_check(XtPointer clientData, XtIntervalId *id)
{
  snd_info *sp = (snd_info *)clientData;
  snd_state *ss;
  int incs[1];
  ss = sp->state;
  incs[0] = 0;
  map_over_sounds(ss,inc_bomb,(void *)incs);
  if (incs[0] > 0)
    XtAppAddTimeOut((ss->sgx)->mainapp,(unsigned long)BOMB_TIME,(XtTimerCallbackProc)bomb_check,clientData);
  else bomb_in_progress = 0;
}

void snd_file_bomb_icon(snd_info *sp, int on)
{
  snd_state *ss;
  if ((on) && (bomb_in_progress == 0))
    {
      ss = sp->state;
      bomb_in_progress = 1;
      XtAppAddTimeOut((ss->sgx)->mainapp,(unsigned long)BOMB_TIME,(XtTimerCallbackProc)bomb_check,(void *)sp);
    }
}

static void snd_file_glasses_icon(snd_info *sp, int on, int glass)
{
  Widget w;
  snd_context *sx;
  w = w_snd_name_icon(sp);
  if (on)
    {
      if (mini_glasses[glass])
	{
	  XtVaSetValues(w,XmNlabelPixmap,mini_glasses[glass],NULL);
	  XmUpdateDisplay(w);
	}
    }
  else
    {
      sx = sp->sgx;
      XtVaSetValues(w,XmNlabelPixmap,sx->file_pix,NULL);
      XmUpdateDisplay(w);
    }
}

#else
void snd_file_lock_icon(snd_info *sp, int on) {}
void snd_file_bomb_icon(snd_info *sp, int on) 
{
  char *buf;
  if (on)
    {
      buf = (char *)CALLOC(256,sizeof(char));
      sprintf(buf,STR_file_has_changed,sp->shortname);
      report_in_minibuffer(sp,buf);
      FREE(buf);
    }
}
static void snd_file_glasses_icon(snd_info *sp, int on, int glass) {}
void x_bomb(snd_info *sp, int on) {}
#endif

static snd_state *info_ss = NULL;

static char *info_completer(char *text)
{
  snd_info *sp = NULL;
  char *new_text,*new_file;
  int i,beg,parens,len;
  if (info_ss) sp = selected_sound(info_ss);
  if (sp)
    {
      if (sp->evaling) return(copy_string(text));   /* C-x C-x so nothing useful for completion to work on */
      if (sp->searching) return(copy_string(text)); /* C-s or C-r so as above */
      if ((sp->marking) || (sp->finding_mark)) return(copy_string(text)); /* C-x C-m etc */
      if (sp->printing) return(copy_string(text));  /* C-x C-d so anything is possible */
      if (sp->amping) return(env_name_completer(text));
      if (sp->filing)
	{
	  if ((sp->filing == INPUT_FILING) ||  /* C-x C-f */
	      (sp->filing == CHANGE_FILING) || /* C-x C-q */
	      (sp->filing == INSERT_FILING))   /* C-x C-i */
	    return(filename_completer(text));
	}
      if (sp->loading) return(filename_completer(text)); /* C-x C-l */
      if (sp->macroing) 
	{
	  new_text = command_completer(text);
	  if (get_completion_matches() == 0)
	    {
	      beg = 0;
	      parens = 0;
	      /* filename would have to be a string in this context */
	      len = snd_strlen(text);
	      for (i=0;i<len;i++)
		if (text[i] == '\"')
		  {
		    beg = i+1;
		    parens++;
		    break;
		  }
	      if ((beg > 0) && (parens & 1)) /* i.e. there is a string and we're in it */
		{
		  if (new_text) FREE(new_text);
		  new_file = filename_completer((char *)(text+beg));
		  len = beg + 2 + snd_strlen(new_file);
		  new_text = (char *)CALLOC(len,sizeof(char));
		  strncpy(new_text,text,beg);
		  strcat(new_text,new_file);
		  return(new_text);
		}
	      else return(new_text);
	    }
	  else return(new_text);
	}
      return(copy_string(text));
    }
  else return(command_completer(text));
}

static void Close_Sound_Dialog(Widget w,XtPointer clientData,XtPointer callData) 
{
  snd_info *sp = (snd_info *)clientData;
  finish_keyboard_selection();
  if (sp) snd_close_file(sp,sp->state);
} 

snd_info *add_sound_window (char *filename, snd_state *state)
{  
  snd_info *sp,*osp;
  file_info *hdr;
  Widget *sw;
  XmString s1;
  int snd_slot,nchans,make_widgets,i,k,need_colors,n,old_chans;
  Arg args[32];
  char *old_name = NULL,*title;
  Dimension app_y,app_dy,screen_y,chan_min_y;
  /* these dimensions are used to try to get a reasonable channel graph size without falling off the screen bottom */
  Pixmap rb,lb;
  int depth;
  int samples_per_channel;
  Widget form;
  snd_context *sx;
  Atom sound_delete;
  static int first_window = 1;
  set_snd_IO_error(SND_NO_ERROR);
  errno = 0;
  hdr = make_file_info(filename,state);
  if (!hdr) return(NULL);
  if (state->pending_change) 
    {
      old_name = filename;
      filename = state->pending_change;
      state->pending_change = NULL;
    }
  nchans = hdr->chans;
  samples_per_channel = hdr->samples/nchans;

  XtVaGetValues(main_SHELL(state),XmNy,&app_y,XmNheight,&app_dy,NULL);
  screen_y = DisplayHeight(main_DISPLAY(state),main_SCREEN(state));
  app_dy = (screen_y - app_y - app_dy - 20*nchans);
  chan_min_y = (Dimension)(app_dy/(Dimension)nchans);
  if (chan_min_y > (Dimension)(state->channel_min_height)) chan_min_y = state->channel_min_height; else if (chan_min_y < 5) chan_min_y = 5;

  snd_slot = find_free_sound_slot(state,nchans); /* expands sound list if needed */
  if (state->sounds[snd_slot]) /* we're trying to re-use an old, inactive set of widgets and whatnot */
    {
      osp = state->sounds[snd_slot];
      old_chans = osp->allocated_chans;
    }
  else old_chans = 0;
  make_widgets = (state->sounds[snd_slot] == NULL);
  state->sounds[snd_slot] = make_snd_info(state->sounds[snd_slot],state,filename,hdr,snd_slot);
  sp = state->sounds[snd_slot];
  sp->inuse = 1;
  sx = sp->sgx;
  sx->file_pix = No_Pixmap;
  sp->bomb_ctr = 0;
  if (sx->snd_widgets == NULL) sx->snd_widgets = (Widget *)CALLOC(NUM_SND_WIDGETS,sizeof(Widget));
  sw = sx->snd_widgets;
  if ((!make_widgets) && (old_chans < nchans))
    {
      for (i=old_chans;i<nchans;i++) add_channel_window(sp,i,state,chan_min_y,1,NULL,WITH_FW_BUTTONS);
    }

  if (make_widgets)
    {
      need_colors = (!(state->using_schemes));

      if (sound_style(state) == SOUNDS_IN_SEPARATE_WINDOWS)
	{
	  title = (char *)CALLOC(128,sizeof(char));
	  sprintf(title,"%d: %s",snd_slot,sp->shortname);
	  if (sx->dialog == NULL)
	    {
	      n=0;
	      if (!(state->using_schemes)) n = background_basic_color(args,n,state);
	      XtSetArg(args[n],XmNautoUnmanage,FALSE); n++;
#if RESIZE_DIALOG
	      XtSetArg(args[n],XmNresizePolicy,XmRESIZE_GROW); n++;
	      XtSetArg(args[n],XmNnoResize,FALSE); n++;
#endif
	      XtSetArg(args[n],XmNtransient,FALSE); n++;
	      sx->dialog = XtCreateWidget(title,xmDialogShellWidgetClass,main_SHELL(state),args,n);
	      add_dialog(state,sx->dialog);
	      sound_delete = XmInternAtom(XtDisplay(sx->dialog),"WM_DELETE_WINDOW",FALSE);
	      XmAddWMProtocolCallback(sx->dialog,sound_delete,Close_Sound_Dialog,(XtPointer)sp);
	      add_popup_handler(sx->dialog);
	    }
	  else XtVaSetValues(sx->dialog,XmNtitle,title,NULL);
	  FREE(title);
	  if (!XtIsManaged(sx->dialog)) XtManageChild(sx->dialog);
	}

      n=0;      
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNallowResize,TRUE); n++;
      XtSetArg(args[n],XmNsashIndent,state->channel_sash_indent); n++;
      if (state->channel_sash_size != 0)
	{
	  XtSetArg(args[n],XmNsashHeight,state->channel_sash_size); n++;
	  XtSetArg(args[n],XmNsashWidth,state->channel_sash_size); n++;
	}

      /* if (mumble_style(state) == CHANNELS_HORIZONTAL) {XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;} */
      /* this doesn't work yet because the control panel is screwed up when trying to display itself horizontally */
      /* Perhaps another layer of panes? */

      if ((sound_style(state) != SOUNDS_IN_NOTEBOOK) && (sound_style(state) != SOUNDS_IN_SEPARATE_WINDOWS))
	if (state->listening != LISTENER_CLOSED) {XtSetArg(args[n],XmNpositionIndex,snd_slot); n++;}

      if (sound_style(state) == SOUNDS_IN_SEPARATE_WINDOWS)
	sw[W_snd_pane] = sndCreatePanedWindowWidget("snd-pane",sx->dialog,args,n);
      else sw[W_snd_pane] = sndCreatePanedWindowWidget("snd-pane",sound_PANE(state),args,n);

      XtAddCallback(sw[W_snd_pane],XmNhelpCallback,W_name_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_pane],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      /* if user clicks in controls, then starts typing, try to send key events to current active channel */
      /* all widgets in the control-pane that would otherwise intercept the key events get this event handler */

      for (i=0;i<nchans;i++) add_channel_window(sp,i,state,chan_min_y,0,NULL,WITH_FW_BUTTONS);
      
      n=0;      
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNpaneMinimum,state->ctrls_height); n++;
      XtSetArg(args[n],XmNpaneMaximum,state->ctrls_height); n++;
      sw[W_snd_ctrls] = sndCreateFormWidget ("snd-ctrls",sw[W_snd_pane],args,n);
      XtAddEventHandler(sw[W_snd_ctrls],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      sw[W_snd_name_form] = sndCreateFormWidget("snd-name-form",sw[W_snd_ctrls],args,n);
      XtAddCallback(sw[W_snd_name_form],XmNhelpCallback,W_name_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_name_form],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      n=0;      
      s1=XmStringCreate(shortname(sp),XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_highlight_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNshadowThickness,0); n++;
      XtSetArg(args[n],XmNhighlightThickness,0); n++;
      XtSetArg(args[n],XmNfillOnArm,FALSE); n++;
      sw[W_snd_name] = XtCreateManagedWidget ("snd-name",xmPushButtonWidgetClass,sw[W_snd_name_form],args,n);
      XtAddCallback(sw[W_snd_name],XmNhelpCallback,W_name_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_name],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);

      n=0;      
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_name]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelType,XmPIXMAP); n++;
      XtSetArg(args[n],XmNlabelPixmap,No_Pixmap); n++;
      sw[W_snd_name_icon] = XtCreateManagedWidget("",xmLabelWidgetClass,sw[W_snd_name_form],args,n);
#if HAVE_XPM
      if (!mini_lock_allocated)
	{ 
	  Pixmap shape1,shape2,shape3; 
	  XpmAttributes attributes; 
	  XpmColorSymbol symbols[1];
	  int scr,pixerr;
	  Display *dp;
	  Drawable wn;
	  dp = XtDisplay(sw[W_snd_name]);
	  wn = XtWindow(sw[W_snd_name]);
	  scr = DefaultScreen(dp);
	  XtVaGetValues(sw[W_snd_name],XmNdepth,&attributes.depth,XmNcolormap,&attributes.colormap,NULL);
	  attributes.visual = DefaultVisual(dp,scr);
	  symbols[0].name = "basiccolor";
	  symbols[0].value = NULL;
	  symbols[0].pixel = (state->sgx)->basic_color;
	  attributes.colorsymbols = symbols;
	  attributes.numsymbols = 1;
	  attributes.valuemask = XpmColorSymbols | XpmDepth | XpmColormap | XpmVisual;
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_lock_xpm,&mini_lock,&shape1,&attributes);
	  if (pixerr != XpmSuccess) snd_error("lock pixmap woe: %d\n",pixerr);

	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb0_xpm,&(mini_bombs[0]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb1_xpm,&(mini_bombs[1]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb2_xpm,&(mini_bombs[2]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb3_xpm,&(mini_bombs[3]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb4_xpm,&(mini_bombs[4]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb5_xpm,&(mini_bombs[5]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb6_xpm,&(mini_bombs[6]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb7_xpm,&(mini_bombs[7]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb8_xpm,&(mini_bombs[8]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb9_xpm,&(mini_bombs[9]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb10_xpm,&(mini_bombs[10]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb11_xpm,&(mini_bombs[11]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb12_xpm,&(mini_bombs[12]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb13_xpm,&(mini_bombs[13]),&shape2,&attributes);
	  pixerr = XpmCreatePixmapFromData(dp,wn,mini_bomb14_xpm,&(mini_bombs[14]),&shape2,&attributes);

	  XpmCreatePixmapFromData(dp,wn,mini_glass0_xpm,&(mini_glasses[0]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass1_xpm,&(mini_glasses[1]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass2_xpm,&(mini_glasses[2]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass3_xpm,&(mini_glasses[3]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass4_xpm,&(mini_glasses[4]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass5_xpm,&(mini_glasses[5]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass6_xpm,&(mini_glasses[6]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass7_xpm,&(mini_glasses[7]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass8_xpm,&(mini_glasses[8]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass9_xpm,&(mini_glasses[9]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass10_xpm,&(mini_glasses[10]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass11_xpm,&(mini_glasses[11]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass12_xpm,&(mini_glasses[12]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass13_xpm,&(mini_glasses[13]),&shape3,&attributes);
	  XpmCreatePixmapFromData(dp,wn,mini_glass14_xpm,&(mini_glasses[14]),&shape3,&attributes);
	  mini_lock_allocated = 1;
      }
#endif

      n=0;      
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNbottomWidget,sw[W_snd_name]); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_name_icon]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;
      XtSetArg(args[n],XmNwidth,20); n++; /* was 40 */
      XtSetArg(args[n],XmNseparatorType,XmSHADOW_ETCHED_IN); n++;
      sw[W_snd_info_sep] = XtCreateManagedWidget ("snd-info-sep",xmSeparatorWidgetClass,sw[W_snd_name_form],args,n);
      XtAddCallback(sw[W_snd_info_sep],XmNhelpCallback,W_info_sep_Help_Callback,state);

      n=0;
      s1=XmStringCreate("     ","button_font");
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNbottomWidget,sw[W_snd_info_sep]); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_info_sep]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNfontList,button_FONT(state)); n++;
      sw[W_snd_info_label] = XtCreateManagedWidget ("snd-info-label",xmLabelWidgetClass,sw[W_snd_name_form],args,n);
      XtAddCallback(sw[W_snd_info_label],XmNhelpCallback,W_info_Help_Callback,state);
      XmStringFree(s1);

      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_info_label]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNfontList,bold_button_FONT(state)); n++;
      XtSetArg(args[n],XmNresizeWidth,TRUE); n++;
      XtSetArg(args[n],XmNmarginHeight,1); n++;
      XtSetArg(args[n],XmNshadowThickness,0); n++;
#ifndef LESSTIF_VERSION
      XtSetArg(args[n],XmNcolumns,30); n++;
#else
      XtSetArg(args[n],XmNcolumns,50); n++;
#endif
      XtSetArg(args[n],XmNhighlightThickness,0); n++;
      sw[W_snd_info] = sndCreateTextFieldWidget(state,"snd-info",sw[W_snd_name_form],args,n,ACTIVATABLE,add_completer_func(info_completer));
      XtAddCallback(sw[W_snd_info],XmNhelpCallback,W_info_Help_Callback,state);
      info_ss = state;

      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
#if NEED_TOGGLE_MARGIN
      XtSetArg(args[n],XmNmarginHeight,TOGGLE_MARGIN); n++;
      XtSetArg(args[n],XmNmarginTop,TOGGLE_MARGIN); n++;
#endif
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNfontList,button_FONT(state)); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNselectColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_play] = sndCreateToggleButtonWidget(STR_play,sw[W_snd_name_form],args,n);
      XtAddCallback(sw[W_snd_play],XmNhelpCallback,W_play_Help_Callback,state);

      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
#if NEED_TOGGLE_MARGIN
      XtSetArg(args[n],XmNmarginHeight,TOGGLE_MARGIN); n++;
      XtSetArg(args[n],XmNmarginTop,TOGGLE_MARGIN); n++;
#endif
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNrightWidget,sw[W_snd_play]); n++;
      XtSetArg(args[n],XmNfontList,button_FONT(state)); n++;
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNselectColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_sync] = sndCreateToggleButtonWidget(STR_sync,sw[W_snd_name_form],args,n);
      XtAddCallback(sw[W_snd_sync],XmNhelpCallback,W_sync_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_sync],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNbottomWidget,sw[W_snd_sync]); n++;
#if NEED_TOGGLE_MARGIN
      XtSetArg(args[n],XmNmarginHeight,TOGGLE_MARGIN); n++;
      XtSetArg(args[n],XmNmarginTop,TOGGLE_MARGIN); n++;
#endif
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNrightWidget,sw[W_snd_sync]); n++;
      XtSetArg(args[n],XmNfontList,button_FONT(state)); n++;
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNselectColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_combine] = sndCreateToggleButtonWidget(STR_unite,sw[W_snd_name_form],args,n);
      XtAddCallback(sw[W_snd_combine],XmNhelpCallback,W_combine_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_combine],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      n=0;
      XtVaSetValues(sw[W_snd_ctrls],XmNskipAdjust,TRUE,NULL);

      /* tried a dial widget here, but it didn't seem to fit and was harder to manipulate and read than a scale */
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_name_form]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNmargin,LINE_MARGIN); n++;
      XtSetArg(args[n],XmNheight,LINE_MARGIN); n++;
      XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
      sw[W_snd_amp_separator] = XtCreateManagedWidget ("snd-amp-sep",xmSeparatorWidgetClass,sw[W_snd_ctrls],args,n);
      XtAddCallback(sw[W_snd_amp_separator],XmNhelpCallback,W_amp_Help_Callback,state);

      n=0;      
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_amp_separator]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      sw[W_snd_amp_form] = sndCreateFormWidget ("snd-amp",sw[W_snd_ctrls],args,n);
      XtAddEventHandler(sw[W_snd_amp_form],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      n=0;      
      /* AMP */
      s1=XmStringCreate(STR_amp_p,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      XtSetArg(args[n],XmNshadowThickness,0); n++;
      XtSetArg(args[n],XmNhighlightThickness,0); n++;
      XtSetArg(args[n],XmNfillOnArm,FALSE); n++;
      sw[W_snd_amp_label] = sndCreatePushButtonWidget ("amp-label",sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_amp_label],XmNhelpCallback,W_amp_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_amp_label],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);

      n=0;
      s1=XmStringCreate(number_one,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_amp_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_amp_label]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      sw[W_snd_amp_number] = XtCreateManagedWidget ("amp-number",xmLabelWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_amp_number],XmNhelpCallback,W_amp_Help_Callback,state);
      XmStringFree(s1);

      n=0;      
      if (need_colors) n = background_position_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_amp_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNheight,16); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_amp_number]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
      XtSetArg(args[n],XmNmaximum,SCROLLBAR_MAX); n++;
      XtSetArg(args[n],XmNvalue,SCROLLBAR_MID); n++;
      XtSetArg(args[n],XmNdragCallback,make_callback_list(W_amp_Drag_Callback,(XtPointer)sp)); n++;
      XtSetArg(args[n],XmNvalueChangedCallback,make_callback_list(W_amp_ValueChanged_Callback,(XtPointer)sp)); n++;
      sw[W_snd_amp] = XtCreateManagedWidget("amp",xmScrollBarWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_amp],XmNhelpCallback,W_amp_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_amp],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      n=0;
      /* SRATE */
      s1=XmStringCreate(STR_speed,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_amp_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++; 
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      XtSetArg(args[n],XmNshadowThickness,0); n++;
      XtSetArg(args[n],XmNhighlightThickness,0); n++;
      XtSetArg(args[n],XmNfillOnArm,FALSE); n++;
      sw[W_snd_srate_label] = sndCreatePushButtonWidget ("srate-label",sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_srate_label],XmNhelpCallback,W_srate_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_srate_label],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);

      n=0;
      switch (speed_style(state))
	{
	case SPEED_AS_RATIO: s1=XmStringCreate(ratio_one,XmFONTLIST_DEFAULT_TAG); break;
	case SPEED_AS_SEMITONE: s1=XmStringCreate(semitone_one,XmFONTLIST_DEFAULT_TAG); break;
	default: s1=XmStringCreate(number_one,XmFONTLIST_DEFAULT_TAG); break;
	}
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_srate_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_srate_label]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++; 
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      sw[W_snd_srate_number] = XtCreateManagedWidget ("srate-number",xmLabelWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_srate_number],XmNhelpCallback,W_srate_Help_Callback,state);
      XmStringFree(s1);

      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_srate_label]); n++;
      XtSetArg(args[n],XmNindicatorOn,FALSE); n++;
      XtSetArg(args[n],XmNlabelType,XmPIXMAP); n++;
      XtSetArg(args[n],XmNmarginHeight,0); n++;
      XtSetArg(args[n],XmNmarginWidth,0); n++;
      XtSetArg(args[n],XmNmarginTop,0); n++;
      XtSetArg(args[n],XmNtopOffset,0); n++;
      sw[W_snd_srate_arrow] = sndCreateToggleButtonWidget("dir",sw[W_snd_amp_form],args,n);
      form = sw[W_snd_srate_arrow];
      rb = XCreateBitmapFromData(XtDisplay(form),RootWindowOfScreen(XtScreen(form)),(const char *)speed_r_bits,16,12);
      lb = XCreateBitmapFromData(XtDisplay(form),RootWindowOfScreen(XtScreen(form)),(const char *)speed_l_bits,16,12);
      XtVaGetValues(form,XmNdepth,&depth,NULL);
      sx->speed_r = XCreatePixmap(XtDisplay(form),RootWindowOfScreen(XtScreen(form)),16,12,depth);
      sx->speed_l = XCreatePixmap(XtDisplay(form),RootWindowOfScreen(XtScreen(form)),16,12,depth);
      XCopyPlane(XtDisplay(form),rb,sx->speed_r,(state->sgx)->speed_gc,0,0,16,12,0,0,1);
      XCopyPlane(XtDisplay(form),lb,sx->speed_l,(state->sgx)->speed_gc,0,0,16,12,0,0,1);
      XFreePixmap(XtDisplay(form),rb);
      XFreePixmap(XtDisplay(form),lb);
      XtVaSetValues(form,XmNselectPixmap,sx->speed_l,XmNlabelPixmap,sx->speed_r,NULL);
      /* pretty damn tedious -- we can't use the bare pixmap because X dies sputtering incomprehensible jargon */
      XtAddCallback(sw[W_snd_srate_arrow],XmNhelpCallback,W_srate_arrow_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_srate_arrow],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      n=0;
      if (need_colors) n = background_position_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_srate_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_srate_number]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNrightWidget,sw[W_snd_srate_arrow]); n++;
      XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
      XtSetArg(args[n],XmNmaximum,1000); n++;
      XtSetArg(args[n],XmNvalue,450); n++;
      XtSetArg(args[n],XmNheight,16); n++;
      XtSetArg(args[n],XmNdragCallback,make_callback_list(W_srate_Drag_Callback,(XtPointer)sp)); n++;
      XtSetArg(args[n],XmNvalueChangedCallback,make_callback_list(W_srate_ValueChanged_Callback,(XtPointer)sp)); n++;
      sw[W_snd_srate] = XtCreateManagedWidget("srate",xmScrollBarWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_srate],XmNhelpCallback,W_srate_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_srate],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      n=0;
      /* EXPAND */
      s1=XmStringCreate(STR_expand,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_srate_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      XtSetArg(args[n],XmNshadowThickness,0); n++;
      XtSetArg(args[n],XmNhighlightThickness,0); n++;
      XtSetArg(args[n],XmNfillOnArm,FALSE); n++;
      sw[W_snd_expand_label] = sndCreatePushButtonWidget ("expand-label",sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_expand_label],XmNhelpCallback,W_expand_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_expand_label],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);
      
      n=0;
      s1=XmStringCreate(number_one,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_expand_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_expand_label]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      sw[W_snd_expand_number] = XtCreateManagedWidget ("expand-number",xmLabelWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_expand_number],XmNhelpCallback,W_expand_Help_Callback,state);
      XmStringFree(s1);
      
      n=0;
      s1=XmStringCreate("",XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_expand_label]); n++;
      XtSetArg(args[n],XmNheight,16); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNmarginWidth,0); n++;
      XtSetArg(args[n],XmNtopOffset,1); n++;
      XtSetArg(args[n],XmNspacing,0); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      if (state->toggle_size > 0) {XtSetArg(args[n],XmNindicatorSize,state->toggle_size); n++;}
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNselectColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_expand_button] = sndCreateToggleButtonWidget("expoff",sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_expand_button],XmNhelpCallback,W_expand_button_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_expand_button],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);

      n=0;
      if (need_colors) n = background_basic_color(args,n,state); /* was scale */
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_expand_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_expand_number]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNrightWidget,sw[W_snd_expand_button]); n++;
      XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
      XtSetArg(args[n],XmNmaximum,1000); n++;
      XtSetArg(args[n],XmNvalue,450); n++;
      XtSetArg(args[n],XmNheight,16); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNdragCallback,make_callback_list(W_expand_Drag_Callback,(XtPointer)sp)); n++;
      XtSetArg(args[n],XmNvalueChangedCallback,make_callback_list(W_expand_ValueChanged_Callback,(XtPointer)sp)); n++;
      sw[W_snd_expand] = XtCreateManagedWidget("",xmScrollBarWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_expand],XmNhelpCallback,W_expand_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_expand],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);


      /* CONTRAST */
      n=0;
      s1=XmStringCreate(STR_contrast,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_expand_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      XtSetArg(args[n],XmNshadowThickness,0); n++;
      XtSetArg(args[n],XmNhighlightThickness,0); n++;
      XtSetArg(args[n],XmNfillOnArm,FALSE); n++;
      sw[W_snd_contrast_label] = sndCreatePushButtonWidget ("contrast-label",sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_contrast_label],XmNhelpCallback,W_contrast_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_contrast_label],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);
      
      n=0;
      s1=XmStringCreate(number_zero,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_contrast_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_contrast_label]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      sw[W_snd_contrast_number] = XtCreateManagedWidget ("contrast-number",xmLabelWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_contrast_number],XmNhelpCallback,W_contrast_Help_Callback,state);
      XmStringFree(s1);
      
      n=0;
      s1=XmStringCreate("",XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_contrast_label]); n++;
      XtSetArg(args[n],XmNheight,16); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNmarginWidth,0); n++;
      XtSetArg(args[n],XmNtopOffset,1); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNspacing,0); n++;
      if (state->toggle_size > 0) {XtSetArg(args[n],XmNindicatorSize,state->toggle_size); n++;}
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNselectColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_contrast_button] = sndCreateToggleButtonWidget("conoff",sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_contrast_button],XmNhelpCallback,W_contrast_button_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_contrast_button],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);

      n=0;
      if (need_colors) n = background_basic_color(args,n,state); /* was scale */
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_contrast_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_contrast_number]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNrightWidget,sw[W_snd_contrast_button]); n++;
      XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
      XtSetArg(args[n],XmNheight,16); n++;
      XtSetArg(args[n],XmNvalue,0); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNdragCallback,make_callback_list(W_contrast_Drag_Callback,(XtPointer)sp)); n++;
      XtSetArg(args[n],XmNvalueChangedCallback,make_callback_list(W_contrast_ValueChanged_Callback,(XtPointer)sp)); n++;
      sw[W_snd_contrast] = XtCreateManagedWidget("",xmScrollBarWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_contrast],XmNhelpCallback,W_contrast_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_contrast],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      /* REVERB */
      /* REVSCL */
      n=0;
      s1=XmStringCreate(STR_reverb,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_contrast_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      XtSetArg(args[n],XmNshadowThickness,0); n++;
      XtSetArg(args[n],XmNhighlightThickness,0); n++;
      XtSetArg(args[n],XmNfillOnArm,FALSE); n++;
      sw[W_snd_revscl_label] = sndCreatePushButtonWidget ("revscl-label",sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_revscl_label],XmNhelpCallback,W_revscl_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_revscl_label],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);
      
      n=0;
      s1=XmStringCreate(number_long_zero,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_revscl_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_revscl_label]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      sw[W_snd_revscl_number] = XtCreateManagedWidget ("revscl-number",xmLabelWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_revscl_number],XmNhelpCallback,W_revscl_Help_Callback,state);
      XmStringFree(s1);
      
      n=0;
      if (need_colors) n = background_basic_color(args,n,state); /* was scale */
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_revscl_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_revscl_number]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
      XtSetArg(args[n],XmNrightPosition,60); n++;
      XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
      XtSetArg(args[n],XmNheight,16); n++;
      XtSetArg(args[n],XmNvalue,0); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNdragCallback,make_callback_list(W_revscl_Drag_Callback,(XtPointer)sp)); n++;
      XtSetArg(args[n],XmNvalueChangedCallback,make_callback_list(W_revscl_ValueChanged_Callback,(XtPointer)sp)); n++;
      sw[W_snd_revscl] = XtCreateManagedWidget("",xmScrollBarWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_revscl],XmNhelpCallback,W_revscl_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_revscl],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      /* REVOFF */
      n=0;
      s1=XmStringCreate("",XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_revscl_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNrightWidget,sw[W_snd_contrast_button]); n++;
      XtSetArg(args[n],XmNheight,16); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNmarginWidth,0); n++;
      XtSetArg(args[n],XmNtopOffset,1); n++;
      XtSetArg(args[n],XmNspacing,0); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      if (state->toggle_size > 0) {XtSetArg(args[n],XmNindicatorSize,state->toggle_size); n++;}
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNselectColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_reverb_button] = sndCreateToggleButtonWidget("revoff",sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_reverb_button],XmNhelpCallback,W_reverb_button_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_reverb_button],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);


      /* REVLEN */
      n=0;
      s1=XmStringCreate(STR_len,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_revscl]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
      XtSetArg(args[n],XmNleftPosition,60); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      XtSetArg(args[n],XmNshadowThickness,0); n++;
      XtSetArg(args[n],XmNhighlightThickness,0); n++;
      XtSetArg(args[n],XmNfillOnArm,FALSE); n++;
      sw[W_snd_revlen_label] = sndCreatePushButtonWidget("revlen-label",sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_revlen_label],XmNhelpCallback,W_revlen_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_revlen_label],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);

      n=0;
      s1=XmStringCreate(number_one,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_revlen_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_revlen_label]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      sw[W_snd_revlen_number] = XtCreateManagedWidget("revlen-number",xmLabelWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_revlen_number],XmNhelpCallback,W_revlen_Help_Callback,state);
      XmStringFree(s1);

      n=0;
      if (need_colors) n = background_basic_color(args,n,state); /* was scale */
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_revlen_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_revlen_number]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNrightWidget,sw[W_snd_reverb_button]); n++;
      XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
      XtSetArg(args[n],XmNheight,16); n++;
      XtSetArg(args[n],XmNvalue,20); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNdragCallback,make_callback_list(W_revlen_Drag_Callback,(XtPointer)sp)); n++;
      XtSetArg(args[n],XmNvalueChangedCallback,make_callback_list(W_revlen_ValueChanged_Callback,(XtPointer)sp)); n++;
      sw[W_snd_revlen] = XtCreateManagedWidget("",xmScrollBarWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_revlen],XmNhelpCallback,W_revlen_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_revlen],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);


      /* FILTER */
      n=0;
      s1=XmStringCreate(STR_filter,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_revscl_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      XtSetArg(args[n],XmNshadowThickness,0); n++;
      XtSetArg(args[n],XmNhighlightThickness,0); n++;
      XtSetArg(args[n],XmNfillOnArm,FALSE); n++;
#ifdef SGI
      sw[W_snd_filter_label] = XtCreateManagedWidget ("filter-label",xmPushButtonWidgetClass,sw[W_snd_amp_form],args,n);
#else
      sw[W_snd_filter_label] = XtCreateManagedWidget ("filter-label",xmLabelWidgetClass,sw[W_snd_amp_form],args,n);
#endif
      XtAddCallback(sw[W_snd_filter_label],XmNhelpCallback,W_filter_Help_Callback,state);
      XmStringFree(s1);

      /* filter order */
      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNresizeWidth,FALSE); n++;
      XtSetArg(args[n],XmNcolumns,3); n++;
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;	
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_filter_label]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_filter_label]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      XtSetArg(args[n],XmNrecomputeSize,FALSE); n++;
      sw[W_snd_filter_order] = sndCreateTextFieldWidget(state,"filter-order",sw[W_snd_amp_form],args,n,ACTIVATABLE,NO_COMPLETER);
      XmTextSetString(sw[W_snd_filter_order]," 20");
      XtAddCallback(sw[W_snd_filter_order],XmNhelpCallback,W_filter_order_Help_Callback,state);

      #define ARROW_SIZE 12

      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_filter_order]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_filter_order]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNheight,ARROW_SIZE); n++;
      XtSetArg(args[n],XmNwidth,ARROW_SIZE); n++;
      XtSetArg(args[n],XmNborderWidth,0); n++;
      XtSetArg(args[n],XmNmarginWidth,0); n++;
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNarmColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_filter_order_down] = sndCreatePushButtonWidget("",sw[W_snd_amp_form],args,n);
      XtAddEventHandler(sw[W_snd_filter_order_down],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XtAddCallback(sw[W_snd_filter_order_down],XmNhelpCallback,W_filter_order_down_Help_Callback,state);

      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_filter_order_down]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_filter_order]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNheight,ARROW_SIZE); n++;
      XtSetArg(args[n],XmNwidth,ARROW_SIZE); n++;
      XtSetArg(args[n],XmNborderWidth,0); n++;
      XtSetArg(args[n],XmNmarginWidth,0); n++;
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNarmColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_filter_order_up] = sndCreatePushButtonWidget("",sw[W_snd_amp_form],args,n);
      XtAddEventHandler(sw[W_snd_filter_order_up],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XtAddCallback(sw[W_snd_filter_order_up],XmNhelpCallback,W_filter_order_up_Help_Callback,state);

      n=0;
      s1=XmStringCreate("",XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_reverb_button]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNheight,16); n++;
      XtSetArg(args[n],XmNmarginWidth,0); n++;
      XtSetArg(args[n],XmNtopOffset,2); n++;
      XtSetArg(args[n],XmNspacing,0); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++; 
      if (state->toggle_size > 0) {XtSetArg(args[n],XmNindicatorSize,state->toggle_size); n++;}
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNselectColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_filter_button] = sndCreateToggleButtonWidget("fltoff",sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_filter_button],XmNhelpCallback,W_filter_button_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_filter_button],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);

      n=0;
      s1=XmStringCreate(STR_dB,XmFONTLIST_DEFAULT_TAG);
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_filter_button]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNrightWidget,sw[W_snd_filter_button]); n++;
      XtSetArg(args[n],XmNlabelString,s1); n++; 
      XtSetArg(args[n],XmNvalue,sp->filter_dBing); n++;
      if (state->toggle_size > 0) {XtSetArg(args[n],XmNindicatorSize,state->toggle_size); n++;}
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNselectColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_filter_dB] = sndCreateToggleButtonWidget("fltdB",sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_filter_dB],XmNhelpCallback,W_filter_dB_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_filter_dB],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);
      XmStringFree(s1);

      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNfontList,bold_button_FONT(state)); n++;
      XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_filter_order_down]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNleftWidget,sw[W_snd_filter_order_down]); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNrightWidget,sw[W_snd_filter_dB]); n++;
      XtSetArg(args[n],XmNmarginHeight,CONTROLS_MARGIN); n++;
      sw[W_snd_filter] = sndCreateTextFieldWidget(state,"filter-window",sw[W_snd_amp_form],args,n,ACTIVATABLE,add_completer_func(filename_completer));
      XtAddCallback(sw[W_snd_filter],XmNhelpCallback,W_filter_envelope_Help_Callback,state);

      #define LEFT_SPACE 3
      #define INTER_SPACE 30

      /* RECORD */
      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
      XtSetArg(args[n],XmNleftPosition,LEFT_SPACE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNselectColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_record] = sndCreateToggleButtonWidget(STR_Record,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_record],XmNhelpCallback,W_record_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_record],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      /* REPLAY */
      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
      XtSetArg(args[n],XmNleftPosition,LEFT_SPACE + INTER_SPACE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNselectColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_replay] = sndCreateToggleButtonWidget(STR_Replay,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_replay],XmNhelpCallback,W_replay_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_replay],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      /* APPLY */
      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
      XtSetArg(args[n],XmNleftPosition,LEFT_SPACE + 2*INTER_SPACE); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNselectColor,(state->sgx)->pushed_button_color); n++;}
      sw[W_snd_apply] = sndCreateToggleButtonWidget(STR_Apply,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_apply],XmNhelpCallback,W_apply_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_apply],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      /* SET */
      n=0;
      if (need_colors) 
	{
	  n = background_basic_color(args,n,state);
	  XtSetArg(args[n],XmNarmColor,(state->sgx)->pushed_button_color); n++;
	  XtSetArg(args[n],XmNfillOnArm,TRUE); n++;
	}
      XtSetArg(args[n],XmNfontList,button_FONT(state)); n++;
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
      XtSetArg(args[n],XmNleftPosition,90); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      sw[W_snd_set] = XtCreateManagedWidget(STR_s,xmPushButtonWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_set],XmNhelpCallback,W_set_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_set],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      /* RESET */
      n=0;
      if (need_colors) 
	{
	  n = background_basic_color(args,n,state);
	  XtSetArg(args[n],XmNarmColor,(state->sgx)->pushed_button_color); n++;
	  XtSetArg(args[n],XmNfillOnArm,TRUE); n++;
	}
      XtSetArg(args[n],XmNfontList,button_FONT(state)); n++;
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
      XtSetArg(args[n],XmNleftPosition,95); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_NONE); n++;
      sw[W_snd_reset] = XtCreateManagedWidget(STR_r,xmPushButtonWidgetClass,sw[W_snd_amp_form],args,n);
      XtAddCallback(sw[W_snd_reset],XmNhelpCallback,W_reset_Help_Callback,state);
      XtAddEventHandler(sw[W_snd_reset],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

      /* RECORD SEPARATOR */
      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNbottomWidget,sw[W_snd_record]); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNmargin,LINE_MARGIN); n++;
      XtSetArg(args[n],XmNheight,LINE_MARGIN); n++;
      XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
      sw[W_snd_record_sep] = XtCreateManagedWidget("snd-rec-sep",xmSeparatorWidgetClass,sw[W_snd_amp_form],args,n);

      /* FILTER GRAPH */
      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNtopWidget,sw[W_snd_filter]); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
      XtSetArg(args[n],XmNbottomWidget,sw[W_snd_record_sep]); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
      XtSetArg(args[n],XmNleftPosition,4); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
      XtSetArg(args[n],XmNrightPosition,98); n++;
      XtSetArg(args[n],XmNallowResize,TRUE); n++;
      if (!(state->using_schemes)) {XtSetArg(args[n],XmNbackground,(state->sgx)->basic_color); n++;}
      XtSetArg(args[n],XmNshadowType,XmSHADOW_ETCHED_IN); n++;
      XtSetArg(args[n],XmNshadowThickness,4); n++;
      sw[W_snd_filter_frame] = sndCreateFrameWidget("filter-frame",sw[W_snd_amp_form],args,n);

      n=0;
      if (need_colors) n = background_basic_color(args,n,state);
      XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
      XtSetArg(args[n],XmNallowResize,TRUE); n++;
      sw[W_snd_filter_env] = sndCreateDrawingAreaWidget("filter-window",sw[W_snd_filter_frame],args,n);
      XtAddCallback(sw[W_snd_filter_env],XmNhelpCallback,filter_drawer_help_Callback,state);

      (sp->sgx)->flt = new_flt(sw[W_snd_filter_env]);

      XtAddEventHandler(sw[W_snd_filter_env],ButtonPressMask,FALSE,filter_drawer_button_press,sp);
      XtAddEventHandler(sw[W_snd_filter_env],ButtonMotionMask,FALSE,filter_drawer_button_motion,sp);
      XtAddEventHandler(sw[W_snd_filter_env],ButtonReleaseMask,FALSE,filter_drawer_button_release,sp);
      XtAddEventHandler(sw[W_snd_filter_env],KeyPressMask,FALSE,graph_key_press,(XtPointer)sp);

#if (XmVERSION > 1)
      if (sound_style(state) == SOUNDS_IN_NOTEBOOK)
	{
	  char name[MAX_NOTEBOOK_TAB_LENGTH+11];
	  strncpy(name,just_filename(sp->shortname),MAX_NOTEBOOK_TAB_LENGTH);
	  name[MAX_NOTEBOOK_TAB_LENGTH]='\0';
	  n = 0;
	  if (need_colors) {XtSetArg(args[n],XmNbackground,(state->sgx)->graph_color); n++;}
	  XtSetArg(args[n],XmNnotebookChildType,XmMAJOR_TAB); n++;
	  sx->tab = XtCreateManagedWidget(name,xmPushButtonWidgetClass,sound_PANE(state),args,n);
	}
#endif

    } /* new sound state */
  else
    { /* re-manage currently inactive chan */
      if (sound_style(state) != SOUNDS_IN_SEPARATE_WINDOWS)
	XtVaSetValues(sw[W_snd_ctrls],XmNpaneMinimum,state->ctrls_height,XmNpaneMaximum,state->ctrls_height,NULL);
      else 
	{
	  title = (char *)CALLOC(128,sizeof(char));
	  sprintf(title,"%d: %s",snd_slot,sp->shortname);
	  XtVaSetValues(sx->dialog,XmNtitle,title,NULL);
	  FREE(title);
	  if (!XtIsManaged(sx->dialog)) XtManageChild(sx->dialog);
	}
      for (i=0;i<NUM_SND_WIDGETS;i++)
	if ((sw[i]) && (!XtIsManaged(sw[i]))) 
	  XtManageChild(sw[i]);
      for (k=0;k<nchans;k++) 
	add_channel_window(sp,k,state,chan_min_y,0,NULL,WITH_FW_BUTTONS);
      make_name_label(sw[W_snd_name],shortname(sp));
      if (sound_style(state) != SOUNDS_IN_SEPARATE_WINDOWS)
	XtVaSetValues(sw[W_snd_ctrls],XmNpaneMinimum,1,XmNpaneMaximum,1000,NULL);
#if (XmVERSION > 1)
      if (sound_style(state) == SOUNDS_IN_NOTEBOOK)
	{
	  make_name_label(sx->tab,just_filename(sp->shortname));
	}
#endif
    }
  if (sp->nchans == 1) 
    {
      XmToggleButtonSetState(w_snd_combine(sp),FALSE,FALSE);
      XtUnmanageChild(w_snd_combine(sp));
    }
  add_sound_data(filename,sp,state);
  add_sound_callbacks(sw,(XtPointer)sp);
  reflect_control_panel_defaults(state,sp); /* expects active callbacks */

  snd_file_lock_icon(sp,(state->viewing || (cant_write(sp->fullname)))); /* sp->read_only not set yet */
  if (samples_per_channel > 100000) start_amp_env(sp,0);
  state->pending_open = NULL;
  if (state->pending_change)
    {
      sprintf(snd_txt_buf,"(translated %s)",old_name);
      report_in_minibuffer(sp,snd_txt_buf);
    }
  if (!(state->using_schemes)) map_over_children(sound_PANE(state),color_sashes,(void *)state);
  if (!(auto_resize(state))) normalize_all_sounds(state);
  
  if (first_window)
    {
      /* try to get the pane height that shows everything except the filter graph (hidden for my amusement) */
      /* this calculation assumes the window is built amp_form down, then record buttons up, then filter_frame */
      Position fey,cy,rsy;
      XtVaGetValues(sw[W_snd_amp_form],XmNy,&cy,NULL);
      XtVaGetValues(sw[W_snd_filter_frame],XmNy,&fey,NULL);
      XtVaGetValues(sw[W_snd_record_sep],XmNy,&rsy,NULL);
      state->open_ctrls_height = fey + ((rsy<0) ? (-rsy) : rsy) + cy - 1;
      first_window = 0;
    } 
  if (sound_style(state) != SOUNDS_IN_SEPARATE_WINDOWS)
    {
      if (make_widgets) XtVaSetValues(sw[W_snd_ctrls],XmNpaneMaximum,1000,NULL); /* locked above to force correct initial setup */
    }
  else 
    {
      XtVaSetValues(sx->dialog,XmNwidth,100,XmNheight,100,NULL);
      /* this is not redundant -- apparently they're trying to ignore size resets to the "current" */
      /* value, but forgot that unmanage/remanage does not return to the previous size */
      XtVaSetValues(sx->dialog,XmNwidth,(Dimension)(snd_window_width(state)),XmNheight,(Dimension)(snd_window_height(state) / 2),NULL);
    }
  return(sp);
}

void snd_info_cleanup(snd_info *sp)
{
  snd_context *sx;
  if ((sp) && (sp->sgx))
    {
      sx = sp->sgx;
      if (w_snd_sync(sp))
	{
	  XtVaSetValues(w_snd_sync(sp),XmNset,FALSE,NULL);
	  XtVaSetValues(w_snd_expand_button(sp),XmNset,FALSE,NULL);
	  XtVaSetValues(w_snd_contrast_button(sp),XmNset,FALSE,NULL);
	  XtVaSetValues(w_snd_srate_arrow(sp),XmNset,FALSE,NULL);
	  XtVaSetValues(w_snd_filter_button(sp),XmNset,FALSE,NULL);
	  XtVaSetValues(w_snd_reverb_button(sp),XmNset,FALSE,NULL);
	  XmToggleButtonSetState(w_snd_combine(sp),FALSE,FALSE);
	  sp->combining = CHANNELS_SEPARATE; 
	  remove_sound_callbacks(sp);
#if (XmVERSION > 1)
	  if (sound_style(sp->state) == SOUNDS_IN_NOTEBOOK)
	    {
	      make_name_label((sp->sgx)->tab,"none");
	    }
#endif
	  XtUnmanageChild(w_snd_pane(sp));
	}
      if ((sx->dialog) && (XtIsManaged(sx->dialog))) XtUnmanageChild(sx->dialog);
    }
}

void unlock_ctrls(snd_info *sp) {XtVaSetValues(w_snd_ctrls(sp),XmNpaneMinimum,1,NULL);}

static void replay_amp_callback(XtPointer clientData, XtIntervalId *id) {replay_amp((void *)clientData);}
void call_replay_amp(snd_state *ss, XtPointer ap,int time) {XtAppAddTimeOut(main_APP(ss),time,replay_amp_callback,ap);}

static void replay_speed_callback(XtPointer clientData, XtIntervalId *id) {replay_speed((void *)clientData);}
void call_replay_speed(snd_state *ss, XtPointer ap,int time) {XtAppAddTimeOut(main_APP(ss),time,replay_speed_callback,ap);}

static void replay_expand_callback(XtPointer clientData, XtIntervalId *id) {replay_expand((void *)clientData);}
void call_replay_expand(snd_state *ss, XtPointer ap,int time) {XtAppAddTimeOut(main_APP(ss),time,replay_expand_callback,ap);}

static void replay_contrast_callback(XtPointer clientData, XtIntervalId *id) {replay_contrast((void *)clientData);}
void call_replay_contrast(snd_state *ss, XtPointer ap,int time) {XtAppAddTimeOut(main_APP(ss),time,replay_contrast_callback,ap);}

static void replay_reverb_callback(XtPointer clientData, XtIntervalId *id) {replay_reverb((void *)clientData);}
void call_replay_reverb(snd_state *ss, XtPointer ap,int time) {XtAppAddTimeOut(main_APP(ss),time,replay_reverb_callback,ap);}

static void replay_direction_callback(XtPointer clientData, XtIntervalId *id) {replay_direction((void *)clientData);}
void call_replay_direction(snd_state *ss, XtPointer ap,int time) {XtAppAddTimeOut(main_APP(ss),time,replay_direction_callback,ap);}

void set_apply_button(snd_info *sp, int val) {XmToggleButtonSetState(w_snd_apply(sp),val,FALSE);}

void normalize_sound(snd_state *ss, snd_info *sp, snd_info *osp, chan_info *ncp)
{
  /* make sp look ok, squeezing others if needed; called only if normalize_on_open(ss) */
  /* if there's already enough (i.e. ss->channel_min_height), just return */
  /* this is used in goto_next_graph and goto_previous_graph (snd-chn.c) to open windows that are currently squeezed shut */
  float val,size,high,low;
  Dimension chan_y;
  int *wid;
  Widget wcp;
  chan_info *cp = NULL;

  if ((!ss) || (!sp) || (!(normalize_on_open(ss))) || (sound_style(ss) == SOUNDS_IN_SEPARATE_WINDOWS)) return;
  if (sound_style(ss) != SOUNDS_HORIZONTAL)
    {
      /* several attempts to be fancy here just made a mess of the display */
      XtVaGetValues(channel_main_pane(ncp),XmNheight,&chan_y,NULL);
      if (chan_y < (Dimension)(ss->channel_min_height>>1)) 
	{
	  wid = (int *)CALLOC(1,sizeof(int));
	  (*wid) = (ss->channel_min_height>>1) + 10;
	  channel_lock_pane(ncp,(void *)wid);
	  channel_open_pane(ncp,NULL);
	  channel_unlock_pane(ncp,NULL);
	  FREE(wid);
	  wid = NULL;
	}
    }
  else
    {
      XtVaGetValues(channel_main_pane(ncp),XmNwidth,&chan_y,NULL);
      if (chan_y < 200)
	{
	  XtUnmanageChild(channel_main_pane(ncp));
	  XtVaSetValues(channel_main_pane(ncp),XmNwidth,200,NULL);
	  XtManageChild(channel_main_pane(ncp));
	}
    }
  if (sp->combining == CHANNELS_COMBINED)
    {
      cp = any_selected_channel(sp);
      high = (float)(sp->nchans - cp->chan)/(float)sp->nchans;
      low = high - 1.0/(float)sp->nchans;
      cp = sp->chans[0];
      wcp = channel_gsy(cp);
      val = (float)get_raw_value(wcp)/(float)(SCROLLBAR_MAX);
      size = (float)get_raw_size(wcp)/(float)(SCROLLBAR_MAX);
      if ((val > low) || ((val+size) < high))
	{
	  val = low;
	  if ((val+size) > 1.0) val = 1.0 - size;
	  set_raw_value(wcp,(int)(val*SCROLLBAR_MAX));
	  gsy_changed((int)(val*SCROLLBAR_MAX),cp);
	}
    }
}

/* -------- PROGRESS REPORT -------- */
/*
 * if no xpm, send a string, else post an hourglass
 */

#if (!(HAVE_XPM))
static char expr_str[128];

static void report_in_minibuffer_and_check_for_stop(snd_info *sp, char *message)
{
  report_in_minibuffer(sp,message);
  check_for_event(sp->state);
}
#endif

void progress_report(snd_state *ss, snd_info *sp, char *funcname, int curchan, int chans, float pct, int from_enved)
{
  int which;
#if HAVE_XPM
  which = (int)(pct * NUM_GLASSES);
  if (which >= NUM_GLASSES) which = NUM_GLASSES-1;
  if (which < 0) which = 0;
  if (from_enved)
    display_enved_progress(ss,NULL,mini_glasses[which]);
  else snd_file_glasses_icon(sp,TRUE,which);
#else
  which = (int)(100.0 * pct);
  if (chans > 1)
    sprintf(expr_str,"%s: (%d of %d) %d%%",funcname,curchan,chans,which);
  else sprintf(expr_str,"%s: %d%%",funcname,which);
  if (from_enved)
    display_enved_progress(ss,expr_str,0);
  else report_in_minibuffer_and_check_for_stop(sp,expr_str);
#endif
}

void finish_progress_report(snd_state *ss, snd_info *sp, int from_enved)
{
#if HAVE_XPM
  if (from_enved)
    display_enved_progress(ss,NULL,No_Pixmap);
  else snd_file_glasses_icon(sp,FALSE,0);
#else
  if (ss->stopped_explicitly) sprintf(expr_str,"stopped"); else expr_str[0]='\0';
  if (from_enved)
    display_enved_progress(ss,expr_str,0);
  else report_in_minibuffer_and_check_for_stop(sp,expr_str);
#endif
}

void start_progress_report(snd_state *ss, snd_info *sp, int from_enved)
{
#if HAVE_XPM
  if (!(from_enved)) snd_file_glasses_icon(sp,TRUE,0);
#else
  if (from_enved)
    {
      expr_str[0]='\0';
      display_enved_progress(ss,expr_str,0);
    }
#endif
}


void color_filter_waveform(snd_state *ss, Pixel color)
{
  int i;
  snd_info *sp;
  XSetForeground(main_DISPLAY(ss),(ss->sgx)->fltenv_data_gc,color);
  for (i=0;i<ss->max_sounds;i++)
    {
      sp = ss->sounds[i];
      if ((sp) && (sp->inuse)) sp_display_env(sp,(spflt *)((sp->sgx)->flt));
    }
}
