#
#  $Id: user.py,v 1.1 1999/12/11 12:35:11 rob Exp $
#
#  Copyright 1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""
"""

__version__ = '$Id: user.py,v 1.1 1999/12/11 12:35:11 rob Exp $'

__copyright__ = 'Copyright 1999 Rob Tillotson <robt@debian.org>'

import sys, os, string
from whrandom import randint

import Pyrite
from Pyrite import _
from Pyrite.Application import Application
from Sulfur.Options import Boolean, String, Integer, O_NOCONFIG, O_NONINTERACTIVE, O_MULTIPLE

class App(Application):
    name = 'Pyrite User Manager'
    version = Pyrite.version
    author = Pyrite.author
    description = _("Manage users.")

    options = [
	Boolean('list', 0, _("list known users"), None,
		(O_NONINTERACTIVE, O_NOCONFIG), ['list', 'l']),
	String('query', '', _("query a user"), None,
	       (O_NONINTERACTIVE, O_NOCONFIG), ['query', 'q']),
	Boolean('add', 0, _("add a new user (by connecting to the handheld)"), None,
		(O_NONINTERACTIVE, O_NOCONFIG), ['add', 'a']),
	Boolean('initialize', 0, _("initialize a new handheld"), None,
		(O_NONINTERACTIVE, O_NOCONFIG), ['init', 'i']),
	]

    def __init__(self):
	Application.__init__(self)

	self.config_path = 'Pyrite::UserManager'

    def new_handheld(self, argv):
	n = ''
	id = 0
	if len(argv) >= 2:
	    n = argv[0]
	    try:
		id = int(argv[1])
	    except:
		print _("'%s' is not an integer") % argv[1]
	elif len(argv) == 1:
	    n = argv[0]

	if not n:
	    while 1:
		print
		n = string.strip(raw_input(_("Please name this handheld: ")))
		print
		print _("You have chosen to name this handheld '%s'.") % n
		yn = string.strip(raw_input(_("Is this correct [Y/n]? ")))
		print
		if not yn or string.lower(yn) in [_("yes"), _("y")]:
		    break
	    
	if not id:
	    uid = (randint(0, 65535) << 16 | randint(0,65535))
	    print _("Assigned UID #%d") % uid
	    
	print _("Sorry, this doesn't really do anything yet.")
	
    def run(self, argv):
	if self.get_option('list'):
	    for i in self.user_list():
		print "%10d  %s" % (i, self.user_name(i))
		
	elif self.get_option('query'):
	    q = self.get_option('query')
	    try:
		i = int(q)
		if self.user_exists(i):
		    print "%10d  %s" % (i, self.user_name(i))
		else:
		    print _("user #%d is unknown") % i
	    except:
		i = self.user_lookup(q)
		if i:
		    print "%10d  %s" % (i, self.user_name(i))
		else:
		    print _("user '%s' is unknown") % q

	elif self.get_option('add'):
	    # most of this is done inside the Application object
	    remote = self.connect(1)
	    self.disconnect()
	    
	elif self.get_option('initialize'):
	    self.new_handheld(argv)

	else:
	    print "%10d  %s" % (self.uid, self.user)
	    
