/* Gnometoaster's semaphore handling code
 * it's complexity actually deserves a separate file,esp. as it'll be easier
 * to find a starting point in the attempt to convert gnometoaster to other
 * platforms that way */

#ifndef SEMS_H
#define SEMS_H

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>

#include "main.h"

/* allow for a maximum of 8 semaphores in gnometoaster */
#define SEMS_MAXCOUNT 8

/* init the semaphore code and allocate a set of semaphores for gnometoaster */
void sems_init();
/* get a new semaphore,quits gnometoaster if no more semaphores are available
 * Semaphores cannot be freed. you'll get a semaphore for life. */
int sems_allocate();
/* lock a semaphore */
void sems_lock(int semnum);
/* unlock a semaphore */
void sems_unlock(int semnum);
/* free our semaphore set as semaphores are global constructs which do not
 * get freed automatically on exit */
void sems_destroy();

#endif // SEMS_H
