/* The Filesystem destination Widget */

#include <gtk/gtk.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <dirent.h>

#include "int.h"

#include "preferences.h"
#include "main.h"
#include "getdir.h"
#include "filelist.h"
#include "fsedit.h"
#include "fileman.h"
#include "treedroppatch.h"
#include "varmanwidgets.h"
#include "dircache.h"
#include "updatehandlers.h"
#include "menusys.h"
#include "preview.h"
#include "multisession.h"

/* uncomment for debugging */
/* #define DEBUG */

GtkWidget *fsedit;
filelist_info *content;
GtkWidget *tree;
GtkWidget *rootitem;
GList *fsedit_updatehandlers=NULL;

/* the following function would usually be placed within the drop handler,
 * however if you try to remove a widget whose drop handler is currently
 * running you get the most interesting results... */
gint fsedit_updatedisplay(gpointer data)
{
	GtkTreeItem *treeentry;
	
	treeentry=content->treeentry;
	
	if (treeentry->expanded)
	  {
		  gtk_tree_item_collapse(treeentry);
		  gtk_tree_item_expand(treeentry);
	  }
	;
	gtk_tree_item_deselect(treeentry);
	gtk_tree_item_select(treeentry);
	
	updatehandlers_call(fsedit_updatehandlers);
	return 0;
}
;

/* drophandler now takes x and y corrdinates of the pointer.
 * Those are not required here,though */
void fsedit_drophandler(char *s,int x,int y)
{
	int success;
	
	success=fileman_add_items(s,(char*)&content->path);
	if (success)  // apply changes to the display
	  {
		  gtk_timeout_add(0,
				  fsedit_updatedisplay,
				  NULL);
	  }
	;		
}
;

int fsedit_setbootimage(char *s,char *p)
{
   char *filename;
   
   filename=strchr(s,':');
   if (filename==NULL)
     filename="";
   else
     filename++;
   filename=filename+strlen(FSEDIT_DESTPATH);
   /* cut '/' as well */
   if (FSEDIT_DESTPATH[strlen(FSEDIT_DESTPATH)-1]!='/')
     filename++;   
   varman_setvar(global_defs,"isotrack_bootimage",filename);
   /* convenience - once a user selects a bootimage,it is very likely
    * he's gonna want to use it as well */
   varman_setvar(global_defs,"isotrack_makebootable","true");
   return 1;
};

void fsedit_selectbootimage(GtkWidget *w,selectlist_info *info)
{
   fileman_selectionhandler(selectlist_getselection(info),"",
			    fsedit_setbootimage);
};

void fsedit_mkdirhandler(GtkWidget *w,selectlist_info *info)
{	
	/* call fileman_mkdir_dialog with the current path.
	 * This will ask the user to enter a directory name.
	 * Once this is done mkdir_dialog will create the directory requested
	 * and call fsedit_updatedisplay as an indication that the process
	 * has finished and that the program can now return to its normal
	 * state of operation. */	
	fileman_mkdir_dialog((char*)&content->path,
			     GTK_SIGNAL_FUNC(fsedit_updatedisplay),NULL);
}
;

void fsedit_removehandler(GtkWidget *w,selectlist_info *info)
{
	int success;
        char *files;

        files=selectlist_getselection(info);
#ifdef DEBUG
	printf ("fsedit_removehandler: removing\n %s\n",
		files);
#endif
	success=fileman_remove_items(files);
	if (success)  // apply changes to the display
	  {
		  gtk_timeout_add(0,
				  fsedit_updatedisplay,
				  NULL);
	  }
	;		
}
;

int fsedit_doubleclickfile(char *s,char *p)
{
   char dirname[256];	

   if (dircache_isdir((char*)(strchr(s,":"[0])+1)))
     {
	fileman_strippath((char*)(strchr(s,":"[0])+1),
			  (char*)&dirname);
	getdir_selectsubdir(GTK_WIDGET(content->treeentry),
			    (char*)&dirname);
     }
   else
     {
	/* play file if the user double-clicks on it */
	preview_playtrack(s,&preview_info);
#ifdef DEBUG
	printf ("fsedit_doubleclickfile: starting media player \n");
#endif
	
     };	
   return 1;
}
;

void fsedit_doubleclick(selectlist_info *info)
{
	fileman_selectionhandler(selectlist_getselection(info),
				 NULL,fsedit_doubleclickfile);
}
;

void fsedit_treedrop(GtkWidget *w,void *data)
{
	getdir_dirinfo *info;
	
	info=(getdir_dirinfo*)data;
	if (fileman_add_items(info->recdata,
			     (char*)&info->dirname))
	  {		  
		  if (GTK_TREE_ITEM(w)->expanded)
		    {
			    gtk_tree_item_collapse(GTK_TREE_ITEM(w));
			    gtk_tree_item_expand(GTK_TREE_ITEM(w));
		    }
		  ;
		  if (!strcmp((char*)&info->dirname,(char*)&content->path))
		    {			    
			    gtk_tree_item_deselect(GTK_TREE_ITEM(w));
			    gtk_tree_item_select(GTK_TREE_ITEM(w));
		    }
		  ;
		  
		  updatehandlers_call(fsedit_updatehandlers);
	  }
	;
}
;

static menusys_menu fsedit_filelistpopup[]=
{
	MENUSYS_ITEM_NONE(N_("Delete File(s)"),N_("Delete marked file(s)/director(y/ies)"),fsedit_removehandler),
	MENUSYS_ITEM_NONE(N_("Create Directory"),N_("Create a directory within the current file list"),fsedit_mkdirhandler),
        MENUSYS_ITEM_NONE(N_("Make Boot Image"),N_("Make current cd bootable using this boot image"),fsedit_selectbootimage),
	MENUSYS_ITEM_END
}
;

void fsedit_cb_filelistselect(GtkWidget *w,getdir_dirinfo *i)
{
	content=filelist_create((char*)&i->dirname,
				/* display vdir */
				(multisession_lastsession!=NULL)
				?virtualdir_finddir(multisession_lastsession,						   
						    &((char*)&i->dirname)[strlen(FSEDIT_DESTPATH)])
				:NULL,
				fsedit_drophandler,FALSE,
				fsedit_filelistpopup,
				GTK_TREE_ITEM(w),
				fsedit_doubleclick
				);
	gtk_paned_add2(GTK_PANED(fsedit),content->widget);
	gtk_widget_show(content->widget);

}
;

void fsedit_cb_filelistdeselect(GtkWidget *w,getdir_dirinfo *i)
{
	filelist_destroy(content);
}
;


int fsedit_treeremove_update(void *data)
{
	getdir_dirinfo *info;
	
	GtkTreeItem *host;
		
	info=(getdir_dirinfo*)data;
	
	host=GTK_TREE_ITEM(info->parent);
	
	gtk_tree_item_collapse(host);
	gtk_tree_item_expand(host);
	/* if the host dir is currently displayed on the right side,
	 * update the right side as well */
	if (host==content->treeentry)
	  {
		  gtk_tree_item_deselect(GTK_TREE_ITEM(host));
		  gtk_tree_item_select(GTK_TREE_ITEM(host));
	  }
	;
	
	updatehandlers_call(fsedit_updatehandlers);
	return 0;
}
;

void fsedit_treeremove(GtkWidget *w,void *data)
{
	getdir_dirinfo *info;
	
	char item[1024];
		
	info=(getdir_dirinfo*)data;

	/* remove the select item only if it is not the root tree */
	if (info->parent!=NULL)
	  {		  
		  strcpy((char*)&item,"file:");
		  strcat((char*)&item,(gchar*)&info->dirname);
		  strcat((char*)&item,CRLF);
		  if (fileman_remove_items((char*)&item))
		    {
			    gtk_timeout_add(0,
					    fsedit_treeremove_update,
					    data);
		    }
		  ;
	  }
	;
}
;

void fsedit_treemkdir_update(gpointer data)
{
	getdir_dirinfo *info;
	
	info=(getdir_dirinfo*)data;

	/* update subdir informations */	
	if ( (GTK_TREE_ITEM_SUBTREE(info->referringto)==NULL) &&
	     (dircache_subdirentries((char*)&info->dirname)>0) )
	  {
		  gtk_tree_item_set_subtree(GTK_TREE_ITEM(info->referringto),
					    gtk_tree_new());
	  }
	;
	if (GTK_TREE_ITEM(info->referringto)->expanded)
	  {
		  gtk_tree_item_collapse(GTK_TREE_ITEM(info->referringto));
		  gtk_tree_item_expand(GTK_TREE_ITEM(info->referringto));
	  }
	;
	if (!strcmp((char*)&info->dirname,(char*)&content->path))
	  {			    
		  gtk_tree_item_deselect(GTK_TREE_ITEM(info->referringto));
		  gtk_tree_item_select(GTK_TREE_ITEM(info->referringto));
	  }
	;

	updatehandlers_call(fsedit_updatehandlers);
}
;
	

void fsedit_treemkdir(GtkWidget *w,void *data)
{
	getdir_dirinfo *info;
	
	info=(getdir_dirinfo*)data;
	
	fileman_mkdir_dialog((char*)&info->dirname,
			     fsedit_treemkdir_update,
			     data);	
}
;


static menusys_menu fsedit_treepopup[]=
{
	MENUSYS_ITEM_NONE(N_("Delete Directory"),N_("Delete a directory"),fsedit_treeremove),
	MENUSYS_ITEM_NONE(N_("Create Directory"),N_("Create a directory within the currently selected dir"),fsedit_treemkdir),
	MENUSYS_ITEM_END	    
}
;

void fsedit_rootitem_create()
{
	rootitem=gtk_tree_item_new_with_label("/");
	gtk_tree_append(GTK_TREE(tree),rootitem);
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(rootitem),
				  gtk_tree_new());
	gtk_widget_show(rootitem);	
	getdir_connectstdsignals(rootitem,
				 NULL, /* this is the first item in the tree hierarchy*/
				 getdir_dirinfo_create(FSEDIT_DESTPATH,
						       fsedit_cb_filelistselect,
						       fsedit_cb_filelistdeselect,
						       NULL,
						       FALSE,
						       fsedit_treedrop,
						       fsedit_treepopup
						       ));
}
;


GtkWidget *fsedit_create()
{
	GtkWidget *treescroll;

	fsedit=gtk_hpaned_new();

	treescroll=gtk_scrolled_window_new (NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(treescroll),
				       GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
	
	tree=gtk_tree_new();
	gtk_tree_set_selection_mode(GTK_TREE(tree),GTK_SELECTION_BROWSE);
	treedroppatch_install(tree);

	
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW(treescroll),tree);
	gtk_widget_show(tree);

	fsedit_rootitem_create();
	
	gtk_paned_pack1(GTK_PANED(fsedit),treescroll,1,1);
	gtk_widget_show(treescroll);
	
	gtk_paned_compute_position(GTK_PANED(fsedit),INITSIZE_X,140,500);
	gtk_paned_set_position(GTK_PANED(fsedit),(int)(INITSIZE_X/3));
	
	return fsedit;
}
;

void fsedit_update_all()
{
	filelist_destroy(content); /* there is always some directory in display,kill it */
	
	/* then do the same with the whole directory tree on the left side.
	 * again: the data fields connected to those directories wont
	 * be deleted. This is due to some lack of signals when the
	 * remove_subtree call is executed (which first of all execs a collapse) */					    					    
	gtk_tree_item_remove_subtree(GTK_TREE_ITEM(rootitem));
	gtk_widget_destroy(rootitem);
	
	fsedit_rootitem_create();
	
	/* display something on the right again :-) */
	gtk_tree_select_item(GTK_TREE(tree),0);
	
	updatehandlers_call(fsedit_updatehandlers);
}
;

/* delete the whole fsedit area including multisession informations */
void fsedit_remove_all()
{
   /* remove virtual files */
   multisession_delete();
   /* remove content of fsedit directory */
   dirlow_removedir(FSEDIT_DESTPATH,1);
   /* update display */
   fsedit_update_all();
};
  
void fsedit_init()
{
	
	gtk_tree_select_item(GTK_TREE(tree),0);
   
        /* update display whenever a session got imported */
        updatehandlers_register(&multisession_updatehandlers,
				fsedit_update_all,
				NULL);				
   
	varman_install_handler(global_defs,
			       "fsedit_destpath",
			       fsedit_update_all,
			       NULL);
}
;

/* delete fsedit area when exiting */
void fsedit_destroy()
{
   /* delete fsedit area only when selected in preferences setup */
   if (!strcasecmp(varman_getvar(global_defs,"isotrack_fseditdelonexit"),
		   "true"))
     fsedit_remove_all();
};
