/* Gnometoaster's dialog routines */

#include <stdlib.h>
#include <gtk/gtk.h>

#include "config.h"
#include "int.h"
#include "dialog.h"

/* define message functions ourselves if gnome is not present */
#ifndef HAVE_GNOME

typedef struct
{
   dialog_replycallback cb;
   gpointer data;
   GtkWidget *dialog;
} dialog_question_info;

void dialog_question_callback_destroy(GtkWidget *w,dialog_question_info *info)
{
   gtk_widget_destroy(info->dialog);
   free(info);
};

GtkWidget *dialog_ok(const gchar *msg)
{
   GtkWidget *dialog;
   GtkWidget *okbutton;
   GtkWidget *text;
   dialog_question_info *info;
   
   dialog=gtk_dialog_new();
      
   info=(dialog_question_info*)malloc(sizeof(dialog_question_info));
   info->dialog=dialog;
   
   text=gtk_label_new(msg);
   gtk_widget_show(text);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),text,TRUE,TRUE,0);
   
   okbutton=gtk_button_new_with_label(_("OK"));
   gtk_widget_show(okbutton);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		      okbutton,TRUE,TRUE,0);
   gtk_signal_connect(GTK_OBJECT(okbutton),"clicked",
		      GTK_SIGNAL_FUNC(dialog_question_callback_destroy),(gpointer)info);
   
   gtk_widget_show(dialog);
   return dialog;
};


void dialog_question_callback_yes(GtkWidget *w,dialog_question_info *info)
{
   info->cb(DIALOG_YES,info->data);
   gtk_widget_destroy(info->dialog);
   free(info);
};

void dialog_question_callback_no(GtkWidget *w,dialog_question_info *info)
{
   info->cb(DIALOG_NO,info->data);
   gtk_widget_destroy(info->dialog);
   free(info);
};

GtkWidget *dialog_question(const gchar *msg,
			   dialog_replycallback callback,
			   gpointer data)
{
   GtkWidget *dialog;
   GtkWidget *yesbutton;
   GtkWidget *nobutton;
   GtkWidget *text;
   
   dialog_question_info *info;
   
   dialog=gtk_dialog_new();
   
   text=gtk_label_new(msg);
   gtk_widget_show(text);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),text,TRUE,TRUE,0);
   
   info=(dialog_question_info*)malloc(sizeof(dialog_question_info));
   info->cb=callback;
   info->data=data;
   info->dialog=dialog;
   
   yesbutton=gtk_button_new_with_label(_("YES"));
   gtk_widget_show(yesbutton);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		      yesbutton,TRUE,TRUE,0);
   gtk_signal_connect(GTK_OBJECT(yesbutton),"clicked",
		      GTK_SIGNAL_FUNC(dialog_question_callback_yes),info);

   nobutton=gtk_button_new_with_label(_("NO"));
   gtk_widget_show(nobutton);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		      nobutton,TRUE,TRUE,0);
   gtk_signal_connect(GTK_OBJECT(nobutton),"clicked",
		      GTK_SIGNAL_FUNC(dialog_question_callback_no),info);
   
   gtk_widget_show(dialog);
   return dialog;
};

#endif
