/* these functions are partly used to calculate tracksizes for the
 * file2track subsystem. See header file calc.h for further details */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdarg.h>
#include <gtk/gtk.h>

#include "varman.h"
#include "calc.h"


/* uncomment for debugging */
/* #define DEBUG */

GList *calc_expressions=NULL;
#define calc_exp(listentry) ((calc_expr*)listentry->data)

void calc_abs(char *arg1,char *arg2,char *output)
{
	float val_in,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg2,"%f",&val_in);    // convert to float
        val_out=fabs(val_in);         // calculate
	sprintf(output,"%f",val_out); // get result rounded to 6 digits in decimal notation
}
;

void calc_greater(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg1,"%f",&val_in1);    // convert to float
	sscanf(arg2,"%f",&val_in2);    // convert to float
        val_out=(val_in1>val_in2);    // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;

void calc_less(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg1,"%f",&val_in1);    // convert to float
	sscanf(arg2,"%f",&val_in2);    // convert to float
        val_out=(val_in1<val_in2);    // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;


void calc_notequal(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg1,"%f",&val_in1);    // convert to float
	sscanf(arg2,"%f",&val_in2);    // convert to float
        val_out=(val_in1!=val_in2);    // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;


void calc_equal(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg1,"%f",&val_in1);    // convert to float
	sscanf(arg2,"%f",&val_in2);    // convert to float
        val_out=(val_in1==val_in2);    // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;

void calc_booland(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg1,"%f",&val_in1);    // convert to float
	sscanf(arg2,"%f",&val_in2);    // convert to float
        val_out=((val_in1>0)&&(val_in2>0));    // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;

void calc_boolor(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg1,"%f",&val_in1);    // convert to float
	sscanf(arg2,"%f",&val_in2);    // convert to float
        val_out=((val_in1>0)||(val_in2>0));    // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;


void calc_mod(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;           // strings have to be converted to numbers ;-)
	sscanf(arg1,"%f",&val_in1);              // convert to float
	sscanf(arg2,"%f",&val_in2);              // convert to float
        val_out=(int)val_in1%(int)val_in2;       // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;

void calc_power(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg1,"%f",&val_in1);    // convert to float
	sscanf(arg2,"%f",&val_in2);    // convert to float
        val_out=pow(val_in1,val_in2);  // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;

void calc_sqrt(char *arg1,char *arg2,char *output)
{
	float val_in,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg2,"%f",&val_in);    // convert to float
        val_out=sqrt(val_in);         // calculate
	sprintf(output,"%f",val_out); // get result rounded to 6 digits in decimal notation
}
;

void calc_sin(char *arg1,char *arg2,char *output)
{
	float val_in,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg2,"%f",&val_in);    // convert to float
        val_out=sin(val_in);          // calculate
	sprintf(output,"%f",val_out); // get result rounded to 6 digits in decimal notation
}
;

void calc_cos(char *arg1,char *arg2,char *output)
{
	float val_in,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg2,"%f",&val_in);    // convert to float
        val_out=cos(val_in);          // calculate
	sprintf(output,"%f",val_out); // get result rounded to 6 digits in decimal notation
}
;

void calc_tan(char *arg1,char *arg2,char *output)
{
	float val_in,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg2,"%f",&val_in);    // convert to float
        val_out=tan(val_in);          // calculate
	sprintf(output,"%f",val_out); // get result rounded to 6 digits in decimal notation
}
;

void calc_mul(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg1,"%f",&val_in1);    // convert to float
	sscanf(arg2,"%f",&val_in2);    // convert to float
        val_out=val_in1*val_in2;       // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;

void calc_div(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;         // strings have to be converted to numbers ;-)
	sscanf(arg1,"%f",&val_in1);    // convert to float
	sscanf(arg2,"%f",&val_in2);    // convert to float
        val_out=val_in1/val_in2;       // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;

void calc_add(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;         // strings have to be converted to numbers ;-)
       	sscanf(arg1,"%f",&val_in1);    // convert to float,if "" result will be Zero
	sscanf(arg2,"%f",&val_in2);    // convert to float
        val_out=val_in1+val_in2;       // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;

void calc_sub(char *arg1,char *arg2,char *output)
{
	float val_in1,val_in2,val_out;         // strings have to be converted to numbers ;-)
       	sscanf(arg1,"%f",&val_in1);    // convert to float,if "" result will be Zero
	sscanf(arg2,"%f",&val_in2);    // convert to float
        val_out=val_in1-val_in2;       // calculate
	sprintf(output,"%f",val_out);  // get result rounded to 6 digits in decimal notation
}
;

void calc_commadummy(char *arg1,char *arg2,char *output)
{
	strcpy(output,arg1);  
	strcat(output,",");   /* simply replace what was "comma" by a "," */
	strcat(output,arg2);
}
;

int calc_calc(char *input,char *output)
{
	int res;
	char *obracket,*cbracket;
	char *restterm,*ptermend;
	char *pterm,*rterm,*resterm;
	char *arg1,*arg2;
	GList *iexp,*xexp;
	 
	res=0; 
	strcpy(output,input); // make a "workshop" copy of the input first...
 
	obracket=strstr(output,"("); // are there brackets in the term ?
	if (obracket!=NULL)          // take the first opening bracket and give everything from this pos on to the recursive call
	  {
		  char *subcalc;
		  char *subresult;
		  subcalc=  (char*)malloc(255);
		  subresult=(char*)malloc(255);
		  
		  strcpy(subcalc,&obracket[1]);   /* copy from first char after ( to the end */
		  calc_calc(subcalc,subresult);   /* get result from recursive call */
		  
		  strcpy(obracket,subresult); // copy the result of the term in brackets at where the opening bracket previously was...

		  free (subresult);           // free obsolete memory...
		  free (subcalc);
	  };                            // the result should also contain the rest of the term after the brackets
	cbracket=strstr(output,")");  // get the first closing bracket which should be the one we want due to the recursive call above
	restterm=(char*)malloc(255);  
	if (cbracket!=NULL)
	  {
		  strcpy (restterm,&cbracket[1]); // save restterm from ")" on...
		  *cbracket=0;                    // preliminarily cut string at the closing bracket
	  } else strcpy(restterm,"");
#ifdef DEBUG
	printf ("calculating expression: %s\n",output);
#endif
	iexp=calc_expressions;
	for (iexp=calc_expressions;
	     iexp!=NULL;
	     iexp=iexp->next)               // go through the list of calculating modes, brackets do not exist in this part of the term
	  {
		  char *Xpos=strstr(output,
				    (char*)&(calc_exp(iexp)->name));
		  
		  /* get the first occurence of the calc mode */
		  while (Xpos!=NULL)
		    {
			    char *ptermcount=Xpos;         // get the begin of the primary term
			    char *ptermstart=output;
			    while ((Xpos!=output) && (output!=ptermcount--) && (ptermstart==output)) // also check if operator is first char in string
			      {
				      for (xexp=calc_expressions;
					   xexp!=NULL;
					   xexp=xexp->next)
					{
						if (strncmp((char*)&calc_exp(xexp)->name,ptermcount,strlen((char*)&calc_exp(xexp)->name))==0)
						    ptermstart=ptermcount+strlen((char*)&calc_exp(xexp)->name); // if keyword is found take the first stringpos after it
					}
				      ;
			      };			    
			    ptermend=output+strlen(output); // default to the 0 that terminates the output string
			    for (xexp=calc_expressions;
				 xexp!=NULL;
				 xexp=xexp->next)
			      {
				      if ((strstr(Xpos+1,(char*)&calc_exp(xexp)->name)!=NULL) &&
					  (strstr(Xpos+1,(char*)&calc_exp(xexp)->name)<ptermend))
					{
						ptermend=strstr(Xpos+1,(char*)&calc_exp(xexp)->name);
					}
				      ;
			      }
			    ;
			    
			    pterm=(char*)malloc(255);
			    rterm=(char*)malloc(255);
			    resterm=(char*)malloc(255);
			    strcpy(pterm,ptermstart);      // finally isolate string to be calculated immediately now...
			    pterm[ptermend-ptermstart]=0;  // cut the rest
			    
			    strcpy(rterm,ptermend);                            // reserve reststring
			    
#ifdef DEBUG
			    printf ("now calculating: %s\n",pterm);
#endif
			     
			    arg1=(char*)malloc(255); // make things as easy as possible for the calc function
			    arg2=(char*)malloc(255);
			    strcpy (arg1,pterm);
			    arg1[strstr(pterm,(char*)&calc_exp(iexp)->name)-pterm]=0;
			    strcpy (arg2,strstr(pterm,(char*)&calc_exp(iexp)->name)+strlen((char*)&calc_exp(iexp)->name));
			     
			    calc_exp(iexp)->handler(arg1,arg2,resterm);  // finally calculate
			    
			    free(arg2);free(arg1);
			    
			    strcpy(ptermstart,resterm);                          // remerge the result
			    strcat(output,rterm);
			    free(resterm);free(rterm);free(pterm);
			    
			    Xpos=strstr(output,(char*)&calc_exp(iexp)->name); // ok,get the next occurence if existent
		    }
		  ;	 
	  }
	;
	strcat(output,restterm);               // merge the restterm to the result of the term calculations...
	free(restterm);
  
	return res;
};
  
int calc_calculate(char *input,char *output)
{
	int res;
	char *inrep=(char*)malloc(255);
	strcpy(inrep,input);
	varman_replacestring(inrep,"-","sub");
	varman_replacestring(inrep,",","comma");
	res=calc_calc(inrep,output);
	free(inrep);
	return(res);
};

float calc_function(char *input,int reps,...) /* char *varname,float value */
{                                        /* return value of a function given in input at a certain position */
	va_list param_pt;
	char *output=(char*)malloc(255);
	char *in=(char*)malloc(255);
	float val;
	char *varname;
	int i;
	
	strcpy(in,input);
	va_start (param_pt,reps);
	for (i=0;i<reps;i++)
	  {
		  
	          varname=va_arg(param_pt,char *);
	          val=va_arg(param_pt,double); /* that ones really great! taking "float" here as argument will result */
		  /* in the neatest things,but never ever in the right values :-/ */

		  varman_replacevarbyvalue_float(in,varname,val);
	  }
	;
	
	va_end(param_pt);
	calc_calculate (in,output);
	sscanf(output,"%f",&val);
	free(in);free(output);
	return val;
}
;
	

#define lim_dx 0.001
float calc_derive(char *input,char *var,float pos) // derive function at position pos to var x
{
	float val1,val2;
	float in1,in2;
        
 	in1=pos-lim_dx;in2=pos+lim_dx;
	val1=calc_function(input,1,var,in1);
	val2=calc_function(input,1,var,in2);
	
	return ((val2-val1)/(2*lim_dx));
		
};

calc_expr *calc_expression_create(char *name,
				  calc_handler handler)
{
	calc_expr *e;
	
	e=(calc_expr*)malloc(sizeof(calc_expr));
	strcpy((char*)&e->name,name);
	e->handler=handler;
	
	return e;
}
;

calc_expr *calc_expression_get_byname(char *name)
{
	GList *current;
	calc_expr *e;
	
	current=calc_expressions;
	e=NULL;
	while ((current!=NULL)&&(e==NULL))
	  {
		  if (!strcmp(((calc_expr*)current->data)->name,name))
		      e=(calc_expr*)current->data;
		  current=current->next;
	  }
	;
	
	return e;
}
;

void calc_expression_register_prepend(calc_expr *e)
{
	calc_expressions=
	    g_list_prepend(calc_expressions,(gpointer)e);
}
;

void calc_expression_register_append(calc_expr *e)
{
	calc_expressions=
	    g_list_append(calc_expressions,(gpointer)e);
}
;

/* FIXME: implement calc_expression_register_before/after not implemented.
 * What would be the best way to do this ? */

void calc_expression_unregister(calc_expr *e)
{
	calc_expressions=
	    g_list_remove(calc_expressions,(gpointer)e);
}
;

void calc_expression_unregister_byname(char *name)
{
	calc_expression_unregister(calc_expression_get_byname(name));
}
;

void calc_init()
{
	/* register built-in expressions */
	calc_expression_register_append(calc_expression_create("abs",calc_abs));
	calc_expression_register_append(calc_expression_create("%",calc_mod));
	calc_expression_register_append(calc_expression_create("^",calc_power));
	calc_expression_register_append(calc_expression_create("sqrt",calc_sqrt));
	calc_expression_register_append(calc_expression_create("sin",calc_sin));
	calc_expression_register_append(calc_expression_create("cos",calc_cos));
	calc_expression_register_append(calc_expression_create("tan",calc_tan));
	calc_expression_register_append(calc_expression_create("/",calc_div));
	calc_expression_register_append(calc_expression_create("*",calc_mul));
	calc_expression_register_append(calc_expression_create("sub",calc_sub));
	calc_expression_register_append(calc_expression_create("+",calc_add));
	calc_expression_register_append(calc_expression_create(">",calc_greater));
	calc_expression_register_append(calc_expression_create("<",calc_less));
	calc_expression_register_append(calc_expression_create("!=",calc_notequal));
	calc_expression_register_append(calc_expression_create("==",calc_equal));
	calc_expression_register_append(calc_expression_create("&&",calc_booland));
	calc_expression_register_append(calc_expression_create("||",calc_boolor));
	calc_expression_register_append(calc_expression_create("comma",calc_commadummy));
	/* the purpose of this definition is to declare "comma" as
	 * an operator for the parsing routine. As it is defined
	 * as the last operator in the list,all other operators
	 * are applied first. Once "comma" has been replaced with ","
	 * by the calc_commadummy function, the resulting expression is treated
	 * as one large "number". That kind of argument can be processed by
	 * a few expressions only,which are the "real" functions then. 
	 * all those "real" functions have to be installed *before*
	 * everything else in the expression list.
	 * use calc_expression_register_prepend to do so...
	 */
}
;

